<?php

/**
 * Udaiti functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Udaiti
 * @since Udaiti
 */

/**
 * Register block styles.
 */

if (!function_exists('twentytwentyfour_block_styles')) :
	/**
	 * Register custom block styles
	 *
	 * @since Udaiti
	 * @return void
	 */
	function twentytwentyfour_block_styles()
	{

		register_block_style(
			'core/details',
			array(
				'name'         => 'arrow-icon-details',
				'label'        => __('Arrow icon', 'twentytwentyfour'),
				/*
				 * Styles for the custom Arrow icon style of the Details block
				 */
				'inline_style' => '
				.is-style-arrow-icon-details {
					padding-top: var(--wp--preset--spacing--10);
					padding-bottom: var(--wp--preset--spacing--10);
				}

				.is-style-arrow-icon-details summary {
					list-style-type: "\2193\00a0\00a0\00a0";
				}

				.is-style-arrow-icon-details[open]>summary {
					list-style-type: "\2192\00a0\00a0\00a0";
				}',
			)
		);
		register_block_style(
			'core/post-terms',
			array(
				'name'         => 'pill',
				'label'        => __('Pill', 'twentytwentyfour'),
				/*
				 * Styles variation for post terms
				 * https://github.com/WordPress/gutenberg/issues/24956
				 */
				'inline_style' => '
				.is-style-pill a,
				.is-style-pill span:not([class], [data-rich-text-placeholder]) {
					display: inline-block;
					background-color: var(--wp--preset--color--base-2);
					padding: 0.375rem 0.875rem;
					border-radius: var(--wp--preset--spacing--20);
				}

				.is-style-pill a:hover {
					background-color: var(--wp--preset--color--contrast-3);
				}',
			)
		);
		register_block_style(
			'core/list',
			array(
				'name'         => 'checkmark-list',
				'label'        => __('Checkmark', 'twentytwentyfour'),
				/*
				 * Styles for the custom checkmark list block style
				 * https://github.com/WordPress/gutenberg/issues/51480
				 */
				'inline_style' => '
				ul.is-style-checkmark-list {
					list-style-type: "\2713";
				}

				ul.is-style-checkmark-list li {
					padding-inline-start: 1ch;
				}',
			)
		);
		register_block_style(
			'core/navigation-link',
			array(
				'name'         => 'arrow-link',
				'label'        => __('With arrow', 'twentytwentyfour'),
				/*
				 * Styles for the custom arrow nav link block style
				 */
				'inline_style' => '
				.is-style-arrow-link .wp-block-navigation-item__label:after {
					content: "\2197";
					padding-inline-start: 0.25rem;
					vertical-align: middle;
					text-decoration: none;
					display: inline-block;
				}',
			)
		);
		register_block_style(
			'core/heading',
			array(
				'name'         => 'asterisk',
				'label'        => __('With asterisk', 'twentytwentyfour'),
				'inline_style' => "
				.is-style-asterisk:before {
					content: '';
					width: 1.5rem;
					height: 3rem;
					background: var(--wp--preset--color--contrast-2, currentColor);
					clip-path: path('M11.93.684v8.039l5.633-5.633 1.216 1.23-5.66 5.66h8.04v1.737H13.2l5.701 5.701-1.23 1.23-5.742-5.742V21h-1.737v-8.094l-5.77 5.77-1.23-1.217 5.743-5.742H.842V9.98h8.162l-5.701-5.7 1.23-1.231 5.66 5.66V.684h1.737Z');
					display: block;
				}

				/* Hide the asterisk if the heading has no content, to avoid using empty headings to display the asterisk only, which is an A11Y issue */
				.is-style-asterisk:empty:before {
					content: none;
				}

				.is-style-asterisk:-moz-only-whitespace:before {
					content: none;
				}

				.is-style-asterisk.has-text-align-center:before {
					margin: 0 auto;
				}

				.is-style-asterisk.has-text-align-right:before {
					margin-left: auto;
				}

				.rtl .is-style-asterisk.has-text-align-left:before {
					margin-right: auto;
				}",
			)
		);
	}
endif;

add_action('init', 'twentytwentyfour_block_styles');
add_theme_support('menus');
/**
 * Enqueue block stylesheets.
 */

if (!function_exists('twentytwentyfour_block_stylesheets')) :
	/**
	 * Enqueue custom block stylesheets
	 *
	 * @since Twenty Twenty-Four 1.0
	 * @return void
	 */
	function twentytwentyfour_block_stylesheets()
	{
		/**
		 * The wp_enqueue_block_style() function allows us to enqueue a stylesheet
		 * for a specific block. These will only get loaded when the block is rendered
		 * (both in the editor and on the front end), improving performance
		 * and reducing the amount of data requested by visitors.
		 *
		 * See https://make.wordpress.org/core/2021/12/15/using-multiple-stylesheets-per-block/ for more info.
		 */
		wp_enqueue_block_style(
			'core/button',
			array(
				'handle' => 'twentytwentyfour-button-style-outline',
				'src'    => get_parent_theme_file_uri('assets/css/button-outline.css'),
				'ver'    => wp_get_theme(get_template())->get('Version'),
				'path'   => get_parent_theme_file_path('assets/css/button-outline.css'),
			)
		);
	}
endif;

add_action('init', 'twentytwentyfour_block_stylesheets');

/**
 * Register pattern categories.
 */

if (!function_exists('twentytwentyfour_pattern_categories')) :
	/**
	 * Register pattern categories
	 *
	 * @since Twenty Twenty-Four 1.0
	 * @return void
	 */
	function twentytwentyfour_pattern_categories()
	{

		register_block_pattern_category(
			'page',
			array(
				'label'       => _x('Pages', 'Block pattern category', 'twentytwentyfour'),
				'description' => __('A collection of full page layouts.', 'twentytwentyfour'),
			)
		);
	}
endif;

add_action('init', 'twentytwentyfour_pattern_categories');
add_action('acf/init', 'my_acf_op_init');

function my_acf_op_init()
{



	// Check function exists.

	if (function_exists('acf_add_options_page')) {



		// Register options page.

		$option_page = acf_add_options_page(array(

			'page_title'    => __('Udaiti Theme General Settings'),

			'menu_title'    => __('Udaiti Theme Settings'),

			'menu_slug'     => 'theme-general-settings',

			'capability'    => 'edit_posts',

			'redirect'      => false

		));
	}
}
function get_my_menu()
{
	// Replace your menu name, slug or ID carefully
	return wp_get_nav_menu_items('Header');
}

add_action('rest_api_init', function () {
	register_rest_route('wp/v2', 'menu', array(
		'methods' => 'GET',
		'callback' => 'get_my_menu',
	));
});

function get_my_footer_menu()
{
	// Replace your menu name, slug or ID carefully
	return wp_get_nav_menu_items('Footer');
}

add_action('rest_api_init', function () {
	register_rest_route('wp/v2', 'menu/footer', array(
		'methods' => 'GET',
		'callback' => 'get_my_footer_menu',
	));
});
add_action('rest_api_init', function () {
	register_rest_route('wp/v2', 'global-settings', array(
		'methods' => 'GET',
		'callback' => 'get_theme_settings',
	));
});

function get_theme_settings()
{
	$theme_settings = get_fields('option');
	$header = get_my_menu();
	$footer = get_my_footer_menu();
	// Add the theme settings to the response
	$result['global_custom_option'] = $theme_settings;
	$result['global_header'] = $header;
	$result['global_footer'] = $footer;


	return $result;
}
// add_filter('rest_pre_echo_response', 'add_theme_settings_to_api_response', 10, 3);

// function add_theme_settings_to_api_response($result, $server, $request) {
//     // Check if the request is a GET request
// 	// echo

//     if ($request->get_method() === 'GET' && $result->code != 'rest_no_route') {
//         // Fetch the theme settings
//         $theme_settings = get_fields('option');
// 		$header = get_my_menu();
// 		$footer = get_my_footer_menu();
//         // Add the theme settings to the response
//         $result['global_custom_option'] = $theme_settings;
// 		$result['gloabal_header'] = $header;
// 		$result['gloabal_footer'] = $footer;
//     }

//     return $result;
// }



// function add_cors_http_header(){
//     header("Access-Control-Allow-Origin: http://localhost:3000");
// 	header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
// 	header("Access-Control-Allow-Headers: Authorization");

//     header("Access-Control-Allow-Credentials: true");
// }
// add_action('init','add_cors_http_header');


// add_action('rest_pre_serve_request', 'add_cors_headers', 0, 4);

// /**
//  * Add CORS headers to the REST API responses.
//  *
//  * @param bool             $served  Whether the request has already been served. Default false.
//  * @param WP_HTTP_Response $result  Result to send to the client. Usually a WP_REST_Response.
//  * @param WP_REST_Request  $request Request used to generate the response.
//  * @param WP_REST_Server   $server  Server instance.
//  */
function add_cors_headers($served, $result, $request, $server) {
    // Set the CORS headers
    header('Access-Control-Allow-Origin: http://localhost:3000');
    header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
    header('Access-Control-Allow-Credentials: true');
    header('Access-Control-Allow-Headers: Authorization');

	
    // Return the response to the client
    return $served;
}


// Now $decrypted_email and $decrypted_password contain the decrypted data

// custom api security starts
// echo __DIR__;die;
// require_once __DIR__ . '/vendor/autoload.php';

// require_once  '/home/devorange/public_html/vendor/autoload.php';



use Lcobucci\JWT\Configuration;
use Lcobucci\JWT\Validation\Constraint\SignedWith;
use Lcobucci\JWT\Signer\Hmac\Sha256;
use Lcobucci\JWT\Signer\Key\InMemory;
function generate_jwt_token($user_id) {
    // Your JWT secret key
    $secret_key = '6789098789099876324324324324324324';

    // Token expiration time (in seconds)
    $expiration_time = 3600; // 1 hour

    $signer = new Sha256();
    $key = InMemory::base64Encoded(base64_encode($secret_key));

    // Use Configuration to create a new token
    $config = Configuration::forSymmetricSigner($signer, $key);

    return $config->builder()
        ->issuedAt(new \DateTimeImmutable())
        ->expiresAt(new \DateTimeImmutable('+ ' . $expiration_time . ' seconds'))
        ->withClaim('user_id', $user_id)
        ->getToken($config->signer(), $config->signingKey());
}

function validate_jwt_token($token) {
    // Your JWT secret key
    $secret_key = '6789098789099876324324324324324324';

    $signer = new Sha256();
    $key = InMemory::base64Encoded(base64_encode($secret_key));

    // Use Configuration to validate the token
    $config = Configuration::forSymmetricSigner($signer, $key);

    // Validation constraints
    $constraints = [
        new SignedWith($config->signer(), $config->signingKey()),
    ];

    // Try to validate the token
    try {
        $parsedToken = $config->parser()->parse($token);
        $config->validator()->validate($parsedToken, ...$constraints);

        // Check token expiration
        if ($parsedToken->isExpired(new \DateTimeImmutable())) {
            // Token has expired
            return false;
        }

        return true; // Token is valid
    } catch (\Exception $e) {
        return false; // Token is invalid
    }
}

add_action('rest_api_init', function () {
    register_rest_route('api/v1', '/token/', array(
        'methods' => 'POST',
        'callback' => 'generate_token_endpoint',
    ));
});

function generate_token_endpoint($request) {
    // $user_id = $data['user_id'];


	$params = $request->get_params();
	if (!isset($params['username']) || 
        !isset($params['password']))
		{
			return new WP_Error('authentication_error', 'Invalid username or password.', array('status' => 403));

		}

    $username = $params['username'];
    $password = $params['password'];
	
	$secret_key = "HD57wdmEe0RCbHRE4hgzOQa4s7X0GP2Y";
	$iv = "2NtJzZaZf/sIlnrvv/H9JA==";
	$retrievedIv = base64_decode($iv);
	$decryptedData = openssl_decrypt(base64_decode($request['username']), 'AES-256-CBC', $secret_key, 0, $retrievedIv);
	$decryptedDataP = openssl_decrypt(base64_decode($request['password']), 'AES-256-CBC', $secret_key, 0, $retrievedIv);
	$username= $decryptedData;
	$password=  $decryptedDataP;
	
		$user = wp_authenticate($username, $password);



	if (is_wp_error($user)) {

		return $user;
        // If authentication fails, return an error response
        return new WP_Error('authentication_error', 'Invalid username or password.', array('status' => 401));
    }

    $token = generate_jwt_token($user->ID);

	$response = new WP_REST_Response(array('jwt_token' => $token->toString()));
    $response->set_status(200);
    $response->header('Content-Type', 'application/json');

    return $response;
}

add_action('rest_api_init', function () {
    register_rest_route('jwt-auth/v1', '/validate-token', array(
        'methods' => 'POST',
        'callback' => 'validate_token_endpoint',
    ));
});
function validate_token_endpoint($data) {
	$authorization_header = isset($_SERVER['HTTP_AUTHORIZATION']) ? $_SERVER['HTTP_AUTHORIZATION'] : '';

    $token = str_replace('Bearer ', '', $authorization_header);

    if (validate_jwt_token($token)) {
        return rest_ensure_response('Token is valid.');
    } else {
        // return rest_ensure_response('Token is invalid or expired.');
        return new WP_Error('authentication_error', 'Token Expired.', array('status' => 401));

    }
};
// add_action('rest_pre_dispatch', 'verify_jwt_token', 10, 3);

function verify_jwt_token($result, WP_REST_Server $server, WP_REST_Request $request) {
    // Check if the request is to a route starting with '/wp-json'
	// return $request->get_route();
	// return ;die;
	
    if (strpos($_SERVER['REQUEST_URI'], '/wp-json') === 0) {
	// return $request->get_route();

        // Skip the token verification for the '/wp-json/jwt-auth/v1/validate-token' route
        if ($_SERVER['REQUEST_URI'] === '/wp-json/jwt-auth/v1/validate-token' || $_SERVER['REQUEST_URI'] === '/wp-json/api/v1/token') {
            return $result;
        }

        // Get the Authorization header
        $authorization_header = $request->get_header('Authorization');
        if (!$authorization_header) {
            return new WP_Error('authentication_error', 'Authorization header is missing.', array('status' => 401));
        }

        // Extract the token from the Authorization header
        $token = str_replace('Bearer ', '', $authorization_header);

        // Validate the token
        if (!validate_jwt_token($token)) {
            return new WP_Error('authentication_error', 'Invalid or expired token.', array('status' => 401));
        }
    }

    return $result;
}








function is_already_submitted($formPostId, $fieldName, $fieldValue) {

    global $wpdb;

    /*We make a select in the table where the contacts are recorded, checking if the email informed already exists on today's date */

    $entry = $wpdb->get_results( "SELECT * FROM hsaniva_db7_forms WHERE form_value LIKE '%$fieldValue%' AND form_post_id = '$formPostId'" );
    
    // If the select query in the database is positive (the email exists on the current date), it returns the error in the form, in the email field, not sending

    $found = false;
    if (!empty($entry)) {
        $found = true;
    }
    return $found;
}

function my_validate_email($result, $tag) {
    $formPostId = '606'; // Change to name of the form containing this field
    $fieldName = 'your-email'; // Change to your form's unique field name
    $errorMessage = 'This email address is already registered'; // Change to your error message
    $name = $tag['name'];
    if ($name == $fieldName) {
        if (is_already_submitted($formPostId, $fieldName, $_POST[$name])) {
            $result->invalidate($tag, $errorMessage);
        }
    }
    return $result;
}

add_filter('wpcf7_validate_email*', 'my_validate_email', 10, 2);
// Register the validation endpoint
// add_action('rest_api_init', function () {
//     register_rest_route('jwt-auth/v1', '/validate-token', array(
//         'methods' => 'POST',
//         'callback' => 'validate_token_endpoint',
//     ));
// });

// // The validate_token_endpoint function remains the same
// function validate_token_endpoint($data) {
//     $authorization_header = isset($_SERVER['HTTP_AUTHORIZATION']) ? $_SERVER['HTTP_AUTHORIZATION'] : '';
//     $token = str_replace('Bearer ', '', $authorization_header);

//     if (validate_jwt_token($token)) {
//         return rest_ensure_response('Token is valid.');
//     } else {
//         return new WP_Error('authentication_error', 'Token Expired.', array('status' => 401));
//     }
// }
// custom api security ends


// function custom_rest_pre_dispatch($result, $server, $request)
// {
// 	if (strpos($request->get_route(), 'api/v1/token') !== false) {
// 		if(isset($request['username'])&& isset($request['password'])){
// 	$secret_key = "HD57wdmEe0RCbHRE4hgzOQa4s7X0GP2Y";
// 	$iv = "2NtJzZaZf/sIlnrvv/H9JA==";
// 	// Store the IV securely (e.g., in a database or file)
// 	// To decrypt the data, you would retrieve the stored IV and decode it
// 	$retrievedIv = base64_decode($iv);
// 	// $encrypted_email = $request['username'];
// 	// $encrypted_password = $request['password'];
// 	// echo "Encrypted Data Email: " . ($encrypted_email) . "\n";
// 	// echo "Encrypted Data Password: " . ($encrypted_password) . "\n";
// 	// Encrypt the data
// 	// $encryptedData = openssl_encrypt($encrypted_email, 'AES-256-CBC', $secret_key, 0, $retrievedIv);
// 	// $encryptedDataPassword = openssl_encrypt($encrypted_password, 'AES-256-CBC', $secret_key, 0, $retrievedIv);
// 	// echo "Encrypted Data Email: " . base64_encode($encryptedData) . "\n";
// 	// echo "Encrypted Data Password: " . base64_encode($encryptedDataPassword) . "\n";
// 	$decryptedData = openssl_decrypt(base64_decode($request['username']), 'AES-256-CBC', $secret_key, 0, $retrievedIv);
// 	$decryptedDataP = openssl_decrypt(base64_decode($request['password']), 'AES-256-CBC', $secret_key, 0, $retrievedIv);
// 	$parameters = $request->get_params();
// 	$request->set_param('username', $decryptedData);
// 	$request->set_param('password',  $decryptedDataP);
// 		// echo "Encrypted Data Email: " . base64_encode($encryptedData) . "\n";
// 	// echo "Encrypted Data Password: " . base64_encode($encryptedDataPassword) . "\n";
// 	// $request->set_params($parameters);
// 		}
// 	}
// 	return $result;
// 	//return $result;
// }

// add_filter('rest_pre_dispatch', 'custom_rest_pre_dispatch', 10, 3);

// Hook into the wpcf7_before_send_mail action
// Hook into the wpcf7_posted_data filter
add_filter('wpcf7_posted_data', 'modify_cf7_form_data');

function modify_cf7_form_data($posted_data) {
    // Modify the form data as needed
    $posted_data['custom_field'] = 'Custom Value';

    return $posted_data;
}
