<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Adminleads extends CI_Model{
    function __construct() {
        $this->usersTbl = 'users'; 
        $this->adminTbl = 'admin'; 
        $this->contentRecordsTbl = 'content'; 
    }
    /*
     * get rows from the users table
     */
    function getRows($params = array()){
        $this->db->select('*');
        $this->db->from($this->adminTbl);
        
        //fetch data by conditions
        if(array_key_exists("conditions",$params)){
			foreach ($params['conditions'] as $key => $value) {
				$this->db->where($key,$value);
			}
		}
        
        if(array_key_exists("id",$params)){
            $this->db->where('id',$params['id']);
			$query = $this->db->get();
			$result = $query->row_array();
        }else{
            //set start and limit
            if(array_key_exists("start",$params) && array_key_exists("limit",$params)){
                $this->db->limit($params['limit'],$params['start']);
            }elseif(!array_key_exists("start",$params) && array_key_exists("limit",$params)){
                $this->db->limit($params['limit']);
            }
            $query = $this->db->get();
            if(array_key_exists("returnType",$params) && $params['returnType'] == 'count'){
				$result = $query->num_rows();
			}elseif(array_key_exists("returnType",$params) && $params['returnType'] == 'single'){
				$result = ($query->num_rows() > 0)?$query->row_array():FALSE;
			}else{
                $result = ($query->num_rows() > 0)?$query->result_array():FALSE;
            }
        }

        //return fetched data
        return $result;
    }
	
	
	function getContactLeads()
	{	
		$page = $this->getPage();
		$num_of_records = $this->getNumRecord();
		$startlimit = ($page*$num_of_records)-$num_of_records;
		$endlimit = $page*$num_of_records;
		$this->db->select("$this->usersTbl.full_name,$this->usersTbl.email,$this->contentRecordsTbl.*");
		$this->db->join("$this->usersTbl","$this->usersTbl.id=$this->contentRecordsTbl.user_id");
		$this->db->where("$this->contentRecordsTbl.is_publish", 0);
		$this->db->or_where("$this->contentRecordsTbl.is_publish", 1);
		if(isset($_GET['search'])){
			$this->db->like("$this->usersTbl.full_name", $_GET['search']);
			$this->db->or_like("$this->usersTbl.email", $_GET['search']);
			$this->db->or_like("$this->contentRecordsTbl.post_title", $_GET['search']);
			$this->db->or_like("$this->contentRecordsTbl.post_content", $this->encrypted_data($_GET['search']));
			
		}
		/* if(isset($_GET['contact_date'])){
			$till_date = $_GET['contact_date'];
			$date = explode(" - ", $till_date);
			$start_date = date('Y-m-d', strtotime(str_replace('-', '/', $date[0])));
			$expire_date = date('Y-m-d 23:59:00', strtotime(str_replace('-', '/', $date[1])));
			$this->db->where('created_at >=',$start_date);
			$this->db->where('created_at <=',$expire_date);
			$date_range = date('Y-m-d', strtotime(str_replace('-', '/', $date[0]))).'_'.date('Y-m-d', strtotime(str_replace('-', '/', $date[1])));
			$this->session->set_userdata('date_range',$date_range);
		} */
		if(isset($_GET['sort'])){
			$this->db->order_by("$this->contentRecordsTbl.id", $_GET['sort']);
		}else{
			$this->db->order_by("$this->contentRecordsTbl.id", "DESC");
		}
		if(isset($_GET['entry'])){
			$this->db->limit($_GET['entry'],$startlimit);
		}
		else{
			$this->db->limit(LIMIT,$startlimit);
		}
		
		
		$query = $this->db->get($this->contentRecordsTbl)->result();
		// echo $this->db->last_query();die;
		return $query; 	
	}
	
	
	
	function getAllFilterContactLeads()
	{	
		$page = $this->getPage();
		$num_of_records = $this->getNumRecord();
		$startlimit = ($page*$num_of_records)-$num_of_records;
		$endlimit = $page*$num_of_records;
		$this->db->select("$this->usersTbl.full_name,$this->usersTbl.email,$this->contentRecordsTbl.*");
		$this->db->join("$this->usersTbl","$this->usersTbl.id=$this->contentRecordsTbl.user_id");
		$this->db->where("$this->contentRecordsTbl.is_publish", 0);
		$this->db->or_where("$this->contentRecordsTbl.is_publish", 1);
		if(isset($_GET['search'])){
			$this->db->like("$this->usersTbl.full_name", $_GET['search']);
			$this->db->or_like("$this->usersTbl.email", $_GET['search']);
			$this->db->or_like("$this->contentRecordsTbl.post_title", $_GET['search']);
			$this->db->or_like("$this->contentRecordsTbl.post_content", $this->encrypted_data($_GET['search']));
		}
		/* if(isset($_GET['contact_date'])){
			$till_date = $_GET['contact_date'];
			$date = explode(" - ", $till_date);
			$start_date = date('Y-m-d', strtotime(str_replace('-', '/', $date[0])));
			$expire_date = date('Y-m-d 23:59:00', strtotime(str_replace('-', '/', $date[1])));
			$this->db->where('created_at >=',$start_date);
			$this->db->where('created_at <=',$expire_date);
			
		} */
		if(isset($_GET['sort'])){
			$this->db->order_by("$this->contentRecordsTbl.id", $_GET['sort']);
		}
		
		$query = $this->db->get($this->contentRecordsTbl)->result();
		return $query; 	
	}
	
	function getAllContactLeads()
	{	
		$query = $this->db->get($this->contentRecordsTbl)->result();
		return $query; 	
	}
	
		
	function getPage(){
		$page = null!==$this->input->get('page')?$this->input->get('page'):1; 	
		return $page;
	}
		
	function getNumRecord(){
		if(isset($_GET['entry'])){
			$numrecord = null!==$this->input->get('numrecord')?$this->input->get('numrecord'):$_GET['entry']; 
		}else{
			$numrecord = null!==$this->input->get('numrecord')?$this->input->get('numrecord'):LIMIT; 
		}
			
		return $numrecord;
	}
		
	function totalCount(){
		$this->db->select("$this->usersTbl.full_name,$this->usersTbl.email,$this->contentRecordsTbl.*");
		$this->db->join("$this->usersTbl","$this->usersTbl.id=$this->contentRecordsTbl.user_id");
		$this->db->where("$this->contentRecordsTbl.is_publish", 0);
		$this->db->or_where("$this->contentRecordsTbl.is_publish", 1);
		if(isset($_GET['search'])){
			$this->db->like("$this->usersTbl.full_name", $_GET['search']);
			$this->db->or_like("$this->usersTbl.email", $_GET['search']);
			$this->db->or_like("$this->contentRecordsTbl.post_title", $_GET['search']);
			$this->db->or_like("$this->contentRecordsTbl.post_content", $this->encrypted_data($_GET['search']));
		}
		/* if(isset($_GET['contact_date'])){
			$till_date = $_GET['contact_date'];
			$date = explode(" - ", $till_date);
			$start_date = date('Y-m-d', strtotime(str_replace('-', '/', $date[0])));
			$expire_date = date('Y-m-d 23:59:00', strtotime(str_replace('-', '/', $date[1])));
			$this->db->where('created_at >=',$start_date);
			$this->db->where('created_at <=',$expire_date);
			
		} */
		
		return $this->db->count_all_results($this->contentRecordsTbl);
	}
	
	
	function getfilterContactLeads($start_date,$expire_date) 
	{
		$this->db->where('created_at >=',$start_date);
		$this->db->where('created_at <=',$expire_date);
		// $sql = 'select * from users where role_id = 3 and created_at >= "'.$start_date.'" AND created_at <= "'.$expire_date.'" order by `id` DESC';
		$query = $this->db->get($this->contentRecordsTbl)->result();
		return $query;	
	}
	
	function encrypted_data($formfield)
	{
		$data = $formfield;
		if(!empty($data))
		{
			$password = '3sc3RLrpd17';

			// CBC has an IV and thus needs randomness every time a message is encrypted
			$method = 'aes-256-cbc';

			// Must be exact 32 chars (256 bit)
			// You must store this secret random key in a safe place of your system.
			$key = substr(hash('sha256', $password, true), 0, 32);

			// Most secure key
			//$key = openssl_random_pseudo_bytes(openssl_cipher_iv_length($method));

			// IV must be exact 16 chars (128 bit)
			$iv = chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0);
			
			$encrypted = base64_encode(openssl_encrypt($data, $method, $key, OPENSSL_RAW_DATA, $iv));
			
			return $encrypted;
		}else{
			return '';
		}
		
	}
	
	/* function getEmail($number)
	{
		$this->db->where('phone',$number);
		$query = $this->db->get($this->usersTbl)->row();
		return $query;
	} */
	
	
	

}
