<?php
// phpinfo();
defined('BASEPATH') OR exit('No direct script access allowed');

class Home extends CI_Controller {

	function __construct() {
        parent::__construct();
		// echo "Under Cosntruction";die;
        $this->load->model('tambola_model');
		include_once APPPATH."libraries/google-api-php-client/Google_Client.php";
		include_once APPPATH."libraries/google-api-php-client/contrib/Google_Oauth2Service.php";
    }
	
	public function index()
	{
		//============== Google API=============	
			// Google Project API Credentials
		
		
		// Google Project API Credentials
		$clientId = GOOGLE_CLIENT_ID;
		$clientSecret = GOOGLE_SECRET;
		$redirectUrl = BASE_URL;
		
		// Google Client Configuration
		$gClient = new Google_Client();
		$gClient->setApplicationName('HO Tambola');
		$gClient->setClientId($clientId);
		$gClient->setClientSecret($clientSecret);
		$gClient->setRedirectUri($redirectUrl);
		$google_oauthV2 = new Google_Oauth2Service($gClient);

		if (isset($_REQUEST['code']) && isset($_REQUEST['scope'])) {
			$gClient->authenticate();
			$this->session->set_userdata('token', $gClient->getAccessToken());
			redirect($redirectUrl);
		}

		$token = $this->session->userdata('token');
		if (!empty($token)) {
			$gClient->setAccessToken($token);
		}

		if ($gClient->getAccessToken()) {
			$userProfile = $google_oauthV2->userinfo->get();
			// Preparing data for database insertion
			$userData['oauth_provider'] = 'google';
			$userData['oauth_uid'] = $userProfile['id'];
			$userData['email'] = $userProfile['email'];
			$userData['full_name'] = $userProfile['name'];
			$userData['profile_pic'] = $userProfile['picture'];
			$data['google_authUrl'] = '';
			$this->session->set_userdata('LoginDetails',$userData);
			
		} else 
		{
			$data['google_authUrl'] = $gClient->createAuthUrl();
		}
		
		// echo "<pre>";print_r($userData);die;
		if(isset($userData['email']))
		{
			$res = $this->tambola_model->insertUserDetails($userData);
			$this->session->set_userdata('user_id',$res);
		}else{
			if($this->session->userdata('verify_otp'))
			{
				// $this->session->set_userdata('show_first',1);
				$this->session->unset_userdata('verify_otp');
			}else{
				$this->session->set_userdata('show_first',0);
				
			}
		}
		
                
		$this->load->view('index',$data);
	}
	
	
	function tambola()
	{
		$number = $this->input->post('num');
		$res = $this->tambola_model->insertTambolaNumber($number);
		echo 1;
	}
	
	function tambola_game()
	{
		$this->load->view('tambola-game');
	}
	
	function check()
	{
		$number = $this->input->post('num');
		$res = $this->tambola_model->checkTambolaNumber($number);
		if($res)
		{
			$user_id = 1;
			$count_number = $this->tambola_model->updateTambolaCount($user_id);
			$category_array = array("Early Five","Top Line","Middle Line","Bottom Line","Four Corners","Full House");
			$achievement_array = array();
			foreach($category_array as $k=>$v)
			{
				$get_achievement = $this->tambola_model->getAchievement($v);
				if($get_achievement)
				{
					array_push($achievement_array,1);
				}else{
					array_push($achievement_array,0);
				}
			}
			$res = array('res'=>1,'count'=>$count_number,'achievements'=>$achievement_array);
			echo json_encode($res);
		}else{
			$res = array('res'=>0,'count'=>0,'achievements'=>0);
			echo json_encode($res);
		}
	}
	
	
	function validateCaptcha()
	{
		$captcha = $this->input->post('token2');
        if (!$captcha) {
            echo '<h2>Please check the the captcha form.</h2>';
            exit;
        }
        $secretKey = SECRET_KEY;
        $ip = $_SERVER['REMOTE_ADDR'];

        // post request to server
        $url = 'https://www.google.com/recaptcha/api/siteverify';
        $data = array('secret' => $secretKey, 'response' => $captcha);

        $options = array(
            'http' => array(
                'header' => "Content-type: application/x-www-form-urlencoded\r\n",
                'method' => 'POST',
                'content' => http_build_query($data)
            )
        );
        $context = stream_context_create($options);
        $response = file_get_contents($url, false, $context);
        $responseKeys = json_decode($response, true);
        header('Content-type: application/json');
        if ($responseKeys["success"]) {
            echo json_encode(array('success' => 'true'));
        } else {
            echo json_encode(array('success' => 'false'));
        }
        exit;
	}
	
	
	
	
	
	
	
	function decode_str($str) 
	{
		$str = strtoupper($str);
		$unit_size = 4;
		$alphatonum = function($s) {
			$alpha_map = ['P', 'M', 'S', 'K'];
			$l = strlen($s);
			$s_ = '';
			for ($x = 0; $x < $l; $x++) {
				$pos = array_search($s[$x], $alpha_map);
				$s_ .= in_array($s[$x], $alpha_map) ? array_search($s[$x], $alpha_map) : $s[$x];
			}
			return $s_;
		};
		
		$decoded    = '';
		$salt       = $alphatonum(substr($str, -3));     
		$data       = $alphatonum(substr($str, 0, strlen($str) - 3));
		
		$loop       = strlen($data) / $unit_size;
		$unit_arr   = [];
		for ($x = 0; $x < $loop; $x++) {
			$unit = substr($data, $x * $unit_size, $unit_size);
			
			$ascii_ = ($unit % 1000) - $salt;
			$decoded .= chr($ascii_);
		}
    
		return $decoded;
	}
	
	
	
	

	
	function logout()
	{
		$this->session->unset_userdata('close',1);
		$this->session->unset_userdata('userMazeData');
		$this->session->unset_userdata('show_first');
		$this->session->unset_userdata('last_maze_insert_id');
		$this->session->unset_userdata('LoginDetails');
		$this->session->unset_userdata('token');
		$this->session->unset_userdata('user_id');
		$this->facebook->destroy_session();
		$this->facebook->logout_url();
		$this->session->unset_userdata('token');
		$this->session->unset_userdata('utm_source');
		redirect(base_url());
	}
	
	
	
	function encrypted_data($formfield)
	{
		$data = $formfield;
		
		if(!empty($data))
		{
			$simple_string = $data; 
			  
			// Store the cipher method 
			$ciphering = "AES-128-CTR"; 
			  
			// Use OpenSSl Encryption method 
			$iv_length = openssl_cipher_iv_length($ciphering); 
			$options = 0; 
			  
			// Non-NULL Initialization Vector for encryption 
			$encryption_iv = '1234567891011121'; 
			  
			// Store the encryption key 
			$encryption_key = "WhenAllThisIsOver"; 
			  
			// Use openssl_encrypt() function to encrypt the data 
			$encryption = openssl_encrypt($simple_string, $ciphering, $encryption_key, $options, $encryption_iv); 
			// $encrypted = $this->encrypted_data(openssl_encrypt($data, $method, $key, OPENSSL_RAW_DATA, $iv));
			
			return $encryption;
		}else{
			return false;
		}
		
	}
	
	function decrypted_data($decryptedformfield)
	{
		$data = $decryptedformfield;
		if(!empty($data))
		{
			// Store the cipher method 
			$ciphering = "AES-128-CTR"; 
			
			$options = 0; 
			
			$decryption_iv = '1234567891011121'; 
		
			// Store the decryption key 
			$decryption_key = "WhenAllThisIsOver"; 
			  
			// Use openssl_decrypt() function to decrypt the data 
			$decryption=openssl_decrypt($data, $ciphering,$decryption_key, $options, $decryption_iv); 
			return $decryption;
		}
		else{
			return false;
		}
		
	}
	
	// Function to get the client IP address
	function get_client_ip() {
		$ipaddress = '';
		if (isset($_SERVER['HTTP_CLIENT_IP']))
			$ipaddress = $_SERVER['HTTP_CLIENT_IP'];
		else if(isset($_SERVER['HTTP_X_FORWARDED_FOR']))
			$ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
		else if(isset($_SERVER['HTTP_X_FORWARDED']))
			$ipaddress = $_SERVER['HTTP_X_FORWARDED'];
		else if(isset($_SERVER['HTTP_FORWARDED_FOR']))
			$ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
		else if(isset($_SERVER['HTTP_FORWARDED']))
			$ipaddress = $_SERVER['HTTP_FORWARDED'];
		else if(isset($_SERVER['REMOTE_ADDR']))
			$ipaddress = $_SERVER['REMOTE_ADDR'];
		else
			$ipaddress = 'UNKNOWN';
		return $ipaddress;
	}
	
	
	function privacy_policy()
	{
		$this->load->view('privacy-policy');
	}
	
	function icons()
	{
		redirect(base_url());
	}
	function url_404()
	{
		redirect(base_url());
		// $this->load->view('404');
	}
}
