<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = 'home';


$route['generate-otp'] = 'home/generate_otp';
$route['validateCaptcha'] = 'home/validateCaptcha';
$route['verify-otp'] = 'home/verify_otp';
$route['resend-otp'] = 'home/resend_otp';

$route['privacy-policy'] = 'home/privacy_policy';
$route['hot-maze'] = 'home/save_data';
$route['submit-maze'] = 'home/submit_data';
// $route['restart-memory-cards'] = 'home/restart_save_data';


$route['thank-you'] = 'home/thank';

$route['facebook-share'] = 'home/fb_share';
$route['twitter-share'] = 'home/tw_share';
$route['whatsapp-share'] = 'home/wt_share';
$route['linkedin-share'] = 'home/ln_share';


$route['logout'] = 'home/logout';


$route['hotmaze'] = 'admin/Admin';
$route['admin/dashboard'] = 'admin/Admin/dashboard';
$route['admin/logout'] = 'admin/Admin/logout';
$route['admin/content-leads'] = 'admin/Admin/contact_leads';
$route['admin/approve/(:any)'] = 'admin/Admin/approved';
$route['admin/disapprove/(:any)'] = 'admin/Admin/disapproved';
/* $route['admin/contact-lead-excel'] = 'admin/Admin/contact_lead_excel';*/
$route['admin/content-lead-reset'] = 'admin/Admin/contact_lead_reset'; 


$route['translate_uri_dashes'] = FALSE;

$route['icons'] = 'home/icons/';
$route['icons/(:any)'] = 'home/icons/';
$route['404.aspx'] = 'home/icons/';
$route['home'] = 'home/icons/';

$route['page-not-found'] = 'home/url_404';


$route['404_override'] = 'home/url_404';