<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Tambola_model extends CI_Model{
    function __construct() {
        $this->usersTbl = 'users'; 
        $this->insert_seq_numbers = 'insert_seq_numbers'; 
		$this->achivementTbl = 'achievements';
		$this->achivementNameTbl = 'achievement';
		$this->playerTbl = 'player';
		$this->gameTbl = 'game';
    }
   
		
		/*  Insert User Details */
		
		function insertUserDetails($loginDetails)
		{
			if($loginDetails['email'])			
			{				
				$email = $loginDetails['email'];			
			}else{				
				$email = null;			
			}						
			if($loginDetails['oauth_uid'])			
			{				
				$oauth_id = $loginDetails['oauth_uid'];			
			}else{
                $oauth_id = null;			
			}
			$insert_array = array(
			'oauth_provider' => $loginDetails['oauth_provider'],
			'access_id' => $oauth_id,
			'email' => $email,
			'profile_pic' => $loginDetails['profile_pic'],
			'full_name' => $loginDetails['full_name'],
			'utm_source' => $this->session->userdata('utm_source'),
			'created_at' => date('Y-m-d H:i:s'),
			'client_ip' => $this->get_client_ip(),
			);
			
			// echo "<pre>";print_r($insert_array);die;
		
			$this->db->where('email',$email);
			$this->db->where('access_id',$oauth_id);
			$res = $this->db->get($this->usersTbl)->row_array();
			
			if($res)
			{
				$this->session->set_userdata('userTambolaData',$res);
				$this->session->set_userdata('show_first',0);
				if($this->session->userdata('utm_source'))
				{
					$utm_source = $this->session->userdata('utm_source');
				}else{
					$utm_source = $res['utm_source'];
				}
				$update_array = array('oauth_provider' => $loginDetails['oauth_provider'],
				'utm_source'=>$utm_source);
				$this->db->where('id',$res['id']);
				$this->db->update($this->usersTbl,$update_array);
				return $res['id'];
			}
			else
			{
				$this->session->set_userdata('show_first',1);
				$this->session->set_userdata('userTambolaData',$insert_array);
				$res = $this->db->insert($this->usersTbl,$insert_array);
				$id = $this->db->insert_id();
				return $id;
			}
			
		}
		
		
		
		
		/* Insert Tambola Number */
		
		function insertTambolaNumber($num)
		{
			$data = array('number'=>$num);
			$res = $this->db->insert($this->insert_seq_numbers,$data);
			return true;
		}
		
		function checkTambolaNumber($click_number)
		{
			$this->db->order_by("id","DESC");
			$num = $this->db->get($this->insert_seq_numbers)->row();
			if($num)
			{
				$get_number = $num->number;
				if($click_number == $get_number)
				{
					return true;
				}else{
					return false;
				}
			}else{
				return false;
			}
		}
		
		function updateTambolaCount($user_id)
		{
			$this->db->set('count', 'count+1', FALSE);
			$this->db->where('id',$user_id);
			$this->db->update($this->usersTbl);
			$res = $this->db->get_where($this->usersTbl,array('id'=>$user_id))->row();
			return $res->count;
		}
		
		
		function getAchievement($param)
		{
			$res = $this->db->get_where($this->achivementTbl,array('achievement_id'=>$param))->row();
			if($res)
			{
				return true;
			}else{
				return false;
			}
		}
		
		function achieversList()
		{
			$this->db->select("$this->achivementNameTbl.*,$this->usersTbl.full_name");
			$this->db->join("$this->achivementTbl","$this->achivementNameTbl.id = $this->achivementTbl.achievement_id",'left');
			$this->db->join("$this->usersTbl","$this->usersTbl.id = $this->achivementTbl.user_id",'left');
			$this->db->order_by("$this->achivementNameTbl.id","ASC");
			$res = $this->db->get("$this->achivementNameTbl")->result();
			return $res;
		}
		
		function insertGameStarted()
		{
			$user_id = $this->session->userdata('user_id');
			// $user_id = 1;
			$res = $this->db->get_where($this->gameTbl,array('user_id'=>$user_id))->row();
			if($res)
			{
				return true;
			}else{
				$this->db->insert($this->gameTbl,array('user_id'=>$user_id,"status"=>1));
				return true;
			}
		}
		
		
		
		
		// Function to get the client IP address
		function get_client_ip() {
			$ipaddress = '';
			if (isset($_SERVER['HTTP_CLIENT_IP']))
				$ipaddress = $_SERVER['HTTP_CLIENT_IP'];
			else if(isset($_SERVER['HTTP_X_FORWARDED_FOR']))
				$ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
			else if(isset($_SERVER['HTTP_X_FORWARDED']))
				$ipaddress = $_SERVER['HTTP_X_FORWARDED'];
			else if(isset($_SERVER['HTTP_FORWARDED_FOR']))
				$ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
			else if(isset($_SERVER['HTTP_FORWARDED']))
				$ipaddress = $_SERVER['HTTP_FORWARDED'];
			else if(isset($_SERVER['REMOTE_ADDR']))
				$ipaddress = $_SERVER['REMOTE_ADDR'];
			else
				$ipaddress = 'UNKNOWN';
			return $ipaddress;
		}
		
		function insertJson($json)
		{
			$user_id = $this->session->userdata('user_id');
			// $user_id = 1;
			
			$array = array(
			'user_id' => $user_id,
			'game_id' => 1,
			'invitee_status' => 'yes',
			'json_slip' => $json,
			'created_at' => date("Y-m-d H:i:s")
			);
			$this->db->insert($this->playerTbl,$array);
			return true;
			
		}
		
		function getJsonArray()
		{
			$user_id = $this->session->userdata('user_id');
			// $user_id = 1;
			if($user_id)
			{
				$this->db->where('user_id',$user_id);
				$res = $this->db->get($this->playerTbl)->row();
				if($res)
				{
					return $res;
				}else{
					return false;
				}
			}else{
				return false;
			}
			
		}
		
		function checkGameModeStatus()
		{
			$res = $this->db->get($this->gameTbl)->row();
			if($res)
			{
				return "Started";
			}else{
				return "Not Started";
			}
		}
		
		function checkLastNumber()
		{
			$this->db->order_by("id","DESC");
			$num = $this->db->get($this->insert_seq_numbers)->row();
			if($num)
			{
				return $num->number;
			}else{
				return 0;
			}
		}
		
		
		function getAchievements()
		{
			$res = $this->db->get($this->achivementNameTbl)->result();
			return $res;
		}
		
		function updateTambolaPostJson($user_id,$jsonData)
		{
			$update = array(
			'json_slip' => $jsonData
			);
			$this->db->where("user_id",$user_id);
			$this->db->update($this->playerTbl,$update);
			return true;
		}
		
		function getJsonCompleteData($user_id)
		{
			$this->db->where("user_id",$user_id);
			$res = $this->db->get($this->playerTbl)->row();
			if($res)
			{
				return $res->json_slip;
			}else{
				return false;
			}
		}
		
		function insertAchievement($user_id,$achieve_id)
		{
			$insert_array = array(
			'player_id' => $user_id,
			'user_id' => $user_id,
			'achievement_id' => $achieve_id
			);
			
			$this->db->insert($this->achivementTbl,$insert_array);
			return true;
		}
		
		
		
		
}
?>