<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Tambola_model extends CI_Model{
    function __construct() {
        $this->usersTbl = 'users'; 
        $this->insert_seq_numbers = 'insert_seq_numbers'; 
		$this->achivementTbl = 'achievements';
		$this->achivementNameTbl = 'achievement';
		$this->playerTbl = 'player';
		$this->gameTbl = 'game';
		$this->inviteEmailsTbl = 'invitee_mails';
    }
   
		
		/*  Insert User Details */
		
		function insertUserDetails($loginDetails)
		{
			if($loginDetails['email'])			
			{				
				$email = $loginDetails['email'];			
			}else{				
				$email = null;			
			}						
			if($loginDetails['oauth_uid'])			
			{				
				$oauth_id = $loginDetails['oauth_uid'];			
			}else{
                $oauth_id = null;			
			}
			$insert_array = array(
			'oauth_provider' => $loginDetails['oauth_provider'],
			'access_id' => $oauth_id,
			'email' => $email,
			'profile_pic' => $loginDetails['profile_pic'],
			'full_name' => $loginDetails['full_name'],
			'utm_source' => $this->session->userdata('utm_source'),
			'created_at' => date('Y-m-d H:i:s'),
			'client_ip' => $this->get_client_ip(),
			);
			
			// echo "<pre>";print_r($insert_array);die;
		
			$this->db->where('email',$email);
			$this->db->where('access_id',$oauth_id);
			$res = $this->db->get($this->usersTbl)->row_array();
			
			if($res)
			{
				$this->session->set_userdata('userTambolaData',$res);
				$this->session->set_userdata('show_first',0);
				if($this->session->userdata('utm_source'))
				{
					$utm_source = $this->session->userdata('utm_source');
				}else{
					$utm_source = $res['utm_source'];
				}
				$update_array = array('oauth_provider' => $loginDetails['oauth_provider'],
				'utm_source'=>$utm_source);
				$this->db->where('id',$res['id']);
				$this->db->update($this->usersTbl,$update_array);
				return $res['id'];
			}
			else
			{
				$this->session->set_userdata('show_first',1);
				$this->session->set_userdata('userTambolaData',$insert_array);
				$res = $this->db->insert($this->usersTbl,$insert_array);
				$id = $this->db->insert_id();
				return $id;
			}
			
		}
		
		
		
		
		/* Insert Tambola Number */
		
		function insertTambolaNumber($num)
		{
			$user_id = $this->session->userdata('user_id');
			$game_uid = $this->session->userdata('game_uid');
			// $user_id = 1;
			$data = array('number'=>$num,'user_id'=>$user_id,'game_uid'=>$game_uid);
			$res = $this->db->insert($this->insert_seq_numbers,$data);
			return true;
		}
		
		function checkTambolaNumber($click_number,$game_uid)
		{
			
			$this->db->where('game_uid',$game_uid);
			$this->db->where('number',$click_number);
			// $this->db->order_by("id","DESC");
			$num = $this->db->get($this->insert_seq_numbers)->row();
			if($num)
			{
				return true;
				/* $get_number = $num->number;
				if($click_number == $get_number)
				{
					return true;
				}else{
					return false;
				} */
			}else{
				return false;
			}
		}
		
		function updateTambolaCount($user_id)
		{
			$this->db->set('count', 'count+1', FALSE);
			$this->db->where('id',$user_id);
			$this->db->update($this->usersTbl);
			$res = $this->db->get_where($this->usersTbl,array('id'=>$user_id))->row();
			return $res->count;
		}
		
		
		function getAchievement($param)
		{
			$game_uid = $this->session->userdata('game_uid');
			$res = $this->db->get_where($this->achivementTbl,array('achievement_id'=>$param,'game_uid'=>$game_uid))->row();
			if($res)
			{
				return true;
			}else{
				return false;
			}
		}
		
		function achieversList()
		{
			$game_uid = $this->session->userdata('game_uid');
			/* $this->db->select("$this->achivementNameTbl.*,$this->usersTbl.full_name");
			$this->db->join("$this->achivementTbl","$this->achivementNameTbl.id = $this->achivementTbl.achievement_id",'left');
			$this->db->join("$this->usersTbl","$this->usersTbl.id = $this->achivementTbl.user_id",'left');
			$this->db->where("$this->achivementTbl.game_uid",$game_id); */
			$this->db->order_by("$this->achivementNameTbl.id","ASC");
			$res = $this->db->get("$this->achivementNameTbl")->result();
			return $res;
		}
		
		function getAchieversListName($id)
		{
			$game_uid = $this->session->userdata('game_uid');
			$this->db->select("$this->usersTbl.full_name,$this->usersTbl.email");
			$this->db->join("$this->achivementNameTbl","$this->achivementNameTbl.id = $this->achivementTbl.achievement_id");
			$this->db->join("$this->usersTbl","$this->usersTbl.id = $this->achivementTbl.user_id");
			$this->db->where("$this->achivementTbl.game_uid",$game_uid);
			$this->db->where("$this->achivementTbl.achievement_id",$id);
			$res = $this->db->get("$this->achivementTbl")->row();
			if($res)
			{
				return $res->full_name." (".$res->email.")";
			}else{
				return false;
			}
			
		}
		
		function getAchieversList($game_uid)
		{
			$this->db->select("$this->usersTbl.full_name,$this->usersTbl.email,$this->achivementNameTbl.name as ach_name");
			$this->db->join("$this->achivementNameTbl","$this->achivementNameTbl.id = $this->achivementTbl.achievement_id");
			$this->db->join("$this->usersTbl","$this->usersTbl.id = $this->achivementTbl.user_id");
			$this->db->where("$this->achivementTbl.game_uid",$game_uid);
			$res = $this->db->get("$this->achivementTbl")->result();
			if($res)
			{
				return $res;
			}else{
				return false;
			}
			
		}
		
		function updateGameStarted()
		{
			$user_id = $this->session->userdata('user_id');
			$game_uid = $this->session->userdata('game_uid');
			$whereArray = array('user_id'=>$user_id,'game_uid'=>$game_uid);
			$this->db->where($whereArray);
			$res_game = $this->db->get($this->gameTbl)->row();
			if($res_game)
			{
				if($res_game->status == 0)
				{
					$this->db->where($whereArray);
					$this->db->update($this->gameTbl,array('status'=>1));
					return true;
				}else{
					return true;
				}
			}
			
			return true;
			
		}
		
		
		
		
		// Function to get the client IP address
		function get_client_ip() {
			$ipaddress = '';
			if (isset($_SERVER['HTTP_CLIENT_IP']))
				$ipaddress = $_SERVER['HTTP_CLIENT_IP'];
			else if(isset($_SERVER['HTTP_X_FORWARDED_FOR']))
				$ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
			else if(isset($_SERVER['HTTP_X_FORWARDED']))
				$ipaddress = $_SERVER['HTTP_X_FORWARDED'];
			else if(isset($_SERVER['HTTP_FORWARDED_FOR']))
				$ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
			else if(isset($_SERVER['HTTP_FORWARDED']))
				$ipaddress = $_SERVER['HTTP_FORWARDED'];
			else if(isset($_SERVER['REMOTE_ADDR']))
				$ipaddress = $_SERVER['REMOTE_ADDR'];
			else
				$ipaddress = 'UNKNOWN';
			return $ipaddress;
		}
		
		function insertJson($json)
		{
			$user_id = $this->session->userdata('user_id');
			$game_id = $this->session->userdata('game_uid');
			// $user_id = 1;
			
			$array = array(
			'user_id' => $user_id,
			'game_uid' => $game_id,
			'invitee_status' => 'yes',
			'json_slip' => $json,
			'created_at' => date("Y-m-d H:i:s")
			);
			$this->db->insert($this->playerTbl,$array);
			return true;
			
		}
		
		function getJsonArray()
		{
			$user_id = $this->session->userdata('user_id');
			$game_id = $this->session->userdata('game_uid');
			// $user_id = 1;
			if($user_id)
			{
				$this->db->where('user_id',$user_id);
				$this->db->where('game_uid',$game_id);
				$res = $this->db->get($this->playerTbl)->row();
				if($res)
				{
					return $res;
				}else{
					return false;
				}
			}else{
				return false;
			}
			
		}
		
		function checkGameModeStatus($game_id)
		{
			$this->db->where('game_uid',$game_id);
			// $this->db->where('status',1);
			$res = $this->db->get($this->gameTbl)->row();
			if($res)
			{
				if($res->status == 0)
				{
					return "Not Started";
				}elseif($res->status == 1)
				{
					return "Started";
				}
				else
				{
					return "Game Ended";
				}
			}else{
				return "Not Started";
			}
		}
		
		function checkLastNumber($game_id)
		{
			$this->db->where('game_uid',$game_id);
			$this->db->order_by("id","DESC");
			$num = $this->db->get($this->insert_seq_numbers)->row();
			if($num)
			{
				return $num->number;
			}else{
				return 0;
			}
		}
		
		
		function getAchievements()
		{
			$res = $this->db->get($this->achivementNameTbl)->result();
			return $res;
		}
		
		function updateTambolaPostJson($user_id,$jsonData,$game_uid)
		{
			$update = array(
			'json_slip' => $jsonData
			);
			$this->db->where("user_id",$user_id);
			$this->db->where("game_uid",$game_uid);
			$this->db->update($this->playerTbl,$update);
			return true;
		}
		
		function getJsonCompleteData($user_id,$game_id)
		{
			$this->db->where("user_id",$user_id);
			$this->db->where("game_uid",$game_id);
			$res = $this->db->get($this->playerTbl)->row();
			if($res)
			{
				return $res->json_slip;
			}else{
				return false;
			}
		}
		
		function insertAchievement($user_id,$achieve_id)
		{
			$game_uid = $this->session->userdata('game_uid');
			$insert_array = array(
			'player_id' => $user_id,
			'game_uid' => $game_uid,
			'user_id' => $user_id,
			'achievement_id' => $achieve_id
			);
			
			$this->db->insert($this->achivementTbl,$insert_array);
			if($game_uid)
			{
				$res = $this->db->get_where($this->achivementTbl,array('game_uid' => $game_uid))->result();
				if(count($res) == 6)
				{
					$this->db->where("game_uid",$game_uid);
					$this->db->update($this->gameTbl,array('status'=>2));
				}
			}
			
			return true;
		}
		
		function inviteeEmails($data)
		{
			$this->db->insert($this->inviteEmailsTbl,$data);
			return true;
		}
		
		function inviteeGame($data)
		{
			$this->db->where('game_uid',$data['game_uid']);
			$res = $this->db->get($this->gameTbl)->row();
			if(empty($res))
			{
				$this->db->insert($this->gameTbl,$data);
			}
			return true;
		}
		
		function createdGames($user_id)
		{
			$this->db->select("$this->inviteEmailsTbl.game_uid,$this->gameTbl.game_name,$this->gameTbl.game_star_time,GROUP_CONCAT($this->inviteEmailsTbl.email SEPARATOR ',') as emails,$this->gameTbl.status,$this->gameTbl.created_at");
			$this->db->join("$this->inviteEmailsTbl","$this->inviteEmailsTbl.game_uid = $this->gameTbl.game_uid");
			$this->db->where("$this->gameTbl.user_id",$user_id);
			$this->db->order_by("$this->gameTbl.id");
			$this->db->group_by("$this->gameTbl.game_uid");
			//$this->db->order_by(DATE_FORMAT("game_star_time, '%Y-%m-%d'"), "ASC");
			$res = $this->db->get($this->gameTbl)->result();
			
			return $res;
		}
		
		function checkCreatedGame($user_id,$game_id)
		{
			$checkArray = array(
			'user_id' =>$user_id,
			'game_uid' =>$game_id,
			'status !=' =>2,
			);
			$this->db->where($checkArray);
			$res = $this->db->get($this->gameTbl)->row();
			// echo $this->db->last_query();die;
			return $res;
		}
		
		function checkInvitationList($user_email)
		{
			$this->db->select("$this->usersTbl.full_name,$this->usersTbl.email,$this->inviteEmailsTbl.email as invite_email,$this->inviteEmailsTbl.game_uid as game_id,$this->gameTbl.status as game_status,$this->gameTbl.created_at");
			$this->db->join("$this->usersTbl","$this->inviteEmailsTbl.user_id = $this->usersTbl.id");
			$this->db->join("$this->gameTbl","$this->gameTbl.game_uid = $this->inviteEmailsTbl.game_uid");
			$this->db->where("$this->inviteEmailsTbl.email",$user_email);
			$res = $this->db->get($this->inviteEmailsTbl)->result();
			return $res;
		}
		
		function checkGameEmail($email,$game_id)
		{
			$checkArray = array(
			'email' =>$email,
			'game_uid' =>$game_id,
			);
			$this->db->where($checkArray);
			$res = $this->db->get($this->inviteEmailsTbl)->row();
			if($res)
			{
				$this->db->where($checkArray);
				$this->db->update($this->inviteEmailsTbl,array('status'=>1));
				return $res;
			}else{
				return false;
			}
			
		}								function getGameDateTime($game_id)		{			$this->db->select("created_at");			$this->db->where('game_uid',$game_id);			$res_game = $this->db->get($this->gameTbl)->row();			return $res_game;		}
		
		
		
		
		
		
}
?>