<?php
// phpinfo();
defined('BASEPATH') OR exit('No direct script access allowed');

class Home extends CI_Controller {

	function __construct() {
        parent::__construct();
		// echo "Under Cosntruction";die;
        $this->load->model('tambola_model');
		include_once APPPATH."libraries/google-api-php-client/Google_Client.php";
		include_once APPPATH."libraries/google-api-php-client/contrib/Google_Oauth2Service.php";
    }
	
	public function index()
	{
		//============== Google API=============	
			// Google Project API Credentials
		
		
		// Google Project API Credentials
		$clientId = GOOGLE_CLIENT_ID;
		$clientSecret = GOOGLE_SECRET;
		$redirectUrl = BASE_URL;
		
		// Google Client Configuration
		$gClient = new Google_Client();
		$gClient->setApplicationName('HO Tambola');
		$gClient->setClientId($clientId);
		$gClient->setClientSecret($clientSecret);
		$gClient->setRedirectUri($redirectUrl);
		$google_oauthV2 = new Google_Oauth2Service($gClient);

		if (isset($_REQUEST['code']) && isset($_REQUEST['scope'])) {
			$gClient->authenticate();
			$this->session->set_userdata('token', $gClient->getAccessToken());
			redirect($redirectUrl);
		}

		$token = $this->session->userdata('token');
		if (!empty($token)) {
			$gClient->setAccessToken($token);
		}

		if ($gClient->getAccessToken()) {
			$userProfile = $google_oauthV2->userinfo->get();
			// Preparing data for database insertion
			$userData['oauth_provider'] = 'google';
			$userData['oauth_uid'] = $userProfile['id'];
			$userData['email'] = $userProfile['email'];
			$userData['full_name'] = $userProfile['name'];
			$userData['profile_pic'] = $userProfile['picture'];
			$data['google_authUrl'] = '';
			$this->session->set_userdata('LoginDetails',$userData);
			
		} else 
		{
			$data['google_authUrl'] = $gClient->createAuthUrl();
		}
		
		// echo "<pre>";print_r($userData);die;
		if(isset($userData['email']))
		{
			$res = $this->tambola_model->insertUserDetails($userData);
			$this->session->set_userdata('user_id',$res);
			if($userData['email'] == Email)
			{
				$data["achievers"] = $this->tambola_model->achieversList();
				$this->load->view('index',$data);
			}
			else{
				$user_id = $this->session->userdata('user_id');
				// $user_id = 1;
				$jsonAvailableData = $this->tambola_model->getJsonCompleteData($user_id);
				if($jsonAvailableData)
				{
					$data['checkCorners'] = $this->checkCorners($jsonAvailableData);
					$data['checkFirstLine'] = $this->checkFirstLine($jsonAvailableData);
					$data['checkSecondLine'] = $this->checkSecondLine($jsonAvailableData);
					$data['checkBottomLine'] = $this->checkBottomLine($jsonAvailableData);
					$data['checkEarlyFive'] = $this->checkEarlyFive($jsonAvailableData);
					$data['checkFullHouse'] = $this->checkFullHouse($jsonAvailableData);
				}else{
					$data['checkCorners'] = '';
					$data['checkFirstLine'] = '';
					$data['checkSecondLine'] = '';
					$data['checkBottomLine'] = '';
					$data['checkEarlyFive'] = '';
					$data['checkFullHouse'] = '';
				}
				$data["achievers"] = $this->tambola_model->achieversList();
				$data["game_status"] = $this->tambola_model->checkGameModeStatus();
				$data["last_number"] = $this->tambola_model->checkLastNumber();
				$this->load->view('tambola-game',$data);
			}
		}else{
			if($this->session->userdata('verify_otp'))
			{
				// $this->session->set_userdata('show_first',1);
				$this->session->unset_userdata('verify_otp');
			}else{
				$this->session->set_userdata('show_first',0);
				
			}
			$data["achievers"] = $this->tambola_model->achieversList();
			$this->load->view('index',$data);
		}
		
                
		
	}
	
	
	function tambola()
	{
		$number = $this->input->post('num');
		$res = $this->tambola_model->insertTambolaNumber($number);
		$res = $this->tambola_model->insertGameStarted($number);
		echo 1;
	}
	
	function tambola_game()
	{
		$user_id = $this->session->userdata('user_id');
		// $user_id = 1;
		$jsonAvailableData = $this->tambola_model->getJsonCompleteData($user_id);
		if($jsonAvailableData)
		{
			$data['checkCorners'] = $this->checkCorners($jsonAvailableData);
			$data['checkFirstLine'] = $this->checkFirstLine($jsonAvailableData);
			$data['checkSecondLine'] = $this->checkSecondLine($jsonAvailableData);
			$data['checkBottomLine'] = $this->checkBottomLine($jsonAvailableData);
			$data['checkEarlyFive'] = $this->checkEarlyFive($jsonAvailableData);
			$data['checkFullHouse'] = $this->checkFullHouse($jsonAvailableData);
		}else{
			$data['checkCorners'] = '';
			$data['checkFirstLine'] = '';
			$data['checkSecondLine'] = '';
			$data['checkBottomLine'] = '';
			$data['checkEarlyFive'] = '';
			$data['checkFullHouse'] = '';
		}
		$data["last_number"] = $this->tambola_model->checkLastNumber();
		$data["achievers"] = $this->tambola_model->achieversList();
		$data["game_status"] = $this->tambola_model->checkGameModeStatus();
		$this->load->view('tambola-game',$data);
	}
	
	function check()
	{
		$number = $this->input->post('num');
		$map = $this->input->post('map');
		$res = $this->tambola_model->checkTambolaNumber($number);
		if($res)
		{
			$user_id = $this->session->userdata('user_id');
			// $user_id = 1;
			$count_number = $this->tambola_model->updateTambolaCount($user_id);
			
			$jsonAvailableData = $this->tambola_model->getJsonCompleteData($user_id);
			if($jsonAvailableData){
				$json = json_decode($jsonAvailableData);
			}else{
				$json = json_decode($map);
			}
			
			
			$updateJsonData = $this->updateJsonArray($json,$number);
			$updateJson = $this->tambola_model->updateTambolaPostJson($user_id,$updateJsonData);
			
			$checkCorners = $this->checkCorners($updateJsonData);
			$checkFirstLine = $this->checkFirstLine($updateJsonData);
			$checkSecondLine = $this->checkSecondLine($updateJsonData);
			$checkBottomLine = $this->checkBottomLine($updateJsonData);
			$checkEarlyFive = $this->checkEarlyFive($updateJsonData);
			$checkFullHouse = $this->checkFullHouse($updateJsonData);
			/* $achievements_array = $this->tambola_model->getAchievements();
			$achievement_array = array();
			foreach($achievements_array as $k=>$v)
			{
				$get_achievement = $this->tambola_model->getAchievement($v->id);
				if($get_achievement)
				{
					array_push($achievement_array,1);
				}else{
					array_push($achievement_array,0);
				}
			} */
			$res = array('res'=>1,'count'=>$count_number,'achievements'=>array($checkCorners,$checkEarlyFive,$checkFirstLine,$checkSecondLine,$checkBottomLine,$checkFullHouse));
			echo json_encode($res);
		}else{
			$res = array('res'=>0,'count'=>0,'achievements'=>array(0,0,0,0,0,0));
			echo json_encode($res);
		}
	}
	
	
	function updateJsonArray($row,$number)
	{
		$new_array = array([],[],[]);
		for ($i=0; $i<sizeof($row); $i++) 
		{
			for ($j=0; $j<9; $j++) {
				if($row[$i][$j])
				{
					$num = explode("/",$row[$i][$j]);
					if($num[0] == $number)
					{
						array_push($new_array[$i],$number."/1");
					}else{
						array_push($new_array[$i],$row[$i][$j]);
					}
				}else{
					array_push($new_array[$i],$row[$i][$j]);
				}
			}
		}
		// print_r($new_array);die;
		return json_encode($new_array);
	}
	
	
	function checkCorners($json)
	{
		// $i = 0
		$corner_array = array();
		$decode_json = json_decode($json);
		$first_array = array_values(array_filter($decode_json[0]));
		$last_array = array_values(array_filter($decode_json[2]));
		$corner_array = array($first_array[0],$first_array[4],$last_array[0],$last_array[4]);
		// $corner_array = array("55/1","55/1","55/1","55/1");
		foreach($corner_array as $v)
		{
			$value = explode('/',$v);
			if($value[1])
			{
				$corner = 1;
			}else{
				$corner = 0;break;
			}
		}
		if($corner)
		{
			$get_achievement = $this->tambola_model->getAchievement(1);
			if($get_achievement)
			{
				return 0;
			}else{
				return 1;
			}
		}else{
			return 0;
		}
		
	}
	
	function checkFirstLine($json)
	{
		$decode_json = json_decode($json);
		$first_array = array_values(array_filter($decode_json[0]));
		
		foreach($first_array as $v)
		{
			$value = explode('/',$v);
			if($value[1])
			{
				$first = 1;
			}else{
				$first = 0;break;
			}
		}
		if($first)
		{
			$get_achievement = $this->tambola_model->getAchievement(3);
			if($get_achievement)
			{
				return 0;
			}else{
				return 1;
			}
		}else{
			return 0;
		}
		
	}
	
	function checkSecondLine($json)
	{
		$decode_json = json_decode($json);
		$middle_array = array_values(array_filter($decode_json[1]));
		foreach($middle_array as $v)
		{
			$value = explode('/',$v);
			if($value[1])
			{
				$middle = 1;
			}else{
				$middle = 0;break;
			}
		}
		if($middle)
		{
			$get_achievement = $this->tambola_model->getAchievement(4);
			if($get_achievement)
			{
				return 0;
			}else{
				return 1;
			}
		}else{
			return 0;
		}
	}
	
	function checkBottomLine($json)
	{
		$decode_json = json_decode($json);
		$bottom_array = array_values(array_filter($decode_json[2]));
		foreach($bottom_array as $v)
		{
			$value = explode('/',$v);
			if($value[1])
			{
				$bottom = 1;
			}else{
				$bottom = 0;break;
			}
		}
		if($bottom)
		{
			$get_achievement = $this->tambola_model->getAchievement(5);
			if($get_achievement)
			{
				return 0;
			}else{
				return 1;
			}
		}else{
			return 0;
		}
	}
	
	function checkEarlyFive($json)
	{
		$count = 0;
		$decode_json = json_decode($json);
		for ($i=0; $i<sizeof($decode_json); $i++) 
		{
			for ($j=0; $j<9; $j++) {
				if($decode_json[$i][$j])
				{
					$num = explode("/",$decode_json[$i][$j]);
					if($num[1])
					{
						$count++;
					}
				}
			}
		}
		if($count >= 5)
		{
			$get_achievement = $this->tambola_model->getAchievement(2);
			if($get_achievement)
			{
				return 0;
			}else{
				return 1;
			}
		}else{
			return 0;
		}
	}
	
	function checkFullHouse($json)
	{
		$full_count = 0;
		$decode_json = json_decode($json);
		for ($i=0; $i<sizeof($decode_json); $i++) 
		{
			for ($j=0; $j<9; $j++) {
				if($decode_json[$i][$j])
				{
					$num = explode("/",$decode_json[$i][$j]);
					if($num[1])
					{
						$full_count++;
					}
				}
			}
		}
		if($full_count >= 15)
		{
			$get_achievement = $this->tambola_model->getAchievement(6);
			if($get_achievement)
			{
				return 0;
			}else{
				return 1;
			}
		}else{
			return 0;
		}
	}
	
	
	function complete()
	{
		$user_id = $this->session->userdata('user_id');
		// $user_id = 1;
		$track = $this->input->post('track');
		$jsonCompleteData = $this->tambola_model->getJsonCompleteData($user_id);
		if($jsonCompleteData)
		{
			// print_r($jsonCompleteData);
			if($track == 'corner')
			{
				$res = $this->checkCorners($jsonCompleteData);
				if($res)
				{
					$insert_achievement = $this->tambola_model->insertAchievement($user_id,1);
					echo 1;
				}else{
					echo  2;
				}
			}elseif($track == 'early'){
				$res = $this->checkEarlyFive($jsonCompleteData);
				if($res)
				{
					$insert_achievement = $this->tambola_model->insertAchievement($user_id,2);
					echo 1;
				}else{
					echo 2;
				}
			}elseif($track == 'first'){
				$res = $this->checkFirstLine($jsonCompleteData);
				if($res)
				{
					$insert_achievement = $this->tambola_model->insertAchievement($user_id,3);
					echo 1;
				}else{
					echo 2;
				}
			}elseif($track == 'middle'){
				$res = $this->checkSecondLine($jsonCompleteData);
				if($res)
				{
					$insert_achievement = $this->tambola_model->insertAchievement($user_id,4);
					echo 1;
				}else{
					echo 2;
				}
			}elseif($track == 'last'){
				$res = $this->checkBottomLine($jsonCompleteData);
				if($res)
				{
					$insert_achievement = $this->tambola_model->insertAchievement($user_id,5);
					echo 1;
				}else{
					echo 2;
				}
			}elseif($track == 'full'){
				$res = $this->checkFullHouse($jsonCompleteData);
				if($res)
				{
					$insert_achievement = $this->tambola_model->insertAchievement($user_id,6);
					echo 1;
				}else{
					echo 2;
				}
			}else{
				echo 0;
			}
		}else{
			echo 0;
		}
		
	}
	
	function gameMode()
	{
		$res = $this->tambola_model->checkGameModeStatus();
		echo $res;
	}
	
	function callNumber()
	{
		$res = $this->tambola_model->checkLastNumber();
		echo $res;
	}
	
	function gameAchievements()
	{
		$data = $this->tambola_model->achieversList();
		foreach($data as $k=>$v)
		{
			?>
			<tr>
				<td><?php echo $v->name; ?></td>
				<td><?php echo $v->full_name; ?></td>
			</tr>
			<?php
		}
	}
	
	function gameAchievementsHome()
	{
		$data = $this->tambola_model->achieversList();
		foreach($data as $k=>$v)
		{
			?>
			<tr>
				<th><?php echo $v->name; ?></th>
				<th><?php echo $v->full_name; ?></th>
			</tr>
			<?php
		}
	}
	
	function validateCaptcha()
	{
		$captcha = $this->input->post('token2');
        if (!$captcha) {
            echo '<h2>Please check the the captcha form.</h2>';
            exit;
        }
        $secretKey = SECRET_KEY;
        $ip = $_SERVER['REMOTE_ADDR'];

        // post request to server
        $url = 'https://www.google.com/recaptcha/api/siteverify';
        $data = array('secret' => $secretKey, 'response' => $captcha);

        $options = array(
            'http' => array(
                'header' => "Content-type: application/x-www-form-urlencoded\r\n",
                'method' => 'POST',
                'content' => http_build_query($data)
            )
        );
        $context = stream_context_create($options);
        $response = file_get_contents($url, false, $context);
        $responseKeys = json_decode($response, true);
        header('Content-type: application/json');
        if ($responseKeys["success"]) {
            echo json_encode(array('success' => 'true'));
        } else {
            echo json_encode(array('success' => 'false'));
        }
        exit;
	}
	
	
	
	
	
	
	
	function decode_str($str) 
	{
		$str = strtoupper($str);
		$unit_size = 4;
		$alphatonum = function($s) {
			$alpha_map = ['P', 'M', 'S', 'K'];
			$l = strlen($s);
			$s_ = '';
			for ($x = 0; $x < $l; $x++) {
				$pos = array_search($s[$x], $alpha_map);
				$s_ .= in_array($s[$x], $alpha_map) ? array_search($s[$x], $alpha_map) : $s[$x];
			}
			return $s_;
		};
		
		$decoded    = '';
		$salt       = $alphatonum(substr($str, -3));     
		$data       = $alphatonum(substr($str, 0, strlen($str) - 3));
		
		$loop       = strlen($data) / $unit_size;
		$unit_arr   = [];
		for ($x = 0; $x < $loop; $x++) {
			$unit = substr($data, $x * $unit_size, $unit_size);
			
			$ascii_ = ($unit % 1000) - $salt;
			$decoded .= chr($ascii_);
		}
    
		return $decoded;
	}
	
	
	
	

	
	function logout()
	{
		$this->session->unset_userdata('close',1);
		$this->session->unset_userdata('userTambolaData');
		$this->session->unset_userdata('show_first');
		$this->session->unset_userdata('LoginDetails');
		$this->session->unset_userdata('token');
		$this->session->unset_userdata('user_id');
		$this->session->unset_userdata('token');
		$this->session->unset_userdata('utm_source');
		session_destroy();
		redirect(base_url());
	}
	
	
	
	function encrypted_data($formfield)
	{
		$data = $formfield;
		
		if(!empty($data))
		{
			$simple_string = $data; 
			  
			// Store the cipher method 
			$ciphering = "AES-128-CTR"; 
			  
			// Use OpenSSl Encryption method 
			$iv_length = openssl_cipher_iv_length($ciphering); 
			$options = 0; 
			  
			// Non-NULL Initialization Vector for encryption 
			$encryption_iv = '1234567891011121'; 
			  
			// Store the encryption key 
			$encryption_key = "WhenAllThisIsOver"; 
			  
			// Use openssl_encrypt() function to encrypt the data 
			$encryption = openssl_encrypt($simple_string, $ciphering, $encryption_key, $options, $encryption_iv); 
			// $encrypted = $this->encrypted_data(openssl_encrypt($data, $method, $key, OPENSSL_RAW_DATA, $iv));
			
			return $encryption;
		}else{
			return false;
		}
		
	}
	
	function decrypted_data($decryptedformfield)
	{
		$data = $decryptedformfield;
		if(!empty($data))
		{
			// Store the cipher method 
			$ciphering = "AES-128-CTR"; 
			
			$options = 0; 
			
			$decryption_iv = '1234567891011121'; 
		
			// Store the decryption key 
			$decryption_key = "WhenAllThisIsOver"; 
			  
			// Use openssl_decrypt() function to decrypt the data 
			$decryption=openssl_decrypt($data, $ciphering,$decryption_key, $options, $decryption_iv); 
			return $decryption;
		}
		else{
			return false;
		}
		
	}
	
	// Function to get the client IP address
	function get_client_ip() {
		$ipaddress = '';
		if (isset($_SERVER['HTTP_CLIENT_IP']))
			$ipaddress = $_SERVER['HTTP_CLIENT_IP'];
		else if(isset($_SERVER['HTTP_X_FORWARDED_FOR']))
			$ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
		else if(isset($_SERVER['HTTP_X_FORWARDED']))
			$ipaddress = $_SERVER['HTTP_X_FORWARDED'];
		else if(isset($_SERVER['HTTP_FORWARDED_FOR']))
			$ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
		else if(isset($_SERVER['HTTP_FORWARDED']))
			$ipaddress = $_SERVER['HTTP_FORWARDED'];
		else if(isset($_SERVER['REMOTE_ADDR']))
			$ipaddress = $_SERVER['REMOTE_ADDR'];
		else
			$ipaddress = 'UNKNOWN';
		return $ipaddress;
	}
	
	
	function privacy_policy()
	{
		$this->load->view('privacy-policy');
	}
	
	function icons()
	{
		redirect(base_url());
	}
	function url_404()
	{
		redirect(base_url());
		// $this->load->view('404');
	}
}
