<?php

namespace Microsoft\BingAds\V13\CampaignManagement;

{
    /**
     * Retrieves the specified audiences from the specified account.
     * @link https://docs.microsoft.com/en-us/advertising/campaign-management-service/getaudiencesbyids?view=bingads-13 GetAudiencesByIds Request Object
     * 
     * @uses AudienceType
     * @uses AudienceAdditionalField
     * @used-by BingAdsCampaignManagementService::GetAudiencesByIds
     */
    final class GetAudiencesByIdsRequest
    {
        /**
         * A maximum of 100 identifiers of the requested audiences.
         * @var integer[]
         */
        public $AudienceIds;

        /**
         * The type of audiences to return.
         * @var AudienceType
         */
        public $Type;

        /**
         * Reserved.
         * @var AudienceAdditionalField
         */
        public $ReturnAdditionalFields;
    }
}
