<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Reports_model extends CI_Model{
    function __construct() {
        $this->channelGroupsTbl = 'channel_group'; 
        $this->channels = 'channel'; 
        $this->brandDailyImportTbl = 'daily_import_data'; 
        $this->brandTbl = 'brands'; 
		$this->brandCostTbl = 'brand_cost_table';
		$this->brandBudgetTbl = 'brand_budget_table';
		$this->websiteRevenueTbl = 'website_revenue_table';
		$this->brandChannelTypeMAppingTbl = 'brand_channel_type_mapping'; 
		$this->brandMappedUserTbl = 'brand_user_mapping'; 
    }
	
	
	function getDailyImportData($where_array)
	{
		$where_array["agency_id"] = $this->session->userdata('loginUserData')['agency_id'];
		$this->db->select("$this->channelGroupsTbl.id as channel_group_id,$this->channelGroupsTbl.name as channel_group_name,SUM($this->brandDailyImportTbl.revenue) as day_channel_revenue");
		$this->db->join($this->brandDailyImportTbl,"$this->channelGroupsTbl.id=$this->brandDailyImportTbl.channel_group_id",'left');
		$this->db->where($where_array);
		$this->db->group_by("$this->channelGroupsTbl.id"); 
		$res = $this->db->get($this->channelGroupsTbl)->result();
		return $res;
	}
	
	function getMonthDailyImportData($brand_id,$total_days,$month,$year)
	{
		$start_date = "$year-$month-01";
		$end_date = "$year-$month-$total_days";
		$this->db->select("$this->channelGroupsTbl.id as channel_group_id,$this->channelGroupsTbl.name as channel_group_name,SUM($this->brandDailyImportTbl.revenue) as total_channel_revenue");
		$this->db->join($this->brandDailyImportTbl,"$this->channelGroupsTbl.id=$this->brandDailyImportTbl.channel_group_id",'left');
		$this->db->where('brand_id',$brand_id);
		$this->db->where('agency_id',$this->session->userdata('loginUserData')['agency_id']);
		$this->db->where('date >=',$start_date);
		$this->db->where('date <=',$end_date);
		$this->db->group_by("$this->channelGroupsTbl.id"); 
		$res = $this->db->get($this->channelGroupsTbl)->result();
		return $res;
	}
	
	function getBrands()
	{
		$user_id = $this->session->userdata('userId');
		if($user_id)
		{
			$resultBrandIds = $this->getUserBrandsIds($user_id);
		}else{
			$resultBrandIds = $this->getUserBrandsIds($user_id = null);
		}
		$this->db->where_in("id",$resultBrandIds);
		$query = $this->db->get($this->brandTbl)->result();
		return $query;
	}
	
	function getChannelGroup($where_array = null,$type)
	{
		if($type)
		{
			if(is_array($type))
			{
				$this->db->where_in("id",$type);
			}else{
				$this->db->where("type",$type);
			}
			
		}
		elseif($where_array)
		{
			$this->db->where($where_array);
		}
		$query = $this->db->select("id,name")->get($this->channelGroupsTbl)->result();
		return $query;
	}
	
	function getAllChannelGroups()
	{
		$query = $this->db->select("id,name,type")->where("status",1)->get($this->channelGroupsTbl)->result();
		return $query;
	}
	
	function getAllChannelGroupsType($brand_id,$type)
	{
		$this->db->select("$this->brandChannelTypeMAppingTbl.channel_group_id");
		$this->db->where("brand_id",$brand_id);
		$res = $this->db->get("$this->brandChannelTypeMAppingTbl")->result();
		$ids_array = array();
		foreach($res as $k=>$v)
		{
			array_push($ids_array,$v->channel_group_id);
		}
		
		$query = $this->db->select("id,name,type")
					->where("status",1)
					->where_not_in("id",$ids_array)
					->where("type",$type)
					->get($this->channelGroupsTbl)->result();
		return $query;
	}
	
	
	
	function getDailyCostData($where_array)
	{
		$this->db->select("channel_group_id,cost");
		$where_array["agency_id"] = $this->session->userdata('loginUserData')['agency_id'];
		$this->db->where($where_array);
		$this->db->order_by("channel_group_id","ASC");
		$query = $this->db->get($this->brandCostTbl)->result();
		return $query;
	}
	
	
	function getMonthTotalDailyCostData($brand_id,$total_days,$month,$year)
	{
		$start_date = "$year-$month-01";
		$end_date = "$year-$month-$total_days";
		$this->db->select("channel_group_id,SUM(cost) as total_cost");
		$where_array["agency_id"] = $this->session->userdata('loginUserData')['agency_id'];
		$this->db->where('brand_id',$brand_id);
		$this->db->where('agency_id',$this->session->userdata('loginUserData')['agency_id']);
		$this->db->where('date >=',$start_date);
		$this->db->where('date <=',$end_date);
		$this->db->group_by("channel_group_id"); 
		$this->db->order_by("channel_group_id","ASC");
		$query = $this->db->get($this->brandCostTbl)->result();
		return $query;
	}
	
	function getMonthlyBudgetData($where_array)
	{
		$this->db->select("channel_group_id,budget");
		$where_array["agency_id"] = $this->session->userdata('loginUserData')['agency_id'];
		$where_array["month"] = date("m",strtotime($where_array["date"]));
		$where_array["year"] = date("Y",strtotime($where_array["date"]));
		unset($where_array["date"]);
		$this->db->where($where_array);
		$this->db->order_by("channel_group_id","ASC");
		$query = $this->db->get($this->brandBudgetTbl)->result();
		return $query;
	}
	
	function getWebsiteRevenue($where_array)
	{
		$this->db->select("(pending_payment_revenue + processing_revenue + shipped_revenue) as revenue");
		$where_array["agency_id"] = $this->session->userdata('loginUserData')['agency_id'];
		$this->db->where($where_array);
		$query = $this->db->get($this->websiteRevenueTbl)->row();
		return $query;
	}
	
	function checkBrandType($brand_id,$type)
	{
		$this->db->select("$this->channelGroupsTbl.id,$this->channelGroupsTbl.name,$this->brandChannelTypeMAppingTbl.type");
		$this->db->join("$this->brandChannelTypeMAppingTbl","$this->brandChannelTypeMAppingTbl.channel_group_id = $this->channelGroupsTbl.id","left");
		$this->db->where("$this->brandChannelTypeMAppingTbl.brand_id",$brand_id);
		$this->db->where("$this->brandChannelTypeMAppingTbl.type",$type);
		// $this->db->group_by("$this->channelGroupsTbl.id");
		$res = $this->db->get("$this->channelGroupsTbl")->result();
		if($res)
		{
			/* echo "<pre>";
			print_r($res);die; */
			return $res;
		}else{
			return false;
		}
	}
	
	function getUserBrandsIds($user_id)
	{
		$this->db->select("brand_id");
		$this->db->where("user_id",$user_id);
		$res = $this->db->get("$this->brandMappedUserTbl")->result_array();
		if($res)
		{
			$brand_ids = array_column($res, 'brand_id');
			return $brand_ids;
		}else{
			return false;
		}
		
	}
		
		
}
?>