<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Brands_model extends CI_Model{
    function __construct() {
        $this->brandUserTbl = 'brand_user'; 
        $this->adminUserTbl = 'admin'; 
        $this->brandTbl = 'brands'; 
        $this->brandMappedUserTbl = 'brand_user_mapping'; 
        $this->channelGroupsTbl = 'channel_group'; 
        $this->channels = 'channel'; 
        $this->brandBudgetTbl = 'brand_budget_table'; 
        $this->brandCostTbl = 'brand_cost_table'; 
        $this->brandDailyImportTbl = 'daily_import_data'; 
        $this->brandWebsiteRevenueTbl = 'website_revenue_table'; 
        $this->brandChannelTypeMAppingTbl = 'brand_channel_type_mapping'; 
    }
    /*
     * get rows from users table
     */
	
		function getBrands($fields=array(),$conditions=array(),$joins=array(),$alias = "",$groupby="",$orderby=array())
		{	
			$user_id = $this->session->userdata('userId');
			if($user_id)
			{
				$resultBrandIds = $this->getUserBrandsIds($user_id);
			}else{
				$resultBrandIds = $this->getUserBrandsIds($user_id = null);
			}
			
			$page = $this->getPage();
			$num_of_records = $this->getNumRecord();
			$startlimit = ($page*$num_of_records)-$num_of_records;
			$endlimit = $page*$num_of_records;
			if(count($fields)){
				$this->db->select(implode(",",$fields));
			}
			if(count($conditions)){
				foreach($conditions as $conditionkey=>$condition){
					$this->db->$conditionkey($condition);					
				}
			}
			$this->db->where_in("$alias.id",$resultBrandIds);
			
			if($groupby!=""){
				 $this->db->group_by($groupby); 
			}
			
			if(count($joins)){
				foreach($joins as $join){
					$this->db->join($join[0],$join[1],'left');
				}
			}
			if(isset($_GET['sort'])){
				$this->db->order_by("$alias.id", $_GET['sort']);
			}else{
				if(count($orderby)){
					$this->db->order_by($orderby[0],$orderby[1]);
				}
			}
			if(isset($_GET['entry'])){
				$this->db->limit($_GET['entry'],$startlimit);
			}
			else{
				$this->db->limit(LIMIT,$startlimit);
			}
			
			if($alias!=""){
				$query = $this->db->get($this->brandTbl." as ".$alias)->result();
			}else{
				$query = $this->db->get($this->brandTbl)->result();
			}
			// echo "<pre>"; print_r($this->db->last_query()); echo "</pre>";die;
			return $query; 	
		}
		
		
		/*     Get Single User      */
		
		function getUsers()
		{	
			$this->db->select("id,name");
			$this->db->where('id !=',1);
			// $this->db->where('status',1);
			$query = $this->db->get($this->adminUserTbl)->result();
			return $query;	
		}
		
		function getPage(){
			$page = null!==$this->input->get('page')?$this->input->get('page'):1; 	
			return $page;
		}
		
		function getNumRecord(){
			if(isset($_GET['entry'])){
				$numrecord = null!==$this->input->get('numrecord')?$this->input->get('numrecord'):$_GET['entry']; 
			}else{
				$numrecord = null!==$this->input->get('numrecord')?$this->input->get('numrecord'):LIMIT; 
			}
				
			return $numrecord;
		}
		
		function totalCount($fields=array(),$conditions=array(),$joins=array(),$alias = "",$groupby="",$orderby=array()){
			if(count($fields)){
				$this->db->select(implode(",",$fields));
			}
			if(count($conditions)){
				foreach($conditions as $conditionkey=>$condition){
					$this->db->$conditionkey($condition);					
				}
			}
			
			if($groupby!=""){
				 $this->db->group_by($groupby); 
			}
			/* if(count($orderby)){
				$this->db->order_by($orderby[0],$orderby[1]);
			} */
			if(count($joins)){
				foreach($joins as $join){
					$this->db->join($join[0],$join[1],'left');
				}
			}if(isset($_GET['sort'])){
				$this->db->order_by("id", $_GET['sort']);
			}else{
				if(count($orderby)){
					$this->db->order_by($orderby[0],$orderby[1]);
				}
			}
			if($alias!=""){
				return $this->db->count_all_results($this->brandTbl." as ".$alias);
			}else{
				return $this->db->count_all_results($this->brandTbl);
			}
		}
		
		
		/*     Insert User      */
		
		function insertBrand($data,$dataUser,$mappedUser)
		{
			if(!array_key_exists("created",$data)){
				$data['created_at'] = date("Y-m-d H:i:s");
			}
			$this->db->insert($this->brandTbl, $data);
			$brand_id = $this->db->insert_id();
			
			$dataUser['brand_id'] = $brand_id;
			$this->db->insert($this->brandUserTbl, $dataUser);
			$id = $this->db->insert_id();
			
			$this->db->where('brand_id',$brand_id);
			$this->db->delete($this->brandMappedUserTbl);
			foreach($mappedUser as $k=>$v)
			{
				$insert_mapped_user = array(
				'brand_id' => $brand_id,
				'user_id' => $v,
				'created_by' => $this->session->userdata('userId'),
				);
				$this->db->insert($this->brandMappedUserTbl, $insert_mapped_user);
			}
			
			 
			return  $id;
			 
			
		}
		
		
		function getBrandsData($fields=array(),$conditions=array(),$joins=array(),$alias = "",$groupby=""){
			if(count($fields)){
				$this->db->select(implode(",",$fields));
			}
			if(count($conditions)){
				foreach($conditions as $conditionkey=>$condition){
					$this->db->$conditionkey($condition);					
				}
			}
			if($groupby!=""){
				 $this->db->group_by($groupby); 
			}
			
			if(count($joins)){
				foreach($joins as $join){
					$this->db->join($join[0],$join[1],'left');
				}
			}
			
			if($alias!=""){
				$query = $this->db->get($this->brandUserTbl." as ".$alias)->result();	
			}else{
				$query = $this->db->get($this->brandUserTbl)->result();
			}
			
			/*echo "<pre>"; print_r($this->db->last_query()); echo "</pre>";
			echo "<pre>"; print_r($query); echo "</pre>";*/
			return $query;
		}
		
		
		
		/*     Get Single Brand User      */
		
		function getSingleBrandUser($id)
		{	
			$query = $this->db->get_where($this->brandUserTbl,array('brand_id'=>$id,'user_type'=>1))->row();
			return $query;	
		}
		
		/*     Get Single Brand      */
		
		function getSingleBrand($id)
		{	
			$this->db->select("$this->brandTbl.*,GROUP_CONCAT($this->brandMappedUserTbl.user_id SEPARATOR ',') as users");
			$this->db->join("$this->brandMappedUserTbl","$this->brandMappedUserTbl.brand_id = $this->brandTbl.id","left");
			$this->db->where("$this->brandTbl.id",$id);
			$query = $this->db->get_where($this->brandTbl)->row();
			// echo "<pre>"; print_r($this->db->last_query()); echo "</pre>";die;
			return $query;	
		}
		
		
		
		
		/*     Update Single User      */
		
		function updateBrand($data,$dataUser,$id,$mappedUser)
		{
			
			$this->db->where('id', $id);
			$this->db->update($this->brandTbl, $data);
			
			$this->db->where('brand_id', $id);
			$this->db->where('user_type', 1);
			$this->db->update($this->brandUserTbl, $dataUser);
			
			$this->db->where('brand_id',$id);
			$this->db->delete($this->brandMappedUserTbl);
			foreach($mappedUser as $k=>$v)
			{
				$insert_mapped_user = array(
				'brand_id' => $id,
				'user_id' => $v,
				'created_by' => $this->session->userdata('userId'),
				);
				$this->db->insert($this->brandMappedUserTbl, $insert_mapped_user);
			}
			
			$query =  $this->db->affected_rows(); 
			return $query;
		}
		
		
		function delete($id)
		{
			$this->db->where('id', $id);
			$this->db->delete($this->brandUserTbl);
		}
		
		function update_status($data,$id)
		{
			
			$this->db->where('id', $id);
			$this->db->update($this->brandTbl, $data);
			
			$this->db->where('brand_id', $id);
			$this->db->update($this->brandUserTbl, $data);
			$query =  $this->db->affected_rows(); 
			return $query;
		}
		
		function getChannelGroups()
		{
			$query = $this->db->get($this->channelGroupsTbl)->result_array();
			return $query;
		}
		
		function getChannels()
		{
			$query = $this->db->get($this->channels)->result_array();
			return $query;
		}
		
		function insertUpdateMonthlyBudget($where_array,$insert_array)
		{
			$this->db->where($where_array);
			$res = $this->db->get($this->brandBudgetTbl)->row();
			if($res)
			{
				$update_array = array('budget'=>$insert_array["budget"],"last_updated_by"=>$insert_array["created_by"]);
				$this->db->where($where_array);
				$this->db->update($this->brandBudgetTbl, $update_array);
				return true;
			}else{
				$this->db->insert($this->brandBudgetTbl,$insert_array);
				return true;
			}
		}
		
		function getMonthlyBudget($year,$brand_id)
		{
			$this->db->select("budget,month,channel_group_id");
			$this->db->where(array("year"=>$year,"brand_id"=>$brand_id));
			$this->db->order_by("channel_group_id","ASC");
			// $this->db->group_by("channel_group_id");
			$res = $this->db->get($this->brandBudgetTbl)->result();
			if($res)
			{
				return $res;
			}else{
				return false;
			}
		}
		
		function getDailyCost($date,$brand_id)
		{
			$this->db->select("cost,date,channel_group_id");
			$this->db->where(array("date"=>$date,"brand_id"=>$brand_id));
			$this->db->order_by("channel_group_id","ASC");
			// $this->db->group_by("channel_group_id");
			$res = $this->db->get($this->brandCostTbl)->result();
			if($res)
			{
				return $res;
			}else{
				return false;
			}
		}
		
		function insertUpdateDailyCost($where_array,$insert_array)
		{
			$this->db->where($where_array);
			$res = $this->db->get($this->brandCostTbl)->row();
			if($res)
			{
				$update_array = array('cost'=>$insert_array["cost"],"last_updated_by"=>$insert_array["created_by"]);
				$this->db->where($where_array);
				$this->db->update($this->brandCostTbl, $update_array);
				return true;
			}else{
				$this->db->insert($this->brandCostTbl,$insert_array);
				return true;
			}
		}
		
		function getDailyImportData($where_array)
		{
			$page = $this->getPage();
			$num_of_records = $this->getNumRecord();
			$startlimit = ($page*$num_of_records)-$num_of_records;
			$endlimit = $page*$num_of_records;
			$this->db->where($where_array);
			$this->db->limit(LIMIT,$startlimit);
			$res = $this->db->get($this->brandDailyImportTbl)->result();
			return $res;
		}
		
		function totalDailyImportCount($where_array)
		{
			$this->db->where($where_array);
			return $this->db->count_all_results($this->brandDailyImportTbl);
		}
		
		function getWebsiteRevenue($date,$brand_id)
		{
			$this->db->select("*");
			$this->db->where(array("date"=>$date,"brand_id"=>$brand_id));
			$this->db->order_by("id","ASC");
			// $this->db->group_by("channel_group_id");
			$res = $this->db->get($this->brandWebsiteRevenueTbl)->result();
			if($res)
			{
				return $res;
			}else{
				return false;
			}
		}
		
		
		function insertUpdateWebsiteRevenue($where_array,$insert_array,$revenue_type)
		{
			$this->db->where($where_array);
			$res = $this->db->get($this->brandWebsiteRevenueTbl)->row();
			if($res)
			{
				$update_array = array($revenue_type=>$insert_array[$revenue_type],"last_updated_by"=>$insert_array["created_by"]);
				$this->db->where($where_array);
				$this->db->update($this->brandWebsiteRevenueTbl, $update_array);
				return true;
			}else{
				$this->db->insert($this->brandWebsiteRevenueTbl,$insert_array);
				return true;
			}
		}
		
		
		function getChannelSettings($brand_id)
		{
			$this->db->select("$this->channelGroupsTbl.id,$this->channelGroupsTbl.name,$this->brandChannelTypeMAppingTbl.type");
			$this->db->join("$this->brandChannelTypeMAppingTbl","$this->brandChannelTypeMAppingTbl.channel_group_id = $this->channelGroupsTbl.id","left");
			$this->db->where("$this->brandChannelTypeMAppingTbl.brand_id",$brand_id);
			// $this->db->group_by("$this->channelGroupsTbl.id");
			$res = $this->db->get("$this->channelGroupsTbl")->result();
			if($res)
			{
				/* echo "<pre>";
				print_r($res);die; */
				return $res;
			}else{
				return false;
			}
			
		}
		
		function getAllChannelGroups()
		{
			$res = $this->db->get("$this->channelGroupsTbl")->result();
			if($res)
			{
				/* echo "<pre>";
				print_r($res);die; */
				return $res;
			}else{
				return false;
			}
			
		}
		
		function insertChannelSettings($brand_id,$data)
		{
			$this->db->where('brand_id',$brand_id);
			$this->db->delete($this->brandChannelTypeMAppingTbl);
			
			foreach($data as $val)
			{
				$this->db->insert($this->brandChannelTypeMAppingTbl,$val);
			}
			
			return true;
		}
		
		function getUserBrandsIds($user_id)
		{
			$this->db->select("brand_id");
			$this->db->where("user_id",$user_id);
			$res = $this->db->get("$this->brandMappedUserTbl")->result_array();
			if($res)
			{
				$brand_ids = array_column($res, 'brand_id');
				return $brand_ids;
			}else{
				return false;
			}
			
		}
	
		
}
?>