<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Reports_model extends CI_Model{
    function __construct() {
        $this->channelGroupsTbl = 'channel_group'; 
        $this->channels = 'channel'; 
        $this->brandDailyImportTbl = 'daily_import_data'; 
        $this->brandTbl = 'brands'; 
		$this->brandCostTbl = 'brand_cost_table';
		$this->brandBudgetTbl = 'brand_budget_table';
		$this->websiteRevenueTbl = 'website_revenue_table';
		$this->brandChannelTypeMAppingTbl = 'brand_channel_type_mapping'; 
		$this->brandMappedUserTbl = 'brand_user_mapping'; 
    }
	
	
	function getDailyImportData($where_array,$source_channel_ids)
	{
		$where_array["agency_id"] = $this->session->userdata('loginUserData')['agency_id'];
		$this->db->select("$this->channelGroupsTbl.id as channel_group_id,$this->channelGroupsTbl.name as channel_group_name,SUM($this->brandDailyImportTbl.revenue) as day_channel_revenue");
		$this->db->join($this->brandDailyImportTbl,"$this->channelGroupsTbl.id=$this->brandDailyImportTbl.channel_group_id",'left');
		$this->db->where($where_array);
		$this->db->where_in("$this->brandDailyImportTbl.channel_id",$source_channel_ids);
		$this->db->group_by("$this->channelGroupsTbl.id"); 
		$res = $this->db->get($this->channelGroupsTbl)->result();
		return $res;
	}
	
	function getMonthDailyImportData($brand_id,$total_days,$month,$year,$source_channel_ids)
	{
		$start_date = "$year-$month-01";
		$end_date = "$year-$month-$total_days";
		$this->db->select("$this->channelGroupsTbl.id as channel_group_id,$this->channelGroupsTbl.name as channel_group_name,SUM($this->brandDailyImportTbl.revenue) as total_channel_revenue");
		$this->db->join($this->brandDailyImportTbl,"$this->channelGroupsTbl.id=$this->brandDailyImportTbl.channel_group_id",'left');
		$this->db->where('brand_id',$brand_id);
		$this->db->where('agency_id',$this->session->userdata('loginUserData')['agency_id']);
		$this->db->where('date >=',$start_date);
		$this->db->where('date <=',$end_date);
		$this->db->where_in("$this->brandDailyImportTbl.channel_id",$source_channel_ids);
		$this->db->group_by("$this->channelGroupsTbl.id"); 
		$res = $this->db->get($this->channelGroupsTbl)->result();
		return $res;
	}
	
	function getBrands()
	{
		$user_id = $this->session->userdata('userId');
		if($user_id)
		{
			$resultBrandIds = $this->getUserBrandsIds($user_id);
		}else{
			$resultBrandIds = $this->getUserBrandsIds($user_id = null);
		}
		$this->db->where('status',1);
		$this->db->where_in("id",$resultBrandIds);
		$query = $this->db->get($this->brandTbl)->result();
		return $query;
	}
	
	
	function getSingleBrandName($id)
	{
		$this->db->where('status',1);
		$this->db->where("id",$id);
		$query = $this->db->get($this->brandTbl)->row();
		if($query)
		{
			return $query->brand_name;
		}else{
			return false;
		}
	}
	
	function getChannelGroup($where_array = null,$type)
	{
		
		if($type != false)
		{
			if(is_array($type))
			{
				$this->db->where_in("id",$type);
			}else{
				$this->db->where("type",$type);
			}
			
		}
		elseif($where_array)
		{
			if(isset($where_array['channel_group.id']))
			{
				if(is_array($where_array['channel_group.id']))
				{
					$this->db->where_in("channel_group.id",$where_array['channel_group.id']);
				}else{
					$this->db->where("channel_group.id",$where_array['channel_group.id']);
				}
			}
			unset($where_array['channel_group.id']);
			$this->db->where($where_array);
		}
		$this->db->where("status",1);
		$query = $this->db->select("id,name,visible")->order_by('id','asc')->get($this->channelGroupsTbl)->result();
		// echo $this->db->last_query();die;
		if($query)
		{
			foreach($query as $k=>$v)
			{
				$v->merged_id = 0;
				$v->sort_order = 0;
			}
		}
		return $query;
	}
	
	function getAllChannelGroups()
	{
		$this->db->select("id,name,type,visible");
		if(null !== $this->input->get('channel_id'))
		{
			
			if(is_array($this->input->get('channel_id')))
			{
				$this->db->where_in("channel_group.id",$this->input->get('channel_id'));
			}else{
				$this->db->where("channel_group.id",$this->input->get('channel_id'));
			}
		}
		$this->db->where("status",1);
		$query = $this->db->get($this->channelGroupsTbl)->result();
		return $query;
	}
	
	function getAllChannelGroupsAll()
	{
		$this->db->select("id,name,type,visible");
		$this->db->where("status",1);
		$query = $this->db->get($this->channelGroupsTbl)->result();
		return $query;
	}
	
	function getAllChannelGroupsType($brand_id,$type)
	{
		$this->db->select("$this->brandChannelTypeMAppingTbl.channel_group_id");
		$this->db->where("brand_id",$brand_id);
		$res = $this->db->get("$this->brandChannelTypeMAppingTbl")->result();
		$ids_array = array();
		foreach($res as $k=>$v)
		{
			array_push($ids_array,$v->channel_group_id);
		}
		
		$query = $this->db->select("id,name,type")
					->where("status",1)
					->where_not_in("id",$ids_array)
					->where("type",$type)
					->get($this->channelGroupsTbl)->result();
		return $query;
	}
	
	
	
	function getDailyCostData($where_array)
	{
		$this->db->select("channel_group_id,cost");
		$where_array["agency_id"] = $this->session->userdata('loginUserData')['agency_id'];
		$this->db->where($where_array);
		$this->db->order_by("channel_group_id","ASC");
		$query = $this->db->get($this->brandCostTbl)->result();
		return $query;
	}
	
	
	function getMonthTotalDailyCostData($brand_id,$total_days,$month,$year)
	{
		$start_date = "$year-$month-01";
		$end_date = "$year-$month-$total_days";
		$this->db->select("channel_group_id,SUM(cost) as total_cost");
		$where_array["agency_id"] = $this->session->userdata('loginUserData')['agency_id'];
		$this->db->where('brand_id',$brand_id);
		$this->db->where('agency_id',$this->session->userdata('loginUserData')['agency_id']);
		$this->db->where('date >=',$start_date);
		$this->db->where('date <=',$end_date);
		$this->db->group_by("channel_group_id"); 
		$this->db->order_by("channel_group_id","ASC");
		$query = $this->db->get($this->brandCostTbl)->result();
		return $query;
	}
	
	function getMonthlyBudgetData($where_array)
	{
		$this->db->select("channel_group_id,budget");
		$where_array["agency_id"] = $this->session->userdata('loginUserData')['agency_id'];
		$where_array["month"] = date("m",strtotime($where_array["date"]));
		$where_array["year"] = date("Y",strtotime($where_array["date"]));
		unset($where_array["date"]);
		$this->db->where($where_array);
		$this->db->order_by("channel_group_id","ASC");
		$query = $this->db->get($this->brandBudgetTbl)->result();
		return $query;
	}
	
	function getWebsiteRevenue($where_array)
	{
		$this->db->select("(pending_payment_revenue + processing_revenue + shipped_revenue) as revenue");
		$where_array["agency_id"] = $this->session->userdata('loginUserData')['agency_id'];
		$this->db->where($where_array);
		$query = $this->db->get($this->websiteRevenueTbl)->row();
		return $query;
	}
	
	function checkBrandType($brand_id,$type)
	{
		$this->db->select("$this->channelGroupsTbl.id,$this->channelGroupsTbl.name,$this->brandChannelTypeMAppingTbl.type");
		$this->db->join("$this->brandChannelTypeMAppingTbl","$this->brandChannelTypeMAppingTbl.channel_group_id = $this->channelGroupsTbl.id","left");
		$this->db->where("$this->brandChannelTypeMAppingTbl.brand_id",$brand_id);
		$this->db->where("$this->brandChannelTypeMAppingTbl.type",$type);
		// $this->db->group_by("$this->channelGroupsTbl.id");
		$res = $this->db->get("$this->channelGroupsTbl")->result();
		if($res)
		{
			/* echo "<pre>";
			print_r($res);die; */
			return $res;
		}else{
			return false;
		}
	}
	
	function getUserBrandsIds($user_id)
	{
		$this->db->select("brand_id");
		$this->db->where("user_id",$user_id);
		$res = $this->db->get("$this->brandMappedUserTbl")->result_array();
		if($res)
		{
			$brand_ids = array_column($res, 'brand_id');
			return $brand_ids;
		}else{
			return false;
		}
		
	}
	
	function get_channel_source_ids_array($channel_ids_data)
	{
		$channel_ids = array();
		foreach($channel_ids_data as $k=>$v)
		{
			array_push($channel_ids,$v->id);
		}
		$this->db->select("id");
		$this->db->where_in("channel_group_id",$channel_ids);
		$this->db->order_by("id","asc");
		$channel_source_ids = $this->db->get($this->channels)->result();
		/* echo "<pre>";
		print_r($this->db->last_query());die; */
		$channel_source_ids_array = array();
		if($channel_source_ids)
		{
			foreach($channel_source_ids as $k=>$v)
			{
				array_push($channel_source_ids_array,$v->id);
			}
		}
		
		/* echo "<pre>";
		print_r($channel_source_ids_array);die; */
		return json_encode($channel_source_ids_array);
	}
	
	function getMonthTillDateImportData($brand_id,$total_days,$month,$year,$source_channel_ids,$date)
	{
		$start_date = "$year-$month-01";
		$end_date = date("Y-m-d",strtotime($date));
		$this->db->select("SUM($this->brandDailyImportTbl.sessions) as total_channel_sessions,SUM($this->brandDailyImportTbl.transactions) as total_channel_transactions,SUM($this->brandDailyImportTbl.revenue) as total_channel_revenue");
		$this->db->where('brand_id',$brand_id);
		$this->db->where('agency_id',$this->session->userdata('loginUserData')['agency_id']);
		$this->db->where('date >=',$start_date);
		$this->db->where('date <=',$end_date);
		$this->db->where_in("$this->brandDailyImportTbl.channel_id",$source_channel_ids);
		$res = $this->db->get($this->brandDailyImportTbl)->row();
		return $res;
		/* 
		$this->db->select("$this->channelGroupsTbl.id as channel_group_id,$this->channelGroupsTbl.name as channel_group_name,SUM($this->brandDailyImportTbl.sessions) as total_channel_sessions,SUM($this->brandDailyImportTbl.transactions) as total_channel_transactions,SUM($this->brandDailyImportTbl.revenue) as total_channel_revenue");
		$this->db->join($this->brandDailyImportTbl,"$this->channelGroupsTbl.id=$this->brandDailyImportTbl.channel_group_id",'left');
		$this->db->where('brand_id',$brand_id);
		$this->db->where('agency_id',$this->session->userdata('loginUserData')['agency_id']);
		$this->db->where('date >=',$start_date);
		$this->db->where('date <=',$end_date);
		$this->db->where_in("$this->brandDailyImportTbl.channel_id",$source_channel_ids);
		$this->db->group_by("$this->channelGroupsTbl.id"); 
		$res = $this->db->get($this->channelGroupsTbl)->result();
		return $res; */
	}
	
	function getMonthTillDateCostData($brand_id,$total_days,$month,$year,$date)
	{
		$start_date = "$year-$month-01";
		$end_date = date("Y-m-d",strtotime($date));
		$this->db->select("channel_group_id,SUM(cost) as total_cost");
		$where_array["agency_id"] = $this->session->userdata('loginUserData')['agency_id'];
		$this->db->where('brand_id',$brand_id);
		$this->db->where('agency_id',$this->session->userdata('loginUserData')['agency_id']);
		$this->db->where('date >=',$start_date);
		$this->db->where('date <=',$end_date);
		$this->db->group_by("channel_group_id"); 
		$this->db->order_by("channel_group_id","ASC");
		$query = $this->db->get($this->brandCostTbl)->result();
		return $query;
	}
	
	
	function get_unique_channel_source_ids_array($id)
	{
		$this->db->select("id");
		if(is_array($id))
		{
			$this->db->where_in("channel_group_id",$id);
		}else{
			$this->db->where("channel_group_id",$id);
		}
		
		$this->db->order_by("id","asc");
		$channel_source_ids = $this->db->get($this->channels)->result();
		/* echo "<pre>";
		print_r($this->db->last_query());die; */
		$channel_source_ids_array = array();
		if($channel_source_ids)
		{
			foreach($channel_source_ids as $k=>$v)
			{
				array_push($channel_source_ids_array,$v->id);
			}
		}
		
		/* echo "<pre>";
		print_r($channel_source_ids_array);die; */
		return json_encode($channel_source_ids_array);
	}
	
	function getDateRangeImportData($brand_id,$start_date,$end_date,$source_channel_ids)
	{
		$this->db->select("SUM($this->brandDailyImportTbl.sessions) as total_channel_sessions,SUM($this->brandDailyImportTbl.transactions) as total_channel_transactions,SUM($this->brandDailyImportTbl.revenue) as total_channel_revenue");
		$this->db->where('brand_id',$brand_id);
		$this->db->where('agency_id',$this->session->userdata('loginUserData')['agency_id']);
		$this->db->where('date >=',$start_date);
		$this->db->where('date <=',$end_date);
		$this->db->where_in("$this->brandDailyImportTbl.channel_id",$source_channel_ids);
		$res = $this->db->get($this->brandDailyImportTbl)->row();
		//echo "<pre>";
		//print_r($this->db->last_query());    
		return $res;
	}
	
	function getDateRangeCostData($brand_id,$start_date,$end_date)
	{
		$this->db->select("channel_group_id,SUM(cost) as total_cost");
		$where_array["agency_id"] = $this->session->userdata('loginUserData')['agency_id'];
		$this->db->where('brand_id',$brand_id);
		$this->db->where('agency_id',$this->session->userdata('loginUserData')['agency_id']);
		$this->db->where('date >=',$start_date);
		$this->db->where('date <=',$end_date);
		$this->db->group_by("channel_group_id"); 
		$this->db->order_by("channel_group_id","ASC");
		$query = $this->db->get($this->brandCostTbl)->result();
		return $query;
	}
	
	function getChannelGroupByBrand($brand_id,$channel_data)
	{
		$this->db->select("channel_group_id,visible,merged_id,sort_order");
		$this->db->where("brand_id",$brand_id);
		$brandMappingRes = $this->db->get("$this->brandChannelTypeMAppingTbl")->result();
		
		if($brandMappingRes)
		{
			$res = $channel_data;
			 
			foreach($res as $k=>$v)
			{
				$v->merged_id = 0;
				$v->sort_order = 0;
				foreach($brandMappingRes as $bk=>$bv)
				{
					if($bv->channel_group_id == $v->id)
					{
						$v->visible = $bv->visible;
						$v->merged_id = $bv->merged_id;
						$v->sort_order = $bv->sort_order;
					}
				}
			}
			
			usort($res, function($a, $b) { return $a->sort_order - $b->sort_order; });
			/* echo "<pre>";
			print_r($res);die; */
			/* $filterBy = 1;

			$showchannels = array_filter($res, function ($var) use ($filterBy) {
				return ($var->visible == $filterBy);
			}); */
			return $res;
		}else{
			// usort($channel_data, function($a, $b) { return $a->sort_order - $b->sort_order; });
			return $channel_data;
		}
	}
	
	function getProjectedAffialiateRoas($brand_id,$month,$year)
	{
		$this->db->select("roas");
		$this->db->where("channel_group_id",2);
		$this->db->where("brand_id",$brand_id);
		$this->db->where("year",$year);
		$this->db->where("month",$month);
		$res = $this->db->get($this->brandBudgetTbl)->row();
		if($res)
		{
			return $res->roas;
		}else{
			return false;
		}
	}
		
		
}
?>