<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Channelsgr_model extends CI_Model{
    function __construct() {
        $this->channelGroupsTbl = 'channel_group'; 
        $this->channels = 'channel'; 
    }
    /*
     * get rows from users table
     */
	
		function getChannelsgr($fields=array(),$conditions=array(),$joins=array(),$alias = "",$groupby="",$orderby=array())
		{	
			$page = $this->getPage();
			$num_of_records = $this->getNumRecord();
			$startlimit = ($page*$num_of_records)-$num_of_records;
			$endlimit = $page*$num_of_records;
			if(count($fields)){
				$this->db->select(implode(",",$fields));
			}
			if(count($conditions)){
				foreach($conditions as $conditionkey=>$condition){
					if(isset($condition[$alias.".name"]))
					{
						$this->db->like($condition);
					}else{
						$this->db->$conditionkey($condition);	
					}					
				}
			}
			if($groupby!=""){
				 $this->db->group_by($groupby); 
			}
			
			if(count($joins)){
				foreach($joins as $join){
					$this->db->join($join[0],$join[1],'left');
				}
			}
			if(isset($_GET['sort'])){
				$this->db->order_by("$alias.id", $_GET['sort']);
			}else{
				if(count($orderby)){
					$this->db->order_by($orderby[0],$orderby[1]);
				}
			}
			if(isset($_GET['entry'])){
				$this->db->limit($_GET['entry'],$startlimit);
			}
			else{
				$this->db->limit(LIMIT,$startlimit);
			}
			
			if($alias!=""){
				$query = $this->db->get($this->channelGroupsTbl." as ".$alias)->result();
			}else{
				$query = $this->db->get($this->channelGroupsTbl)->result();
			}
			//echo "<pre>"; print_r($this->db->last_query()); echo "</pre>";
			return $query; 	
		}
		
		
		
		function getPage(){
			$page = null!==$this->input->get('page')?$this->input->get('page'):1; 	
			return $page;
		}
		
		function getNumRecord(){
			if(isset($_GET['entry'])){
				$numrecord = null!==$this->input->get('numrecord')?$this->input->get('numrecord'):$_GET['entry']; 
			}else{
				$numrecord = null!==$this->input->get('numrecord')?$this->input->get('numrecord'):LIMIT; 
			}
				
			return $numrecord;
		}
		
		function totalCount($fields=array(),$conditions=array(),$joins=array(),$alias = "",$groupby="",$orderby=array()){
			if(count($fields)){
				$this->db->select(implode(",",$fields));
			}
			if(count($conditions)){
				foreach($conditions as $conditionkey=>$condition){
					if(isset($condition[$alias.".name"]))
					{
						$this->db->like($condition);
					}else{
						$this->db->$conditionkey($condition);	
					}					
				}
			}
			
			if($groupby!=""){
				 $this->db->group_by($groupby); 
			}
			/* if(count($orderby)){
				$this->db->order_by($orderby[0],$orderby[1]);
			} */
			if(count($joins)){
				foreach($joins as $join){
					$this->db->join($join[0],$join[1],'left');
				}
			}if(isset($_GET['sort'])){
				$this->db->order_by("id", $_GET['sort']);
			}else{
				if(count($orderby)){
					$this->db->order_by($orderby[0],$orderby[1]);
				}
			}
			if($alias!=""){
				return $this->db->count_all_results($this->channelGroupsTbl." as ".$alias);
			}else{
				return $this->db->count_all_results($this->channelGroupsTbl);
			}
		}
		
		
		/*     Insert Channel Group      */
		
		function insertChannelgr($data)
		{
			if(!array_key_exists("created",$data)){
				$data['created_at'] = date("Y-m-d H:i:s");
			}
			$this->db->insert($this->channelGroupsTbl, $data);
			$id = $this->db->insert_id();
			 
			return  $id;
			 
			
		}
		
		
		function getChannelsgrData($fields=array(),$conditions=array(),$joins=array(),$alias = "",$groupby=""){
			if(count($fields)){
				$this->db->select(implode(",",$fields));
			}
			if(count($conditions)){
				foreach($conditions as $conditionkey=>$condition){
					$this->db->$conditionkey($condition);					
				}
			}
			if($groupby!=""){
				 $this->db->group_by($groupby); 
			}
			
			if(count($joins)){
				foreach($joins as $join){
					$this->db->join($join[0],$join[1],'left');
				}
			}
			
			if($alias!=""){
				$query = $this->db->get($this->channelgrUserTbl." as ".$alias)->result();	
			}else{
				$query = $this->db->get($this->channelgrUserTbl)->result();
			}
			
			/*echo "<pre>"; print_r($this->db->last_query()); echo "</pre>";
			echo "<pre>"; print_r($query); echo "</pre>";*/
			return $query;
		}
		
		
		
		
		
		/*     Get Single Channel Group     */
		
		function getSingleChannelgr($id)
		{	
			$query = $this->db->get_where($this->channelGroupsTbl,array('id'=>$id))->row();
			return $query;	
		}
		
		
		
		
		/*     Update Single Channel Group      */
		
		function updateChannelgr($data,$id)
		{
			
			$this->db->where('id', $id);
			$this->db->update($this->channelGroupsTbl, $data);
			$query =  $this->db->affected_rows(); 
			return $query;
		}
		
		
		function delete($id)
		{
			$this->db->where('id', $id);
			$this->db->delete($this->channelGroupsTbl);
		}
		
		function update_status($data,$id)
		{
			
			$this->db->where('id', $id);
			$this->db->update($this->channelGroupsTbl, $data);
			$query =  $this->db->affected_rows(); 
			return $query;
		}
		
		function getChannelGroups()
		{
			$query = $this->db->get($this->channelGroupsTbl)->result_array();
			return $query;
		}
		
		function getChannels()
		{
			$query = $this->db->get($this->channels)->result_array();
			return $query;
		}
		
		
}
?>