<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Adminleads extends CI_Model{
    function __construct() {
        $this->userTbl = 'admin'; 
        $this->userTbl2 = 'contact_us'; 
		$this->roleTbl = 'roles'; 
		$this->importTbl = 'daily_import_data'; 
		$this->channelTbl = 'channel'; 
		$this->channelGroupTbl = 'channel_group'; 
		$this->brandCostTbl = 'brand_cost_table'; 
    }
    /*
     * get rows from the users table
     */
    function getRows($params = array()){
        $this->db->select('*');
        $this->db->from($this->userTbl);
        $this->db->join($this->roleTbl," $this->roleTbl.role_id = $this->userTbl.role_id");
        //fetch data by conditions
        if(array_key_exists("conditions",$params)){
			foreach ($params['conditions'] as $key => $value) {
				$this->db->where($key,$value);
			}
		}
        
        if(array_key_exists("id",$params)){
            $this->db->where('id',$params['id']);
			$query = $this->db->get();
			$result = $query->row_array();
        }else{
            //set start and limit
            if(array_key_exists("start",$params) && array_key_exists("limit",$params)){
                $this->db->limit($params['limit'],$params['start']);
            }elseif(!array_key_exists("start",$params) && array_key_exists("limit",$params)){
                $this->db->limit($params['limit']);
            }
            $query = $this->db->get();
            if(array_key_exists("returnType",$params) && $params['returnType'] == 'count'){
				$result = $query->num_rows();
			}elseif(array_key_exists("returnType",$params) && $params['returnType'] == 'single'){
				$result = ($query->num_rows() > 0)?$query->row_array():FALSE;
			}else{
                $result = ($query->num_rows() > 0)?$query->result_array():FALSE;
            }
        }

        //return fetched data
        return $result;
    }
	
	
	function getContactLeads()
	{	
		$page = $this->getPage();
		$num_of_records = $this->getNumRecord();
		$startlimit = ($page*$num_of_records)-$num_of_records;
		$endlimit = $page*$num_of_records;
		if(isset($_GET['search'])){
			$this->db->like('name', $_GET['search']);
			$this->db->or_like('spoc_name', $this->encrypted_data($_GET['search']));
			$this->db->or_like('email', $this->encrypted_data($_GET['search']));
			$this->db->or_like('mobile_no', $this->encrypted_data($_GET['search']));
		}
		if(isset($_GET['contact_date'])){
			$till_date = $_GET['contact_date'];
			$date = explode(" - ", $till_date);
			$start_date = date('Y-m-d', strtotime(str_replace('-', '/', $date[0])));
			$expire_date = date('Y-m-d 23:59:00', strtotime(str_replace('-', '/', $date[1])));
			$this->db->where('created_at >=',$start_date);
			$this->db->where('created_at <=',$expire_date);
			$date_range = date('Y-m-d', strtotime(str_replace('-', '/', $date[0]))).'_'.date('Y-m-d', strtotime(str_replace('-', '/', $date[1])));
			$this->session->set_userdata('date_range',$date_range);
		}
		if(isset($_GET['sort'])){
			$this->db->order_by("id", $_GET['sort']);
		}
		if(isset($_GET['entry'])){
			$this->db->limit($_GET['entry'],$startlimit);
		}
		else{
			$this->db->limit(LIMIT,$startlimit);
		}
		
		$query = $this->db->get($this->userTbl2)->result();
		return $query; 	
	}
	
	
	
	function getAllFilterContactLeads()
	{	
		$page = $this->getPage();
		$num_of_records = $this->getNumRecord();
		$startlimit = ($page*$num_of_records)-$num_of_records;
		$endlimit = $page*$num_of_records;
		if(isset($_GET['search'])){
			$this->db->like('name', $_GET['search']);
			$this->db->or_like('spoc_name', $this->encrypted_data($_GET['search']));
			$this->db->or_like('email', $this->encrypted_data($_GET['search']));
			$this->db->or_like('mobile_no', $this->encrypted_data($_GET['search']));
		}
		if(isset($_GET['contact_date'])){
			$till_date = $_GET['contact_date'];
			$date = explode(" - ", $till_date);
			$start_date = date('Y-m-d', strtotime(str_replace('-', '/', $date[0])));
			$expire_date = date('Y-m-d 23:59:00', strtotime(str_replace('-', '/', $date[1])));
			$this->db->where('created_at >=',$start_date);
			$this->db->where('created_at <=',$expire_date);
			
		}
		if(isset($_GET['sort'])){
			$this->db->order_by("name", $_GET['sort']);
		}
		
		$query = $this->db->get($this->userTbl2)->result();
		return $query; 	
	}
	
	function getAllContactLeads()
	{	
		$query = $this->db->get($this->userTbl2)->result();
		return $query; 	
	}
	
		
	function getPage(){
		$page = null!==$this->input->get('page')?$this->input->get('page'):1; 	
		return $page;
	}
		
	function getNumRecord(){
		if(isset($_GET['entry'])){
			$numrecord = null!==$this->input->get('numrecord')?$this->input->get('numrecord'):$_GET['entry']; 
		}else{
			$numrecord = null!==$this->input->get('numrecord')?$this->input->get('numrecord'):LIMIT; 
		}
			
		return $numrecord;
	}
		
	function totalCount(){
		if(isset($_GET['search'])){
			$this->db->like('name', $_GET['search']);
			$this->db->or_like('spoc_name', $this->encrypted_data($_GET['search']));
			$this->db->or_like('email', $this->encrypted_data($_GET['search']));
			$this->db->or_like('mobile_no', $this->encrypted_data($_GET['search']));
		}
		if(isset($_GET['contact_date'])){
			$till_date = $_GET['contact_date'];
			$date = explode(" - ", $till_date);
			$start_date = date('Y-m-d', strtotime(str_replace('-', '/', $date[0])));
			$expire_date = date('Y-m-d 23:59:00', strtotime(str_replace('-', '/', $date[1])));
			$this->db->where('created_at >=',$start_date);
			$this->db->where('created_at <=',$expire_date);
			
		}
		return $this->db->count_all_results($this->userTbl2);
	}
	
	
	function getfilterContactLeads($start_date,$expire_date) 
	{
		$this->db->where('created_at >=',$start_date);
		$this->db->where('created_at <=',$expire_date);
		// $sql = 'select * from users where role_id = 3 and created_at >= "'.$start_date.'" AND created_at <= "'.$expire_date.'" order by `id` DESC';
		$query = $this->db->get($this->userTbl2)->result();
		return $query;	
	}
	
	function encrypted_data($formfield)
	{
		$data = $formfield;
		if(!empty($data))
		{
			$password = '3sc3RLrpd17';

			// CBC has an IV and thus needs randomness every time a message is encrypted
			$method = 'aes-256-cbc';

			// Must be exact 32 chars (256 bit)
			// You must store this secret random key in a safe place of your system.
			$key = substr(hash('sha256', $password, true), 0, 32);

			// Most secure key
			//$key = openssl_random_pseudo_bytes(openssl_cipher_iv_length($method));

			// IV must be exact 16 chars (128 bit)
			$iv = chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0);
			
			$encrypted = base64_encode(openssl_encrypt($data, $method, $key, OPENSSL_RAW_DATA, $iv));
			
			return $encrypted;
		}else{
			return '';
		}
		
	}
	
	
	function getGraphData($field,$whereArray,$timeArray,$channel_ids,$type)
	{
		
		if(!empty(array_filter($channel_ids)))
		{
			$source_channel_ids = json_decode($this->get_channel_source_ids_array($channel_ids));
		}else{
			$source_channel_ids = 0;
		}
		
		$this->db->select("date,SUM($field) as total_$type"."_".$field);
		$this->db->where($whereArray);
		$this->db->where("date >= ",$timeArray["start_date"]);
		$this->db->where("date <= ",$timeArray["end_date"]);
		// $this->db->where_in("channel_group_id",$channel_ids);
		$this->db->where_in("channel_id",$source_channel_ids);
		$this->db->group_by("date");
		$res = $this->db->get($this->importTbl)->result_array();
		// echo $this->db->last_query();die;
		return $res;
	}
	
	function getGraphDataByMonth($field,$whereArray,$timeArray,$channel_ids,$type)
	{
		if(!empty(array_filter($channel_ids)))
		{
			$source_channel_ids = json_decode($this->get_channel_source_ids_array($channel_ids));
		}else{
			$source_channel_ids = 0;
		}
		// $this->db->select("CONCAT(MONTH(date), '-',YEAR(date)) as month,SUM($field) as total_$type"."_".$field, FALSE);
		$this->db->select("date as month,SUM($field) as total_$type"."_".$field, FALSE);
		$this->db->where($whereArray);
		// $this->db->where_in("channel_group_id",$channel_ids);
		$this->db->where_in("channel_id",$source_channel_ids);
		$this->db->group_by("MONTH(date)");
		$res = $this->db->get($this->importTbl)->result_array();
		// echo $this->db->last_query();die;
		return $res;
	}
	
	function getGraphDataByWeek($field,$whereArray,$timeArray,$channel_ids,$type)
	{
		$source_channel_ids = json_decode($this->get_channel_source_ids_array($channel_ids));
		$this->db->select("date,SUM($field) as total_$type"."_".$field);
		$this->db->where($whereArray);
		$this->db->where("date >= ",$timeArray["start_date"]);
		$this->db->where("date <= ",$timeArray["end_date"]);
		$this->db->where_in("channel_id",$source_channel_ids);
		// $this->db->where_in("channel_group_id",$channel_ids);
		$this->db->order_by("date");
		$this->db->group_by("date");
		$res = $this->db->get($this->importTbl)->result_array();
		return $res;
	}
	
	
	function get_channel_source_ids_array($channel_ids)
	{
		$this->db->select("id");
		$this->db->where_in("channel_group_id",$channel_ids);
		$channel_source_ids = $this->db->get($this->channelTbl)->result();
		$channel_source_ids_array = array();
		if($channel_source_ids)
		{
			foreach($channel_source_ids as $k=>$v)
			{
				array_push($channel_source_ids_array,$v->id);
			}
		}
		if(empty($channel_source_ids_array))
		{
			$channel_source_ids_array = array("0");
			
		}
		
		/* echo "<pre>";
		print_r($channel_source_ids_array);die; */
		return json_encode($channel_source_ids_array);
	}
	
	
	
	
	function getGraphDataByRevenue($field,$whereArray,$timeArray,$channel_group_id,$type)
	{
		
		$channel_name = $this->db->select("name")->get_where($this->channelGroupTbl,array("id"=>$channel_group_id))->row()->name;
		
		$source_channel_ids = json_decode($this->get_channel_source_ids_array($channel_group_id));
		
		
		$this->db->select("SUM($field) as total_$type"."_".$field);
		$this->db->where($whereArray);
		$this->db->where("date >= ",$timeArray["start_date"]);
		$this->db->where("date <= ",$timeArray["end_date"]);
		// $this->db->where_in("channel_group_id",$channel_ids);
		$this->db->where_in("channel_id",$source_channel_ids);
		$this->db->group_by("brand_id");
		$res = $this->db->get($this->importTbl)->row_array();
		$res["channel_name"] = $channel_name;
		// echo "<pre>";print_r($res);die;
		// echo $this->db->last_query();die;
		return $res;
	}
	
	
	function getGraphDataByCost($field,$whereArray,$timeArray,$channel_group_id,$type)
	{
		
		$this->db->select("$this->channelGroupTbl.name as channel_group_name,SUM($field) as total_$type"."_".$field);
		$this->db->join($this->channelGroupTbl,"$this->channelGroupTbl.id=$this->brandCostTbl.channel_group_id");
		$this->db->where($whereArray);
		$this->db->where("$this->brandCostTbl.date >= ",$timeArray["start_date"]);
		$this->db->where("$this->brandCostTbl.date <= ",$timeArray["end_date"]);
		// $this->db->where_in("channel_group_id",$channel_ids);
		$this->db->where("$this->brandCostTbl.channel_group_id",$channel_group_id);
		$this->db->group_by("$this->brandCostTbl.brand_id");
		$res = $this->db->get($this->brandCostTbl)->row_array();
		// echo "<pre>";print_r($res);die;
		// echo $this->db->last_query();die;
		return $res;
	}
	
	/* function getEmail($number)
	{
		$this->db->where('phone',$number);
		$query = $this->db->get($this->userTbl)->row();
		return $query;
	} */
	
	
	

}
