<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Dailyreports extends CI_Controller { 
    
	private $getAllUserBrands;
	
    function __construct() {
		// echo "Under Construction";die;
        parent::__construct();
        $this->load->model('admin/Adminleads');
        $this->load->model('admin/reports_model');
		$this->load->model('admin/brands_model');
		if(!$this->session->userdata('isAdminLoggedIn'))
		{
			 redirect('admin');
		}
		
		$this->getAllUserBrands = $this->reports_model->getUserBrandsIds($this->session->userdata('userId'));
		/* elseif($this->session->userdata('loginUserData')['role_id'] != 1)
		{
			redirect(base_url().'admin/dashboard');
		} */
    }



	function index()
	{
		if(null !== $this->input->get('filter_date'))
		{
			/* echo "<pre>";
			print_r($this->input->get());die; */
			$brand_id = $this->input->get('brand_id');
			$this->accessBrandCheck($brand_id);
			$filter_date = $this->input->get('filter_date');
			$month_all_alpha = date('F', strtotime($this->input->get('filter_date')));
			$filter_date_array = explode("-",$filter_date);
			$date = $filter_date_array[0];
			$month = $filter_date_array[1];
			$year = $filter_date_array[2];
			$previous_date = date('d-m-Y', strtotime('-1 day', strtotime($filter_date)));
			$previous_date_array = explode("-",$previous_date);
			$days_in_current_month = cal_days_in_month(CAL_GREGORIAN,$month,$year);
			
			$where_array = array("brand_id"=>$brand_id,"date"=>date("Y-m-d",strtotime($filter_date)));
			
			
			
			$whereArray = array();
			if(null!==$this->input->get('channel_id') && $this->input->get('channel_id')!=""){
				$whereArray['channel_group.id'] = $this->input->get('channel_id');
			}
			
			if(null!==$this->input->get('type') && $this->input->get('type')!=""){
				$type = $this->input->get('type');
				$brandTypeRes = $this->reports_model->checkBrandType($brand_id,$type);
				
				if($brandTypeRes)
				{
					
					$allChannels = $this->reports_model->getAllChannelGroupsType($brand_id,$type);
					// echo "<pre>"; print_r($this->db->last_query()); echo "</pre>";die;
					// $new_array = array_merge($brandTypeRes,$allChannels);
					
					// echo "<pre>"; print_r($brandTypeRes); echo "</pre>";die;
					// echo "<pre>"; print_r($allChannels); echo "</pre>";die;
					$brandChannelArray = array();
					// echo "<pre>"; print_r($allChannels); echo "</pre>";die;
					foreach($brandTypeRes as $k=>$v)
					{
						array_push($brandChannelArray,$v->id);
					}
					foreach($allChannels as $ket=>$vat)
					{
							array_push($brandChannelArray,$vat->id);
					}
					
					$type = $brandChannelArray;
					// echo "<pre>"; print_r($brandChannelArray); echo "</pre>";die;
					
				}
				
			}else{
				$type = null;
			}
			
			
			
			/* Get All Channel Groups */
			$channel_groups = $this->reports_model->getChannelGroup($whereArray,$type);
			
			$channel_groups = $this->reports_model->getChannelGroupByBrand($brand_id,$channel_groups);
			
			foreach($channel_groups as $kt=>$bt)
			{
				
				$id = $bt->id;
				$merged_id = $bt->merged_id;
				$getGroup = $this->searchForId($id,$channel_groups);
				
				if($getGroup != null)
				{
					$channel_groups[$kt]->new_ids = $getGroup;
				}else{
					$channel_groups[$kt]->new_ids = $getGroup;
				}
				
			}
			// $channel_groups = json_decode($channel_groups);
			
			// $channel_source_channel_ids = json_decode($this->reports_model->get_channel_source_ids_array($data["channel_groups"]));
			// echo "<pre>"; print_r($channel_groups); echo "</pre>";die;
			
			$imported_data_array = array();
			foreach($channel_groups as $k=>$v)
			{
				if($v->visible)
				{
					$channel_source_channel_ids = json_decode($this->reports_model->get_unique_channel_source_ids_array($v->new_ids));
					if($channel_source_channel_ids)
					{
						$month_imported_data = $this->reports_model->getMonthTillDateImportData($brand_id,$days_in_current_month,$month,$year,$channel_source_channel_ids,$filter_date);
						// echo "<pre>"; print_r($this->db->last_query()); echo "</pre>";die;
					}
					else{
						$month_imported_data = 0;
					}
					
					if($month_imported_data)
					{
						// echo "<pre>"; print_r($month_imported_data); echo "</pre>";die;
						$total_channel_sessions = $month_imported_data->total_channel_sessions;
						$total_channel_transactions = $month_imported_data->total_channel_transactions;
						$total_channel_revenue = $month_imported_data->total_channel_revenue;
					}else{
						$total_channel_sessions = 0;
						$total_channel_transactions = 0;
						$total_channel_revenue = 0;
					}
					
					$imported_array = array(
						"channel_group_id"=>$v->id,
						"name"=>$v->name,
						"total_channel_sessions"=>$total_channel_sessions,
						"total_channel_transactions"=>$total_channel_transactions,
						"total_channel_revenue"=>$total_channel_revenue,
						
					);
					
					array_push($imported_data_array,$imported_array);
				}
			}
			
			// $data['month_imported_data'] = $this->reports_model->getMonthTillDateImportData($brand_id,$days_in_current_month,$month,$year,$channel_source_channel_ids,$filter_date);
			// echo "<pre>"; print_r($imported_data_array); echo "</pre>";die;
			
			$data["daily_cost_month"] = $this->reports_model->getMonthTillDateCostData($brand_id,$days_in_current_month,$month,$year,$filter_date);
			// echo "<pre>"; print_r($this->db->last_query()); echo "</pre>";die;
			// $data["monthly_budget"] = $this->reports_model->getMonthlyBudgetData($where_array);
			$data["website_revenue"] = $this->reports_model->getWebsiteRevenue($where_array);
			// echo "<pre>"; print_r($data["date_imported_data"]); echo "</pre>";die;
			
			
			
			
			
			/* if($data["website_revenue"])
			{
				$data["channel_groups"][$channels_count+1] = new \stdClass();
				$data["channel_groups"][$channels_count+1]->id = $channels_count+2;
				$data["channel_groups"][$channels_count+1]->name = "Backend Number";
				$data["channel_groups"][$channels_count+1]->revenue = $data["website_revenue"]->revenue;
			} */
			
			
			
			// echo "<pre>"; print_r($data["channel_groups"]); echo "</pre>";die;
			// $data["reports"] = $data["channel_groups"];
			$roas = $this->reports_model->getProjectedAffialiateRoas($brand_id,$month,$year);
			$data["projected_numbers"] = json_decode($this->getProjectedNumbers($brand_id,$month,$year));
			$data["projected_numbers_till_date"] = json_decode($this->getProjectedNumbersTillDate($brand_id,$filter_date));
			$data["achieved_numbers_till_date"] = json_decode($this->getAchievedNumbersTillDate($brand_id,$imported_data_array,$data["daily_cost_month"],$roas));
			$data["month"] = $month_all_alpha;
			/* echo "<pre>";
			print_r($data["projected_numbers_till_date"]);die; */
			$data["brand_name"] = $this->reports_model->getSingleBrandName($brand_id);
			/* echo "<pre>";
			print_r($data["achieved_numbers_till_date"]);die; */
			$this->session->set_userdata("monthProjectedNumbersreports_data",$data["projected_numbers"]);
			$this->session->set_userdata("monthTillDateProjectedNumbersreports_data",$data["projected_numbers_till_date"]);
			$this->session->set_userdata("monthTillDateAchievedNumbersreports_data",$data["achieved_numbers_till_date"]);
			// $this->session->set_userdata("date",$data["date_filter_session"]);
			$this->session->set_userdata("brand",$data["brand_name"]);
			$this->session->set_userdata("monthTilldate",$filter_date);
			$data["brands"] = $this->reports_model->getBrands();
			$data["channels"] = $this->reports_model->getAllChannelGroupsAll();
			$data['file']  = 'admin/reports/monthtilldate';
			$this->load->view('admin/template',$data);	
		}else{
			$data["channels"] = $this->reports_model->getAllChannelGroupsAll();
			$data["brands"] = $this->reports_model->getBrands();
			// echo "<pre>"; print_r($data["brands"]); echo "</pre>";die;
			$data['file']  = 'admin/reports/monthtilldate';
			$this->load->view('admin/template',$data);	
		}
		
	}
	
	
	function getProjectedNumbers($brand_id,$month,$year)
	{
		$data['records'] = $this->brands_model->getMonthlyBudget($year,$month,$brand_id);
		$channel_groups = $this->reports_model->getAllChannelGroups();
		
		$channel_groups = $this->reports_model->getChannelGroupByBrand($brand_id,$channel_groups);
		
		/* echo "<pre>";
		print_r($channel_groups);die; */
		$channel_gr_array = array();
		foreach($channel_groups as $k=>$v){
			
			if($v->visible)
			{
				$new_array = array(
					"id" => $v->id,
					"name" => $v->name,
					"sessions" => '',
					"ecom_conversion_rate" => '',
					"transactions" => '',
					"aov" => '',
					"revenue" => '',
					"cost" => '',
					"roas" => '',
				);
				if($data['records'])
				{
					foreach($data["records"] as $key=>$val)
					{
						
						if($val->channel_group_id == $v->id)
						{
							$new_array['sessions'] = $val->sessions;
							$new_array['ecom_conversion_rate'] = $val->ecom_conversion_rate;
							$new_array['transactions'] = $val->transactions;
							$new_array['aov'] = $val->aov;
							$new_array['revenue'] = $val->budget;
							$new_array['cost'] = $val->cost;
							$new_array['roas'] = $val->roas;
						}
					}
					/* echo "<pre>";
					print_r($records_channel_array);die; */
				}
				array_push($channel_gr_array,$new_array);
			}
		}
		$data["channel_gr_array"] = $channel_gr_array;
		$data["month"] = $month;
		
		return json_encode($data["channel_gr_array"]);
	}
	
	
	function getProjectedNumbersTillDate($brand_id,$date_c)
	{
		
		$filter_date_array = explode("-",$date_c);
		$date = $filter_date_array[0];
		$month = $filter_date_array[1];
		$year = $filter_date_array[2];	
		$previous_date = date('d-m-Y', strtotime('-1 day', strtotime($date_c)));
		$previous_date_array = explode("-",$previous_date);
		$days_in_current_month = cal_days_in_month(CAL_GREGORIAN,$month,$year);
			
		$data['records'] = $this->brands_model->getMonthlyBudget($year,$month,$brand_id);
		$channel_groups = $this->reports_model->getAllChannelGroups();
		
		$channel_groups = $this->reports_model->getChannelGroupByBrand($brand_id,$channel_groups);
		/* echo "<pre>";
		print_r($previous_date_array);die; */
		$channel_gr_array = array();
		foreach($channel_groups as $k=>$v){
			
			if($v->visible)
			{
				$new_array = array(
					"id" => $v->id,
					"name" => $v->name,
					"sessions" => '',
					"ecom_conversion_rate" => '',
					"transactions" => '',
					"aov" => '',
					"revenue" => '',
					"cost" => '',
					"roas" => '',
				);
				if($data['records'])
				{
					foreach($data["records"] as $key=>$val)
					{
						$sessions = 0; 
						$transactions = 0; 
						$budget = 0; 
						$cost = 0;
						if($val->channel_group_id == $v->id)
						{
							if($month == $previous_date_array[1])
							{
								if(null != $val->sessions)
								{
									$sessions = round($val->sessions/$days_in_current_month*($date-1)); 
								}
								if(null != $val->transactions)
								{
									$transactions = round($val->transactions/$days_in_current_month*($date-1));  
								}
								if(null != $val->budget)
								{
									$budget = round($val->budget/$days_in_current_month*($date-1)); 
								}
								if(null != $val->cost)
								{
									$cost = round($val->cost/$days_in_current_month*($date-1)); 
								}
							}else{
								if(null != $val->sessions)
								{
									$sessions = round($val->sessions/$days_in_current_month*($date)); 
								}
								if(null != $val->transactions)
								{
									$transactions = round($val->transactions/$days_in_current_month*($date));  
								}
								if(null != $val->budget)
								{
									$budget = round($val->budget/$days_in_current_month*($date)); 
								}
								if(null != $val->cost)
								{
									$cost = round($val->cost/$days_in_current_month*($date)); 
								}
							}
							$new_array['sessions'] = $sessions;
							$new_array['ecom_conversion_rate'] = $val->ecom_conversion_rate;
							$new_array['transactions'] = $transactions;
							$new_array['aov'] = $val->aov;
							$new_array['revenue'] = $budget;
							$new_array['cost'] = $cost;
							$new_array['roas'] = $val->roas;
						}
					}
					/* echo "<pre>";
					print_r($records_channel_array);die; */
				}
				array_push($channel_gr_array,$new_array);
			}
		}
		$data["channel_gr_array"] = $channel_gr_array;
		$data["month"] = $month;
		
		return json_encode($data["channel_gr_array"]);
	}
	
	function getAchievedNumbersTillDate($brand_id,$importedData,$costData,$affiliateroas)
	{
		$channel_groups = $this->reports_model->getAllChannelGroups();
		
		$channel_groups = $this->reports_model->getChannelGroupByBrand($brand_id,$channel_groups);
		/* echo "<pre>";
		print_r($importedData);die; */
		$channel_gr_array = array();
		foreach($channel_groups as $k=>$v){
			
			if($v->visible)
			{
				$new_array = array(
					"id" => $v->id,
					"name" => $v->name,
					"sessions" => '',
					"ecom_conversion_rate" => '',
					"transactions" => '',
					"aov" => '',
					"revenue" => '',
					"cost" => '',
					"roas" => '',
				);
				if($importedData)
				{
					
					foreach($importedData as $key=>$val)
					{
						
						if($val['channel_group_id'] == $v->id)
						{
							if($val['total_channel_sessions'])
							{
								$cr_cal = $val['total_channel_transactions']/$val['total_channel_sessions'];
								if($cr_cal)
								{
									$cr = number_format((float)$cr_cal*100, 2, '.', '');
								}else{
									$cr = 0;
								}
								
							}else{
								$cr = 0;
							}
							
							if($val['total_channel_transactions'])
							{
								$aov = round($val['total_channel_revenue']/$val['total_channel_transactions']);
							}else{
								$aov = 0;
							}
							$new_array['sessions'] = $val['total_channel_sessions'];
							$new_array['ecom_conversion_rate'] = $cr;
							$new_array['transactions'] = $val['total_channel_transactions'];
							$new_array['aov'] = $aov;
							$new_array['revenue'] = number_format((float)$val['total_channel_revenue'], 2, '.', '');
						}
					}
						
					/* echo "<pre>";
					print_r($records_channel_array);die; */
				}
				array_push($channel_gr_array,$new_array);
			}
		}
			
			$total_cost = 0;
			$roas = 0;
			/* echo "<pre>";
			print_r($channel_gr_array);die; */
			if($costData)
			{
				foreach($channel_gr_array as $kc=>$vc)
				{
					if($affiliateroas)
					{
						if($vc["id"] == 2)
						{
							$roas_get_cost = $vc["revenue"]/$affiliateroas;
							$channel_gr_array[$kc]['cost'] = number_format((float)$roas_get_cost, 2, '.', '');
							$channel_gr_array[$kc]['roas'] = $affiliateroas;
						}
					}
					foreach($costData as $key=>$val)
					{
						
						if($val->channel_group_id == $vc["id"])
						{
							$total_cost = number_format((float)$val->total_cost, 2, '.', '');
							$channel_gr_array[$kc]['cost'] = $total_cost;
							if($total_cost && $vc["revenue"])
							{
								$roas_cal = $vc["revenue"]/$total_cost;
								if($roas_cal)
								{
									$roas = number_format((float)$roas_cal, 2, '.', '');
								}else{
									$roas = 0;
								}
								/* $roas_cal = $vc["revenue"]/$val->total_cost;
								if($roas_cal)
								{
									$roas = number_format((float)$roas_cal, 2, '.', '');
								}else{
									$roas = 0;
								} */
								
								$channel_gr_array[$kc]['roas'] = $roas;
							}
							
						}
						
					}
				}
				
				/* echo "<pre>";
				print_r($records_channel_array);die; */
			}
			/* echo "<pre>";
			print_r($channel_gr_array);die; */
		
		$data["channel_gr_array"] = $channel_gr_array;
		// $data["month"] = $month;
		
		return json_encode($data["channel_gr_array"]);
	}
	
	function daterangereports()
	{
		if(null !== $this->input->get('filter_date'))
		{
			$brand_id = $this->input->get('brand_id');
			$this->accessBrandCheck($brand_id);
			$till_date = $this->input->get('filter_date');
			$date = explode(" - ", $till_date);
			$start_date = date('Y-m-d', strtotime(str_replace('/', '-', $date[0])));
			$end_date = date('Y-m-d', strtotime(str_replace('/', '-', $date[1])));
			
			$end_date_array = explode("-",$end_date);
			$end_date_year = $end_date_array[0];
			$end_date_month = $end_date_array[1];
			
			$roas = $this->reports_model->getProjectedAffialiateRoas($brand_id,$end_date_month,$end_date_year);
			
			$whereArray = array();
			if(null!==$this->input->get('channel_id') && $this->input->get('channel_id')!=""){
				$whereArray['channel_group.id'] = $this->input->get('channel_id');
			}
			
			if(null!==$this->input->get('type') && $this->input->get('type')!=""){
				$type = $this->input->get('type');
				$brandTypeRes = $this->reports_model->checkBrandType($brand_id,$type);
				
				if($brandTypeRes)
				{
					
					$allChannels = $this->reports_model->getAllChannelGroupsType($brand_id,$type);
					// echo "<pre>"; print_r($this->db->last_query()); echo "</pre>";die;
					// $new_array = array_merge($brandTypeRes,$allChannels);
					
					// echo "<pre>"; print_r($brandTypeRes); echo "</pre>";die;
					// echo "<pre>"; print_r($allChannels); echo "</pre>";die;
					$brandChannelArray = array();
					// echo "<pre>"; print_r($allChannels); echo "</pre>";die;
					foreach($brandTypeRes as $k=>$v)
					{
						array_push($brandChannelArray,$v->id);
					}
					foreach($allChannels as $ket=>$vat)
					{
							array_push($brandChannelArray,$vat->id);
					}
					
					$type = $brandChannelArray;
					// echo "<pre>"; print_r($brandChannelArray); echo "</pre>";die;
					
				}
				
			}else{
				$type = null;
			}
			
			
			
			/* Get All Channel Groups */
			$channel_groups = $this->reports_model->getChannelGroup($whereArray,$type);
			
			$channel_groups = $this->reports_model->getChannelGroupByBrand($brand_id,$channel_groups);
			// $channel_source_channel_ids = json_decode($this->reports_model->get_channel_source_ids_array($data["channel_groups"]));
			foreach($channel_groups as $kt=>$bt)
			{
				
				$id = $bt->id;
				$merged_id = $bt->merged_id;
				$getGroup = $this->searchForId($id,$channel_groups);
				
				if($getGroup != null)
				{
					$channel_groups[$kt]->new_ids = $getGroup;
				}else{
					$channel_groups[$kt]->new_ids = $getGroup;
				}
				
			}
			/* echo "<pre>";
			print_r($channel_groups);die; */
			$imported_data_array = array();
			foreach($channel_groups as $k=>$v)
			{
				if($v->visible)
				{
					$channel_source_channel_ids = json_decode($this->reports_model->get_unique_channel_source_ids_array($v->new_ids));
					// $channel_source_channel_ids = json_decode($this->reports_model->get_unique_channel_source_ids_array($v->id));
					if($channel_source_channel_ids)
					{
						$month_imported_data = $this->reports_model->getDateRangeImportData($brand_id,$start_date,$end_date,$channel_source_channel_ids);
					}
					else{
						$month_imported_data = 0;
					}
					
					if($month_imported_data)
					{
						$total_channel_sessions = $month_imported_data->total_channel_sessions;
						$total_channel_transactions = $month_imported_data->total_channel_transactions;
						$total_channel_revenue = $month_imported_data->total_channel_revenue;
					}else{
						$total_channel_sessions = 0;
						$total_channel_transactions = 0;
						$total_channel_revenue = 0;
					}
					
					$imported_array = array(
						"channel_group_id"=>$v->id,
						"name"=>$v->name,
						"total_channel_sessions"=>$total_channel_sessions,
						"total_channel_transactions"=>$total_channel_transactions,
						"total_channel_revenue"=>$total_channel_revenue,
						
					);
					
					array_push($imported_data_array,$imported_array);
				}
				
			}
			
			// echo "<pre>"; print_r($imported_data_array); echo "</pre>";die;
			
			$data["daily_cost_month"] = $this->reports_model->getDateRangeCostData($brand_id,$start_date,$end_date);
			// echo "<pre>"; print_r($this->db->last_query()); echo "</pre>";die;
			
			$data["achieved_numbers_till_date"] = json_decode($this->getAchievedNumbersDateRange($brand_id,$imported_data_array,$data["daily_cost_month"],$roas));
			
			$data["date_filter"] = date("d M Y",strtotime($start_date)) ." to ". date("d M Y",strtotime($end_date));
			$data["date_filter_session"] = date("d-m-Y",strtotime($start_date)) ." to ". date("d-m-Y",strtotime($end_date));
			$data["brand_name"] = $this->reports_model->getSingleBrandName($brand_id);
			/* echo "<pre>";
			print_r($data["achieved_numbers_till_date"]);die; */
			$this->session->set_userdata("daterangereports_data",$data["achieved_numbers_till_date"]);
			$this->session->set_userdata("date",$data["date_filter_session"]);
			$this->session->set_userdata("brand",$data["brand_name"]);
			$data["brands"] = $this->reports_model->getBrands();
			$data["channels"] = $this->reports_model->getAllChannelGroupsAll();
			$data['file']  = 'admin/reports/daterangereports';
			$this->load->view('admin/template',$data);	
		}else{
			$data["channels"] = $this->reports_model->getAllChannelGroupsAll();
			$data["brands"] = $this->reports_model->getBrands();
			// echo "<pre>"; print_r($data["brands"]); echo "</pre>";die;
			$data['file']  = 'admin/reports/daterangereports';
			$this->load->view('admin/template',$data);	
		}
	}
	
	
	function getAchievedNumbersDateRange($brand_id,$importedData,$costData,$affiliateroas)
	{
		$channel_groups = $this->reports_model->getAllChannelGroups();
		
		$channel_groups = $this->reports_model->getChannelGroupByBrand($brand_id,$channel_groups);
		/* echo "<pre>";
		print_r($importedData);die; */
		$channel_gr_array = array();
		foreach($channel_groups as $k=>$v){
			
			if($v->visible)
			{
				$new_array = array(
					"id" => $v->id,
					"name" => $v->name,
					"sessions" => '',
					"ecom_conversion_rate" => '',
					"transactions" => '',
					"aov" => '',
					"revenue" => '',
					"cost" => '',
					"roas" => '',
				);
				if($importedData)
				{
					foreach($importedData as $key=>$val)
					{
						
						if($val['channel_group_id'] == $v->id)
						{
							if($val['total_channel_sessions'])
							{
								$cr_cal = $val['total_channel_transactions']/$val['total_channel_sessions'];
								if($cr_cal)
								{
									$cr = number_format((float)$cr_cal*100, 2, '.', '');
								}else{
									$cr = 0;
								}
								
							}else{
								$cr = 0;
							}
							
							if($val['total_channel_transactions'])
							{
								$aov = round($val['total_channel_revenue']/$val['total_channel_transactions']);
							}else{
								$aov = 0;
							}
							$new_array['sessions'] = $val['total_channel_sessions'];
							$new_array['ecom_conversion_rate'] = $cr;
							$new_array['transactions'] = $val['total_channel_transactions'];
							$new_array['aov'] = $aov;
							$new_array['revenue'] = number_format((float)$val['total_channel_revenue'], 2, '.', '');
						}
					}
					/* echo "<pre>";
					print_r($records_channel_array);die; */
				}
				array_push($channel_gr_array,$new_array);
			}
		}
			
			/* echo "<pre>";
			print_r($channel_gr_array);die; */
			if($costData)
			{
				foreach($channel_gr_array as $kc=>$vc)
				{
					if($affiliateroas)
					{
						if($vc["id"] == 2)
						{
							$roas_get_cost = $vc["revenue"]/$affiliateroas;
							$channel_gr_array[$kc]['cost'] = number_format((float)$roas_get_cost, 2, '.', '');
							$channel_gr_array[$kc]['roas'] = $affiliateroas;
						}
					}
					
					foreach($costData as $key=>$val)
					{
						
						if($val->channel_group_id == $vc["id"])
						{
							if($val->total_cost && $vc["revenue"])
							{
								$total_cost = number_format((float)$val->total_cost, 2, '.', '');
								$roas_cal = $vc["revenue"]/$total_cost;
								if($roas_cal)
								{
									$roas = number_format((float)$roas_cal, 2, '.', '');
								}else{
									$roas = 0;
								}
								
							}else{
								$roas = 0;
								$total_cost = 0;
							}
							$channel_gr_array[$kc]['cost'] = $total_cost;
							$channel_gr_array[$kc]['roas'] = $roas;
						}
					}
				}
				
				/* echo "<pre>";
				print_r($records_channel_array);die; */
			}
			/* echo "<pre>";
			print_r($channel_gr_array);die; */
		
		$data["channel_gr_array"] = $channel_gr_array;
		// $data["month"] = $month;
		
		return json_encode($data["channel_gr_array"]);
	}
	
	
	public function daterangereport_excel()  
	{
		if (!$this->session->userdata('isAdminLoggedIn')) {
            redirect(base_url());
        }
        require_once APPPATH . '/third_party/Phpexcel/Bootstrap.php';
        $reportList = $this->session->userdata('daterangereports_data');
        // Create new Spreadsheet object
        $spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
        // Set document properties
        $spreadsheet->getProperties()->setCreator('Media');
		if ($this->session->userdata('date') && $this->session->userdata('brand')) {
            $fileName = $this->session->userdata('brand').'-media-report-' . $this->session->userdata('date') . ".xls";
            $date = $this->session->userdata('date');
        } else {
            $fileName = 'media-report-' . date('d-m-Y') . ".xls";
			$date = date('d-m-Y');
        }
		/* echo "<pre>";
		print_r($reportList);die; */
        // add style to the header
        $styleArray = array('font' => array('bold' => true,), 'alignment' => array('horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER, 'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,), 'borders' => array('top' => array('style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,),), 'fill' => array('type' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_GRADIENT_LINEAR, 'rotation' => 90, 'startcolor' => array('argb' => 'FFA0A0A0',), 'endcolor' => array('argb' => 'FFFFFFFF',),),);
        $spreadsheet->getActiveSheet()->getStyle('A1:H1')->applyFromArray($styleArray);
		
		
        // auto fit column to content
        foreach (range('A', 'H') as $columnID) {
            $spreadsheet->getActiveSheet()->getColumnDimension($columnID)->setAutoSize(true);
        }
        // set the names of header cells
        $spreadsheet->setActiveSheetIndex(0)
		->setCellValue("A1", 'Source/Channels')
		->setCellValue("B1", "Sessions")
		->setCellValue("C1", "CR%")
		->setCellValue("D1", "Transactions")
		->setCellValue("E1", 'AOV')
		->setCellValue("F1", 'Revenue')
		->setCellValue("G1", 'Cost')
		->setCellValue("H1", 'ROAS');
        // Add some data
        $x = 2;
		$i = 1;
		$total_sessions = 0;
		$total_cr = 0;
		$total_transactions = 0;
		$total_aov = 0;
		$total_revenue = 0;
		$total_cost = 0;
		$total_roas = 0;
        foreach ($reportList as $prokey=>$proval) {
			$id = $proval->id;
			$count_total = count($reportList);
			
			$total_sessions += $this->checkValue($proval->sessions);
			$total_transactions += $this->checkValue($proval->transactions);
			$total_revenue += $this->checkValue($proval->revenue);
			$total_cost += $this->checkValue($proval->cost);
			
			if(isset($proval->sessions)){$sessions = $proval->sessions;}else{$sessions = 0;}
			if(isset($proval->ecom_conversion_rate)){$ecom_conversion_rate = $proval->ecom_conversion_rate;}else{$ecom_conversion_rate = 0;}
			if(isset($proval->transactions)){$transactions = $proval->transactions;}else{$transactions = 0;}
			if(isset($proval->aov)){$aov = $proval->aov;}else{$aov = 0;}
			if(isset($proval->revenue)){$revenue = $proval->revenue;}else{$revenue = 0;}
			if(isset($proval->cost)){$cost = $proval->cost;}else{$cost = 0;}
			if(isset($proval->roas)){$roas = $proval->roas;}else{$roas = 0;}
            $spreadsheet->setActiveSheetIndex(0)
			->setCellValue("A$x", "$proval->name")
			->setCellValue("B$x", "$sessions")
			->setCellValue("C$x", "$ecom_conversion_rate")
			->setCellValue("D$x", "$transactions")
			->setCellValue("E$x", "$aov")
			->setCellValue("F$x", "$revenue")
			->setCellValue("G$x", "$cost")
			->setCellValue("H$x", "$roas");
            $x++;
        }
		
		if($total_sessions)
		{
			$total_cr = number_format((float)$total_transactions/$total_sessions*100, 2, '.', ''); 
		}
		if($total_transactions)
		{
			$total_aov = round($total_revenue/$total_transactions);
		}
		if($total_cost)
		{
			$total_roas = number_format((float)$total_revenue/$total_cost, 2, '.', ''); 
		}
		if(isset($total_sessions)){$ts = $total_sessions;}else{$ts =  0;};
		if(isset($total_cr)){$tc = $total_cr."%";}else{$tc =  0;};
		if(isset($total_transactions)){$tt =  $total_transactions;}else{$tt = 0;};
		if(isset($total_aov)){$ta =  $total_aov;}else{$ta =  0;};
		if(isset($total_revenue)){$tr =  $total_revenue;}else{$tr =  0;};
		if(isset($total_cost)){$tcost =  $total_cost;}else{$tcost =  0;};
		if(isset($total_roas)){$troas =  $total_roas;}else{$troas =  0;};
		$styleArray = array('font' => array('bold' => true,),);
        $spreadsheet->getActiveSheet()->getStyle("A$x:H$x")->applyFromArray($styleArray);
		$spreadsheet->setActiveSheetIndex(0)
			->setCellValue("A$x", "Total")
			->setCellValue("B$x", "$ts")
			->setCellValue("C$x", "$tc")
			->setCellValue("D$x", "$tt")
			->setCellValue("E$x", "$ta")
			->setCellValue("F$x", "$tr")
			->setCellValue("G$x", "$tcost")
			->setCellValue("H$x", "$troas");
		
        // Rename worksheet
        $spreadsheet->getActiveSheet()->setTitle('Media');
        $spreadsheet->setActiveSheetIndex(0);
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename= "' . $fileName . '"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0
        $writer = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, 'Excel2007');
        //ob_end_clean();
        $writer->save('php://output');
        exit;
	}
	
	
	public function monthtilldatereport_excel()  
	{
		if (!$this->session->userdata('isAdminLoggedIn')) {
            redirect(base_url());
        }
        require_once APPPATH . '/third_party/Phpexcel/Bootstrap.php';
        $projectedNumbersList = $this->session->userdata('monthProjectedNumbersreports_data');
        $monthTillDateProjectedNumbersList = $this->session->userdata('monthTillDateProjectedNumbersreports_data');
        $achievedNumbersList = $this->session->userdata('monthTillDateAchievedNumbersreports_data');
        // Create new Spreadsheet object
        $spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
        // Set document properties
        $spreadsheet->getProperties()->setCreator('Media');
		if ($this->session->userdata('monthTilldate') && $this->session->userdata('brand')) {
            $fileName = $this->session->userdata('brand').'-media-monthtilldate-report-' . $this->session->userdata('monthTilldate') . ".xls";
            $date = date("F",strtotime($this->session->userdata('monthTilldate')));
            $showdate = $this->session->userdata('monthTilldate');
        } else {
            $fileName = 'media-monthtilldate-report-' . date('d-m-Y') . ".xls";
			$date = date('d-m-Y');
			$showdate = date('d-m-Y');
        }
		/* echo "<pre>";
		print_r($reportList);die; */
		
		
		/* Projected Numbers */
		
        // add style to the header
        $styleArray = array('font' => array('bold' => true,), 'alignment' => array('horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER, 'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,), 'borders' => array('top' => array('style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,),), 'fill' => array('type' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_GRADIENT_LINEAR, 'rotation' => 90, 'startcolor' => array('argb' => 'FFA0A0A0',), 'endcolor' => array('argb' => 'FFFFFFFF',),),);
        $spreadsheet->getActiveSheet()->getStyle('A3:H3')->applyFromArray($styleArray);
		
		$styleHeading = array('font' => array('bold' => true,), 'alignment' => array('horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER, 'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,));
        $spreadsheet->getActiveSheet()->getStyle("A1:H1")->applyFromArray($styleHeading);
        $spreadsheet->getActiveSheet()->getStyle("A1:H1")->getFont()->setSize(16);
		$spreadsheet->setActiveSheetIndex(0)
			->mergeCells('A1:H1')
			->getCell('A1')
			->setValue("Projected Numbers - $date");
			
		$spreadsheet->setActiveSheetIndex(0)
			->mergeCells('A2:H2')
			->getCell('A2')
			->setValue(" ");
        // auto fit column to content
        foreach (range('A', 'H') as $columnID) {
            $spreadsheet->getActiveSheet()->getColumnDimension($columnID)->setAutoSize(true);
        }
        // set the names of header cells
        $spreadsheet->setActiveSheetIndex(0)
		->setCellValue("A3", 'Source/Channels')
		->setCellValue("B3", "Sessions")
		->setCellValue("C3", "CR%")
		->setCellValue("D3", "Transactions")
		->setCellValue("E3", 'AOV')
		->setCellValue("F3", 'Revenue')
		->setCellValue("G3", 'Cost')
		->setCellValue("H3", 'ROAS');
        // Add some data
        $x = 4;
		$i = 1;
		$total_sessions = 0;
		$total_cr = 0;
		$total_transactions = 0;
		$total_aov = 0;
		$total_revenue = 0;
		$total_cost = 0;
		$total_roas = 0;
        foreach ($projectedNumbersList as $prokey=>$proval) {
			$id = $proval->id;
			$count_total = count($projectedNumbersList);
			
			$total_sessions += $this->checkValue($proval->sessions);
			$total_transactions += $this->checkValue($proval->transactions);
			$total_revenue += $this->checkValue($proval->revenue);
			$total_cost += $this->checkValue($proval->cost);
			
			if(isset($proval->sessions)){$sessions = $proval->sessions;}else{$sessions = 0;}
			if(isset($proval->ecom_conversion_rate)){$ecom_conversion_rate = $proval->ecom_conversion_rate;}else{$ecom_conversion_rate = 0;}
			if(isset($proval->transactions)){$transactions = $proval->transactions;}else{$transactions = 0;}
			if(isset($proval->aov)){$aov = $proval->aov;}else{$aov = 0;}
			if(isset($proval->revenue)){$revenue = $proval->revenue;}else{$revenue = 0;}
			if(isset($proval->cost)){$cost = $proval->cost;}else{$cost = 0;}
			if(isset($proval->roas)){$roas = $proval->roas;}else{$roas = 0;}
            $spreadsheet->setActiveSheetIndex(0)
			->setCellValue("A$x", "$proval->name")
			->setCellValue("B$x", "$sessions")
			->setCellValue("C$x", "$ecom_conversion_rate")
			->setCellValue("D$x", "$transactions")
			->setCellValue("E$x", "$aov")
			->setCellValue("F$x", "$revenue")
			->setCellValue("G$x", "$cost")
			->setCellValue("H$x", "$roas");
            $x++;
        }
		
		if($total_sessions)
		{
			$total_cr = number_format((float)$total_transactions/$total_sessions*100, 2, '.', ''); 
		}
		if($total_transactions)
		{
			$total_aov = round($total_revenue/$total_transactions);
		}
		if($total_cost)
		{
			$total_roas = number_format((float)$total_revenue/$total_cost, 2, '.', ''); 
		}
		if(isset($total_sessions)){$ts = $total_sessions;}else{$ts =  0;};
		if(isset($total_cr)){$tc = $total_cr."%";}else{$tc =  0;};
		if(isset($total_transactions)){$tt =  $total_transactions;}else{$tt = 0;};
		if(isset($total_aov)){$ta =  $total_aov;}else{$ta =  0;};
		if(isset($total_revenue)){$tr =  $total_revenue;}else{$tr =  0;};
		if(isset($total_cost)){$tcost =  $total_cost;}else{$tcost =  0;};
		if(isset($total_roas)){$troas =  $total_roas;}else{$troas =  0;};
		$styleArray = array('font' => array('bold' => true,),);
        $spreadsheet->getActiveSheet()->getStyle("A$x:H$x")->applyFromArray($styleArray);
		$spreadsheet->setActiveSheetIndex(0)
			->setCellValue("A$x", "Total")
			->setCellValue("B$x", "$ts")
			->setCellValue("C$x", "$tc")
			->setCellValue("D$x", "$tt")
			->setCellValue("E$x", "$ta")
			->setCellValue("F$x", "$tr")
			->setCellValue("G$x", "$tcost")
			->setCellValue("H$x", "$troas");
			
			
		
		/* Projected Numbers Till Date */
		
		$styleArray = array('font' => array('bold' => true,), 'alignment' => array('horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER, 'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,), 'borders' => array('top' => array('style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,),), 'fill' => array('type' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_GRADIENT_LINEAR, 'rotation' => 90, 'startcolor' => array('argb' => 'FFA0A0A0',), 'endcolor' => array('argb' => 'FFFFFFFF',),),);
        $spreadsheet->getActiveSheet()->getStyle('K3:R3')->applyFromArray($styleArray);
		
		$styleHeading = array('font' => array('bold' => true,), 'alignment' => array('horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER, 'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,));
        $spreadsheet->getActiveSheet()->getStyle("K1:R1")->applyFromArray($styleHeading);
        $spreadsheet->getActiveSheet()->getStyle("K1:R1")->getFont()->setSize(16);
		$spreadsheet->setActiveSheetIndex(0)
			->mergeCells('K1:R1')
			->getCell('K1')
			->setValue("Projected Numbers Till Date - $showdate");
			
		$spreadsheet->setActiveSheetIndex(0)
			->mergeCells('K2:R2')
			->getCell('K2')
			->setValue(" ");
        // auto fit column to content
        foreach (range('K', 'R') as $columnID) {
            $spreadsheet->getActiveSheet()->getColumnDimension($columnID)->setAutoSize(true);
        }
        // set the names of header cells
        $spreadsheet->setActiveSheetIndex(0)
		->setCellValue("K3", 'Source/Channels')
		->setCellValue("L3", "Sessions")
		->setCellValue("M3", "CR%")
		->setCellValue("N3", "Transactions")
		->setCellValue("O3", 'AOV')
		->setCellValue("P3", 'Revenue')
		->setCellValue("Q3", 'Cost')
		->setCellValue("R3", 'ROAS');
        // Add some data
        $x = 4;
		$i = 1;
		$total_sessions = 0;
		$total_cr = 0;
		$total_transactions = 0;
		$total_aov = 0;
		$total_revenue = 0;
		$total_cost = 0;
		$total_roas = 0;
		$revenue_array = array();
        foreach ($monthTillDateProjectedNumbersList as $prokey=>$proval) {
			$id = $proval->id;
			$count_total = count($monthTillDateProjectedNumbersList);
			
			$total_sessions += $this->checkValue($proval->sessions);
			$total_transactions += $this->checkValue($proval->transactions);
			$total_revenue += $this->checkValue($proval->revenue);
			$total_cost += $this->checkValue($proval->cost);
			array_push($revenue_array,$this->checkValue($proval->revenue));
			
			if(isset($proval->sessions)){$sessions = $proval->sessions;}else{$sessions = 0;}
			if(isset($proval->ecom_conversion_rate)){$ecom_conversion_rate = $proval->ecom_conversion_rate;}else{$ecom_conversion_rate = 0;}
			if(isset($proval->transactions)){$transactions = $proval->transactions;}else{$transactions = 0;}
			if(isset($proval->aov)){$aov = $proval->aov;}else{$aov = 0;}
			if(isset($proval->revenue)){$revenue = $proval->revenue;}else{$revenue = 0;}
			if(isset($proval->cost)){$cost = $proval->cost;}else{$cost = 0;}
			if(isset($proval->roas)){$roas = $proval->roas;}else{$roas = 0;}
            $spreadsheet->setActiveSheetIndex(0)
			->setCellValue("K$x", "$proval->name")
			->setCellValue("L$x", "$sessions")
			->setCellValue("M$x", "$ecom_conversion_rate")
			->setCellValue("N$x", "$transactions")
			->setCellValue("O$x", "$aov")
			->setCellValue("P$x", "$revenue")
			->setCellValue("Q$x", "$cost")
			->setCellValue("R$x", "$roas");
            $x++;
        }
		
		if($total_sessions)
		{
			$total_cr = number_format((float)$total_transactions/$total_sessions*100, 2, '.', ''); 
		}
		if($total_transactions)
		{
			$total_aov = round($total_revenue/$total_transactions);
		}
		if($total_cost)
		{
			$total_roas = number_format((float)$total_revenue/$total_cost, 2, '.', ''); 
		}
		if(isset($total_sessions)){$ts = $total_sessions;}else{$ts =  0;};
		if(isset($total_cr)){$tc = $total_cr."%";}else{$tc =  0;};
		if(isset($total_transactions)){$tt =  $total_transactions;}else{$tt = 0;};
		if(isset($total_aov)){$ta =  $total_aov;}else{$ta =  0;};
		if(isset($total_revenue)){$tr =  $total_revenue;}else{$tr =  0;};
		if(isset($total_cost)){$tcost =  $total_cost;}else{$tcost =  0;};
		if(isset($total_roas)){$troas =  $total_roas;}else{$troas =  0;};
		$styleArray = array('font' => array('bold' => true,),);
        $spreadsheet->getActiveSheet()->getStyle("K$x:R$x")->applyFromArray($styleArray);
		$spreadsheet->setActiveSheetIndex(0)
			->setCellValue("K$x", "Total")
			->setCellValue("L$x", "$ts")
			->setCellValue("M$x", "$tc")
			->setCellValue("N$x", "$tt")
			->setCellValue("O$x", "$ta")
			->setCellValue("P$x", "$tr")
			->setCellValue("Q$x", "$tcost")
			->setCellValue("R$x", "$troas");
			
		
		
		/* Achieved Numbers Till Date */
		
		$styleArray = array('font' => array('bold' => true,), 'alignment' => array('horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER, 'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,), 'borders' => array('top' => array('style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,),), 'fill' => array('type' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_GRADIENT_LINEAR, 'rotation' => 90, 'startcolor' => array('argb' => 'FFA0A0A0',), 'endcolor' => array('argb' => 'FFFFFFFF',),),);
        $spreadsheet->getActiveSheet()->getStyle('U3:AC3')->applyFromArray($styleArray);
		
		$styleHeading = array('font' => array('bold' => true,), 'alignment' => array('horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER, 'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,));
        $spreadsheet->getActiveSheet()->getStyle("U1:AC1")->applyFromArray($styleHeading);
        $spreadsheet->getActiveSheet()->getStyle("U1:AC1")->getFont()->setSize(16);
		$spreadsheet->setActiveSheetIndex(0)
			->mergeCells('U1:AB1')
			->getCell('U1')
			->setValue("Achieved Numbers Till Date - $showdate");
			
		$spreadsheet->setActiveSheetIndex(0)
			->mergeCells('U2:AC2')
			->getCell('U2')
			->setValue(" ");
        // auto fit column to content
        foreach (range('U', 'AC') as $columnID) {
            $spreadsheet->getActiveSheet()->getColumnDimension($columnID)->setAutoSize(true);
        }
        // set the names of header cells
        $spreadsheet->setActiveSheetIndex(0)
		->setCellValue("U3", 'Source/Channels')
		->setCellValue("V3", "Sessions")
		->setCellValue("W3", "CR%")
		->setCellValue("X3", "Transactions")
		->setCellValue("Y3", 'AOV')
		->setCellValue("Z3", 'Revenue')
		->setCellValue("AA3", 'Cost')
		->setCellValue("AB3", 'ROAS')
		->setCellValue("AC3", 'Diff');
        // Add some data
        $x = 4;
		$i = 1;
		$total_sessions = 0;
		$total_cr = 0;
		$total_transactions = 0;
		$total_aov = 0;
		$total_revenue = 0;
		$total_cost = 0;
		$total_roas = 0;
		$diff = 0;
		$total_diff = 0;
        foreach ($achievedNumbersList as $prokey=>$proval) {
			$id = $proval->id;
			$count_total = count($achievedNumbersList);
			
			$total_sessions += $this->checkValue($proval->sessions);
			$total_transactions += $this->checkValue($proval->transactions);
			$total_revenue += $this->checkValue($proval->revenue);
			$total_cost += $this->checkValue($proval->cost);
			
			if(isset($revenue_array[$prokey]))
			{
				$diff = $this->checkValue($proval->revenue) - $revenue_array[$prokey];
			}else{
				$diff = 0;
			}
			
			$total_diff += $diff;
			
			if(isset($proval->sessions)){$sessions = $proval->sessions;}else{$sessions = 0;}
			if(isset($proval->ecom_conversion_rate)){$ecom_conversion_rate = $proval->ecom_conversion_rate;}else{$ecom_conversion_rate = 0;}
			if(isset($proval->transactions)){$transactions = $proval->transactions;}else{$transactions = 0;}
			if(isset($proval->aov)){$aov = $proval->aov;}else{$aov = 0;}
			if(isset($proval->revenue)){$revenue = $proval->revenue;}else{$revenue = 0;}
			if(isset($proval->cost)){$cost = $proval->cost;}else{$cost = 0;}
			if(isset($proval->roas)){$roas = $proval->roas;}else{$roas = 0;}
            $spreadsheet->setActiveSheetIndex(0)
			->setCellValue("U$x", "$proval->name")
			->setCellValue("V$x", "$sessions")
			->setCellValue("W$x", "$ecom_conversion_rate")
			->setCellValue("X$x", "$transactions")
			->setCellValue("Y$x", "$aov")
			->setCellValue("Z$x", "$revenue")
			->setCellValue("AA$x", "$cost")
			->setCellValue("AB$x", "$roas")
			->setCellValue("AC$x", "$diff");
            $x++;
        }
		
		if($total_sessions)
		{
			$total_cr = number_format((float)$total_transactions/$total_sessions*100, 2, '.', ''); 
		}
		if($total_transactions)
		{
			$total_aov = round($total_revenue/$total_transactions);
		}
		if($total_cost)
		{
			$total_roas = number_format((float)$total_revenue/$total_cost, 2, '.', ''); 
		}
		if(isset($total_sessions)){$ts = $total_sessions;}else{$ts =  0;};
		if(isset($total_cr)){$tc = $total_cr."%";}else{$tc =  0;};
		if(isset($total_transactions)){$tt =  $total_transactions;}else{$tt = 0;};
		if(isset($total_aov)){$ta =  $total_aov;}else{$ta =  0;};
		if(isset($total_revenue)){$tr =  $total_revenue;}else{$tr =  0;};
		if(isset($total_cost)){$tcost =  $total_cost;}else{$tcost =  0;};
		if(isset($total_roas)){$troas =  $total_roas;}else{$troas =  0;};
		$styleArray = array('font' => array('bold' => true,),);
        $spreadsheet->getActiveSheet()->getStyle("U$x:AC$x")->applyFromArray($styleArray);
		$spreadsheet->setActiveSheetIndex(0)
			->setCellValue("U$x", "Total")
			->setCellValue("V$x", "$ts")
			->setCellValue("W$x", "$tc")
			->setCellValue("X$x", "$tt")
			->setCellValue("Y$x", "$ta")
			->setCellValue("Z$x", "$tr")
			->setCellValue("AA$x", "$tcost")
			->setCellValue("AB$x", "$troas")
			->setCellValue("AC$x", "$total_diff");
			
			
			
			
		
		
        // Rename worksheet
        $spreadsheet->getActiveSheet()->setTitle('Media');
        $spreadsheet->setActiveSheetIndex(0);
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename= "' . $fileName . '"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0
        $writer = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, 'Excel2007');
        //ob_end_clean();
        $writer->save('php://output');
        exit;
	}
	
	
	public function report_excel()  
	{
		if (!$this->session->userdata('isAdminLoggedIn')) {
            redirect(base_url());
        }
        require_once APPPATH . '/third_party/Phpexcel/Bootstrap.php';
        $reportList = $this->session->userdata('report_data');
        // Create new Spreadsheet object
        $spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
        // Set document properties
        $spreadsheet->getProperties()->setCreator('Media');
		if ($this->session->userdata('date')) {
            $fileName = 'media-report-' . $this->session->userdata('date') . ".xls";
            $date = $this->session->userdata('date');
        } else {
            $fileName = 'media-report-' . date('d-m-Y') . ".xls";
			$date = date('d-m-Y');
        }
		/* echo "<pre>";
		print_r($reportList);die; */
        // add style to the header
        $styleArray = array('font' => array('bold' => true,), 'alignment' => array('horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER, 'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,), 'borders' => array('top' => array('style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,),), 'fill' => array('type' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_GRADIENT_LINEAR, 'rotation' => 90, 'startcolor' => array('argb' => 'FFA0A0A0',), 'endcolor' => array('argb' => 'FFFFFFFF',),),);
        $spreadsheet->getActiveSheet()->getStyle('A1:I1')->applyFromArray($styleArray);
        // auto fit column to content
        foreach (range('A', 'I') as $columnID) {
            $spreadsheet->getActiveSheet()->getColumnDimension($columnID)->setAutoSize(true);
        }
        // set the names of header cells
        $spreadsheet->setActiveSheetIndex(0)
		->setCellValue("A1", 'Channel')
		->setCellValue("B1", "Date - ".$date)
		->setCellValue("C1", "Cost")
		->setCellValue("D1", "Month Target")
		->setCellValue("E1", 'MTD Projected Number')
		->setCellValue("F1", 'MTD Achieved Number')
		->setCellValue("G1", 'Difference')
		->setCellValue("H1", 'Total Cost')
		->setCellValue("I1", 'ROAS');
        // Add some data
        $x = 2;
        foreach ($reportList as $key => $report) {
			if(isset($report->revenue)){$revenue = $report->revenue;}else{$revenue = 0;}
			if(isset($report->cost)){$cost = $report->cost;}else{$cost = 0;}
			if(isset($report->budget)){$budget = $report->budget;}else{$budget = 0;}
			if(isset($report->pr_month_to_date)){$pr_month_to_date = $report->pr_month_to_date;}else{$pr_month_to_date = 0;}
			if(isset($report->ach_month_to_date)){$ach_month_to_date = $report->ach_month_to_date;}else{$ach_month_to_date = 0;}
			if(isset($report->difference)){$difference = $report->difference;}else{$difference = 0;}
			if(isset($report->total_cost)){$total_cost = $report->total_cost;}else{$total_cost = 0;}
			if(isset($report->roas)){$roas = $report->roas;}else{$roas = 0;}
            $spreadsheet->setActiveSheetIndex(0)
			->setCellValue("A$x", "$report->name")
			->setCellValue("B$x", "$revenue")
			->setCellValue("C$x", "$cost")
			->setCellValue("D$x", "$budget")
			->setCellValue("E$x", "$pr_month_to_date")
			->setCellValue("F$x", "$ach_month_to_date")
			->setCellValue("G$x", "$difference")
			->setCellValue("H$x", "$total_cost")
			->setCellValue("I$x", "$roas");
            $x++;
        }
        // Rename worksheet
        $spreadsheet->getActiveSheet()->setTitle('Media');
        $spreadsheet->setActiveSheetIndex(0);
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename= "' . $fileName . '"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0
        $writer = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, 'Excel2007');
        //ob_end_clean();
        $writer->save('php://output');
        exit;
	}
	
	function accessBrandCheck($id)
	{
		if(!in_array($id,$this->getAllUserBrands))
		{
			$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">You are not access to this brand</div>');
			redirect(base_url().'admin/reports/', 'refresh');
		}
	}
	
	function searchForId($id, $array) {
		$new_ids_array = array($id);
	   foreach ($array as $key => $val) {
		   if ($val->merged_id === $id) {
			   array_push($new_ids_array,$val->id);
		   } 
	   }
	   return $new_ids_array;
		// return null;
	}
	
	function checkValue($value)
	{
		if(null !== $value && $value)
		{
			// echo $value;
			return $value;
		}else{
			return 0;
		}
	}
	
}
?>