<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Channelssr extends CI_Controller { 
    
	
    function __construct() {
        parent::__construct();
        $this->load->model('admin/channelssr_model');
		if(!$this->session->userdata('isAdminLoggedIn'))
		{
			 redirect('admin');
		}
		/* elseif($this->session->userdata('loginUserData')['role_id'] != 1)
		{
			redirect(base_url().'admin/dashboard');
		} */
    }



	function index()
	{
		$whereArray = array();
		$alias = "chgr";
		$fields = array($alias.".*","cg.name as channel_group_name");
		if(null!==$this->input->get('channelssr_name') && $this->input->get('channelssr_name')!=""){
			$whereArray[$alias.'.channel_name'] = $this->input->get('channelssr_name');
		}
		if(null!==$this->input->get('status') && $this->input->get('status')!=""){
			$whereArray[$alias.'.status'] = $this->input->get('status');
		}
		
		if(null!==$this->input->get('channel_group') && $this->input->get('channel_group')!=""){
			$whereArray['cg.name'] = $this->input->get('channel_group');
		}
		
		$orderby = array($alias.".id", "asc");
		$joins = array(array('channel_group as cg', 'cg.id = '.$alias.'.channel_group_id'));
		$where = array("where"=>$whereArray); 
		$data['channelssrs'] = $this->channelssr_model->getChannelssr($fields,$where,$joins,$alias,"",$orderby);
		// echo "<pre>"; print_r($this->db->last_query()); echo "</pre>";	die;	
		// echo "<pre>"; print_r($data['channelssr']); echo "</pre>";die;
		$data['totalCount'] = $this->channelssr_model->totalCount($fields,$where,$joins,$alias,"",$orderby); 
		// echo "<pre>"; print_r($this->db->last_query()); echo "</pre>";die;
		$data['numrecord'] = $this->channelssr_model->getNumRecord();
		$data['page'] = $this->channelssr_model->getPage();
		$data['filters'] = $this->getFilter();
		$data['number_of_page'] = ceil($data['totalCount']/$data['numrecord']);
		$data["channel_groups"] = $this->channelssr_model->getChannelGroups();
		$data['file']  = 'admin/channelssr/channelssr_view';
		$this->load->view('admin/template',$data);	
		
	}
	
	function getFilter(){
		$data["channel_groups"] = $this->channelssr_model->getFilterChannelGroups();
		/* echo "<pre>";
		print_r($data["channel_groups"]);die; */
		$filter = array();
		$filter['name'] = array("field"=>"text", "values"=>"channelssr_name");
		$filter['channel_group'] = array("field"=>"select","values"=>$data["channel_groups"]);
		$filter['status'] = array("field"=>"select","values"=>array("1"=>"Enabled","0"=>"Disabled"));
		return $filter;
	}
	

	public function addChannelsr()
	{
		
		
		if($this->input->post('submit'))
		{
			
			$this->form_validation->set_rules('channelssr_name','Channel Source/Medium Name','trim|required|xss_clean|is_unique[channel.channel_name]');

			$this->form_validation->set_rules('channel_gr_id','Select Channel Group','trim|required|xss_clean');
			$this->form_validation->set_rules('status','Select Status','trim|required|xss_clean');
				
			if($this->form_validation->run() == false)
			{
				$data["channel_groups"] = $this->channelssr_model->getChannelGroups();
				$data['file']  = 'admin/channelssr/channelssr_add';
				$this->load->view('admin/template',$data);
			}
			else
			{
				
					$channelgr_data = array(
						'channel_name'=>$this->input->post('channelssr_name'),
						'slug'=>str_replace(" ","",trim($this->input->post('channelssr_name'))),
						'channel_group_id'=>$this->input->post('channel_gr_id'),
						'created_at'=>date('Y-m-d H:i:s'),
						'status'=>$this->input->post('status'),
						'created_by'=>$this->session->userdata('userId'),
						'agency_id'=>$this->session->userdata('loginUserData')['agency_id'],
					);   
				 
					
				/* echo "<pre>";
				print_r($channelgr_data);die; */
				$insert_id = $this->channelssr_model->insertChannelsr($channelgr_data);
				
			
				  if($insert_id)
				  {
					$this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Channel Group added successfully.</div>');
					redirect(base_url().'admin/channelssr/', 'refresh');
				  }
				  else
				  {
					$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Please Try Again...</div>');
					redirect(base_url().'admin/channelssr/addChannelsr', 'refresh');
				  }
				
				
			}
		}
		else
		{
			$data["channel_groups"] = $this->channelssr_model->getChannelGroups();
			$data['file']  = 'admin/channelssr/channelssr_add';
			$this->load->view('admin/template',$data);
		}
	}

	public function editChannelsr($id)
	{
		$data['channelssr'] = $this->channelssr_model->getSingleChannelsr($id);
		if(empty($data['channelssr']))
		{
			redirect(base_url().'admin/channelssr/', 'refresh');
		}
		$data["channel_groups"] = $this->channelssr_model->getChannelGroups();
		$data['file']  = 'admin/channelssr/channelssr_edit';
		$this->load->view('admin/template',$data);
	}

	public function updateChannelsr($id)
	{
	
		if ($this->input->post('submit')) 
		{
			$data['channelssr'] = $this->channelssr_model->getSingleChannelsr($id);
			$original_value = $data['channelssr']->channel_name;
			if($this->input->post('channelssr_name') != $original_value) {
			   $is_unique =  '|is_unique[channel.channel_name]';
			} else {
			   $is_unique =  '';
			}
			$this->form_validation->set_rules('channelssr_name','Channel Source/Medium Name','trim|required|xss_clean'.$is_unique);	
			$this->form_validation->set_rules('channel_gr_id','Select Channel Group','trim|required|xss_clean');
			$this->form_validation->set_rules('status','Select Status','trim|required|xss_clean');
			
				
			if($this->form_validation->run() == false)
			{
				$data["channel_groups"] = $this->channelssr_model->getChannelGroups();
				$data['channelssr'] = $this->channelssr_model->getSingleChannelsr($id);	
				$data['file']  = 'admin/channelssr/channelssr_edit';
				$this->load->view('admin/template',$data);
			}
			else
			{
				$update_channelgr_data = array(
						'channel_name'=>$this->input->post('channelssr_name'),
						'slug'=>str_replace(" ","",trim($this->input->post('channelssr_name'))),
						'channel_group_id'=>$this->input->post('channel_gr_id'),
						'status'=>$this->input->post('status'),
						'created_by'=>$this->session->userdata('userId'),
						'agency_id'=>$this->session->userdata('loginUserData')['agency_id'],
					);  
				
					
					/* echo "<pre>";
					print_r($update_channelgr_data);die; */
				
				$data_update = $this->channelssr_model->updateChannelsr($update_channelgr_data,$id);
				  if($data_update > 0)
				  {
					 $this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Channel Group updated successfully.</div>');
					 redirect(base_url().'admin/channelssr/', 'refresh');
				  }
				  else
				  {
					$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Please Try Again...</div>');
				   redirect(base_url().'admin/channelssr/editChannelsr/'.$id, 'refresh');
				  }
			}
		}
		else
		{
		   
		   redirect(base_url().'admin/channelssr');
		}
	}
	
	
	public function deleteChannelsr($id)  
	{
		$this->channelssr_model->delete($id);
	
		$this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Channel Group  deleted successfully!</div>');
	
		redirect(base_url().'admin/channelssr');
	}
	
	public function updateChannelsrStatus($id)  
	{
		$status = $this->input->post('status');
		$status_array = array('status'=>$status);
		$query = $this->channelssr_model->update_status($status_array,$id);
		if($query){
			echo 1;
		}else{
			echo 0;
		}
	}
	
	function updateMultipleChannelSource()
	{
		$channel_group = $this->input->post("selected_group");
		$channel_sources = $this->input->post("sources");
		$update_array = array("channel_group_id"=>$channel_group,"last_updated_by"=>$this->session->userdata('userId'));
		$query = $this->channelssr_model->updateChannelGroupStatus($channel_sources,$update_array);
		if($query){
			$this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Channel Group  Updated successfully!</div>');
			echo 1;
		}else{
			$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Please Try Again...</div>');
			echo 0;
		}
	}
	
}
?>