<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Channelsgr extends CI_Controller { 
    
	
    function __construct() {
        parent::__construct();
        $this->load->model('admin/channelsgr_model');
		if(!$this->session->userdata('isAdminLoggedIn'))
		{
			 redirect('admin');
		}
		/* elseif($this->session->userdata('loginUserData')['role_id'] != 1)
		{
			redirect(base_url().'admin/dashboard');
		} */
    }



	function index()
	{
		$whereArray = array();
		$alias = "chgr";
		$fields = array($alias.".*");
		if(null!==$this->input->get('channelsgr_name') && $this->input->get('channelsgr_name')!=""){
			$whereArray[$alias.'.name'] = $this->input->get('channelsgr_name');
		}
		if(null!==$this->input->get('status') && $this->input->get('status')!=""){
			$whereArray[$alias.'.status'] = $this->input->get('status');
		}
		
		$orderby = array($alias.".id", "asc");
		$joins = array();
		$where = array("where"=>$whereArray); 
		$data['channelsgrs'] = $this->channelsgr_model->getChannelsgr($fields,$where,$joins,$alias,"",$orderby);
		// echo "<pre>"; print_r($this->db->last_query()); echo "</pre>";	die;	
		// echo "<pre>"; print_r($data['channelsgr']); echo "</pre>";die;
		$data['totalCount'] = $this->channelsgr_model->totalCount($fields,$where,$joins,$alias,"",$orderby); 
		// echo "<pre>"; print_r($this->db->last_query()); echo "</pre>";die;
		$data['numrecord'] = $this->channelsgr_model->getNumRecord();
		$data['page'] = $this->channelsgr_model->getPage();
		$data['filters'] = $this->getFilter();
		$data['number_of_page'] = ceil($data['totalCount']/$data['numrecord']);
		$data['file']  = 'admin/channelsgr/channelsgr_view';
		$this->load->view('admin/template',$data);	
		
	}
	
	function getFilter(){
		$filter = array();
		$filter['name'] = array("field"=>"text", "values"=>"channelsgr_name");
		$filter['status'] = array("field"=>"select","values"=>array("1"=>"Enabled","0"=>"Disabled"));
		return $filter;
	}
	

	public function addChannelgr()
	{
		
		
		if($this->input->post('submit'))
		{
			
			$this->form_validation->set_rules('channelsgr_name','Channel Group Name','trim|required|xss_clean|is_unique[channel_group.name]');	
				
			if($this->form_validation->run() == false)
			{
				$data['file']  = 'admin/channelsgr/channelsgr_add';
				$this->load->view('admin/template',$data);
			}
			else
			{
				
					$channelgr_data = array(
						'name'=>$this->input->post('channelsgr_name'),
						'created_at'=>date('Y-m-d H:i:s'),
						'status'=>$this->input->post('status'),
						'type'=>$this->input->post('type')
					);   
				 
					
				/* echo "<pre>";
				print_r($channelgr_data);die; */
				$insert_id = $this->channelsgr_model->insertChannelgr($channelgr_data);
				
			
				  if($insert_id)
				  {
					$this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Channel Group added successfully.</div>');
					redirect(base_url().'admin/channelsgr/', 'refresh');
				  }
				  else
				  {
					$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Please Try Again...</div>');
					redirect(base_url().'admin/channelsgr/addChannelgr', 'refresh');
				  }
				
				
			}
		}
		else
		{
			$data['file']  = 'admin/channelsgr/channelsgr_add';
			$this->load->view('admin/template',$data);
		}
	}

	public function editChannelgr($id)
	{
		$data['channelsgr'] = $this->channelsgr_model->getSingleChannelgr($id);
		if(empty($data['channelsgr']))
		{
			redirect(base_url().'admin/channelsgr/', 'refresh');
		}
		
		$data['file']  = 'admin/channelsgr/channelsgr_edit';
		$this->load->view('admin/template',$data);
	}

	public function updateChannelgr($id)
	{
	
		if ($this->input->post('submit')) 
		{
			$data['channelsgr'] = $this->channelsgr_model->getSingleChannelgr($id);
			$original_value = $data['channelsgr']->name;
			if($this->input->post('channelsgr_name') != $original_value) {
			   $is_unique =  '|is_unique[channel_group.name]';
			} else {
			   $is_unique =  '';
			}
			$this->form_validation->set_rules('channelsgr_name','Channelgr Name','trim|required|xss_clean'.$is_unique);	
			
				
			if($this->form_validation->run() == false)
			{
				$data['channelsgr'] = $this->channelsgr_model->getSingleChannelgr($id);	
				$data['file']  = 'admin/channelsgr/channelsgr_edit';
				$this->load->view('admin/template',$data);
			}
			else
			{
				
					$update_channelgr_data = array(
						'name'=>$this->input->post('channelsgr_name'),
						'status'=>$this->input->post('status'),
						'type'=>$this->input->post('type')
					);   
				
					
					/* echo "<pre>";
					print_r($update_channelgr_data);die; */
				
				$data_update = $this->channelsgr_model->updateChannelgr($update_channelgr_data,$id);
				  if($data_update > 0)
				  {
					 $this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Channel Group updated successfully.</div>');
					 redirect(base_url().'admin/channelsgr/', 'refresh');
				  }
				  else
				  {
					$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Please Try Again...</div>');
				   redirect(base_url().'admin/channelsgr/editChannelgr/'.$id, 'refresh');
				  }
			}
		}
		else
		{
		   
		   redirect(base_url().'admin/channelsgr');
		}
	}
	
	
	public function deleteChannelgr($id)  
	{
		$this->channelsgr_model->delete($id);
	
		$this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Channel Group  deleted successfully!</div>');
	
		redirect(base_url().'admin/channelsgr');
	}
	
	public function updateChannelgrStatus($id)  
	{
		$status = $this->input->post('status');
		$status_array = array('status'=>$status);
		$query = $this->channelsgr_model->update_status($status_array,$id);
		if($query){
			echo 1;
		}else{
			echo 0;
		}
	}
	
	public function updateChannelgrType($id)  
	{
		$type = $this->input->post('type');
		$type_array = array('type'=>$type);
		$query = $this->channelsgr_model->update_status($type_array,$id);
		if($query){
			echo 1;
		}else{
			echo 0;
		}
	}
	
}
?>