<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Home extends CI_Controller {
    
    function __construct() {
        parent::__construct();
       // $this->load->library('form_validation');
	   //$this->load->library('session');
       $this->load->model('admin/Adminleads');
	   $this->load->model('admin/reports_model');
    }
    
    
    
	function index()
	{
		
		$this->session->set_userdata('loginUserData');
		if($this->session->userdata('isAdminLoggedIn'))
		{
			redirect('admin/dashboard');
		}
		
        $data = array();
        if($this->session->userdata('success_msg')){
            $data['success_msg'] = $this->session->userdata('success_msg');
            $this->session->unset_userdata('success_msg');
        }
        if($this->session->userdata('error_msg')){
            $data['error_msg'] = $this->session->userdata('error_msg');
            $this->session->unset_userdata('error_msg');
        }
        if($this->input->post('loginSubmit')){
			
            $this->form_validation->set_rules('email', 'Email/Mobile', 'required');
            $this->form_validation->set_rules('password', 'password', 'required');
            if ($this->form_validation->run() == true) {
                $con['returnType'] = 'single';
				$email = $this->input->post('email');
				$password = $this->input->post('password');
				
				$salt = strrev(substr($email, 0, strpos($email, '@')));
				
				$con['conditions'] = array(
						'email'=>$email,
						'password' => md5($this->input->post('password')),
						'status' => '1'
					);
				
				
                $checkLogin = $this->Adminleads->getRows($con);
				// echo "<pre>";print_r($checkLogin);die;
                if($checkLogin){
					
					if($this->google_recaptcha_validation())
					{
						$this->session->set_userdata('isAdminLoggedIn',TRUE);
						$this->session->set_userdata('userId',$checkLogin['id']);
						$this->session->set_userdata('loginUserData',$checkLogin);
					}
					else
					{
						$data['error_msg'] = 'Captcha Error.Try Again';
					}

                    redirect(base_url().'admin/dashboard');
                }else{
                    $data['error_msg'] = 'Wrong email/username or password, please try again.';
                }
				
            }
        }
        //load the view
        $this->load->view('admin/login', $data);
    }
	
	function contact_leads()
	{
		$this->session->unset_userdata('date_range');
		if(!$this->session->userdata('isAdminLoggedIn'))
		{
			redirect(base_url());
		}
		
		if(isset($_GET['search']) || isset($_GET['contact_date']) || isset($_GET['sort']) || isset($_GET['entry']))
		{
			$data['contact_leads_excel'] = $this->Adminleads->getAllFilterContactLeads(); 
			$this->session->set_userdata('contactRecords',$data['contact_leads_excel']);
		}
		else{
			$data['contact_leads_excel'] = $this->Adminleads->getAllContactLeads(); 
			$this->session->set_userdata('contactRecords',$data['contact_leads_excel']);
		}
		$data['contact_leads'] = $this->Adminleads->getContactLeads(); 
		$data['totalCount'] = $this->Adminleads->totalCount(); 
		$data['numrecord'] = $this->Adminleads->getNumRecord();
		$data['page'] = $this->Adminleads->getPage();
		$data['number_of_page'] = ceil($data['totalCount']/$data['numrecord']);
		$data['file']  = 'admin/contact_leads_view';
		$this->load->view('admin/template',$data);
	}   
   
    
    /*
     * User logout
     */
    function logout(){
        $this->session->unset_userdata('isAdminLoggedIn');
        $this->session->unset_userdata('userId');
		$this->session->unset_userdata('date_range');
        $this->session->sess_destroy();
        redirect(base_url());
    }
    
    
	function dashboard()
	{ 
		$data["channels"] = $this->reports_model->getAllChannelGroups();
		$data["brands"] = $this->reports_model->getBrands();
		$data["paidUnpaidGraph"] = $this->lastSevenDaysGraphData("sessions",1);
		
		$data["revenuevscost"] = $this->lastSevenDaysGraphDataByRevenueVsCost(1);
		
		/* echo "<pre>";
		print_r($data["revenuevscost"]);die; */
		$data["months"] = $this->monthlyGraphData();
		/* $start_date = date("Y-m-d H:i:s",strtotime("-2 month"));
		$end_date = date("Y-m-d H:i:s");
		$data["weeks"] = $this->displayWeekDates($start_date,$end_date,"Y-m-d");
		echo "<pre>";
		print_r($data["weeks"]);die; */
		if($this->session->userdata('isAdminLoggedIn'))
		{
			if(empty($this->session->userdata('loginUserData')))
			{
				redirect(base_url()."home/logout");
			}
			$data['file'] = 'admin/index';
			$this->load->view('admin/template',$data);  
		}
		else
		{
			redirect(base_url());
		}
		
	}
	
	
	function lastSevenDaysGraphData($type,$br_id)
	{
		$whereArray = array();
		$timeArray = array();
		$field = $type;
		$start_date = date("Y-m-d H:i:s",strtotime("-7 days"));
		$end_date = date("Y-m-d H:i:s");
		$brand_id = $br_id;
		$agency_id = $this->session->userdata('loginUserData')['agency_id'];
		$timeArray["start_date"] = $start_date;
		$timeArray["end_date"] = $end_date;
		$whereArray["brand_id"] = $brand_id;
		$whereArray["agency_id"] = $agency_id;
		
		$paid_ids = $this->getChannelIdsByType(1,$brand_id);
		$unpaid_ids = $this->getChannelIdsByType(0,$brand_id);
		// echo "<pre>";print_r($unpaid_ids);die;	
		$paid_res = $this->Adminleads->getGraphData($field,$whereArray,$timeArray,$paid_ids,"paid");
		$unpaid_res = $this->Adminleads->getGraphData($field,$whereArray,$timeArray,$unpaid_ids,"unpaid");
		// $countPaidData = count($paid_res);
		// $countUnpaidData = count($unpaid_res);
		$new_res = array_map(array($this, 'modifyArray'), $unpaid_res, $paid_res);
		// $new_res = array_merge_recursive($paid_res, $unpaid_res); 
		
		// echo "<pre>";print_r($new_res);die;
		$dates = $this->displayDates($start_date, $end_date);
		
		$newGraphDataArray = array();
		foreach($dates as $k=>$v)
		{
			$i = 0;
			if($new_res){
				foreach($new_res as $key=>$val)
				{
					
					$temp = array();

				  // The following line will be used to slice the chart
					if($val['date'] == $v)
					{
						$i++;
						$temp = array('datetime' => $v,'paid' => $val['total_paid_'.$field],'unpaid' => $val['total_unpaid_'.$field]); 

						// Values of the each slice

						$newGraphDataArray[] = $temp;
					}
						
				}
			}
			if($i == 0)
			{
				$temp = array('datetime' => $v,'paid' => 0,'unpaid' => 0); 

					// Values of the each slice

					$newGraphDataArray[] = $temp;
			}
		}
		// echo "<pre>";print_r($newGraphDataArray);die;
		$res = $this->getGraphDateRangeTableData($newGraphDataArray);
		// echo "<pre>";print_r($res);die;
		return $res;
	}
	
	
	
	function lastSevenDaysGraphDataByRevenueVsCost($br_id)
	{
		$whereArray = array();
		$timeArray = array();
		$field = "revenue";
		$start_date = date("Y-m-d 00:00:00",strtotime("-7 days"));
		$end_date = date("Y-m-d 23:59:59");
		$brand_id = $br_id;
		$agency_id = $this->session->userdata('loginUserData')['agency_id'];
		$timeArray["start_date"] = $start_date;
		$timeArray["end_date"] = $end_date;
		$whereArray["brand_id"] = $brand_id;
		$whereArray["agency_id"] = $agency_id;
		
		$paid_ids = $this->getChannelIdsByType(1,$brand_id);
		// $unpaid_ids = $this->getChannelIdsByType(0,$brand_id);
		// echo "<pre>";print_r($paid_ids);die;	
		$channel_group_revenue_cost_array = array();
		foreach($paid_ids as $k=>$v)
		{
			$paid_res = $this->Adminleads->getGraphDataByRevenue($field,$whereArray,$timeArray,$v,"paid");
			$paid_res_cost = $this->Adminleads->getGraphDataByCost("cost",$whereArray,$timeArray,$v,"paid");
			if(!isset($paid_res['total_paid_'.$field]))
			{
				$paid_res['total_paid_'.$field] = 0;
			}
			if(!isset($paid_res_cost['total_paid_cost']))
			{
				$paid_res['total_paid_cost'] = 0;
			}else{
				$paid_res['total_paid_cost'] = $paid_res_cost['total_paid_cost'];
			}
			array_push($channel_group_revenue_cost_array,$paid_res);
		}
		
		// echo "<pre>";print_r($this->db->last_query());die;	
		// echo "<pre>";print_r($channel_group_revenue_cost_array);die;	
		
		// echo "<pre>";print_r($newGraphDataArray);die;
		$res = $this->getGraphRevenueCostTableData($channel_group_revenue_cost_array);
		// echo "<pre>";print_r($res);die;
		return $res;
	}
	
	
	// For Revenue & Cost Graph
	
	function getGraphRevenueCostTableData($result)
	{
		$rows = array();
		/* Extract the information from $result */
		 $rows[] = array('Channels','Revenue','Cost'); 
		foreach($result as $r) {

		 //  $temp = array();

		  // The following line will be used to slice the chart

		 
		  $rows[] = array((string) $r['channel_name'],(int) $r['total_paid_revenue'],(int) $r['total_paid_cost']); 

		}
		// convert data into JSON format
		$jsonTable = json_encode($rows);
		return $jsonTable;
	}
	
	// For ROAS Graph
	
	function getGraphRoasTableData($result)
	{
		$rows = array();
		/* Extract the information from $result */
		 $rows[] = array('Channels','ROAS'); 
		foreach($result as $r) {

		 //  $temp = array();

		  // The following line will be used to slice the chart

		 
		  $rows[] = array((string) $r['channel_name'],(float) $r['roas']); 

		}
		// convert data into JSON format
		$jsonTable = json_encode($rows);
		return $jsonTable;
	}
	
	
	
	function getMetricGraphs()
	{
		$whereArray = array();
		$timeArray = array();
		
		/* Filter Columns */
		
		$field = $this->input->post("metric"); /* Filter Column Compulsory */
		$brand_id = $this->input->post("brand_id"); /* Filter Column Compulsory */
		
		$channel_id = $this->input->post("channel_id"); /* Filter Column */
		$frequency = $this->input->post("frequency"); /* Filter Column */
		$filter_date_range = $this->input->post("filter_date_range"); /* Filter Column */
		
		$start_date = date("Y-m-d H:i:s",strtotime("-7 days")); /* Filter Column */
		$end_date = date("Y-m-d H:i:s"); /* Filter Column */
		
		
		$agency_id = $this->session->userdata('loginUserData')['agency_id'];
		
		$whereArray["brand_id"] = $brand_id;
		$whereArray["agency_id"] = $agency_id;
		
		// echo "<pre>";print_r($channel_id);die;
		
		
		$paid_ids = $this->getChannelIdsByType(1,$brand_id);
		$unpaid_ids = $this->getChannelIdsByType(0,$brand_id);
		
		// echo "<pre>";print_r($paid_ids);die;
		if(!empty($channel_id))
		{
			$paid_ids_array = array();
			$unpaid_ids_array = array();
			foreach($channel_id as $kch=>$vch)
			{
				if(in_array($vch,$paid_ids))
				{
					$paid_ids_array[] = $vch;
				}
				elseif(in_array($vch,$unpaid_ids))
				{
					$unpaid_ids_array[] = $vch;
				}
			}
			if(empty($paid_ids_array))
			{
				$paid_ids_array = array("0");
			}
			if(empty($unpaid_ids_array))
			{
				$unpaid_ids_array = array("0");
			}
			$paid_ids = $paid_ids_array;
			$unpaid_ids = $unpaid_ids_array;
		}
		
		// echo "<pre>";print_r($unpaid_ids);die;
		
		if(!empty($filter_date_range))
		{
			$date = explode(" - ", $filter_date_range);
			
			$start_date = date('Y-m-d H:i:s', strtotime(str_replace('/', '-', $date[0])));
			$end_date = date('Y-m-d 23:59:00', strtotime(str_replace('/', '-', $date[1])));
			
			$timeArray["start_date"] = $start_date;
			$timeArray["end_date"] = $end_date;
			// echo "<pre>";print_r($end_date);die;
		}
		
		if(!empty($frequency))
		{
			// $this->monthlyGraphData();
			if($frequency == "today")
			{
				$start_date = date("Y-m-d 00:00:00");
				$end_date = date("Y-m-d 23:59:00");
				
				if(!empty($filter_date_range))
				{
					$date = explode(" - ", $filter_date_range);
					
					$start_date = date('Y-m-d H:i:s', strtotime(str_replace('/', '-', $date[0])));
					$end_date = date('Y-m-d 23:59:00', strtotime(str_replace('/', '-', $date[1])));
					
					$timeArray["start_date"] = $start_date;
					$timeArray["end_date"] = $end_date;
					// echo "<pre>";print_r($end_date);die;
				}
				
				$timeArray["start_date"] = $start_date;
				$timeArray["end_date"] = $end_date;
				$paid_res = $this->Adminleads->getGraphData($field,$whereArray,$timeArray,$paid_ids,"paid");
				$unpaid_res = $this->Adminleads->getGraphData($field,$whereArray,$timeArray,$unpaid_ids,"unpaid");
				// echo "<pre>";print_r($unpaid_res);die;
				$new_res = array_map(array($this, 'modifyArray'), $unpaid_res, $paid_res);
				// echo "<pre>";print_r($new_res);die;
				$resultGraphData = $this->dateRangeFilter($start_date, $end_date,$new_res,$field);
		
			}elseif($frequency == "weekly")
			{
				/* $ddate = date("Y-m-d");
				$date = new DateTime($ddate);
				$week = $date->format("W");
				$week_date_array = $this->getStartAndEndDate($week,date("Y"));
				$start_date = date('Y-m-d 00:00:00', strtotime(str_replace('-', '/', $week_date_array["week_start"])));
				$end_date = date('Y-m-d 23:59:00', strtotime(str_replace('-', '/', $week_date_array["week_end"]))); */
				
				$start_date = date('Y-m-01',strtotime("-1 month"));
				$end_date = date('Y-m-d 23:59:00');
				
				if(!empty($filter_date_range))
				{
					$date = explode(" - ", $filter_date_range);
					
					$start_date = date('Y-m-d H:i:s', strtotime(str_replace('/', '-', $date[0])));
					$end_date = date('Y-m-d 23:59:00', strtotime(str_replace('/', '-', $date[1])));
					
					$timeArray["start_date"] = $start_date;
					$timeArray["end_date"] = $end_date;
					// echo "<pre>";print_r($end_date);die;
				}
				
				$timeArray["start_date"] = $start_date;
				$timeArray["end_date"] = $end_date;
				$paid_res = $this->Adminleads->getGraphDataByWeek($field,$whereArray,$timeArray,$paid_ids,"paid");
				// echo "<pre>";print_r($this->db->last_query());die;
				$unpaid_res = $this->Adminleads->getGraphDataByWeek($field,$whereArray,$timeArray,$unpaid_ids,"unpaid");
				
				$new_res = array_map(array($this, 'modifyArray'), $unpaid_res, $paid_res);
				// echo "<pre>";print_r($new_res);die;
				$resultGraphData = $this->dateRangeWeekFilter($start_date, $end_date,$new_res,$field);
		
			}elseif($frequency == "monthly")
			{
				$timeArray["start_date"] = 0;
				$timeArray["end_date"] = 0;
				$paid_res = $this->Adminleads->getGraphDataByMonth($field,$whereArray,$timeArray,$paid_ids,"paid");
				$unpaid_res = $this->Adminleads->getGraphDataByMonth($field,$whereArray,$timeArray,$unpaid_ids,"unpaid");
				/* $start_date = date('Y-m-01 00:00:00');
				$end_date = date('Y-m-t 23:59:00'); */
				if(!empty($this->input->post("filter_month")))
				{
					$month = $this->input->post("filter_month");
					// 	echo "<pre>";print_r($this->input->post("filter_month"));die;
				}else{
					$month = null;
				}
				$new_res = array_map(array($this, 'modifyArray'), $unpaid_res, $paid_res);
				// echo "<pre>";print_r($paid_res);die;
				$resultGraphData = $this->MonthlyFilter($month,$new_res,$field);
			}
			
		}else{
			
			$timeArray["start_date"] = $start_date;
			$timeArray["end_date"] = $end_date;
			// echo "<pre>";print_r($paid_ids);die;
			$paid_res = $this->Adminleads->getGraphData($field,$whereArray,$timeArray,$paid_ids,"paid");
			$unpaid_res = $this->Adminleads->getGraphData($field,$whereArray,$timeArray,$unpaid_ids,"unpaid");
			
			$new_res = array_map(array($this, 'modifyArray'), $unpaid_res, $paid_res);
			// echo "<pre>";print_r($paid_res);die;
			// echo "<pre>";print_r($this->db->last_query());die;
			$resultGraphData = $this->dateRangeFilter($start_date, $end_date,$new_res,$field);
		}
		
		
		// echo "<pre>";print_r($resultGraphData);die;
		echo $resultGraphData;
		// print_r($res); 
		//echo  date('D M d Y H:i:s O'); same as javascript pattern
		
		// echo "<pre>";print_r($dates);die;
		// echo "<pre>";print_r($new_res);die;
	}
	
	
	
	function getRevenueCostRoasMetricGraphs()
	{
		$whereArray = array();
		$timeArray = array();
		
		/* Filter Columns */
		/* echo "<pre>";
		print_r($_POST);die; */
		$metric = $this->input->post("metric");
		$field = "revenue"; /* Filter Column Compulsory */
		$brand_id = $this->input->post("brand_id"); /* Filter Column Compulsory */
		
		// $channel_id = $this->input->post("channel_id"); /* Filter Column */
		$filter_date_range = $this->input->post("filter_date_range"); /* Filter Column */
		
		$start_date = date("Y-m-d H:i:s",strtotime("-7 days")); /* Filter Column */
		$end_date = date("Y-m-d H:i:s"); /* Filter Column */
		
		$timeArray["start_date"] = $start_date;
		$timeArray["end_date"] = $end_date;
		
		$agency_id = $this->session->userdata('loginUserData')['agency_id'];
		
		$whereArray["brand_id"] = $brand_id;
		$whereArray["agency_id"] = $agency_id;
		
		// echo "<pre>";print_r($channel_id);die;
		
		
		$paid_ids = $this->getChannelIdsByType(1,$brand_id);
		
		if(!empty($filter_date_range))
		{
			$date = explode(" - ", $filter_date_range);
			
			$start_date = date('Y-m-d H:i:s', strtotime(str_replace('/', '-', $date[0])));
			$end_date = date('Y-m-d 23:59:00', strtotime(str_replace('/', '-', $date[1])));
			
			$timeArray["start_date"] = $start_date;
			$timeArray["end_date"] = $end_date;
			// echo "<pre>";print_r($end_date);die;
		}
		
		
		$channel_group_revenue_cost_array = array();
		foreach($paid_ids as $k=>$v)
		{
			$paid_res = $this->Adminleads->getGraphDataByRevenue($field,$whereArray,$timeArray,$v,"paid");
			$paid_res_cost = $this->Adminleads->getGraphDataByCost("cost",$whereArray,$timeArray,$v,"paid");
			if(!isset($paid_res['total_paid_'.$field]))
			{
				$paid_res['total_paid_'.$field] = 0;
			}
			if(!isset($paid_res_cost['total_paid_cost']))
			{
				$paid_res['total_paid_cost'] = 0;
			}else{
				$paid_res['total_paid_cost'] = $paid_res_cost['total_paid_cost'];
			}
			
			if($metric == "roas")
			{
				if($paid_res['total_paid_cost'] == 0)
				{
					$paid_res['roas'] = 0;
				}else{
					$paid_res['roas'] = number_format((float)$paid_res['total_paid_'.$field]/$paid_res_cost['total_paid_cost'], 2, '.', '');
				}
				
			}
			array_push($channel_group_revenue_cost_array,$paid_res);
		}
		
			// echo "<pre>";print_r($this->db->last_query());die;	
			// echo "<pre>";print_r($channel_group_revenue_cost_array);die;	
			if($metric == "roas")
			{
				$res = $this->getGraphRoasTableData($channel_group_revenue_cost_array);
			}else{
				$res = $this->getGraphRevenueCostTableData($channel_group_revenue_cost_array);
			}
			
		 // echo "<pre>";print_r($res);die;
		 echo $res;
		
	}
	
	function dateRangeFilter($start_date, $end_date,$new_res,$field)
	{
		$dates = $this->displayDates($start_date, $end_date);
		
		$newGraphDataArray = array();
		foreach($dates as $k=>$v)
		{
			$i = 0;
			foreach($new_res as $key=>$val)
			{
				
				$temp = array();

			  // The following line will be used to slice the chart
				if($val['date'] == $v)
				{
					$i++;
					if(!isset($val['total_paid_'.$field]))
					{
						$paid_data = 0;
					}else{
						$paid_data = $val['total_paid_'.$field];
					}
					if(!isset($val['total_unpaid_'.$field]))
					{
						$unpaid_data = 0;
					}else{
						$unpaid_data = $val['total_unpaid_'.$field];
					}
					$temp = array('datetime' => $v,'paid' => $paid_data,'unpaid' => $unpaid_data); 

					// Values of the each slice

					$newGraphDataArray[] = $temp;
				}
					
			}
			if($i == 0)
			{
				$temp = array('datetime' => $v,'paid' => 0,'unpaid' => 0); 

					// Values of the each slice

					$newGraphDataArray[] = $temp;
			}
		}
		// echo "<pre>";print_r($newGraphDataArray);die;
		$res = $this->getGraphDateRangeTableData($newGraphDataArray);
		return $res;
	}
	
	
	function dateRangeWeekFilter($start_date, $end_date,$new_res,$field)
	{
		$dates = $this->displayWeekDates($start_date, $end_date);
		$newGraphDataArray = array();
		// $temp = array();
		foreach($dates as $dkey=>$dval)
		{
			$start_date_str = date('d-m-Y',strtotime($dval["start_date"]));
			$end_date_str = date('d-m-Y',strtotime($dval["end_date"]));
			$paid_data = 0;
			$unpaid_data = 0;
			foreach($new_res as $nkey=>$nval)
			{
				
				if($nval['date'] >= $dval["start_date"] && $nval['date'] <= $dval["end_date"])
				{
					if(!isset($nval['total_paid_'.$field]))
					{
						$paid_data = 0;
					}else{
						$paid_data += $nval['total_paid_'.$field];
					}
					if(!isset($nval['total_unpaid_'.$field]))
					{
						$unpaid_data = 0;
					}else{
						$unpaid_data += $nval['total_unpaid_'.$field];
					}
				}
				
			}
			$i = $dkey+1;
			$temp = array('datetime' => "Week-$i ($start_date_str - $end_date_str)",'paid' => $paid_data,'unpaid' => $unpaid_data); 
			$newGraphDataArray[] = $temp;
		}
		/* echo "<pre>";
		print_r($newGraphDataArray);die; */
		/* $newGraphDataArray = array();
		$i = 0;
		foreach($dates as $k=>$v)
		{
			$i++;
			$j = 0;
			foreach($new_res as $key=>$val)
			{
				
				$temp = array();

				if($val['date'] >= $v["start_date"] && $val['date'] <= $v["end_date"])
				{
					$j++;
					if(!isset($val['total_paid_'.$field]))
					{
						$paid_data = 0;
					}else{
						$paid_data = $val['total_paid_'.$field];
					}
					if(!isset($val['total_unpaid_'.$field]))
					{
						$unpaid_data = 0;
					}else{
						$unpaid_data = $val['total_unpaid_'.$field];
					}
					$start_date_str = date('d-m-Y',strtotime($v["start_date"]));
					$end_date_str = date('d-m-Y',strtotime($v["end_date"]));
					// $date_time = 
					$temp = array('datetime' => "Week-$i ($start_date_str - $end_date_str)",'paid' => $paid_data,'unpaid' => $unpaid_data); 

					// Values of the each slice

					$newGraphDataArray[] = $temp;
				}
					
			}
			if($j == 0)
			{
				$start_date_str = date('d-m-Y',strtotime($v["start_date"]));
				$end_date_str = date('d-m-Y',strtotime($v["end_date"]));
				$temp = array('datetime' => "Week-$i ($start_date_str - $end_date_str)",'paid' => 0,'unpaid' => 0); 

					// Values of the each slice

					$newGraphDataArray[] = $temp;
			}
		}	
		echo "<pre>";print_r($newGraphDataArray);die; */
		$res = $this->getGraphWeekDateRangeTableData($newGraphDataArray);
		return $res;
	}
	
	
	function MonthlyFilter($month,$new_res,$field)
	{
		if($month)
		{
			$totalMonths = $month;
		}else{
			$totalMonths = $this->monthlyGraphData();
		}
		
		// echo "<pre>";print_r($totalMonths);die;
		// echo "<pre>";print_r($new_res);die;
		$newGraphDataArray = array();
		foreach($totalMonths as $k=>$v)
		{
			$i = 0;
			foreach($new_res as $key=>$val)
			{
				
				$temp = array();
				// echo $val['month'];die;
			  // The following line will be used to slice the chart
				if(date("M-Y",strtotime($val['month'])) == $v)
				{
					$i++;
					if(!isset($val['total_paid_'.$field]))
					{
						$paid_data = 0;
					}else{
						$paid_data = $val['total_paid_'.$field];
					}
					if(!isset($val['total_unpaid_'.$field]))
					{
						$unpaid_data = 0;
					}else{
						$unpaid_data = $val['total_unpaid_'.$field];
					}
					$temp = array('datetime' => $v,'paid' => $paid_data,'unpaid' => $unpaid_data); 
					// Values of the each slice
					$newGraphDataArray[] = $temp;
				}
					
			}
			if($i == 0)
			{
				$temp = array('datetime' => $v,'paid' => 0,'unpaid' => 0); 

					// Values of the each slice

					$newGraphDataArray[] = $temp;
			}
		}
		// echo "<pre>";print_r($newGraphDataArray);die;
		$res = $this->getGraphMonthTableData($newGraphDataArray);
		return $res;
	}
	
	
	function monthlyGraphData()
	{
		for ($i = 12; $i >= 1; $i--) {
			$months[] = date("M-Y", strtotime( date( 'Y-m-01' )." -$i months"));
		}
		$months[] = date("M-Y");
		return $months;
	}
	
	function getStartAndEndDate($week, $year) 
	{
		  $dto = new DateTime();
		  $dto->setISODate($year, $week);
		  $ret['week_start'] = $dto->format('Y-m-d');
		  $dto->modify('+6 days');
		  $ret['week_end'] = $dto->format('Y-m-d');
		  return $ret;
	}
	
	
	function getGraphDateRangeTableData($result)
	{
		  $rows = array();
		  $table = array();
		  $table['cols'] = array(

			// Labels for your chart, these represent the column titles.

			array('label' => 'Date', 'type' => 'date'),
			array('label' => 'Paid', 'type' => 'number'),
			array('label' => 'Un-Paid', 'type' => 'number'),
		);

		
		/* Extract the information from $result */
		foreach($result as $r) {

		  $temp = array();

		  // The following line will be used to slice the chart

		  $temp[] = array('v' => 'Date('.date('Y',strtotime($r['datetime'])).',' . 
										 (date('n',strtotime($r['datetime'])) - 1).','.
										 date('d',strtotime($r['datetime'])).','.
										 date('H',strtotime($r['datetime'])).','.
										 date('i',strtotime($r['datetime'])).','.
										 date('s',strtotime($r['datetime'])).')'); 

		  // Values of the each slice

		  $temp[] = array('v' => (int) $r['paid']); 
		  $temp[] = array('v' => (int) $r['unpaid']); 
		  $rows[] = array('c' => $temp);
		}

		$table['rows'] = $rows;
		// convert data into JSON format
		$jsonTable = json_encode($table);
		return $jsonTable;
	}
	
	
	function getGraphWeekDateRangeTableData($result)
	{
		  $rows = array();
		  $table = array();
		  $table['cols'] = array(

			// Labels for your chart, these represent the column titles.

			array('label' => 'Week', 'type' => 'string'),
			array('label' => 'Paid', 'type' => 'number'),
			array('label' => 'Un-Paid', 'type' => 'number'),
		);

		
		/* Extract the information from $result */
		foreach($result as $r) {

		  $temp = array();

		  // The following line will be used to slice the chart

		  $temp[] = array('v' => $r['datetime']); 

		  // Values of the each slice

		  $temp[] = array('v' => (int) $r['paid']); 
		  $temp[] = array('v' => (int) $r['unpaid']); 
		  $rows[] = array('c' => $temp);
		}

		$table['rows'] = $rows;
		// convert data into JSON format
		$jsonTable = json_encode($table);
		return $jsonTable;
	}
	
	function getGraphMonthTableData($result)
	{
		  $rows = array();
		  $table = array();
		  $table['cols'] = array(

			// Labels for your chart, these represent the column titles.

			array('label' => 'Month', 'type' => 'string'),
			array('label' => 'Paid', 'type' => 'number'),
			array('label' => 'Un-Paid', 'type' => 'number'),
		);

		
		/* Extract the information from $result */
		foreach($result as $r) {

		  $temp = array();

		  // The following line will be used to slice the chart

		 /*  $temp[] = array('v' => 'Date('.date('Y',strtotime($r['datetime'])).',' . 
										 (date('n',strtotime($r['datetime'])) - 1).','.
										 date('d',strtotime($r['datetime'])).','.
										 date('H',strtotime($r['datetime'])).','.
										 date('i',strtotime($r['datetime'])).','.
										 date('s',strtotime($r['datetime'])).')');  */
			$temp[] = array('v' => str_replace("-","/",$r['datetime']));

		  // Values of the each slice

		  $temp[] = array('v' => (int) $r['paid']); 
		  $temp[] = array('v' => (int) $r['unpaid']); 
		  $rows[] = array('c' => $temp);
		}

		$table['rows'] = $rows;
		// convert data into JSON format
		$jsonTable = json_encode($table);
		/* echo "<pre>";
		print_r($table);die; */
		return $jsonTable;
	}
	
	function displayDates($date1, $date2, $format = 'Y-m-d' ) {
      $dates = array();
      $current = strtotime($date1);
      $date2 = strtotime($date2);
      $stepVal = '+1 day';
      while( $current <= $date2 ) {
         $dates[] = date($format, $current);
         $current = strtotime($stepVal, $current);
      }
      return $dates;
	}
	
	function displayWeekDates($date1, $date2, $format = 'Y-m-d' ) {
      $dates = array();
      $current = strtotime($date1);
      $date2 = strtotime($date2);
      $stepVal = '+1 day';
      while( $current <= $date2 ) {
         $dates[] = date($format, $current);
         $current = strtotime($stepVal, $current);
      }
	  
	 
	  $days = 7;
	  $i = 0;
	  $weeks_array = array();
	  $next_date = "";
	  foreach($dates as $k=>$v)
	  {
		if($i == 0)
		{
		 $next_date = $v;
		}
		  $i++;
		  $lastRangeDate = end($dates);
		  
			if($next_date <= $v)
			{
			  $date_day = date("N",strtotime($v));
			  $remainingWeekDays = 7-$date_day;
			  $completeWeekDaysDate = date("Y-m-d",strtotime($v." +".$remainingWeekDays." Days"));
			  
				if($lastRangeDate >= $completeWeekDaysDate)
				{
					$weekRange = array("start_date"=>$v,"end_date"=>$completeWeekDaysDate);
					array_push($weeks_array,$weekRange);
					$next_date = date("Y-m-d",strtotime($completeWeekDaysDate." +1 Days"));
				}else{
					/* if($lastRangeDate > $next_date)
					{ */
						$weekRange = array("start_date"=>$v,"end_date"=>$lastRangeDate);
						array_push($weeks_array,$weekRange);
						break;
					//}
					
					// $next_date = $lastRangeDate;
				}
			}
		  
		  
	  }
	 //  echo "<pre>";print_r($weeks_array);die;
      return $weeks_array;
	}
	
	function modifyArray($a, $b)
	{
		if (!empty($a) && !empty($b)) {
			return array_merge($a, $b);
		} else if (!empty($a) && empty($b)) {
			return $a;
		}  else if (empty($a) && !empty($b)) {
			return $b;
		}
	}

	
	
	function getChannelIdsByType($type,$brand_id)
	{
		$type = $type;
		$brandTypeRes = $this->reports_model->checkBrandType($brand_id,$type);	
		if($brandTypeRes)
		{
			$allChannels = $this->reports_model->getAllChannelGroupsType($brand_id,$type);
			$brandChannelArray = array();
			foreach($brandTypeRes as $k=>$v)
			{
				array_push($brandChannelArray,$v->id);
			}
			foreach($allChannels as $ket=>$vat)
			{
					array_push($brandChannelArray,$vat->id);
			}
			$paidChannelTypeIds = $brandChannelArray;
			
			
		}else{
			$res = $this->reports_model->getChannelGroup(null,$type);
			$brandChannelArray = array();
			foreach($res as $k=>$v)
			{
				array_push($brandChannelArray,$v->id);
			}
			$paidChannelTypeIds = $brandChannelArray;
		}
		
		return $paidChannelTypeIds;
	}
	
	function contact_lead_reset()
	{
		if(!$this->session->userdata('isAdminLoggedIn'))
		{
			redirect(base_url());
		}
		$this->session->unset_userdata('contactRecords');
		$this->session->unset_userdata('date_range');
		redirect('home/contact-leads');
	}
	
	
	public function google_recaptcha_validation()
	{
		if(empty($this->input->post('g-recaptcha-response')))
		{
			$this->session->set_flashdata( 'error', 'Captcha Error' );
			return 0;
		}
		 // post request to server
		$url = 'https://www.google.com/recaptcha/api/siteverify';
		$data = array('secret' => SECRET_KEY, 'response' => $this->input->post('g-recaptcha-response'));
		
		$options = array(
			'http' => array(
			  'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
			  'method'  => 'POST',
			  'content' => http_build_query($data)
			)
		);
		$context  = stream_context_create($options);
		$result = file_get_contents($url, false, $context);
		$responseJson = json_decode($result,true);
		/* echo "<pre>";
		print_r($responseJson);die; */
		if(empty($responseJson['success']) || $responseJson['success'] != 1)
		{
			$this->session->set_flashdata( 'error', 'Captcha Error' );
			return 0;
			  
		}else
		{
			return 1;
		}
	}
	
	
	public function contact_lead_excel()
	{
		if(!$this->session->userdata('isAdminLoggedIn'))
		{
			redirect(base_url());
		}
		require_once APPPATH . '/third_party/Phpexcel/Bootstrap.php';
		
		$contact_list = $this->session->userdata('contactRecords');
	
			// Create new Spreadsheet object
			$spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
			
			// Set document properties
			$spreadsheet->getProperties()->setCreator('Maxlife');
			if($this->session->userdata('date_range'))
			{
				$fileName = 'MLI-INNOVATIONLABS_DATA_'.$this->session->userdata('date_range').".xls";
			}
			else{
				$fileName = 'MLI-INNOVATIONLABS_DATA_'.date('d-m-Y').".xls";
			}
			
			// add style to the header
			$styleArray = array(
				'font' => array(
					'bold' => true,
				),
				'alignment' => array(
					'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
					'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
				),
				'borders' => array(
					'top' => array(
						'style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
					),
				),
				'fill' => array(
					'type' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_GRADIENT_LINEAR,
					'rotation' => 90,
					'startcolor' => array(
						'argb' => 'FFA0A0A0',
					),
					'endcolor' => array(
						'argb' => 'FFFFFFFF',
					),
				),
			);
			$spreadsheet->getActiveSheet()->getStyle('A1:K1')->applyFromArray($styleArray);
			

			// auto fit column to content

			foreach (range('A', 'K') as $columnID) {
				$spreadsheet->getActiveSheet()->getColumnDimension($columnID)
						->setAutoSize(true);
			}
			
			// set the names of header cells
			$spreadsheet->setActiveSheetIndex(0)
					->setCellValue("A1", 'Name OF Organization')
					->setCellValue("B1", "SPOC's Name")
					->setCellValue("C1", "SPOC's Email")
					->setCellValue("D1", "SPOC's Mobile Number")
					->setCellValue("E1", 'State')
					->setCellValue("F1", 'City')
					->setCellValue("G1", 'Category')
					->setCellValue("H1", 'Website Link')
					->setCellValue("I1", 'Description')
					->setCellValue("J1", 'Upload PDF Path')
					->setCellValue("K1", 'Created Date');
					
			// Add some data
			$x = 2;
			foreach ($contact_list as $key=>$row) {
				if($row->category === 0)
				{
					$category = '';
				}
				else{
					$category = $row->category;
				}
				$spreadsheet->setActiveSheetIndex(0)
						->setCellValue("A$x", $row->name)
						->setCellValue("B$x", $this->decrypted_data($row->id,$row->spoc_name))
						->setCellValue("C$x", $this->decrypted_data($row->id,$row->email))
						->setCellValue("D$x", $this->decrypted_data($row->id,$row->mobile_no))
						->setCellValue("E$x", $row->state_name)
						->setCellValue("F$x", $row->city_name)
						->setCellValue("G$x", $category)
						->setCellValue("H$x", $row->website_link)
						->setCellValue("I$x", $row->description)
						->setCellValue("J$x", $row->upload_name)
						->setCellValue("K$x", date('d-m-Y H:i:s',strtotime($row->created_at)));
						
				$x++;
		}
		
		// Rename worksheet
		$spreadsheet->getActiveSheet()->setTitle('Maxlife');
		
		$spreadsheet->setActiveSheetIndex(0);
		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		header('Content-Disposition: attachment;filename= "'.$fileName.'"');
		header('Cache-Control: max-age=0');
		// If you're serving to IE 9, then the following may be needed
		header('Cache-Control: max-age=1');

		// If you're serving to IE over SSL, then the following may be needed
		header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
		header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
		header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
		header('Pragma: public'); // HTTP/1.0
		$writer = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, 'Excel2007');
		//ob_end_clean();
		$writer->save('php://output');
		exit;
	}
	
	function decrypted_data($id,$decryptedformfield)
	{
		$data = $decryptedformfield;
		
		if ($id <= 112)
		{
			return $decryptedformfield;
		}
		if(!empty($data))
		{
			$password = '3sc3RLrpd17';

			// CBC has an IV and thus needs randomness every time a message is encrypted
			$method = 'aes-256-cbc';

			// Must be exact 32 chars (256 bit)
			// You must store this secret random key in a safe place of your system.
			$key = substr(hash('sha256', $password, true), 0, 32);

			// Most secure key
			//$key = openssl_random_pseudo_bytes(openssl_cipher_iv_length($method));

			// IV must be exact 16 chars (128 bit)
			$iv = chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0);
			
			
			$decrypted = openssl_decrypt(base64_decode($data), $method, $key, OPENSSL_RAW_DATA, $iv);
			
			return $decrypted;
		}
		else{
			return '';
		}
		
	}
	function terms(){
		$data['file']  = 'brand/terms';
		
		$this->load->view('brand/template',$data);
	}
	function privacy(){
		$data['file']  =  'brand/privacy';
		$this->load->view('brand/template',$data);
	}
	
}