<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Brands extends CI_Controller {
    
    function __construct() {
        parent::__construct();
       // $this->load->library('form_validation');
	   //$this->load->library('session');
       $this->load->model('brand/Brandleads');
    }
    
    
    
	function index()
	{
		
		$this->session->set_userdata('loginUserData');
		if($this->session->userdata('isBrandLoggedIn'))
		{
			redirect('brands/dashboard');
		}
		
        $data = array();
        if($this->session->userdata('success_msg')){
            $data['success_msg'] = $this->session->userdata('success_msg');
            $this->session->unset_userdata('success_msg');
        }
        if($this->session->userdata('error_msg')){
            $data['error_msg'] = $this->session->userdata('error_msg');
            $this->session->unset_userdata('error_msg');
        }
        if($this->input->post('loginSubmit')){
			
            $this->form_validation->set_rules('email', 'Email/Mobile', 'required');
            $this->form_validation->set_rules('password', 'password', 'required');
            if ($this->form_validation->run() == true) {
                $con['returnType'] = 'single';
				$email = $this->input->post('email');
				$password = $this->input->post('password');
				
				$salt = strrev(substr($email, 0, strpos($email, '@')));
				
				$con['conditions'] = array(
						'email'=>$email,
						'password' => md5($this->input->post('password')),
						'brand_user.status' => '1',
						'brands.status' => '1'
					);
				
				
                $checkLogin = $this->Brandleads->getRows($con);
				// echo "<pre>";print_r($this->db->last_query());die;
				// echo "<pre>";print_r($checkLogin);die;
                if($checkLogin){
					
					if($this->google_recaptcha_validation())
					{
						$this->session->set_userdata('isBrandLoggedIn',TRUE);
						$this->session->set_userdata('userId',$checkLogin['id']);
						$this->session->set_userdata('loginUserData',$checkLogin);
					}
					else
					{
						$data['error_msg'] = 'Captcha Error.Try Again';
					}

                    redirect(base_url().'brands/dashboard');
                }else{
                    $data['error_msg'] = 'Wrong email/username or password, please try again.';
                }
				
            }
        }
        //load the view
        $this->load->view('brand/login', $data);
    }
	
   
    
    /*
     * User logout
     */
    function logout(){
        $this->session->unset_userdata('isBrandLoggedIn');
        $this->session->unset_userdata('userId');
		$this->session->unset_userdata('date_range');
        $this->session->sess_destroy();
        redirect(base_url()."brands");
    }
    
    
	function dashboard()
	{ 
	
		if($this->session->userdata('isBrandLoggedIn'))
		{
			$data['file'] = 'brand/index';
			$this->load->view('brand/template',$data);  
		}
		else
		{
			redirect(base_url()."brands");
		}
		
	}
	
	
	
	public function google_recaptcha_validation()
	{
		if(empty($this->input->post('g-recaptcha-response')))
		{
			$this->session->set_flashdata( 'error', 'Captcha Error' );
			return 0;
		}
		 // post request to server
		$url = 'https://www.google.com/recaptcha/api/siteverify';
		$data = array('secret' => SECRET_KEY, 'response' => $this->input->post('g-recaptcha-response'));
		
		$options = array(
			'http' => array(
			  'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
			  'method'  => 'POST',
			  'content' => http_build_query($data)
			)
		);
		$context  = stream_context_create($options);
		$result = file_get_contents($url, false, $context);
		$responseJson = json_decode($result,true);
		/* echo "<pre>";
		print_r($responseJson);die; */
		if(empty($responseJson['success']) || $responseJson['success'] != 1)
		{
			$this->session->set_flashdata( 'error', 'Captcha Error' );
			return 0;
			  
		}else
		{
			return 1;
		}
	}
	
	
	
	
	
}