<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Analyticsapi extends CI_Controller {
    
    function __construct() {
        parent::__construct();
		$this->load->model('admin/brands_model');
		require_once(APPPATH . 'third_party/vendor/autoload.php');
    }
    
    
    
	function index()
	{
		if(isset($_GET["enterDate"]))
		{
			$date = date("Y-m-d",strtotime($_GET["enterDate"]));
		}else{
			$date = date("Y-m-d",strtotime("-1 day"));
		}
		
		$client = new Google_Client();
		$client->setAuthConfig(APPPATH . 'third_party/client_secrets.json');
		$client->addScope(Google_Service_Analytics::ANALYTICS_READONLY);

		$access_token = ACCESS_TOKEN;
		// If the user has already authorized this app then get an access token
		// else redirect to ask the user to authorize access to Google Analytics.
		
		// Set the access token on the client.
		$client->setAccessToken($access_token);

		// Create an authorized analytics service object.
		$analytics = new Google_Service_Analytics($client);
		// echo "<pre>";print_r($analytics);die;
		
		// Get the first view (profile) id for the authorized user.
		// $profile = $this->getFirstProfileId($analytics);
		
		$this->db->select("id,agency_id,view_id,google_status");
		if(isset($_GET["brand"]))
		{
			$this->db->where('id',$_GET["brand"]);
		}
		$this->db->where('status',1);
		$this->db->order_by("id","ASC");
		$profile_ids = $this->db->get("brands")->result();
		/* echo "<pre>";
		print_r($profile_ids);die; */
		if($profile_ids)
		{
			foreach($profile_ids as $k=>$v)
			{
				
				 
				// Get the results from the Core Reporting API and print the results.
				$results = $this->getResults($analytics,$v->view_id,$date);
				// echo "<pre>";print_r($results);die;
				if($results != "error")
				{
					$this->printResults($v->id,$v->agency_id,$results,$date);
				} 
				
				
				if($v->google_status)
				{
					// Get the results from the Core Reporting API and print the results.
					$results = $this->getResultsByCampaignBrand($analytics,$v->view_id,$date);
				     //echo "<pre>";print_r($results);die;
					if($results != "error")
					{
						//$this->printResultsByCampaign($v->id,$v->agency_id,$results,$date,"google_brand",14);
					}
					// Get the results from the Core Reporting API and print the results.
					$results = $this->getResultsByCampaignNotBrand($analytics,$v->view_id,$date);
				   //  echo "<pre>";print_r($results);die;
					if($results != "error")
					{
						//$this->printResultsByCampaign($v->id,$v->agency_id,$results,$date,"google / cpc",5);
					}
				}
				
				
			}
		}else{
			echo "Brand id not available";exit();
		}
		
	}
	
	function getFirstProfileId($analytics) 
	{
	  // Get the user's first view (profile) ID.

	  // Get the list of accounts for the authorized user.
	  $accounts = $analytics->management_accounts->listManagementAccounts();
		// echo "<pre>";print_r($accounts);die;
	  if (count($accounts->getItems()) > 0) {
		$items = $accounts->getItems();
		// echo "<pre>";print_r($items);die;
		$firstAccountId = $items[0]->getId();

		// Get the list of properties for the authorized user.
		$properties = $analytics->management_webproperties
			->listManagementWebproperties($firstAccountId);

		if (count($properties->getItems()) > 0) {
		  $items = $properties->getItems();
		  $firstPropertyId = $items[0]->getId();

		  // Get the list of views (profiles) for the authorized user.
		  $profiles = $analytics->management_profiles
			  ->listManagementProfiles($firstAccountId, $firstPropertyId);

		  if (count($profiles->getItems()) > 0) {
			$items = $profiles->getItems();
			// Return the first view (profile) ID.
			return $items[0]->getId();

		  } else {
			throw new Exception('No views (profiles) found for this user.');
		  }
		} else {
		  throw new Exception('No properties found for this user.');
		}
	  } else {
		throw new Exception('No accounts found for this user.');
	  }
	}
	
	/* By Filter through Source / Medium */
	function getResults($analytics, $profileId,$dataDate) 
	{
	
		//echo $dataDate; die;
		// Calls the Core Reporting API and queries for the number of sessions
		// Define secondary parameters
		try{
			$SecondaryParams = array('dimensions' => 'ga:sourceMedium','sort' => '-ga:transactionRevenue','max-results' => MAX_RESULTS);  
				  return $analytics->data_ga->get(
				  'ga:' . $profileId,
				  $dataDate,
				  $dataDate,'ga:users,ga:newUsers,ga:sessions,ga:bounceRate,ga:pageviewsPerSession,ga:avgSessionDuration,ga:transactionsPerSession,ga:transactions,ga:transactionRevenue,ga:revenuePerTransaction', 
			 $SecondaryParams);
		}catch(Exception $e){ //do we have an error?
			return "error"; //display error
		}
	}
	
	/* By Filter through Campaign With Brand */
	function getResultsByCampaignBrand($analytics, $profileId,$dataDate) 
	{
	
		// Calls the Core Reporting API and queries for the number of sessions
		// Define secondary parameters
		try{
			$SecondaryParams = array('dimensions' => 'ga:sourceMedium,ga:campaign','filters' => "ga:sourceMedium%3D%3Dgoogle / cpc;ga:campaign%3D@brand",'sort' => '-ga:transactionRevenue','max-results' => MAX_RESULTS); 
				  return $analytics->data_ga->get(
				  'ga:' . $profileId,
				  $dataDate,
				  $dataDate,'ga:users,ga:newUsers,ga:sessions,ga:bounceRate,ga:pageviewsPerSession,ga:avgSessionDuration,ga:transactionsPerSession,ga:transactions,ga:transactionRevenue,ga:revenuePerTransaction',
			 $SecondaryParams);
		}catch(Exception $e){ //do we have an error?
			return "error"; //display error
		}
	}
	
	/* By Filter through Campaign Without Brand*/
	function getResultsByCampaignNotBrand($analytics, $profileId,$dataDate) 
	{
	
		// Calls the Core Reporting API and queries for the number of sessions
		// Define secondary parameters
		try{
			$SecondaryParams = array('dimensions' => 'ga:sourceMedium,ga:campaign','filters' => "ga:sourceMedium%3D%3Dgoogle / cpc;ga:campaign!@brand",'sort' => '-ga:transactionRevenue','max-results' => MAX_RESULTS); 
				  return $analytics->data_ga->get(
				  'ga:' . $profileId,
				  $dataDate,
				  $dataDate,'ga:users,ga:newUsers,ga:sessions,ga:bounceRate,ga:pageviewsPerSession,ga:avgSessionDuration,ga:transactionsPerSession,ga:transactions,ga:transactionRevenue,ga:revenuePerTransaction',
			 $SecondaryParams);
		}catch(Exception $e){ //do we have an error?
			return "error"; //display error
		}
	}

	function printResults($brand_id,$agency_id,$results,$date) 
	{
		// echo "<pre>";print_r($results);die;
		// Parses the response from the Core Reporting API and prints
		// the profile name and total sessions.
		if (count($results->getRows()) > 0) {

		// Get the profile name.
		// $profileName = $results->getProfileInfo()->getProfileName();

		// Get the entry for the first entry in the first row.
		$rows = $results->getRows();
		// echo "<pre>";print_r($rows);die;
		
		$sourcesresult = array();
	 
		// Loop through all the results using the total results returned value
		for ($x = 0; $x < count($rows); $x++) {

		  // Add each source row into the array, with individual metics assigned within the same row
			if(!empty(round($rows[$x][4], 2)))
			{
				$bounce_rate = round($rows[$x][4], 2)."%";
			}else{
				$bounce_rate = round($rows[$x][4], 2);
			}
			
			
			if(!empty(round($rows[$x][7], 2)))
			{
				$ecom_con = round($rows[$x][7], 2)."%";
			}else{
				$ecom_con = round($rows[$x][7], 2);
			}
		  // Add each source row into the array, with individual metics assigned within the same row
		  $sourcesresult[] = array(
			'source_/_medium' => $rows[$x][0],
			'users' => $rows[$x][1],
			'new_users' => $rows[$x][2],
			'sessions' => $rows[$x][3],
			'bounce_rate' => $bounce_rate,
			'pages_/_session' => round($rows[$x][5], 2),
			'avg._session_duration' => round($rows[$x][6], 2),
			'ecommerce_conversion_rate' => $ecom_con,
			'transactions' => round($rows[$x][8], 2),
			'revenue' => number_format((float)$rows[$x][9], 2, '.', ''),
			'avg._order_value' => round($rows[$x][10], 2),
		  );
		}
		
		 $sourcesresult[] = array(
			'source_/_medium' => "",
			'users' => "",
			'new_users' => "",
			'sessions' => "",
			'bounce_rate' => "",
			'pages_/_session' => "",
			'avg._session_duration' => "",
			'ecommerce_conversion_rate' => "",
			'transactions' => "",
			'revenue' => "",
			'avg._order_value' => "",
		  );
		$this->insertResults($sourcesresult,$brand_id,$agency_id,$date);
		// echo "<pre>";print_r($sourcesresult);
		// $sessions = $rows[0][0];

		// Print the results.
	   //  print "<p>First view (profile) found: $profileName</p>";
		// print "<p>Total sessions: $sessions</p>";
	  } else {
		print "<p>No results found.</p>";
	  }
	}
	
	
	function printResultsByCampaign($brand_id,$agency_id,$results,$date,$channel_type,$channel_gr_id) 
	{
		// echo "<pre>";print_r($results->getTotalsForAllResults());die;
		// Parses the response from the Core Reporting API and prints
		// the profile name and total sessions.
		if (count($results->getTotalsForAllResults()) > 0) {

		// Get the profile name.
		// $profileName = $results->getProfileInfo()->getProfileName();

		// Get the entry for the first entry in the first row.
		$rows = $results->getTotalsForAllResults();
		// echo "<pre>";print_r($rows);die;
			
			$sourcesresult[] = array(
			'source_/_medium' => $channel_type,
			'users' => $rows["ga:users"],
			'new_users' => $rows["ga:newUsers"],
			'sessions' => $rows["ga:sessions"],
			'bounce_rate' => round($rows["ga:bounceRate"], 2)."%",
			'pages_/_session' => round($rows["ga:pageviewsPerSession"], 2),
			'avg._session_duration' => round($rows["ga:avgSessionDuration"], 2),
			'ecommerce_conversion_rate' => round($rows["ga:transactionsPerSession"], 2)."%",
			'transactions' => $rows["ga:transactions"],
			'revenue' => round($rows["ga:transactionRevenue"], 2),
			'avg._order_value' => round($rows["ga:revenuePerTransaction"], 2),
		  ); 
		
		// echo "<pre>";print_r($sourcesresult);die;
		$this->insertGoogleResultsData($sourcesresult,$brand_id,$agency_id,$date,$channel_gr_id);
		// echo "<pre>";print_r($sourcesresult);
		// $sessions = $rows[0][0];

		// Print the results.
	   //  print "<p>First view (profile) found: $profileName</p>";
		// print "<p>Total sessions: $sessions</p>";
	  } else {
		print "<p>No results found.</p>";
	  }
	}
	
	
	function insertGoogleResultsData($csvData,$brand_id,$agency_id,$date,$channel_gr_id)
	{
		$id = $brand_id;
		$agency_id = $agency_id;
		
		$allChannels = $this->brands_model->getAllChannelsByChannelGroup($channel_gr_id);
		$allChannels_array = array();
		if($allChannels)
		{
			foreach($allChannels as $k=>$v)
			{
				array_push($allChannels_array,$v->id);
			}
			
			$this->db->where('date',$date);
			$this->db->where('brand_id',$id);
			$this->db->where('agency_id',$agency_id);
			$this->db->where_in('channel_id',$allChannels_array);
			$this->db->delete('daily_import_data');
		}
		if($channel_gr_id == 14)
		{
			$channel_id = 51;
		}else{
			$channel_id = 2;
		}
		// echo $this->db->last_query();die;
		// $revenue_total = 0;
		foreach($csvData as $k=>$v){
				$insert = array(
					'agency_id'=>$agency_id,
					'brand_id'=>$id,
					'date'=>$date,
					'channel_id'=>$channel_id,
					'channel_group_id'=>$channel_gr_id,
					'source'=>$v['source_/_medium'],
					'users'=>$v['users'],
					'new_users'=>$v['new_users'],
					'sessions'=>$v['sessions'],
					'bounce_rate'=>$v['bounce_rate'],
					'pages_session'=>$v['pages_/_session'],
					'avg_session_duration'=>$v['avg._session_duration'],
					'ecom_conversion_rate'=>$v['ecommerce_conversion_rate'],
					'transactions'=>$v['transactions'],
					'revenue'=>$v['revenue'],
					'aov'=>$v['avg._order_value'],
					'status'=>1,
					'created_by'=>777,
					'created_at'=>date("Y-m-d H:i:s"),
				);
			$insert_id = $this->db->insert('daily_import_data',$insert);
					
				
		}
		echo "DONE";
	}
	
	function insertResults($csvData,$brand_id,$agency_id,$date)
	{
		$id = $brand_id;
		$agency_id = $agency_id;
		/* if(isset($_GET["enterDate"]))
		{
			$date = date("Y-m-d",strtotime($_GET["enterDate"]));
		}else{
			$date = date("Y-m-d",strtotime("-1 day"));
		} */
		
		
		$channels = $this->brands_model->getChannels();
		$this->db->where('date',$date);
		$this->db->where('brand_id',$id);
		$this->db->where('agency_id',$agency_id);
		$this->db->delete('daily_import_data');
		$this->db->where('date',$date);
		$this->db->where('brand_id',$id);
		$this->db->where('agency_id',$agency_id);
		$this->db->delete('daily_revenue_total');
		$revenue_total = 0;
		foreach($csvData as $k=>$v){
			if($v['source_/_medium'])
			{
				/* echo "<pre>";
				print_r($v['revenue']);die; */
				/* if($v['revenue'] != 0.00)
				{ */
					$medium =  str_replace(' ', '', $v['source_/_medium']);
					// $medium =  str_replace(' ', '', "flymedia / cps");
					$value = $this->in_array_r($medium, $channels);
					if(empty($value))
					{
						if(strpos(strtolower($medium), "admitad") !== false || strpos(strtolower($medium), "flymedia") !== false || strpos(strtolower($medium), "optimidea") !== false || strpos(strtolower($medium), "flairm") !== false || strpos(strtolower($medium), "clickonik") !== false || strpos(strtolower($medium), "optimise") !== false || strpos(strtolower($medium), "mediazotic") !== false || strpos(strtolower($medium), "tradetracker") !== false || strpos(strtolower($medium), "affoy") !== false || strpos(strtolower($medium), "affiliate") !== false)
						{
							$channel_group_id = 2;
						}
						elseif(strpos(strtolower($medium), "moengage") !== false || strpos(strtolower($medium), "sms") !== false)
						{
							$channel_group_id = 1;
						}
						elseif(strpos(strtolower($medium), "criteo") !== false)
						{
							$channel_group_id = 16;
						}
						elseif(strpos(strtolower($medium), "influencers") !== false || strpos(strtolower($medium), "partnership") !== false)
						{
							$channel_group_id = 15;
						}
						elseif(strpos(strtolower($medium), "google_discovery") !== false)
						{
							$channel_group_id = 17;
						}
						elseif(strpos(strtolower($medium), "google_display") !== false)
						{
							$channel_group_id = 18;
						}
						else{
							$channel_group_id = 11;
						}
						$insert_channel = array(
							"agency_id"=>$agency_id,
							"channel_group_id"=>$channel_group_id,
							"channel_name"=>$v['source_/_medium'],
							"slug"=>$medium,
							"status"=>1,
							"created_by" =>777,
							"created_at" => date("Y-m-d H:i:s")
						);
						$res = $this->db->insert('channel',$insert_channel);
						$last_insert_id = $this->db->insert_id();
						array_push($channels,$insert_channel);
						$channel_id = $last_insert_id;
						// $channel_group_id = 11;
					}else{
						$channel_id = $value['id'];
						$channel_group_id = $value['channel_group_id'];
					}
					
					$aov = preg_replace("/[^0-9.]/", "", $v['avg._order_value']);
					$revenue = preg_replace("/[^0-9.]/", "", $v['revenue']);
					$revenue_total += $revenue;
					$insert = array(
						'agency_id'=>$agency_id,
						'brand_id'=>$id,
						'date'=>$date,
						'channel_id'=>$channel_id,
						'channel_group_id'=>$channel_group_id,
						'source'=>$v['source_/_medium'],
						'users'=>$v['users'],
						'new_users'=>$v['new_users'],
						'sessions'=>$v['sessions'],
						'bounce_rate'=>$v['bounce_rate'],
						'pages_session'=>$v['pages_/_session'],
						'avg_session_duration'=>$v['avg._session_duration'],
						'ecom_conversion_rate'=>$v['ecommerce_conversion_rate'],
						'transactions'=>$v['transactions'],
						'revenue'=>$revenue,
						'aov'=>$aov,
						'status'=>1,
						'created_by'=>777,
						'created_at'=>date("Y-m-d H:i:s"),
					);
					$insert_id = $this->db->insert('daily_import_data',$insert);
					// echo $this->db->last_query();die;
				//}
				
			}else{
				$insert_total = array(
				'agency_id'=>$agency_id,
				'brand_id'=>$id,
				'date'=>$date,
				'revenue_total'=>$revenue_total,
				'created_at'=>date("Y-m-d H:i:s"),
				);
				$insert_id = $this->db->insert('daily_revenue_total',$insert_total);
				break;
			}
		}
		echo "DONE";
	}
	
	function in_array_r($needle, $haystack, $strict = false) {
		foreach ($haystack as $item) {
			if (($strict ? $item === $needle : $item == $needle) || (is_array($item) && $this->in_array_r($needle, $item, $strict))) {
				return $item;
			}
		}

		return false;
	}
	
	function verifyID()
	{
		$dataDate = date("Y-m-d",strtotime("-1 day"));
		$profile_id = $this->input->post("id");
		if(empty($profile_id))
		{
			echo "Please Enter Valid Digits";exit();
		}
		if(ctype_digit($profile_id))
		{
			$client = new Google_Client();
			$client->setAuthConfig(APPPATH . 'third_party/client_secrets.json');
			$client->addScope(Google_Service_Analytics::ANALYTICS_READONLY);

			$access_token = ACCESS_TOKEN;
			// If the user has already authorized this app then get an access token
			// else redirect to ask the user to authorize access to Google Analytics.
			
			// Set the access token on the client.
			$client->setAccessToken($access_token);
		
			// Create an authorized analytics service object.
			$analytics = new Google_Service_Analytics($client);
			// echo "<pre>";print_r($analytics);die;
			
			$results = $this->getResults($analytics,$profile_id,$dataDate);
			if($results == "error")
			{
				echo "Invalid View Id.Please assign permission first.(analytics@hashtagorange.iam.gserviceaccount.com)";exit();
			}else{
				$this->session->set_userdata("verify_id",true);
				echo 1;
			}
		}else{
			echo "Please Enter All Digits";
		}
	}
	
	
}
?>