<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Adscostapi extends CI_Controller {
    
	var $google_client_id;
	var $google_client_secret;
	var $google_developer_token;
	var $hashtag_customer_id;
	var $hashtag_fb_get_url;
	var $hashtag_fb_get_access_token;
	var $hashtag_fb_profile_id;
    function __construct() {
        parent::__construct();
		$this->google_client_id = GOOGLE_API_CLIENT_ID;
		$this->google_client_secret = GOOGLE_API_CLIENT_SECRET;
		$this->google_developer_token = DEVELOPERS_TOKEN;
		$this->hashtag_customer_id = HASHTAG_CUSTOMER_ID;
		$this->hashtag_fb_get_url = FACEBOOK_GET_URL;
		$this->hashtag_fb_get_access_token = FACEBOOK_ACCESS_TOKEN_HO;
		$this->hashtag_fb_profile_id = FACEBOOK_PROFILE_ID_HO;
		$this->load->model('admin/brands_model');
		require_once(APPPATH . 'third_party/vendor/autoload.php');
    }
	
    function index()
	{
		if(isset($_GET["enterDate"]))
		{
			$date = date("Y-m-d",strtotime($_GET["enterDate"]));
		}else{
			$date = date("Y-m-d",strtotime("-1 day"));
		}
		// echo $date;die;
		$client = new Google_Client();
		$client->setAuthConfig(APPPATH . 'third_party/client_secrets.json');
		$client->setRedirectUri('https://' . $_SERVER['HTTP_HOST'] . '/adscostapi');
		$client->addScope(Google_Service_Analytics::ANALYTICS_READONLY);
		$client->addScope("https://www.googleapis.com/auth/adwords");
		$client->setClientId($this->google_client_id);
		$client->setClientSecret($this->google_client_secret);
		$client->setAccessType('offline');
		$client->setApprovalPrompt('force');
		
		
		// unset($_SESSION['access_token']);die("Session out");
		$tokenpath = TOKEN_PATH;

		if (isset($_GET['code'])) {
			
		  $data = $client->authenticate($_GET['code']);
		  $_SESSION['access_token'] = $client->getAccessToken();
		  file_put_contents($tokenpath, json_encode($client->getAccessToken()));
		  redirect(REDIRECT_ADS_API);
		}	
		/* echo "<pre>";
		print_r($_SESSION['access_token']);die; */
		if (isset($_SESSION['access_token']) && $_SESSION['access_token']) 
		{
			$access_token  = $_SESSION['access_token']['access_token'];
			$refresh_token  = $_SESSION['access_token']['refresh_token'];
			$client->setAccessToken($_SESSION['access_token']);
			
			// Refresh the token if it's expired.
			if ($client->isAccessTokenExpired()) { 
				
				$client->setAccessType('offline');
				$client->setApprovalPrompt('force');
				$client->fetchAccessTokenWithRefreshToken($client->getRefreshToken());
				
				$client->setAccessToken($client->getAccessToken());
				/* echo "<pre>";
				print_r($client->getAccessToken());die; */
				$_SESSION['access_token'] = $client->getAccessToken(); 
				
				$access_token  = $_SESSION['access_token']['access_token'];	
				$_SESSION['access_token']['refresh_token'] = $refresh_token;
				
				file_put_contents($tokenpath, json_encode($_SESSION['access_token']));
			}  

			$this->db->select("id,agency_id,customer_id,google_status");
			if(isset($_GET["brand"]))
			{
				$this->db->where('id',$_GET["brand"]);
			}
			$this->db->where('status',1);
			$this->db->order_by("id","ASC");
			$customer_id_ids = $this->db->get("brands")->result();
			
			if($customer_id_ids)
			{
				foreach($customer_id_ids as $k=>$v)
				{
					if($v->customer_id)
					{
						
						if($v->google_status)
						{
							// Get the results from the Google Brand Filter Reporting API and print the results.
							$result = $this->getAdsFilterGoogleBrandCustomerCost($v->customer_id,$date,$access_token);
							 //echo "<pre>";print_r($result);die;
							if(isset($result[0]) && !empty($result) && !isset($result[0]->error))
							{
								$ch_gr_id = 14;
								$this->printGoogleAdsCostResults($ch_gr_id,$v->id,$v->agency_id,$result,$date);
							}elseif(empty($result))
							{
								$this->insertDailyCost(0,14,$v->id,$v->agency_id,$date);
							}
							
							// Get the results from the Not Google Brand Filter Reporting API and print the results.
							$result = $this->getAdsFilterNotGoogleBrandCustomerCost($v->customer_id,$date,$access_token);
							
							if(isset($result[0]) && !empty($result) && !isset($result[0]->error))
							{
								$ch_gr_id = 5;
								$this->printGoogleAdsCostResults($ch_gr_id,$v->id,$v->agency_id,$result,$date);
							}elseif(empty($result))
							{
								$this->insertDailyCost(0,5,$v->id,$v->agency_id,$date);
							}
							
							if(!isset($_GET["enterDate"]))
							{
								$oneDateBefore = date('Y-m-d', strtotime($date . ' -1 day'));
								// One Date Before previous date
								
								// Get the results from the Google Brand Filter Reporting API and print the results.
								$resultDateBefore = $this->getAdsFilterGoogleBrandCustomerCost($v->customer_id,$oneDateBefore,$access_token);
								
								if(isset($resultDateBefore[0]) && !empty($resultDateBefore) && !isset($resultDateBefore[0]->error))
								{
									$ch_gr_id = 14;
									$this->printGoogleAdsCostResults($ch_gr_id,$v->id,$v->agency_id,$resultDateBefore,$oneDateBefore);
								}elseif(empty($resultDateBefore))
								{
									$this->insertDailyCost(0,14,$v->id,$v->agency_id,$oneDateBefore);
								}
								
								// Get the results from the Not Google Brand Filter Reporting API and print the results.
								$resultDateBefore = $this->getAdsFilterNotGoogleBrandCustomerCost($v->customer_id,$oneDateBefore,$access_token);
								
								if(isset($resultDateBefore[0]) && !empty($resultDateBefore) && !isset($resultDateBefore[0]->error))
								{
									$ch_gr_id = 5;
									$this->printGoogleAdsCostResults($ch_gr_id,$v->id,$v->agency_id,$resultDateBefore,$oneDateBefore);
								}elseif(empty($resultDateBefore))
								{
									$this->insertDailyCost(0,5,$v->id,$v->agency_id,$oneDateBefore);
								} 
							}
							
							
						}
						else
						{
							$ch_gr_id = 5;
							// Get the results from the Core Reporting API and print the results.
							$result = $this->getAdsCustomerCost($v->customer_id,$date,$access_token);
							
							if(isset($result[0]) && !empty($result) && !isset($result[0]->error))
							{
								
								$this->printGoogleAdsCostResults($ch_gr_id,$v->id,$v->agency_id,$result,$date);
							}elseif(empty($result))
							{
								$this->insertDailyCost(0,5,$v->id,$v->agency_id,$date);
							}
							
							if(!isset($_GET["enterDate"]))
							{
								$oneDateBefore = date('Y-m-d', strtotime($date . ' -1 day'));
								// One Date Before previous date
								$resultDateBefore = $this->getAdsCustomerCost($v->customer_id,$oneDateBefore,$access_token);
								
								if(isset($resultDateBefore[0]) && !empty($resultDateBefore) && !isset($resultDateBefore[0]->error))
								{
									
									$this->printGoogleAdsCostResults($ch_gr_id,$v->id,$v->agency_id,$resultDateBefore,$oneDateBefore);
								}elseif(empty($resultDateBefore))
								{
									$this->insertDailyCost(0,5,$v->id,$v->agency_id,$oneDateBefore);
								}
							}
							
						}
						
					}
					
				}
			}else{
				echo "Brand id not available";exit();
			}
		  
		}else{
			
			$accessToken = json_decode(file_get_contents($tokenpath), true);
			$_SESSION['access_token'] = $accessToken;
			/* echo "<pre>";
			print_r($accessToken);exit(); */
			$redirect_uri = REDIRECT_ADS_API;
			// $redirect_uri = 'https://' . $_SERVER['HTTP_HOST'] . '/adscostapi/loginAds';
			redirect($redirect_uri);
			// header('Location: ' . filter_var($redirect_uri, FILTER_SANITIZE_URL));
		}
	}
	
	function getAdsCustomerCost($customer_id,$date,$access_token)
	{
			// echo $access_token;die;
			// $customer_id = "73091422023";
			// $customer_id = "1182962239";
			$payload = json_encode(array("query" => "SELECT
				  campaign.name,
				  metrics.cost_micros,
				  segments.date
				FROM campaign
				WHERE segments.date = '$date'"));
				/* $payload = json_encode(array("query" => "SELECT
				  campaign.name,
				  metrics.cost_micros,
				  segments.date
				FROM campaign
				WHERE campaign.status = 'ENABLED' AND segments.date = '$date'")); */
			 $headers = array(
				// 'HOST: googleads.googleapis.com',
				// 'User-Agent: curl',
				'Content-Type: application/json',
				// 'Accept: application/json',
				"developer-token: $this->google_developer_token",
				"login-customer-id: $this->hashtag_customer_id",
				"client_id: $this->google_client_id",
				"client_secret: $this->google_client_secret",
				'refresh_token: 1',
				 sprintf('Authorization: Bearer %s', $access_token)
			);	
			$curl = curl_init("https://googleads.googleapis.com/v6/customers/$customer_id/googleAds:searchStream");
			// curl_setopt($curl, CURLOPT_FOLLOWLOCATION, false);
			curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($curl, CURLOPT_POST, true);
			curl_setopt($curl, CURLOPT_POSTFIELDS,$payload);
			$result = json_decode(curl_exec($curl));
			/* echo "<pre>";
			print_r($result);exit(); */
			/* if ($result === false)
			{
				// throw new Exception('Curl error: ' . curl_error($crl));
				print_r('Curl error: ' . curl_error($curl));exit();
			} */

			curl_close($curl);
			
			return $result;
			/* echo "<pre>";
			print_r($result);exit(); */	
			
	}
	
	
	function getAdsFilterGoogleBrandCustomerCost($customer_id,$date,$access_token)
	{
		$payload = json_encode(array("query" => "SELECT
			  campaign.name,
			  metrics.cost_micros,
			  segments.date
			FROM campaign
			WHERE campaign.name REGEXP_MATCH '(?i).*brand.*' AND segments.date = '$date'"));
		 $headers = array(
			// 'HOST: googleads.googleapis.com',
			// 'User-Agent: curl',
			'Content-Type: application/json',
			// 'Accept: application/json',
			"developer-token: $this->google_developer_token",
			"login-customer-id: $this->hashtag_customer_id",
			"client_id: $this->google_client_id",
			"client_secret: $this->google_client_secret",
			'refresh_token: 1',
			 sprintf('Authorization: Bearer %s', $access_token)
		);	
		$curl = curl_init("https://googleads.googleapis.com/v6/customers/$customer_id/googleAds:searchStream");
		// curl_setopt($curl, CURLOPT_FOLLOWLOCATION, false);
		curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($curl, CURLOPT_POST, true);
		curl_setopt($curl, CURLOPT_POSTFIELDS,$payload);
		$result = json_decode(curl_exec($curl));
		/* echo "<pre>";
		print_r($result);exit(); */
		/* if ($result === false)
		{
			// throw new Exception('Curl error: ' . curl_error($crl));
			print_r('Curl error: ' . curl_error($curl));exit();
		} */

		curl_close($curl);
		
		return $result;
		/* echo "<pre>";
		print_r($result);exit(); */	
			
	}
	
	
	function getAdsFilterNotGoogleBrandCustomerCost($customer_id,$date,$access_token)
	{
		$payload = json_encode(array("query" => "SELECT
			  campaign.name,
			  metrics.cost_micros,
			  segments.date
			FROM campaign
			WHERE campaign.name NOT REGEXP_MATCH '(?i).*brand.*' AND segments.date = '$date'"));
		 $headers = array(
			// 'HOST: googleads.googleapis.com',
			// 'User-Agent: curl',
			'Content-Type: application/json',
			// 'Accept: application/json',
			"developer-token: $this->google_developer_token",
			"login-customer-id: $this->hashtag_customer_id",
			"client_id: $this->google_client_id",
			"client_secret: $this->google_client_secret",
			'refresh_token: 1',
			 sprintf('Authorization: Bearer %s', $access_token)
		);	
		$curl = curl_init("https://googleads.googleapis.com/v6/customers/$customer_id/googleAds:searchStream");
		// curl_setopt($curl, CURLOPT_FOLLOWLOCATION, false);
		curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($curl, CURLOPT_POST, true);
		curl_setopt($curl, CURLOPT_POSTFIELDS,$payload);
		$result = json_decode(curl_exec($curl));
		/* echo "<pre>";
		print_r($result);exit(); */
		/* if ($result === false)
		{
			// throw new Exception('Curl error: ' . curl_error($crl));
			print_r('Curl error: ' . curl_error($curl));exit();
		} */

		curl_close($curl);
		
		return $result;
		/* echo "<pre>";
		print_r($result);exit(); */	
			
	}
	
	function printGoogleAdsCostResults($ch_gr_id,$brand_id,$agency_id,$result,$date)
	{
		$results_data = $result[0]->results;
		$total_cost = 0;
		$total_sum_cost = 0;
		foreach($results_data as $k=>$v){
			$countNumberCostInMicrons = $this->count_digit($v->metrics->costMicros);
			if($countNumberCostInMicrons > 4)
			{
				$costInPaise = substr($v->metrics->costMicros, 0, -4);
			}else{
				$costInPaise = 0;
			}
			$total_cost = $costInPaise/100;
			$v->metrics->rupees = $total_cost;
			$total_sum_cost += $total_cost;
		}
		
		/* echo "<pre>";
		print_r($total_sum_cost);exit();  */
		$this->insertDailyCost($total_sum_cost,$ch_gr_id,$brand_id,$agency_id,$date);
		// echo $this->db->last_query();
		// return true;
		/* echo "<pre>";
		// print_r($result);exit();	
		print_r($total_sum_cost);exit(); */
		
	}
	
	function insertDailyCost($cost,$ch_gr_id,$brand_id,$agency_id,$date)
	{
		$channel_gr_id = $ch_gr_id;
		$where_array = array(
			"brand_id"=>$brand_id,
			"date"=>$date,
			"channel_group_id"=>$channel_gr_id,
			"agency_id"=>$agency_id,
		);
		$insert_array = array(
			"brand_id"=>$brand_id,
			"date"=>$date,
			"channel_group_id"=>$channel_gr_id,
			"agency_id"=>$agency_id,
			"cost"=>$cost,
			"created_by" =>777,
			"created_at" => date("Y-m-d H:i:s"),
			"status"=>1
		);
		
		$res = $this->brands_model->insertUpdateDailyCost($where_array,$insert_array);
		// echo $this->db->last_query();
		echo "DONE<br>";
	}
	
	
	function loginAds()
	{
		// Create the client object and set the authorization configuration
		// from the client_secrets.json you downloaded from the Developers Console.
		$client = new Google_Client();
		$client->setAuthConfig(APPPATH . 'third_party/client_secrets.json');
		$client->setRedirectUri('https://' . $_SERVER['HTTP_HOST'] . '/adscostapi');
		$client->addScope(Google_Service_Analytics::ANALYTICS_READONLY);
		$client->addScope("https://www.googleapis.com/auth/adwords");
		$client->setClientId($this->google_client_id);
		$client->setClientSecret($this->google_client_secret);
		$client->setAccessType('offline');
		$client->setApprovalPrompt('force');
			
		// Handle authorization flow from the server.
		if (! isset($_GET['code'])) {
			
		  $auth_url = $client->createAuthUrl();
		  /* echo "<pre>";
			print_r($auth_url);die; */
		  header('Location: ' . filter_var($auth_url, FILTER_SANITIZE_URL));
		} else {
		  $client->authenticate($_GET['code']);
		  $_SESSION['access_token'] = $client->getAccessToken();
		  $tokenpath = TOKEN_PATH;
		  file_put_contents($tokenpath, json_encode($client->getAccessToken()));
		  // $client->setAccessToken($_SESSION['access_token']);
		  $redirect_uri = REDIRECT_ADS_API;
		  redirect($redirect_uri);
		}
	}
    
	function count_digit($number) {
		return strlen($number);
	}
	
	function getAdsCustomerCostfb()
	{
		if(isset($_GET["enterDate"]))
		{
			$date = date("Y-m-d",strtotime($_GET["enterDate"]));
		}else{
			$date = date("Y-m-d",strtotime("-1 day"));
		}
		
		$fbAccess_token = "&access_token=$this->hashtag_fb_get_access_token";
		
		// $accountId = "act_350207249239570"; // Moms Co Account ID
		$this->db->select("id,agency_id,fb_cost_account_id");
		if(isset($_GET["brand"]))
		{
			$this->db->where('id',$_GET["brand"]);
		}
		$this->db->where('status',1);
		$this->db->order_by("id","ASC");
		$fb_account_ids = $this->db->get("brands")->result();
		/* echo "<pre>";
		print_r($fb_account_ids);die; */
		if($fb_account_ids)
		{
			foreach($fb_account_ids as $k=>$v)
			{
				if($v->fb_cost_account_id)
				{
					$fb_cost_account_id_array = explode(",",$v->fb_cost_account_id);
					$cost = 0;
					
					foreach($fb_cost_account_id_array as $fbval)
					{
						// Get the results from the Core Reporting API and print the results.
						$result = $this->getAdsFbCost(trim($fbval),$date,$fbAccess_token);
						/* echo "<pre>";
						print_r($result); */
						if(isset($result) && !empty($result) && !isset($result->error))
						{
							if(isset($result->data[0]))
							{
								$cost += $result->data[0]->spend;
								
							}
							elseif(isset($result->data))
							{
								$cost += 0;
							}
							
						}
					}
					
					// echo $cost;die;
					$this->printFbCostResults($v->id,$v->agency_id,$result,$date,$cost);
					
					if(!isset($_GET["enterDate"]))
					{
						$oneDateBefore = date('Y-m-d', strtotime($date . ' -1 day'));
						
						$datebeforecost = 0;
						foreach($fb_cost_account_id_array as $fbval)
						{
							// Get the results from the Core Reporting API and print the results.
							$result = $this->getAdsFbCost(trim($fbval),$oneDateBefore,$fbAccess_token);
							// echo "<pre>";
							// print_r($result);die;
							if(isset($result) && !empty($result) && !isset($result->error))
							{
								if(isset($result->data[0]))
								{
									$datebeforecost += $result->data[0]->spend;
									
								}
								elseif(isset($result->data))
								{
									$datebeforecost += 0;
								}
								
							}
						}
						
						$this->printFbCostResults($v->id,$v->agency_id,$result,$oneDateBefore,$datebeforecost);
					}
					
				}
				
				
			}
		}else{
			echo "Brand id not available";exit();
		}
			
	}
	
	function getAdsFbCost($accountId,$date,$access_token)
	{
		$facebookGetUrl = $this->hashtag_fb_get_url;
		$facebookRequestUrlInsight = "/insights?fields=spend&level=account&time_range={'since':'$date','until':'$date'}";
		$curl = curl_init("$facebookGetUrl$accountId$facebookRequestUrlInsight$access_token"); // For Insights
		curl_setopt($curl, CURLOPT_FOLLOWLOCATION, false);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		$result = json_decode(curl_exec($curl));
		/* echo "<pre>";
		print_r($result);die; */
		curl_close($curl);
		return $result;
	}
	
	function printFbCostResults($brand_id,$agency_id,$result,$date,$cost)
	{
		
		$channel_gr_id = 4;
		$where_array = array(
			"brand_id"=>$brand_id,
			"date"=>$date,
			"channel_group_id"=>$channel_gr_id,
			"agency_id"=>$agency_id,
		);
		$insert_array = array(
			"brand_id"=>$brand_id,
			"date"=>$date,
			"channel_group_id"=>$channel_gr_id,
			"agency_id"=>$agency_id,
			"cost"=>$cost,
			"created_by" =>777,
			"created_at" => date("Y-m-d H:i:s"),
			"status"=>1
		);
		
		$res = $this->brands_model->insertUpdateDailyCost($where_array,$insert_array);
		// echo $this->db->last_query();
		echo "DONE<br>";
	}
	
	function getFbAccounts()
	{
		$profileId = $this->hashtag_fb_profile_id;
		$facebookGetUrl = $this->hashtag_fb_get_url;
		$facebookRequestUrlAccount = "$profileId/adaccounts?fields=id,name,account_status,balance,business_city,business_country_code,business_name,business_state,business_street,business_street2,business_zip,spend_cap,created_time,currency,media_agency,min_daily_budget&limit=40";
		
		$access_token = "&access_token=$this->hashtag_fb_get_access_token";
		
		$curl = curl_init("$facebookGetUrl$facebookRequestUrlAccount$access_token"); // For Accounts to profile Id
		curl_setopt($curl, CURLOPT_FOLLOWLOCATION, false);
		// curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		$result = json_decode(curl_exec($curl));
		echo "<pre>";
		print_r($result);die;
		/* if ($result === false)
		{
			// throw new Exception('Curl error: ' . curl_error($crl));
			print_r('Curl error: ' . curl_error($curl));exit();
		} */

		curl_close($curl);
		
		return $result;
	}
} 

?>