<?php

namespace Microsoft\BingAds\V13\CampaignManagement;

{
    /**
     * Gets ad group criterions by identifiers and types.
     * @link https://docs.microsoft.com/en-us/advertising/campaign-management-service/getadgroupcriterionsbyids?view=bingads-13 GetAdGroupCriterionsByIds Request Object
     * 
     * @uses AdGroupCriterionType
     * @uses CriterionAdditionalField
     * @used-by BingAdsCampaignManagementService::GetAdGroupCriterionsByIds
     */
    final class GetAdGroupCriterionsByIdsRequest
    {
        /**
         * A list of unique identifiers that identify the criterions to get.
         * @var integer[]
         */
        public $AdGroupCriterionIds;

        /**
         * The identifier of the ad group that owns the criterions to get.
         * @var integer
         */
        public $AdGroupId;

        /**
         * The type of criterion to get, for example Webpage.
         * @var AdGroupCriterionType
         */
        public $CriterionType;

        /**
         * Reserved.
         * @var CriterionAdditionalField
         */
        public $ReturnAdditionalFields;
    }
}
