<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Pava_model extends CI_Model{
    function __construct() {
        $this->pavaTbl = 'pava'; 
        $this->pavaApplicationTbl = 'pava_application_images'; 
    }
    
		
		function getPava($whereRoleId = null)
		{	
			/* $page = $this->getPage();
			$num_of_records = $this->getNumRecord();
			$startlimit = ($page*$num_of_records)-$num_of_records;
			$endlimit = $page*$num_of_records;
			if(isset($_GET['pava_rec'])){
				$this->db->like($this->pavaTbl.'.name', $_GET['pava_rec']);
				$this->db->or_like($this->pavaTbl.'.url', $_GET['pava_rec']);
				$this->db->or_like($this->pavaTbl.'.short_description', $_GET['pava_rec']);
			} */
			if($whereRoleId)
			{
				$this->db->where($this->pavaTbl.'.role_id', $whereRoleId);
				$this->db->where($this->pavaTbl.'.id', 1);
			}
			/* if(isset($_GET['sort'])){
				$this->db->order_by($this->pavaTbl.".name", $_GET['sort']);
			}
			if(isset($_GET['entry'])){
				$this->db->limit($_GET['entry'],$startlimit);
			}
			else{
				$this->db->limit(LIMIT,$startlimit);
			} */
			$query = $this->db->get($this->pavaTbl)->result(); 
			return $query; 	
		}
		
		
		
		/*     Get All Pava      */
		
		function getAllPava($whereRoleId = null)
		{	
			if($whereRoleId)
			{
				$query = $this->db->get_where($this->pavaTbl,array('role_id'=>$whereRoleId))->result();
			}
			else{
				$query = $this->db->get_where($this->pavaTbl)->result();
			}
			
			return $query;	
		}
		
		
		
		/*     Insert Pava      */
		
		function insertPava($data)
		{
			 if(!array_key_exists("created",$data)){
				$data['created_at'] = date("Y-m-d H:i:s");
			}
			$this->db->insert($this->pavaTbl, $data);
			$id = $this->db->insert_id();
			
			 
			return  $id;
			 
			
		}
		
		
		
		
		
		/*     Get Single Pava      */
		
		function getSinglePava($id,$whereRoleId = null)
		{	
			if($whereRoleId)
			{
				$query = $this->db->get_where($this->pavaTbl,array('id'=>$id,'role_id'=>$whereRoleId))->row();
			}
			else
			{
				$query = $this->db->get_where($this->pavaTbl,array('id'=>$id))->row();
			}
			
			return $query;	
		}
		
		
		
		/*     Get Pava Application Data     */
		
		function getPavaApplicationData($id)
		{	
			$query = $this->db->get_where($this->pavaApplicationTbl,array('pava_id'=>$id))->result();
			return $query;	
		}
		
		
		
		
		
		
		
		
		/*     Update Single Pava      */
		
		function updatePava($data,$id)
		{
			$this->db->where('id', $id);
			$this->db->update($this->pavaTbl, $data);
			$query =  $this->db->affected_rows(); 
			return $query;
		}
		
		/*     Update Single Pava Application data    */
		
		function updatePavaApplicationData($data,$id)
		{
			$this->db->where('pava_id',$id);
			$this->db->delete($this->pavaApplicationTbl);
			if($data)
			{
				foreach($data as $k=>$v)
				{
					$v['pava_id'] = $id;
					$this->db->insert($this->pavaApplicationTbl,$v);
				}
			}
			
			
			return true;
		}
		
		
		function delete($id,$whereRoleId = null)
		{
			if($whereRoleId)
			{
				$this->db->where('role_id',$whereRoleId);
			}
			$this->db->where('id', $id);
			$query = $this->db->delete($this->pavaTbl);
			$query =  $this->db->affected_rows(); 
			return $query;
		}
		
		function update_status($data,$id,$whereRoleId = null)
		{
			if($whereRoleId)
			{
				$this->db->where('role_id',$whereRoleId);
			}
			$this->db->where('id', $id);
			$this->db->update($this->pavaTbl, $data);
			$query =  $this->db->affected_rows(); 
			return $query;
		}
		
		function url_recursive($id,$url)
		{
			$res = $this->db->get_where($this->pavaTbl,array('id'=>$id))->row();
			if($res)
			{
				$parent_id = $res->parent_id;
				$name = str_replace(' ','-',strtolower($res->name));
				
				if($parent_id)
				{
					$url .= $name.'/';
					$this->url_recursive($parent_id,$url);
				}
				else
				{
					$url .= $name;
					$url = array_reverse(explode('/',$url),true);
					$url = implode('/',$url);
					$this->url_complete($url);
					
				}
				// return $url;
				
			}
			
			
		}
		
		function getParentidBySlug($slug)
		{
			$res = $this->db->get_where($this->pavaTbl,array('url'=>'/'.$slug))->row();
			if($res)
			{
				return $res->role_id;
			}else{
				return false;
			}
		}
		
		function url_complete($url)
		{
			print_r($url);
		}
		
		/*     Get Sub Category Pava      */
		
		function getSubPava($whereRoleId = null)
		{	
			$page = $this->getPage();
			$num_of_records = $this->getNumRecord();
			$startlimit = ($page*$num_of_records)-$num_of_records;
			$endlimit = $page*$num_of_records;
			if(isset($_GET['sub_pava_rec'])){
				$this->db->like($this->pavaTbl.'.name', $_GET['sub_pava_rec']);
				$this->db->or_like($this->pavaTbl.'.url', $_GET['sub_pava_rec']);
				$this->db->or_like($this->pavaTbl.'.short_description', $_GET['sub_pava_rec']);
			}
			if($whereRoleId)
			{
				$this->db->where($this->pavaTbl.'.role_id', $whereRoleId);
				$this->db->where($this->pavaTbl.'.id !=', 1);
			}
			if(isset($_GET['sort'])){
				$this->db->order_by($this->pavaTbl.".name", $_GET['sort']);
			}
			if(isset($_GET['entry'])){
				$this->db->limit($_GET['entry'],$startlimit);
			}
			else{
				$this->db->limit(LIMIT,$startlimit);
			}
			$query = $this->db->get($this->pavaTbl)->result(); 
			return $query; 	
		}
		
		
		function getPage(){
			$page = null!==$this->input->get('page')?$this->input->get('page'):1; 	
			return $page;
		}
		
		function getNumRecord(){
			if(isset($_GET['entry'])){
				$numrecord = null!==$this->input->get('numrecord')?$this->input->get('numrecord'):$_GET['entry']; 
			}else{
				$numrecord = null!==$this->input->get('numrecord')?$this->input->get('numrecord'):LIMIT; 
			}
				
			return $numrecord;
		}
		
		function totalCount($whereRoleId = null){
			if(isset($_GET['sub_pava_rec'])){
				$this->db->like('name', $_GET['sub_pava_rec']);
				$this->db->or_like($this->pavaTbl.'.url', $_GET['sub_pava_rec']);
				$this->db->or_like($this->pavaTbl.'.short_description', $_GET['sub_pava_rec']);
			}
			if($whereRoleId)
			{
				$this->db->where($this->pavaTbl.'.role_id', $whereRoleId);
				$this->db->where($this->pavaTbl.'.id !=', 1);
			}
			return $this->db->count_all_results($this->pavaTbl);
		}
		
		
		/*     Insert Sub Category Pava      */
		
		function insertSubCategoryPava($data)
		{
			if(!array_key_exists("created",$data)){
				$data['created_at'] = date("Y-m-d H:i:s");
			}
			$this->db->insert($this->pavaTbl, $data);
			$id = $this->db->insert_id();
			
			 
			return  $id;
			 
			
		}
		
		function updateSubPava($data,$id)
		{
			
		}
		
		
}
?>