<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Patient_model extends CI_Model{
    function __construct() {
        $this->patientTbl = 'patient'; 
        $this->patientReminderTbl = 'reminder'; 
        $this->patientPrescriptionTbl = 'prescription'; 
        $this->patientReadingTbl = 'patient_reading'; 
		$this->clinicAddressTbl = 'clinic_address'; 
		$this->chatTbl = 'chat_message'; 
		$this->globalchatTbl = 'global_chat_message'; 
    }
    /*
     * get rows from the Patient
     */
	 
	 function getRows($params = array()){

        $this->db->select('*');

        $this->db->from($this->patientTbl);


        if(array_key_exists("conditions",$params)){

			foreach ($params['conditions'] as $key => $value) {

				$this->db->where($key,$value);

			}

		}

        if(array_key_exists("id",$params)){

            $this->db->where('id',$params['id']);

			$query = $this->db->get();

			$result = $query->row();

        }else{

            //set start and limit

            if(array_key_exists("start",$params) && array_key_exists("limit",$params)){

                $this->db->limit($params['limit'],$params['start']);

            }elseif(!array_key_exists("start",$params) && array_key_exists("limit",$params)){

                $this->db->limit($params['limit']);

            }

            $query = $this->db->get();

            if(array_key_exists("returnType",$params) && $params['returnType'] == 'count'){

				$result = $query->num_rows();

			}elseif(array_key_exists("returnType",$params) && $params['returnType'] == 'single'){

				$result = ($query->num_rows() > 0)?$query->row():FALSE;

			}else{

                $result = ($query->num_rows() > 0)?$query->row():FALSE;

            }

        }

        return $result;

    }
	
		function getPatient($fields=array(),$conditions=array(),$joins=array(),$alias = "",$groupby="",$orderby=array())
		{	
			$page = $this->getPage();
			$num_of_records = $this->getNumRecord();
			$startlimit = ($page*$num_of_records)-$num_of_records;
			$endlimit = $page*$num_of_records;
			if(count($fields)){
				$this->db->select(implode(",",$fields));
			}
			if(count($conditions)){
				foreach($conditions as $conditionkey=>$condition){
					$this->db->$conditionkey($condition);					
				}
			}
			
			if($groupby!=""){
				 $this->db->group_by($groupby); 
			}
			if(count($orderby)){
				$this->db->order_by($orderby[0],$orderby[1]);
			}
			if(count($joins)){
				foreach($joins as $join){
					$this->db->join($join[0],$join[1],'left');
				}
			}			if(isset($_GET['sort'])){
				$this->db->order_by("name", $_GET['sort']);
			}
			if(isset($_GET['entry'])){
				$this->db->limit($_GET['entry'],$startlimit);
			}
			else{
				$this->db->limit(LIMIT,$startlimit);
			}
			
			if($alias!=""){
				$query = $this->db->get($this->patientTbl." as ".$alias)->result();
			}else{
				$query = $this->db->get($this->patientTbl)->result();
			}
			//echo "<pre>"; print_r($this->db->last_query()); echo "</pre>";
			return $query; 	
		}
		
		function getPage(){
			$page = null!==$this->input->get('page')?$this->input->get('page'):1; 	
			return $page;
		}
		
		function getNumRecord(){
			if(isset($_GET['entry'])){
				$numrecord = null!==$this->input->get('numrecord')?$this->input->get('numrecord'):$_GET['entry']; 
			}else{
				$numrecord = null!==$this->input->get('numrecord')?$this->input->get('numrecord'):LIMIT; 
			}
				
			return $numrecord;
		}
		
		function totalCount($fields=array(),$conditions=array(),$joins=array(),$alias = "",$groupby="",$orderby=array()){
			if(count($fields)){
				$this->db->select(implode(",",$fields));
			}
			if(count($conditions)){
				foreach($conditions as $conditionkey=>$condition){
					$this->db->$conditionkey($condition);					
				}
			}
			
			if($groupby!=""){
				 $this->db->group_by($groupby); 
			}
			if(count($orderby)){
				$this->db->order_by($orderby[0],$orderby[1]);
			}
			if(count($joins)){
				foreach($joins as $join){
					$this->db->join($join[0],$join[1],'left');
				}
			}			if(isset($_GET['sort'])){
				$this->db->order_by("name", $_GET['sort']);
			}
			if($alias!=""){
				return $this->db->count_all_results($this->patientTbl." as ".$alias);
			}else{
				return $this->db->count_all_results($this->patientTbl);
			}
		}
		
		
		/*     Insert Patient      */
		
		function insertPatient($data)
		{
			 if(!array_key_exists("created",$data)){
				$data['created_at'] = date("Y-m-d H:i:s");
			}
			$this->db->insert($this->patientTbl, $data);
			$id = $this->db->insert_id();
			
			 
			return  $id;
			 
			
		}
		
		function getPatientData($fields=array(),$conditions=array(),$joins=array(),$alias = "",$groupby=""){
			if(count($fields)){
				$this->db->select(implode(",",$fields));
			}
			if(count($conditions)){
				foreach($conditions as $conditionkey=>$condition){
					$this->db->$conditionkey($condition);					
				}
			}
			if($groupby!=""){
				 $this->db->group_by($groupby); 
			}
			
			if(count($joins)){
				foreach($joins as $join){
					$this->db->join($join[0],$join[1],'left');
				}
			}
			
			if($alias!=""){
				$query = $this->db->get($this->patientTbl." as ".$alias)->result();	
			}else{
				$query = $this->db->get($this->patientTbl)->result();
			}
			
			/*echo "<pre>"; print_r($this->db->last_query()); echo "</pre>";
			echo "<pre>"; print_r($query); echo "</pre>";*/
			return $query;
		}
		
		/*     Get Single Patient      */
		
		function getSinglePatient($id)
		{	
			$query = $this->db->get_where($this->patientTbl,array('id'=>$id))->row();
			return $query;	
		}
		
		/*     Update Single Patient      */
		
		function updatePatient($data,$id)
		{
			
			$this->db->where('id', $id);
			$this->db->update($this->patientTbl, $data);
			$query =  $this->db->affected_rows(); 
			return $query;
		}
		
		
		function delete($id)
		{
			$this->db->where('id', $id);
			$this->db->delete($this->patientTbl);
		}
		
		
		/*     Insert Patient Reminder     */
		
		function insertPatientReminder($data)
		{
			 if(!array_key_exists("created",$data)){
				$data['created_at'] = date("Y-m-d H:i:s");
			}
			$this->db->insert($this->patientReminderTbl, $data);
			$id = $this->db->insert_id();
			return  $id;	
		}
		
		/*     Get All Patient Reminder     */
		
		function getAllPatientReminder($id)
		{	
			$query = $this->db->get_where($this->patientReminderTbl,array('patient_id'=>$id))->result();
			return $query;	
		}
		
		/*     Get Single Patient Reminder     */
		
		function getSinglePatientReminder($reminder_id)
		{	
			$query = $this->db->get_where($this->patientReminderTbl,array('id'=>$reminder_id))->row();
			return $query;	
		}
		
		
		/*     Delete Single Patient Reminder     */
		
		function deleteSinglePatientReminder($reminder_id)
		{	
			$this->db->where('id',$reminder_id);
			$this->db->delete($this->patientReminderTbl);
			return true;	
		}
		
		
		
		
		
		
		/*     Insert Patient Reading     */
		
		function insertPatientReading($data)
		{
			 if(!array_key_exists("created",$data)){
				$data['created_at'] = date("Y-m-d H:i:s");
			}
			$this->db->insert($this->patientReadingTbl, $data);
			$id = $this->db->insert_id();
			return  $id;	
		}
		
		
		/*     Get All Patient Reading     */
		
		function getAllPatientReading($id)
		{	
			$query = $this->db->get_where($this->patientReadingTbl,array('patient_id'=>$id))->result();
			return $query;	
		}
		
		/*     Insert Patient Prescription     */
		
		function insertPatientPrescription($data)
		{
			 if(!array_key_exists("created",$data)){
				$data['created_at'] = date("Y-m-d H:i:s");
			}
			$this->db->insert($this->patientPrescriptionTbl, $data);
			$id = $this->db->insert_id();
			return  $id;	
		}
		
		/*     Get All Patient Prescription     */
		
		function getAllPatientPrescription($id)
		{	
			$query = $this->db->get_where($this->patientPrescriptionTbl,array('patient_id'=>$id))->result();
			return $query;	
		}
		
		/* Get All Filter Patient Prescription */
		
		function getAllFilterPatientPrescription($id,$from_date,$to_date)
		{
			$start_date = date('Y-m-d H:i:s', strtotime($from_date));
			$expire_date = date('Y-m-d 23:59:00', strtotime($to_date));
			$this->db->where('date >=',$start_date);
			$this->db->where('date <=',$expire_date);
			$this->db->where('patient_id',$id);
			$query = $this->db->get($this->patientPrescriptionTbl)->result();
			return $query;	
		}
		
		/*     Delete Single Patient Prescription     */
		
		function deleteSinglePatientPrescription($prescription_id)
		{	
			$this->db->where('id',$prescription_id);
			$this->db->delete($this->patientPrescriptionTbl);
			return true;	
		}
		
		
		function update_status($data,$id)
		{
			
			$this->db->where('id', $id);
			$this->db->update($this->patientTbl, $data);
			$query =  $this->db->affected_rows(); 
			return $query;
		}
		
		function getClinicAddresses()
		{
			$this->db->where('status', 1);
			$query = $this->db->get($this->clinicAddressTbl)->result();
			return $query;
		}
		
		function getAllResult($sessuser,$from_date,$to_date)
		{
			$res  = $this->db->query("SELECT  * FROM $this->patientReadingTbl 
			WHERE patient_id = '$sessuser' AND `reportdate` >= '$from_date' AND `reportdate` <= '$to_date'
			ORDER BY id ASC ")->result_array();
			if($res || !empty($res))
			{
				return $res;
			}else{
				return false;
			}
			
		}
		
		function getAllSugar($sessuser,$from_date,$to_date)
		{
			$res  = $this->db->query("SELECT * FROM  $this->patientReadingTbl 
			WHERE patient_id = '$sessuser' AND `reportdate` >= '$from_date' AND `reportdate` <= '$to_date'
			AND sugar IS NOT NULL AND sugar!='' ORDER BY id ASC ")->result_array();
			if($res || !empty($res))
			{
				return $res;
			}else{
				return false;
			}
		}
		
		function getAllBP($sessuser,$from_date,$to_date)
		{
			$res  = $this->db->query("SELECT  * FROM $this->patientReadingTbl 
			WHERE patient_id = '$sessuser' AND `reportdate` >= '$from_date' AND `reportdate` <= '$to_date'
			AND bp_min IS NOT NULL AND bp_min !='' ORDER BY id ASC ")->result_array();
			if($res || !empty($res))
			{
				return $res;
			}else{
				return false;
			}
		}
		
		
		
		function getAvgBPMin($sessuser,$from_date,$to_date)
		{
			$res  = $this->db->query("SELECT  AVG(bp_min) as minavg FROM $this->patientReadingTbl 
			WHERE patient_id = '$sessuser' AND `reportdate` >= '$from_date' AND `reportdate` <= '$to_date'
			AND bp_min IS NOT NULL AND bp_min !='' ORDER BY id ASC ")->result_array();
			if($res || !empty($res))
			{
				return $res;
			}else{
				return false;
			}
		}
		
		function getAvgBPMax($sessuser,$from_date,$to_date)
		{
			$res  = $this->db->query("SELECT  AVG(bp_max) as maxavg FROM $this->patientReadingTbl 
			WHERE patient_id = '$sessuser' AND `reportdate` >= '$from_date' AND `reportdate` <= '$to_date'
			AND bp_max IS NOT NULL AND bp_max !='' ORDER BY id ASC")->result_array();
			if($res || !empty($res))
			{
				return $res;
			}else{
				return false;
			}
		}
		
		function getAvgSugar($sessuser,$from_date,$to_date)
		{
			$res  = $this->db->query("SELECT  AVG(sugar) as avgsugar FROM $this->patientReadingTbl 
			WHERE patient_id = '$sessuser' AND `reportdate` >= '$from_date' AND `reportdate` <= '$to_date'
			AND sugar IS NOT NULL AND sugar!='' ORDER BY id ASC")->result_array();
			if($res || !empty($res))
			{
				return $res;
			}else{
				return false;
			}
		}
		
		/*     Get Chat Messages      */
		
		function getAllChats($id)
		{
			$this->db->where("(from_user_id = 'patient-$id' OR to_user_id = 'patient-$id')");
			$this->db->order_by('chat_message_id','ASC');
			$query = $this->db->get($this->chatTbl)->result();
			return $query;
		}
		
		
		/*     Get All Unread Chat Messages      */
		
		function getAllUnreadChats($id)
		{
			$this->db->where("(from_user_id = 'patient-$id')");
			$this->db->where("status",0);
			$this->db->order_by('chat_message_id','ASC');
			$query = $this->db->count_all_results($this->chatTbl);
			return $query;
		}
		
		/*     Get Update Doctor Read Chat Messages      */
		
		function getUpdateUnreadChats($id)
		{
			$this->db->where("(from_user_id = 'patient-$id')");
			$this->db->where("status",0);
			$query = $this->db->update($this->chatTbl,array("status"=>1));
			return $query;
		}
		
		/*     Get Update Patient Read Chat Messages      */
		
		function getToUpdateUnreadChats($id)
		{
			$this->db->where("(to_user_id = 'patient-$id')");
			$this->db->where("status",0);
			$query = $this->db->update($this->chatTbl,array("status"=>1));
			return $query;
		}
		
		
		
		
		/*     Insert Chat Messages      */
		
		function insertChatMessage($data)
		{
			 if(!array_key_exists("created",$data)){
				$data['timestamp'] = date("Y-m-d H:i:s");
			}
			$this->db->insert($this->chatTbl, $data);
			$id = $this->db->insert_id();
			
			 
			return  $id;
			 
			
		}
		
		
		/*     Get Global Chat Messages      */
		
		function getAllGlobalChats($id)
		{
			$this->db->where("(from_user_id = 'patient-$id' OR from_user_id = 'doctor-1')");
			$this->db->order_by('chat_message_id','ASC');
			$query = $this->db->get($this->globalchatTbl)->result();
			return $query;
		}
		
		/*     Insert Global Chat Messages      */
		
		function insertGlobalChatMessage($data)
		{
			 if(!array_key_exists("created",$data)){
				$data['timestamp'] = date("Y-m-d H:i:s");
			}
			$this->db->insert($this->globalchatTbl, $data);
			$id = $this->db->insert_id();
			
			 
			return  $id;
		}
		
		function count_all_patients()
		{
			if(isset($_GET['date'])){
				$till_date = $_GET['date'];
				$date = explode(" - ", $till_date);
				$start_date = date('Y-m-d', strtotime(str_replace('-', '/', $date[0])));
				$expire_date = date('Y-m-d 23:59:00', strtotime(str_replace('-', '/', $date[1])));
				$this->db->where('created_at >=',$start_date);
				$this->db->where('created_at <=',$expire_date);
			
			}
			
			// $this->db->where('patient_id',$id);
			return $this->db->count_all_results($this->patientTbl);
		}
		
		/* Cron Patient Reminder */
		
		function getPatientCronReminder($start_date,$expire_date)
		{
			$this->db->select("$this->patientTbl.player_id,$this->patientTbl.name,$this->patientTbl.email,$this->patientTbl.phone,$this->patientReminderTbl.*");
			$this->db->join("$this->patientTbl","$this->patientTbl.id=$this->patientReminderTbl.patient_id");
			$this->db->where("$this->patientReminderTbl.time >=",$start_date);
			$this->db->where("$this->patientReminderTbl.time <=",$expire_date);
			$query = $this->db->get($this->patientReminderTbl)->result();
			// echo $this->db->last_query();die;
			if($query)
			{
				return $query;
			}else{
				return false;
			}
			
		}
		
		function updatePatientReminder($reminder_id,$time)
		{	
			$data = array("time"=>$time);
			$this->db->where("id",$reminder_id);
			$query = $this->db->update($this->patientReminderTbl,$data);
			return $query;	
		}
		
		
}
?>