<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Menu_model extends CI_Model{
    function __construct() {
        $this->categoryTbl = 'pava'; 
    }
    /*
     * get rows from the cso teachers table
     */
	
		function getParentCategory($whereRoleId = null)
		{	
			$page = $this->getPage();
			$num_of_records = $this->getNumRecord();
			$startlimit = ($page*$num_of_records)-$num_of_records;
			$endlimit = $page*$num_of_records;
			if(isset($_GET['categori'])){
				$this->db->like($this->categoryTbl.'.name', $_GET['categori']);
				$this->db->or_like($this->categoryTbl.'.url', $_GET['categori']);
			}
			if($whereRoleId)
			{
				$this->db->where($this->categoryTbl.'.role_id', $whereRoleId);
				
			}
			$this->db->where($this->categoryTbl.'.parent_id', 0);
			if(isset($_GET['sort'])){
				$this->db->order_by($this->categoryTbl.".name", $_GET['sort']);
			}
			if(isset($_GET['entry'])){
				$this->db->limit($_GET['entry'],$startlimit);
			}
			else{
				$this->db->limit(LIMIT,$startlimit);
			}
			$query = $this->db->get($this->categoryTbl)->result(); 
			return $query; 	
		}
		
		
		/* Get Sub Category */
		
		function getSubCategory($role_id)
		{
			
			//$query = $this->buildTree(3);
			$query = $this->db->select('id,name,parent_id,url,is_menu,is_menu_sort_order')
			->order_by("is_menu_sort_order","ASC")
			->get_where($this->categoryTbl,array('role_id'=>$role_id))
			->result_array();
			$query = $this->buildTree($query);
			
			return $query;
		}
		
		
		function buildTree(array $elements, $parentId = 0) 
		{
			$branch = array();

			foreach ($elements as $element) {
				if ($element['parent_id'] == $parentId) {
					$children = $this->buildTree($elements, $element['id']);
					if ($children) {
						$element['sub_menu'] = $children;
					}
					$branch[] = $element;
				}
			}
			
			return $branch;
		}

		
		
		
		
		/*     Get Single Category      */
		
		function getAllCategory($whereRoleId = null)
		{	
			if($whereRoleId)
			{
				$query = $this->db->get_where($this->categoryTbl,array('role_id'=>$whereRoleId))->result();
			}
			else{
				$query = $this->db->get_where($this->categoryTbl)->result();
			}
			
			return $query;	
		}
		
		function getPage(){
			$page = null!==$this->input->get('page')?$this->input->get('page'):1; 	
			return $page;
		}
		
		function getNumRecord(){
			if(isset($_GET['entry'])){
				$numrecord = null!==$this->input->get('numrecord')?$this->input->get('numrecord'):$_GET['entry']; 
			}else{
				$numrecord = null!==$this->input->get('numrecord')?$this->input->get('numrecord'):LIMIT; 
			}
				
			return $numrecord;
		}
		
		function totalCount($whereRoleId = null){
			if(isset($_GET['categori'])){
				$this->db->like('name', $_GET['categori']);
				$this->db->or_like($this->categoryTbl.'.url', $_GET['categori']);
				$this->db->or_like($this->categoryTbl.'.short_description', $_GET['categori']);
			}
			if($whereRoleId)
			{
				$this->db->where($this->categoryTbl.'.role_id', $whereRoleId);
			}
			return $this->db->count_all_results($this->categoryTbl);
		}
		
		
		
		/*     Get Single Category      */
		
		function getSingleCategory($id,$whereRoleId = null)
		{	
			if($whereRoleId)
			{
				$query = $this->db->get_where($this->categoryTbl,array('id'=>$id,'role_id'=>$whereRoleId))->row();
			}
			else
			{
				$query = $this->db->get_where($this->categoryTbl,array('id'=>$id))->row();
			}
			
			return $query;	
		}
		
		
		
		
		/*     Update Single Category      */
		
		function updateCategory($data,$id,$whereRoleId = null)
		{
			$this->db->where('id', $id);
			$this->db->update($this->categoryTbl, $data);
			$query =  $this->db->affected_rows(); 
			return $query;
		}
		
		
		function delete($id,$whereRoleId = null)
		{
			if($whereRoleId)
			{
				$this->db->where('role_id',$whereRoleId);
			}
			$this->db->where('id', $id);
			$query = $this->db->delete($this->categoryTbl);
			$query =  $this->db->affected_rows(); 
			return $query;
		}
		
		function isMenuStatus($data,$id,$whereRoleId = null)
		{
			$res = $this->db->select('parent_id')->get_where($this->categoryTbl,array('id'=>$id))->row();
			if($res)
			{
				$parent_id = $res->parent_id;
				if($parent_id)
				{
					$is_menu_res = $this->db->select('is_menu')->get_where($this->categoryTbl,array('id'=>$parent_id,'is_menu'=>1))->row();
					if(empty($is_menu_res))
					{
						return 2;
					}
					else
					{
						if($whereRoleId)
						{
							$this->db->where('role_id',$whereRoleId);
						}
						$this->db->where('id', $id);
						$this->db->update($this->categoryTbl, $data);
						$query =  $this->db->affected_rows(); 
						return $query;
					}
				}
				else
				{
					if($whereRoleId)
					{
						$this->db->where('role_id',$whereRoleId);
					}
					$this->db->where('id', $id);
					$this->db->update($this->categoryTbl, $data);
					$query =  $this->db->affected_rows(); 
					return $query;
				}
				
			}
			
		}
		
		function isSortingStatus($data,$id,$whereRoleId = null)
		{
			if($whereRoleId)
			{
				$this->db->where('role_id',$whereRoleId);
			}
			$this->db->where('id', $id);
			$this->db->update($this->categoryTbl, $data);
			$query =  $this->db->affected_rows(); 
			return $query;
		}
		
}
?>