<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Cms_model extends CI_Model{
    function __construct() {
        $this->cmsTbl = 'cms_pages'; 
    }
    /*
     * get rows from the cso teachers table
     */
	
		function getCMS()
		{	
			$page = $this->getPage();
			$num_of_records = $this->getNumRecord();
			$startlimit = ($page*$num_of_records)-$num_of_records;
			$endlimit = $page*$num_of_records;
			if(isset($_GET['cms_name'])){
				$this->db->like($this->cmsTbl.'.name', $_GET['cms_name']);
			}
			if(isset($_GET['sort'])){
				$this->db->order_by($this->cmsTbl.".name", $_GET['sort']);
			}
			if(isset($_GET['entry'])){
				$this->db->limit($_GET['entry'],$startlimit);
			}
			else{
				$this->db->limit(LIMIT,$startlimit);
			}
			$query = $this->db->get($this->cmsTbl)->result(); 
			return $query; 	
		}
		
		
		/*     Get Single CMS      */
		
		function getAllCMS()
		{	
			$query = $this->db->get_where($this->cmsTbl)->result();
			return $query;	
		}
		
		function getPage(){
			$page = null!==$this->input->get('page')?$this->input->get('page'):1; 	
			return $page;
		}
		
		function getNumRecord(){
			if(isset($_GET['entry'])){
				$numrecord = null!==$this->input->get('numrecord')?$this->input->get('numrecord'):$_GET['entry']; 
			}else{
				$numrecord = null!==$this->input->get('numrecord')?$this->input->get('numrecord'):LIMIT; 
			}
				
			return $numrecord;
		}
		
		function totalCount(){
			if(isset($_GET['cms_name'])){
				$this->db->like('name', $_GET['cms_name']);
			}
			return $this->db->count_all_results($this->cmsTbl);
		}
		
		
		/*     Insert CMS      */
		
		function insertCMS($data)
		{
			 if(!array_key_exists("created",$data)){
				$data['created_at'] = date("Y-m-d H:i:s");
			}
			$this->db->insert($this->cmsTbl, $data);
			$id = $this->db->insert_id();
			
			 
			return  $id;
			 
			
		}
		
		
		
		/*     Get Single CMS      */
		
		function getSingleCMS($id)
		{	
			$query = $this->db->get_where($this->cmsTbl,array('id'=>$id))->row();
			return $query;	
		}
		
		
		
		
		/*     Update Single CMS      */
		
		function updateCMS($data,$id)
		{
			
			$this->db->where('id', $id);
			$this->db->update($this->cmsTbl, $data);
			$query =  $this->db->affected_rows(); 
			return $query;
		}
		
		
		function delete($id)
		{
			$this->db->where('id', $id);
			$this->db->delete($this->cmsTbl);
		}
		
		function update_status($data,$id)
		{
			
			$this->db->where('id', $id);
			$this->db->update($this->cmsTbl, $data);
			$query =  $this->db->affected_rows(); 
			return $query;
		}
		
		function url_recursive($id,$url)
		{
			$res = $this->db->get_where($this->cmsTbl,array('id'=>$id))->row();
			if($res)
			{
				$parent_id = $res->parent_id;
				$name = str_replace(' ','_',strtolower($res->name));
				
				if($parent_id)
				{
					$url .= $name.'/';
					$this->url_recursive($parent_id,$url);
				}
				else
				{
					
					$url .= $name;
					$url = array_reverse(explode('/',$url),true);
					$url = implode('/',$url);
					$this->url_complete($url);
					
				}
				// return $url;
				
			}
			
			
		}
		
		
		
		function url_complete($url)
		{
			print_r($url);
		}
		
		
}
?>