<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Category_model extends CI_Model{
    function __construct() {
        $this->categoryTbl = 'categories'; 
    }
    /*
     * get rows from the cso teachers table
     */
	
		function getCategory($whereRoleId = null)
		{	
			$page = $this->getPage();
			$num_of_records = $this->getNumRecord();
			$startlimit = ($page*$num_of_records)-$num_of_records;
			$endlimit = $page*$num_of_records;
			if(isset($_GET['categori'])){
				$this->db->like($this->categoryTbl.'.name', $_GET['categori']);
				$this->db->or_like($this->categoryTbl.'.url', $_GET['categori']);
				$this->db->or_like($this->categoryTbl.'.short_description', $_GET['categori']);
			}
			if($whereRoleId)
			{
				$this->db->where($this->categoryTbl.'.role_id', $whereRoleId);
			}
			if(isset($_GET['sort'])){
				$this->db->order_by($this->categoryTbl.".name", $_GET['sort']);
			}
			if(isset($_GET['entry'])){
				$this->db->limit($_GET['entry'],$startlimit);
			}
			else{
				$this->db->limit(LIMIT,$startlimit);
			}
			$query = $this->db->get($this->categoryTbl)->result(); 
			return $query; 	
		}
		
		
		/*     Get Single Category      */
		
		function getAllCategory($whereRoleId = null)
		{	
			if($whereRoleId)
			{
				$query = $this->db->get_where($this->categoryTbl,array('role_id'=>$whereRoleId))->result();
			}
			else{
				$query = $this->db->get_where($this->categoryTbl)->result();
			}
			
			return $query;	
		}
		
		function getPage(){
			$page = null!==$this->input->get('page')?$this->input->get('page'):1; 	
			return $page;
		}
		
		function getNumRecord(){
			if(isset($_GET['entry'])){
				$numrecord = null!==$this->input->get('numrecord')?$this->input->get('numrecord'):$_GET['entry']; 
			}else{
				$numrecord = null!==$this->input->get('numrecord')?$this->input->get('numrecord'):LIMIT; 
			}
				
			return $numrecord;
		}
		
		function totalCount($whereRoleId = null){
			if(isset($_GET['categori'])){
				$this->db->like('name', $_GET['categori']);
				$this->db->or_like($this->categoryTbl.'.url', $_GET['categori']);
				$this->db->or_like($this->categoryTbl.'.short_description', $_GET['categori']);
			}
			if($whereRoleId)
			{
				$this->db->where($this->categoryTbl.'.role_id', $whereRoleId);
			}
			return $this->db->count_all_results($this->categoryTbl);
		}
		
		
		/*     Insert Category      */
		
		function insertCategory($data)
		{
			 if(!array_key_exists("created",$data)){
				$data['created_at'] = date("Y-m-d H:i:s");
			}
			$this->db->insert($this->categoryTbl, $data);
			$id = $this->db->insert_id();
			
			 
			return  $id;
			 
			
		}
		
		
		
		/*     Get Single Category      */
		
		function getSingleCategory($id,$whereRoleId = null)
		{	
			if($whereRoleId)
			{
				$query = $this->db->get_where($this->categoryTbl,array('id'=>$id,'role_id'=>$whereRoleId))->row();
			}
			else
			{
				$query = $this->db->get_where($this->categoryTbl,array('id'=>$id))->row();
			}
			
			return $query;	
		}
		
		
		
		
		/*     Update Single Category      */
		
		function updateCategory($data,$id,$whereRoleId = null)
		{
			
			$this->db->where('id', $id);
			$this->db->update($this->categoryTbl, $data);
			$query =  $this->db->affected_rows(); 
			return $query;
		}
		
		
		function delete($id,$whereRoleId = null)
		{
			if($whereRoleId)
			{
				$this->db->where('role_id',$whereRoleId);
			}
			$this->db->where('id', $id);
			$query = $this->db->delete($this->categoryTbl);
			$query =  $this->db->affected_rows(); 
			return $query;
		}
		
		function update_status($data,$id,$whereRoleId = null)
		{
			if($whereRoleId)
			{
				$this->db->where('role_id',$whereRoleId);
			}
			$this->db->where('id', $id);
			$this->db->update($this->categoryTbl, $data);
			$query =  $this->db->affected_rows(); 
			return $query;
		}
		
		function url_recursive($id,$url)
		{
			$res = $this->db->get_where($this->categoryTbl,array('id'=>$id))->row();
			if($res)
			{
				$parent_id = $res->parent_id;
				$name = str_replace(' ','-',strtolower($res->name));
				
				if($parent_id)
				{
					$url .= $name.'/';
					$this->url_recursive($parent_id,$url);
				}
				else
				{
					$url .= $name;
					$url = array_reverse(explode('/',$url),true);
					$url = implode('/',$url);
					$this->url_complete($url);
					
				}
				// return $url;
				
			}
			
			
		}
		
		function getParentidBySlug($slug)
		{
			$res = $this->db->get_where($this->categoryTbl,array('url'=>'/'.$slug))->row();
			if($res)
			{
				return $res->role_id;
			}else{
				return false;
			}
		}
		
		function url_complete($url)
		{
			print_r($url);
		}
		
		
}
?>