<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Pava extends CI_Controller { 
    var $role_id;
	
    function __construct() {
        parent::__construct();
		$this->load->model('admin/pava_model');
		if(!$this->session->userdata('isAdminLoggedIn'))
		{
			 redirect('admin');
		}
		if($this->session->userdata('loginUserData')['role_id'] != 1)
		{
			$this->role_id = $this->session->userdata('loginUserData')['role_id'];
		}
		else
		{
			$this->role_id = 4;
		}
    }



	function index()
	{
		$data['pava'] = $this->pava_model->getPava($this->role_id); 
		// $data['totalCount'] = $this->pava_model->totalCount($this->role_id); 
		// $data['numrecord'] = $this->pava_model->getNumRecord();
		// $data['page'] = $this->pava_model->getPage();
		// $data['number_of_page'] = ceil($data['totalCount']/$data['numrecord']);
		$data['file']  = 'admin/pava/pava_view';
		$this->load->view('admin/template',$data);
	}
	
	
	function subPava()
	{
		$data['sub_pava'] = $this->pava_model->getSubPava($this->role_id); 
		$data['totalCount'] = $this->pava_model->totalCount($this->role_id); 
		$data['numrecord'] = $this->pava_model->getNumRecord();
		$data['page'] = $this->pava_model->getPage();
		$data['number_of_page'] = ceil($data['totalCount']/$data['numrecord']);
		$data['file']  = 'admin/pava/subpava_view';
		$this->load->view('admin/template',$data);
	}
	

	function addPava()
	{
		if($this->input->post('submit'))
		{
			/* echo "<pre>";
			print_r($_FILES);
			echo "<pre>";
			print_r($_POST);die;  */
			
			$this->form_validation->set_rules('pava_heading','Pava Heading','trim|required|xss_clean');
			$this->form_validation->set_rules('pava_sub_heading','Pava Sub Heading','trim|required|xss_clean');	
			$this->form_validation->set_rules('pava_description','Pava Description','trim|required|xss_clean');	
			$this->form_validation->set_rules('pava_product_title','Pava Product Title','trim|required|xss_clean');	
			$this->form_validation->set_rules('pava_product_sub_title','Pava Product Sub Title','trim|required|xss_clean');	
			$this->form_validation->set_rules('pava_product_description','Pava Product Description','trim|required|xss_clean');	
			$this->form_validation->set_rules('pava_application_title','Pava Product Application Title','trim|required|xss_clean');	
			$this->form_validation->set_rules('pava_sub_application_title','Pava Product Application Sub Title','trim|required|xss_clean');	
			$this->form_validation->set_rules('pava_project_title','Pava Project Title','trim|required|xss_clean');	
			$this->form_validation->set_rules('pava_project_sub_title','Pava Project Sub Title','trim|required|xss_clean');	
			$this->form_validation->set_rules('meta_title','Meta Title','trim|required|xss_clean');	
			$this->form_validation->set_rules('meta_keywords','Meta Keywords','trim|required|xss_clean');	
			$this->form_validation->set_rules('meta_description','Meta Description','trim|required|xss_clean');	
			
			if($this->form_validation->run() == false)
			{
				$data['pavas'] = $this->pava_model->getAllPava($this->role_id); 
				$data['file']  = 'admin/pava/pava_add';
				$this->load->view('admin/template',$data);
			}
			else
			{
				/* if(!empty($_FILES['application_image']['name']))
				{ */
					$application_data_array = array();
					$filesCount = count($_FILES['application_image']['name']);
					for($i = 0; $i < $filesCount; $i++)
					{
						if($_FILES['application_image']['name'][$i])
						{
							$_FILES['images']['name'] = $_FILES['application_image']['name'][$i];
							$_FILES['images']['type'] = $_FILES['application_image']['type'][$i];
							$_FILES['images']['tmp_name'] = $_FILES['application_image']['tmp_name'][$i];
							$_FILES['images']['error'] = $_FILES['application_image']['error'][$i];
							$_FILES['images']['size'] = $_FILES['application_image']['size'][$i];
							
								$uploadPath = 'uploads/pava/application/';
								$config['upload_path'] = $uploadPath;
								$config['allowed_types'] = 'gif|jpg|png|jpeg';
								$config['max_size']	= '52428800';
								/* $config['max_width']  = '1600';
								$config['max_height']  = '1200';  */
								/* $config['max_width']  = '1024';
								$config['max_height']  = '768'; */
								$config['file_name'] = time().''.$_FILES['images']['name']; 
								
								$this->load->library('upload', $config);
								$this->upload->initialize($config);
								if($this->upload->do_upload('images'))
								{
									$fileData = $this->upload->data();
									$applicationUploadData[$i]['name'] = $this->input->post('application_image_title')[$i];
									$applicationUploadData[$i]['pava_id'] = 1;
									$applicationUploadData[$i]['image'] = $fileData['file_name'];
									$applicationUploadData[$i]['sort_order'] = $this->input->post('application_sort_number')[$i];
									
									
								}
								else
								{
									//$error = array('error' => $this->upload->display_errors());
									$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Application Images not uploaded.</div>');
									redirect(base_url().'admin/pava/editPava/'.$id, 'refresh');
								}
						}
						else
						{
							$applicationUploadData[$i]['name'] = '';
							$applicationUploadData[$i]['pava_id'] = 1;
							$applicationUploadData[$i]['image'] = '';
							$applicationUploadData[$i]['sort_order'] = '';
						}
						
					}
					/* echo "<pre>";
					print_r($applicationUploadData);die; */
					
				// }
				
				
				if(!empty($_FILES['pava_project_image']['name']))
				{
					$config['upload_path'] = 'uploads/pava/project/';
					$config['allowed_types'] = 'jpg|jpeg|png|gif';
					$config['file_name'] = time().''.$_FILES['pava_project_image']['name'];
					
					//Load upload library and initialize configuration
					$this->load->library('upload',$config);
					$this->upload->initialize($config);
					
					if($this->upload->do_upload('pava_project_image')){
						$uploadData = $this->upload->data();
						$pava_project_image = $uploadData['file_name'];
					}
					else
					{
						$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Project Image not uploaded.</div>');
						redirect(base_url().'admin/pava/editPava/'.$id, 'refresh');
					}
				}
				else
				{
					$pava_project_image  = '';
				}
				
				$pava_data = array(
						'parent_id'=>0,
						'role_id'=>4,
						'pava_heading'=>$this->input->post('pava_heading'),
						'pava_sub_heading'=>$this->input->post('pava_sub_heading'),
						'pava_description'=>$this->input->post('pava_description'),
						'url'=>'/pava',
						'pava_product_title'=>$this->input->post('pava_product_title'),
						'pava_product_sub_title'=>$this->input->post('pava_product_sub_title'),
						'pava_product_description'=>$this->input->post('pava_product_description'),
						'pava_application_title'=>$this->input->post('pava_application_title'),
						'pava_sub_application_title'=>$this->input->post('pava_sub_application_title'),
						'pava_project_title'=>$this->input->post('pava_project_title'),
						'pava_project_sub_title'=>$this->input->post('pava_project_sub_title'),
						'pava_project_image'=>$pava_project_image,
						'meta_title'=>$this->input->post('meta_title'),
						'meta_keywords'=>$this->input->post('meta_keywords'),
						'meta_description'=>$this->input->post('meta_description'),
						'created_by'=>$this->session->userdata('userId'),
						'created_at'=>date('Y-m-d H:i:s'),
						'status'=>$this->input->post('status')
				);     
				
				$insert_id = $this->pava_model->insertPava($pava_data);
				
				$application_data_update = $this->pava_model->updatePavaApplicationData($applicationUploadData,$insert_id);
			
				  if($insert_id)
				  {
					$this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Sub Category Pava added successfully.</div>');
					redirect(base_url().'admin/pava', 'refresh');
				  }
				  else
				  {
					$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Please Try Again...</div>');
					redirect(base_url().'admin/pava/addPava', 'refresh');
				  }
			}
		}
		else
		{
		   
			$data['pavas'] = $this->pava_model->getAllPava($this->role_id); 
			$data['file']  = 'admin/pava/pava_add';
			$this->load->view('admin/template',$data);
		}
	}
	
	
	function addSubPava()
	{
		
		if($this->input->post('submit'))
		{
			/* echo "<pre>";
			print_r($_FILES); */
			/* echo "<pre>";
			print_r($_POST);die;  */
			//Check whether user upload picture
			
			$this->form_validation->set_rules('pava_sub_category_title','Pava Sub Category Name','trim|required|xss_clean');	
			$this->form_validation->set_rules('parent_id','Parent Pava','trim|required|xss_clean');	
			$this->form_validation->set_rules('pava_sub_category_short_description','Pava Sub Category Short Description','trim|required|xss_clean');	
			$this->form_validation->set_rules('pava_sub_category_description','Pava Sub Category Long Description','trim|required|xss_clean');	
			$this->form_validation->set_rules('pava_product_title','Pava Sub Category Product Title','trim|required|xss_clean');	
			$this->form_validation->set_rules('pava_product_sub_title','Pava Sub Category Product Sub Title','trim|required|xss_clean');	
			$this->form_validation->set_rules('meta_title','Meta Title','trim|required|xss_clean');	
			$this->form_validation->set_rules('meta_keywords','Meta Keywords','trim|required|xss_clean');	
			$this->form_validation->set_rules('meta_description','Meta Description','trim|required|xss_clean');	
				
				
			//$this->form_validation->set_rules('image','Image','trim|required|xss_clean');	
			if($this->form_validation->run() == false)
			{
				$data['pavas'] = $this->pava_model->getAllPava($this->role_id); 
				$data['file']  = 'admin/pava/subpava_add';
				$this->load->view('admin/template',$data);
			}
			else
			{
				
				$application_data_array = array();
				if(isset($_FILES['application_image']))
				{
					$filesCount = count($_FILES['application_image']['name']);
					for($i = 0; $i < $filesCount; $i++)
					{
						if($_FILES['application_image']['name'][$i])
						{
							$_FILES['images']['name'] = $_FILES['application_image']['name'][$i];
							$_FILES['images']['type'] = $_FILES['application_image']['type'][$i];
							$_FILES['images']['tmp_name'] = $_FILES['application_image']['tmp_name'][$i];
							$_FILES['images']['error'] = $_FILES['application_image']['error'][$i];
							$_FILES['images']['size'] = $_FILES['application_image']['size'][$i];
							
								$uploadPath = 'uploads/pava/application/';
								$config['upload_path'] = $uploadPath;
								$config['allowed_types'] = 'gif|jpg|png|jpeg';
								$config['max_size']	= '52428800';
								/* $config['max_width']  = '1600';
								$config['max_height']  = '1200';  */
								/* $config['max_width']  = '1024';
								$config['max_height']  = '768'; */
								$config['file_name'] = time().''.$_FILES['images']['name']; 
								
								$this->load->library('upload', $config);
								$this->upload->initialize($config);
								if($this->upload->do_upload('images'))
								{
									$fileData = $this->upload->data();
									$applicationUploadData[$i]['name'] = $this->input->post('application_image_title')[$i];
									$applicationUploadData[$i]['pava_id'] = 1;
									$applicationUploadData[$i]['image'] = $fileData['file_name'];
									$applicationUploadData[$i]['sort_order'] = $this->input->post('application_sort_number')[$i];
									
									
								}
								else
								{
									//$error = array('error' => $this->upload->display_errors());
									$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Application Images not uploaded.</div>');
									redirect(base_url().'admin/pava/editPava/'.$id, 'refresh');
								}
						}
						else
						{
							$applicationUploadData[$i]['name'] = $this->input->post('application_image_title')[$i];
							$applicationUploadData[$i]['pava_id'] = 1;
							$applicationUploadData[$i]['image'] = $this->input->post('application_image_pic')[$i];
							$applicationUploadData[$i]['sort_order'] = $this->input->post('application_sort_number')[$i];
						}
						
					}
				}
				else
				{
					$applicationUploadData = array();
				}
				
				
				if(!empty($_FILES['pava_sub_category_image']['name']))
				{
					$config['upload_path'] = 'uploads/pava/category/';
					$config['allowed_types'] = 'jpg|jpeg|png|gif';
					$config['file_name'] = time().''.$_FILES['pava_sub_category_image']['name'];
					
					//Load upload library and initialize configuration
					$this->load->library('upload',$config);
					$this->upload->initialize($config);
					
					if($this->upload->do_upload('pava_sub_category_image')){
						$uploadData = $this->upload->data();
						$image = $uploadData['file_name'];
					}
					else
					{
						$image = '';
					}
				}
				else
				{
					$image = '';
				}
					
					if($this->role_id == 0)
					{
						$url = explode('/',$this->input->post('url'));
						$parent_slug = $url[1];
						$res = $this->pava_model->getParentidBySlug($parent_slug);
						if($res)
						{
							$this->role_id = $res;
						}
					}
					
					if(null !== $this->input->post('is_home'))
					{
						$is_home = $this->input->post('is_home');
					}else{
						$is_home = 0;
					}
				
					$pava_data = array(
						'name'=>$this->input->post('pava_sub_category_title'),
						'parent_id'=>$this->input->post('parent_id'),
						'role_id'=>$this->role_id,
						'url'=>$this->input->post('url'),
						'pava_sub_category_title'=>$this->input->post('pava_sub_category_title'),
						'is_home'=>$is_home,
						'pava_sub_category_short_description'=>$this->input->post('pava_sub_category_short_description'),
						'pava_sub_category_description'=>$this->input->post('pava_sub_category_description'),
						'pava_application_title'=>$this->input->post('pava_application_title'),
						'pava_sub_application_title'=>$this->input->post('pava_sub_application_title'),
						'pava_product_title'=>$this->input->post('pava_product_title'),
						'pava_product_sub_title'=>$this->input->post('pava_product_sub_title'),
						'meta_title'=>$this->input->post('meta_title'),
						'meta_keywords'=>$this->input->post('meta_keywords'),
						'meta_description'=>$this->input->post('meta_description'),
						'created_by'=>$this->session->userdata('userId'),
						'created_at'=>date('Y-m-d H:i:s'),
						'updated_at'=>date('Y-m-d H:i:s'),
						'pava_sub_category_image'=>$image,
						'status'=>$this->input->post('status')
					);    
						   
				$insert_id = $this->pava_model->insertPava($pava_data);
				
				$application_data_update = $this->pava_model->updatePavaApplicationData($applicationUploadData,$insert_id);
			
				  if($insert_id)
				  {
					$this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Sub Category Pava added successfully.</div>');
					redirect(base_url().'admin/pava/subPava', 'refresh');
				  }
				  else
				  {
					$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Please Try Again...</div>');
					redirect(base_url().'admin/pava/addSubPava', 'refresh');
				  }
				
				
			}
		}
		else
		{
			$data['pavas'] = $this->pava_model->getAllPava($this->role_id); 
			$data['file']  = 'admin/pava/subpava_add';
			$this->load->view('admin/template',$data);
		}
	}

	function editPava($id)
	{
		// $data['categori'] = $this->pava_model->getAllPava($this->role_id); 
		$data['pava'] = $this->pava_model->getSinglePava($id,$this->role_id);
		$data['application_pava'] = $this->pava_model->getPavaApplicationData($id);
		$data['file']  = 'admin/pava/pava_edit';
		$this->load->view('admin/template',$data);
	}
	
	
	function editSubPava($id)
	{
		$data['categori'] = $this->pava_model->getAllPava($this->role_id); 
		$data['subpava'] = $this->pava_model->getSinglePava($id,$this->role_id);
		$data['application_pava'] = $this->pava_model->getPavaApplicationData($id);
		$data['file']  = 'admin/pava/subpava_edit';
		$this->load->view('admin/template',$data);
	}

	function updatePava($id)
	{
	
		if ($this->input->post('submit')) 
		{
			/* echo "<pre>";
			print_r($_FILES);
			echo "<pre>";
			print_r($_POST);die; */		
			
			$this->form_validation->set_rules('pava_heading','Pava Heading','trim|required|xss_clean');
			$this->form_validation->set_rules('pava_sub_heading','Pava Sub Heading','trim|required|xss_clean');	
			$this->form_validation->set_rules('pava_description','Pava Description','trim|required|xss_clean');	
			$this->form_validation->set_rules('pava_product_title','Pava Product Title','trim|required|xss_clean');	
			$this->form_validation->set_rules('pava_product_sub_title','Pava Product Sub Title','trim|required|xss_clean');	
			$this->form_validation->set_rules('pava_product_description','Pava Product Description','trim|required|xss_clean');	
			$this->form_validation->set_rules('pava_application_title','Pava Product Application Title','trim|required|xss_clean');	
			$this->form_validation->set_rules('pava_sub_application_title','Pava Product Application Sub Title','trim|required|xss_clean');	
			$this->form_validation->set_rules('pava_project_title','Pava Project Title','trim|required|xss_clean');	
			$this->form_validation->set_rules('pava_project_sub_title','Pava Project Sub Title','trim|required|xss_clean');	
			$this->form_validation->set_rules('meta_title','Meta Title','trim|required|xss_clean');	
			$this->form_validation->set_rules('meta_keywords','Meta Keywords','trim|required|xss_clean');	
			$this->form_validation->set_rules('meta_description','Meta Description','trim|required|xss_clean');				
				
			if($this->form_validation->run() == false)
			{
				// $data['categori'] = $this->pava_model->getAllPava($this->role_id); 
				$data['pava'] = $this->pava_model->getSinglePava($id,$this->role_id);	
				$data['application_pava'] = $this->pava_model->getPavaApplicationData($id);
				$data['file']  = 'admin/pava/pava_edit';
				$this->load->view('admin/template',$data);
			}
			else
			{
				/* if(!empty($_FILES['application_image']['name']))
				{ */
					$application_data_array = array();
					$filesCount = count($_FILES['application_image']['name']);
					for($i = 0; $i < $filesCount; $i++)
					{
						if($_FILES['application_image']['name'][$i])
						{
							$_FILES['images']['name'] = $_FILES['application_image']['name'][$i];
							$_FILES['images']['type'] = $_FILES['application_image']['type'][$i];
							$_FILES['images']['tmp_name'] = $_FILES['application_image']['tmp_name'][$i];
							$_FILES['images']['error'] = $_FILES['application_image']['error'][$i];
							$_FILES['images']['size'] = $_FILES['application_image']['size'][$i];
							
								$uploadPath = 'uploads/pava/application/';
								$config['upload_path'] = $uploadPath;
								$config['allowed_types'] = 'gif|jpg|png|jpeg';
								$config['max_size']	= '52428800';
								/* $config['max_width']  = '1600';
								$config['max_height']  = '1200';  */
								/* $config['max_width']  = '1024';
								$config['max_height']  = '768'; */
								$config['file_name'] = time().''.$_FILES['images']['name']; 
								
								$this->load->library('upload', $config);
								$this->upload->initialize($config);
								if($this->upload->do_upload('images'))
								{
									$fileData = $this->upload->data();
									$applicationUploadData[$i]['name'] = $this->input->post('application_image_title')[$i];
									$applicationUploadData[$i]['pava_id'] = 1;
									$applicationUploadData[$i]['image'] = $fileData['file_name'];
									$applicationUploadData[$i]['sort_order'] = $this->input->post('application_sort_number')[$i];
									
									
								}
								else
								{
									//$error = array('error' => $this->upload->display_errors());
									$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Application Images not uploaded.</div>');
									redirect(base_url().'admin/pava/editPava/'.$id, 'refresh');
								}
						}
						else
						{
							$applicationUploadData[$i]['name'] = $this->input->post('application_image_title')[$i];
							$applicationUploadData[$i]['pava_id'] = 1;
							$applicationUploadData[$i]['image'] = $this->input->post('application_image_pic')[$i];
							$applicationUploadData[$i]['sort_order'] = $this->input->post('application_sort_number')[$i];
						}
						
					}
					/* echo "<pre>";
					print_r($applicationUploadData);die; */
					
				// }
				
				
				if(!empty($_FILES['pava_project_image']['name']))
				{
					$config['upload_path'] = 'uploads/pava/project/';
					$config['allowed_types'] = 'jpg|jpeg|png|gif';
					$config['file_name'] = time().''.$_FILES['pava_project_image']['name'];
					
					//Load upload library and initialize configuration
					$this->load->library('upload',$config);
					$this->upload->initialize($config);
					
					if($this->upload->do_upload('pava_project_image')){
						$uploadData = $this->upload->data();
						$pava_project_image = $uploadData['file_name'];
					}
					else
					{
						$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Project Image not uploaded.</div>');
						redirect(base_url().'admin/pava/editPava/'.$id, 'refresh');
					}
				}
				else
				{
					$pava_project_image  = $this->input->post('project_image_pic');
				}
				
				$pava_data = array(
						'parent_id'=>0,
						'role_id'=>4,
						'pava_heading'=>$this->input->post('pava_heading'),
						'pava_sub_heading'=>$this->input->post('pava_sub_heading'),
						'pava_description'=>$this->input->post('pava_description'),
						'url'=>'/pava',
						'pava_product_title'=>$this->input->post('pava_product_title'),
						'pava_product_sub_title'=>$this->input->post('pava_product_sub_title'),
						'pava_product_description'=>$this->input->post('pava_product_description'),
						'pava_application_title'=>$this->input->post('pava_application_title'),
						'pava_sub_application_title'=>$this->input->post('pava_sub_application_title'),
						'pava_project_title'=>$this->input->post('pava_project_title'),
						'pava_project_sub_title'=>$this->input->post('pava_project_sub_title'),
						'pava_project_image'=>$pava_project_image,
						'meta_title'=>$this->input->post('meta_title'),
						'meta_keywords'=>$this->input->post('meta_keywords'),
						'meta_description'=>$this->input->post('meta_description'),
						'created_by'=>$this->session->userdata('userId'),
						'created_at'=>date('Y-m-d H:i:s'),
						'status'=>$this->input->post('status')
				);     
				
				$data_update = $this->pava_model->updatePava($pava_data,$id);
				$application_data_update = $this->pava_model->updatePavaApplicationData($applicationUploadData,$id);
				  if($data_update > 0)
				  {
					 $this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Pava updated successfully.</div>');
					 redirect(base_url().'admin/pava/', 'refresh');
				  }
				  else
				  {
					$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Please Try Again...</div>');
				   redirect(base_url().'admin/pava/editPava/'.$id, 'refresh');
				  }
			}
		}
		else
		{
		   
		   redirect(base_url().'admin/pava');
		}
	}
	
	
	function updateSubPava($id)
	{
		if ($this->input->post('submit')) 
		{
			/* echo "<pre>";
			print_r($_POST);die;  */
			//Check whether user upload picture
			
			$this->form_validation->set_rules('pava_sub_category_title','Pava Sub Category Name','trim|required|xss_clean');	
			$this->form_validation->set_rules('parent_id','Parent Pava','trim|required|xss_clean');	
			$this->form_validation->set_rules('pava_sub_category_short_description','Pava Sub Category Short Description','trim|required|xss_clean');	
			$this->form_validation->set_rules('pava_sub_category_description','Pava Sub Category Long Description','trim|required|xss_clean');	
			$this->form_validation->set_rules('pava_product_title','Pava Sub Category Product Title','trim|required|xss_clean');	
			$this->form_validation->set_rules('pava_product_sub_title','Pava Sub Category Product Sub Title','trim|required|xss_clean');	
			$this->form_validation->set_rules('meta_title','Meta Title','trim|required|xss_clean');	
			$this->form_validation->set_rules('meta_keywords','Meta Keywords','trim|required|xss_clean');	
			$this->form_validation->set_rules('meta_description','Meta Description','trim|required|xss_clean');	
				
				
			//$this->form_validation->set_rules('image','Image','trim|required|xss_clean');	
			if($this->form_validation->run() == false)
			{
				$data['categori'] = $this->pava_model->getAllPava($this->role_id); 
				$data['subpava'] = $this->pava_model->getSinglePava($id,$this->role_id);
				$data['file']  = 'admin/pava/subpava_edit';
				$this->load->view('admin/template',$data);
			}
			else
			{
				
				$application_data_array = array();
				$filesCount = count($_FILES['application_image']['name']);
				for($i = 0; $i < $filesCount; $i++)
				{
					if($_FILES['application_image']['name'][$i])
					{
						$_FILES['images']['name'] = $_FILES['application_image']['name'][$i];
						$_FILES['images']['type'] = $_FILES['application_image']['type'][$i];
						$_FILES['images']['tmp_name'] = $_FILES['application_image']['tmp_name'][$i];
						$_FILES['images']['error'] = $_FILES['application_image']['error'][$i];
						$_FILES['images']['size'] = $_FILES['application_image']['size'][$i];
						
							$uploadPath = 'uploads/pava/application/';
							$config['upload_path'] = $uploadPath;
							$config['allowed_types'] = 'gif|jpg|png|jpeg';
							$config['max_size']	= '52428800';
							/* $config['max_width']  = '1600';
							$config['max_height']  = '1200';  */
							/* $config['max_width']  = '1024';
							$config['max_height']  = '768'; */
							$config['file_name'] = time().''.$_FILES['images']['name']; 
							
							$this->load->library('upload', $config);
							$this->upload->initialize($config);
							if($this->upload->do_upload('images'))
							{
								$fileData = $this->upload->data();
								$applicationUploadData[$i]['name'] = $this->input->post('application_image_title')[$i];
								$applicationUploadData[$i]['pava_id'] = 1;
								$applicationUploadData[$i]['image'] = $fileData['file_name'];
								$applicationUploadData[$i]['sort_order'] = $this->input->post('application_sort_number')[$i];
								
								
							}
							else
							{
								//$error = array('error' => $this->upload->display_errors());
								$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Application Images not uploaded.</div>');
								redirect(base_url().'admin/pava/editPava/'.$id, 'refresh');
							}
					}
					else
					{
						$applicationUploadData[$i]['name'] = $this->input->post('application_image_title')[$i];
						$applicationUploadData[$i]['pava_id'] = 1;
						$applicationUploadData[$i]['image'] = $this->input->post('application_image_pic')[$i];
						$applicationUploadData[$i]['sort_order'] = $this->input->post('application_sort_number')[$i];
					}
					
				}
				
				if(!empty($_FILES['pava_sub_category_image']['name']))
				{
					$config['upload_path'] = 'uploads/pava/category/';
					$config['allowed_types'] = 'jpg|jpeg|png|gif';
					$config['file_name'] = time().''.$_FILES['pava_sub_category_image']['name'];
					
					//Load upload library and initialize configuration
					$this->load->library('upload',$config);
					$this->upload->initialize($config);
					
					if($this->upload->do_upload('pava_sub_category_image')){
						$uploadData = $this->upload->data();
						$image = $uploadData['file_name'];
					}
					else
					{
						$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Sub Category Image not uploaded.</div>');
						redirect(base_url().'admin/pava/editSubPava/'.$id, 'refresh');
					}
				}
				else
				{
					$image = $this->input->post('sub_category_image_pic');
				}
					
					if($this->role_id == 0)
					{
						$url = explode('/',$this->input->post('url'));
						$parent_slug = $url[1];
						$res = $this->pava_model->getParentidBySlug($parent_slug);
						if($res)
						{
							$this->role_id = $res;
						}
					}
					
					if(null !== $this->input->post('is_home'))
					{
						$is_home = $this->input->post('is_home');
					}else{
						$is_home = 0;
					}
				
					$pava_data = array(
						'name'=>$this->input->post('pava_sub_category_title'),
						'parent_id'=>$this->input->post('parent_id'),
						'role_id'=>$this->role_id,
						'url'=>$this->input->post('url'),
						'pava_sub_category_title'=>$this->input->post('pava_sub_category_title'),
						'is_home'=>$is_home,
						'pava_sub_category_short_description'=>$this->input->post('pava_sub_category_short_description'),
						'pava_sub_category_description'=>$this->input->post('pava_sub_category_description'),
						'pava_product_title'=>$this->input->post('pava_product_title'),
						'pava_product_sub_title'=>$this->input->post('pava_product_sub_title'),
						'pava_application_title'=>$this->input->post('pava_application_title'),
						'pava_sub_application_title'=>$this->input->post('pava_sub_application_title'),
						'meta_title'=>$this->input->post('meta_title'),
						'meta_keywords'=>$this->input->post('meta_keywords'),
						'meta_description'=>$this->input->post('meta_description'),
						'created_by'=>$this->session->userdata('userId'),
						'created_at'=>date('Y-m-d H:i:s'),
						'updated_at'=>date('Y-m-d H:i:s'),
						'pava_sub_category_image'=>$image,
						'status'=>$this->input->post('status')
					);    
						   
					$data_update = $this->pava_model->updatePava($pava_data,$id);
					
					$application_data_update = $this->pava_model->updatePavaApplicationData($applicationUploadData,$id);
				
			
				  if($data_update)
				  {
					$this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Sub Category Pava edited successfully.</div>');
					redirect(base_url().'admin/pava/subPava', 'refresh');
				  }
				  else
				  {
					$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Please Try Again...</div>');
					redirect(base_url().'admin/pava/editSubPava/'.$id, 'refresh');
				  }
				
				
			}
		}
		else
		{
			$data['categori'] = $this->pava_model->getAllPava($this->role_id); 
			$data['subpava'] = $this->pava_model->getSinglePava($id,$this->role_id);
			$data['file']  = 'admin/pava/subpava_edit';
			$this->load->view('admin/template',$data);
		}
	}
	
	
	public function deletePava($id)  
	{
		$res = $this->pava_model->delete($id,$this->role_id);
		
		if($res)
		{
			$this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Pava  deleted successfully!</div>');
		}
		else
		{	
			$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Please Try Again...</div>');
		}
		
	
		redirect(base_url().'admin/pava');
	}
	
	public function updatePavaStatus($id)  
	{
		$status = $this->input->post('status');
		$status_array = array('status'=>$status);
		$query = $this->pava_model->update_status($status_array,$id);
		if($query){
			echo 1;
		}else{
			echo 0;
		}
	}
	
	public function updatePavaIsHomeStatus($id)  
	{
		$is_home = $this->input->post('is_home');
		$status_array = array('is_home'=>$is_home);
		$query = $this->pava_model->update_status($status_array,$id);
		if($query){
			echo 1;
		}else{
			echo 0;
		}
	}
	
	
	
	function addUrl()
	{
		$parent_id = $this->input->post('parent_id');
		$pava_name = $this->input->post('pava_name');
		$url = '';
		$res = $this->pava_model->url_recursive($parent_id,$url);
		echo $res.'/'.$pava_name;
	}
}
?>