<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Patient extends MY_Controller { 
    var $adminUser;
    function __construct() {
        parent::__construct();
        $this->load->model('admin/patient_model');
        $this->load->model('admin/doctor_model');
        $this->load->model('admin/states_model');
		$this->load->library('send_mail');
		$this->lang->load('general_lang', 'english');
		if(!$this->session->userdata('isAdminLoggedIn'))
		{
			 redirect('admin');
		}
		if($this->session->userdata('loginUserData')){
		   $this->adminUser = $this->session->userdata('loginUserData');
		}
    }



	function index()
	{	
		$whereArray = array();
		$alias = "usr";
		$fields = array($alias.".id", $alias.".name", $alias.".email",$alias.".clinic_uid", $alias.'.phone', $alias.'.status', $alias.".state_id", $alias.".city_id", "st.name as state_name", "ct.name as city_name","cd.name as clinic_name","dt.duid as d_uid");
		if(null!==$this->input->get('name') && $this->input->get('name')!=""){
			$whereArray[$alias.'.name'] = $this->input->get('name');
		}
		if(null!==$this->input->get('email') && $this->input->get('email')!=""){
			$whereArray[$alias.'.email'] = $this->input->get('email');
		}
		if(null!==$this->input->get('clinic_uid') && $this->input->get('clinic_uid')!=""){
			$whereArray[$alias.'.clinic_uid'] = $this->input->get('clinic_uid');
		}
		if(null!==$this->input->get('phone') && $this->input->get('phone')!=""){
			$whereArray[$alias.'.phone'] = $this->input->get('phone');
		}
		if(null!==$this->input->get('state_id') && $this->input->get('state_id')!=""){
			$whereArray[$alias.'.state_id'] = $this->input->get('state_id');
		}
		if(null!==$this->input->get('city_id') && $this->input->get('city_id')!=""){
			$whereArray[$alias.'.city_id'] = $this->input->get('city_id');
		}
		if(null!==$this->input->get('clinic_id') && $this->input->get('clinic_id')!=""){
			$whereArray[$alias.'.clinic_id'] = $this->input->get('clinic_id');
		}
		if(null!==$this->input->get('status') && $this->input->get('status')!=""){
			$whereArray[$alias.'.status'] = $this->input->get('status');
		}
		if(null!==$this->input->get('d_uid') && $this->input->get('d_uid')!=""){
			$whereArray['dt.duid'] = $this->input->get('d_uid');
		}
		$orderby = array($alias.".id", "asc");
		$joins = array(array('states as st', 'st.id = '.$alias.'.state_id'),array('cities as ct', 'ct.id = '.$alias.'.city_id'),array('clinic_address as cd', 'cd.id = '.$alias.'.clinic_id'),array('doctor as dt', 'dt.id = '.$alias.'.doctor_id'));
		$where = array("where"=>$whereArray); 
		$data['patients'] = $this->patient_model->getPatient($fields,$where,$joins,$alias,"",$orderby);
		// echo "<pre>"; print_r($this->db->last_query()); echo "</pre>";		
		// echo "<pre>"; print_r($data['patient']); echo "</pre>";
		$data['totalCount'] = $this->patient_model->totalCount($fields,$where,$joins,$alias,"",$orderby); 
		// echo "<pre>"; print_r($this->db->last_query()); echo "</pre>";die;
		$data['numrecord'] = $this->patient_model->getNumRecord();
		$data['page'] = $this->patient_model->getPage();
		$data['filters'] = $this->getFilter();
		$data['number_of_page'] = ceil($data['totalCount']/$data['numrecord']);
		$data['file']  = 'admin/patient/patient_view';
		$this->load->view('admin/template',$data);
	}
	
	function getFilter(){
		$filter = array();
		$filter['name'] = array("field"=>"text", "values"=>"name");
		$filter['email'] = array("field"=>"text", "values"=>"email");
		$filter['clinic uid'] = array("field"=>"text", "values"=>"clinic_uid");
		$filter['doctor id'] = array("field"=>"text", "values"=>"d_uid");
		$filter['phone'] = array("field"=>"text", "values"=>"phone");
		// $filter['clinic_id'] = array("field"=>"select","values"=>$this->patient_model->getClinicAddresses());
		// $filter['state_id'] = array("field"=>"select","values"=>$this->states_model->getStates());
		// $filter['city_id'] = array("field"=>"select","values"=>"");
		$filter['status'] = array("field"=>"select","values"=>array("0"=>"Disabled","1"=>"Enabled"));
		return $filter;
	}

	public function addPatient()
	{
		
		if($this->input->post('submit'))
		{
			//Check whether user upload picture
			
			$this->form_validation->set_rules('user_name','Patient Name','trim|required|xss_clean');	
			$this->form_validation->set_rules('user_email','Email','trim|required|valid_email|xss_clean|is_unique[patient.email]');
			// $this->form_validation->set_rules('clinic_uid','Clinic Uid','trim|required|xss_clean');
			$this->form_validation->set_rules('phone','Mobile Number','trim|required|xss_clean|is_unique[patient.phone]|numeric|max_length[10]');	
			$this->form_validation->set_rules('password','Password','trim|required|xss_clean');
			$this->form_validation->set_rules('confirm_password', 'Confirm Password', 'required|matches[password]');
			// $this->form_validation->set_rules('clinic_id','Select Clinic','trim|required|xss_clean');
			/*$this->form_validation->set_rules('address1','Address 1','trim|required|xss_clean');	
			$this->form_validation->set_rules('address2','Address 2','trim|required|xss_clean');	
			$this->form_validation->set_rules('state_id','Select State','trim|required|xss_clean');	
			$this->form_validation->set_rules('city_id','Select City','trim|required|xss_clean');	
			$this->form_validation->set_rules('pincode','Enter Pincode','trim|required|xss_clean|numeric|max_length[6]');	
			*/
				
			//$this->form_validation->set_rules('image','Image','trim|required|xss_clean');	
			if($this->form_validation->run() == false)
			{
				$state_id = $this->input->post('state_id');
				$data['clinic_address'] = $this->patient_model->getClinicAddresses(); 
				$data['states'] = $this->states_model->getStates();
				$data['cities'] = $this->states_model->getCities($state_id);	
				$data['file']  = 'admin/patient/patient_add';
				$this->load->view('admin/template',$data);
			}
			else
			{
				if(!empty($this->input->post('doc_id')) && !empty($this->input->post('clinic_uid')))
				{
					$array = array("duid"=>$this->input->post('doc_id'),"clinic_uid"=>$this->input->post('clinic_uid'));
					$doc_result = $this->doctor_model->getSingleDoctorData($array);
					if($doc_result)
					{
						$doc_id = $doc_result->id;
						$clinic_id = $doc_result->clinic_uid;
					}else{
						$this->session->set_flashdata('perror', "Doctor Id OR Clinic Id not Available.");   
						redirect(base_url().'admin/patient/addPatient', 'refresh');
					}
				}else if(!empty($this->input->post('clinic_uid')))
				{
					$array = array("clinic_uid"=>$this->input->post('clinic_uid'),"is_parent"=>0);
					$doc_result = $this->doctor_model->getSingleDoctorData($array);
					if($doc_result)
					{
						$doc_id = $doc_result->id;
						$clinic_id = $doc_result->clinic_uid;
					}else{
						$this->session->set_flashdata('perror', "Clinic Id not Available.");   
						redirect(base_url().'admin/patient/addPatient', 'refresh');
					}
				}else if(!empty($this->input->post('doc_id')))
				{
					$array = array("duid"=>$this->input->post('doc_id'));
					$doc_result = $this->doctor_model->getSingleDoctorData($array);
					if($doc_result)
					{
						$doc_id = $doc_result->id;
						$clinic_id = 1;
					}else{
						$this->session->set_flashdata('perror', "Doctor Id not Available.");   
						redirect(base_url().'admin/patient/addPatient', 'refresh');
					}
				}else{
					$doc_id = 1;
					$clinic_id = 1;
				}
				
				if(!empty($_FILES['image']['name']))
				{
					$config['upload_path'] = 'uploads/patient/';
					$config['allowed_types'] = 'jpg|jpeg|png|gif';
					$config['file_name'] = $_FILES['image']['name'];
					
					//Load upload library and initialize configuration
					$this->load->library('upload',$config);
					$this->upload->initialize($config);
					
					if($this->upload->do_upload('image')){
						$uploadData = $this->upload->data();
						$image = $uploadData['file_name'];
					}
					else
					{
						$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Image Not uploaded.Please Try Again...</div>');
						redirect(base_url().'admin/patient/addPatient', 'refresh');
					}
				}
				else
				{
					$image = '';
				}
				/* $permitted_chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
				$randompass = substr(str_shuffle($permitted_chars), 0, 8);
				$salt = strrev(substr($this->input->post('user_email'), 0, strpos($this->input->post('user_email'), '@'))); */
					$registration_data = array(
						'name'=>$this->input->post('user_name'),
						'email'=>$this->input->post('user_email'),
						'clinic_id'=>1,
						'doctor_id'=>$doc_id,
						'clinic_uid'=>$clinic_id,
						'phone'=>$this->input->post('phone'),
						'password'=>password_hash($this->input->post('password'), PASSWORD_DEFAULT),
						'p1'=>$this->input->post('password'),
						'address1'=>$this->input->post('address1'),
						'address2'=>$this->input->post('address2'),
						'state_id'=>$this->input->post('state_id'),
						'city_id'=>$this->input->post('city_id'),
						'pincode'=>$this->input->post('pincode'),
						'designation'=>$this->input->post('designation'),
						'created_by'=>$this->adminUser['id'],
						'created_at'=>date('Y-m-d H:i:s'),
						'updated_at'=>date('Y-m-d H:i:s'),
						'picture'=>$image,
						'status'=>$this->input->post('status'),
					);    
						   
				$insert_id = $this->patient_model->insertPatient($registration_data);
				
			
				  if($insert_id)
				  {
					/* $mailbody = 'Dear '.ucfirst($this->input->post('user_name')).'<p> Welcomes you on board!!</p>
							<p>Confirm your email address to get started.</p>
							<p>Your Account has been created. Credentials are given below </p>
							<p>Patientname:  <b>'.$this->input->post('user_email').'</b></p>
							<p>Password:  <b>'.$randompass.'</b></p>
							<p>Click here to  <a href="'.base_url("admin/login").'">Login</a></p>';
					$subject = "Account Created"; 		
					$mail = $this->send_mail->sendMail(array($this->input->post('user_email') => ucfirst($this->input->post('user_name'))),$mailbody,$subject);    */
					$this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Patient added successfully.</div>');
					redirect(base_url().'admin/patient/', 'refresh');
				  }
				  else
				  {
					$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Please Try Again...</div>');
					redirect(base_url().'admin/patient/addPatient', 'refresh');
				  }
				
				
			}
		}
		else
		{
			$data['clinic_address'] = $this->patient_model->getClinicAddresses(); 
			$data['states'] = $this->states_model->getStates();
			$data['cities'] = 0;
			$data['file']  = 'admin/patient/patient_add';
			$this->load->view('admin/template',$data);
		}
	}


	public function editPatient($id)
	{
		$data['clinic_address'] = $this->patient_model->getClinicAddresses(); 
		$data['patient'] = $this->patient_model->getSinglePatient($id);
		if(empty($data['patient']))
		{
			redirect(base_url().'admin/patient');
		}
		$data['doctor_user_details'] = $this->doctor_model->getSingleDoctor($data['patient']->doctor_id);
		$data['states'] = $this->states_model->getStates();
		if(!empty($data['patient']))
		{
			$data['cities'] = $this->states_model->getCities($data['patient']->state_id);;
		}else
		{
			$data['cities'] = 0;
		}
		
		$data['file']  = 'admin/patient/patient_edit';
		$this->load->view('admin/template',$data);
	}

	public function updatePatient($id)
	{
	
		if ($this->input->post('submit')) 
		{
			$this->form_validation->set_rules('user_name','Patient Name','trim|required|xss_clean');	
			$this->form_validation->set_rules('user_email','Email','trim|required|valid_email|xss_clean');
			$this->form_validation->set_rules('phone','Mobile Number','trim|required|xss_clean|numeric|max_length[10]');	
			/*$this->form_validation->set_rules('address1','Address 1','trim|required|xss_clean');	
			$this->form_validation->set_rules('address2','Address 2','trim|required|xss_clean');	
			$this->form_validation->set_rules('state_id','Select State','trim|required|xss_clean');	
			$this->form_validation->set_rules('city_id','Select City','trim|required|xss_clean');	
			$this->form_validation->set_rules('pincode','Enter Pincode','trim|required|xss_clean|numeric|max_length[6]');*/	
			 	
			// $this->form_validation->set_rules('password','Password','trim|required');	
			if($this->form_validation->run() == false)
			{
				$data['clinic_address'] = $this->patient_model->getClinicAddresses(); 
				$data['patient'] = $this->patient_model->getSinglePatient($id);
				$state_id = $this->input->post('state_id');
				$data['states'] = $this->states_model->getStates();
				$data['cities'] = $this->states_model->getCities($state_id);		
				$data['file']  = 'admin/patient/patient_edit';
				$this->load->view('admin/template',$data);
			}
			else
			{
				if(!empty($this->input->post('doc_id')) && !empty($this->input->post('clinic_uid')))
				{
					$array = array("duid"=>$this->input->post('doc_id'),"clinic_uid"=>$this->input->post('clinic_uid'));
					$doc_result = $this->doctor_model->getSingleDoctorData($array);
					if($doc_result)
					{
						$doc_id = $doc_result->id;
						$clinic_id = $doc_result->clinic_uid;
					}else{
						$this->session->set_flashdata('perror', "Doctor Id OR Clinic Id not Available.");   
						redirect(base_url().'admin/patient/editPatient/'.$id, 'refresh');
					}
				}else if(!empty($this->input->post('clinic_uid')))
				{
					$array = array("clinic_uid"=>$this->input->post('clinic_uid'),"is_parent"=>0);
					$doc_result = $this->doctor_model->getSingleDoctorData($array);
					if($doc_result)
					{
						$doc_id = $doc_result->id;
						$clinic_id = $doc_result->clinic_uid;
					}else{
						$this->session->set_flashdata('perror', "Clinic Id not Available.");   
						redirect(base_url().'admin/patient/editPatient/'.$id, 'refresh');
					}
				}else if(!empty($this->input->post('doc_id')))
				{
					$array = array("duid"=>$this->input->post('doc_id'));
					$doc_result = $this->doctor_model->getSingleDoctorData($array);
					if($doc_result)
					{
						$doc_id = $doc_result->id;
						$clinic_id = 1;
					}else{
						$this->session->set_flashdata('perror', "Doctor Id not Available.");   
						redirect(base_url().'admin/patient/editPatient/'.$id, 'refresh');
					}
				}else{
					$doc_id = 1;
					$clinic_id = 1;
				}
				
				
				if(!empty($_FILES['image']['name']))
				{
					$config['upload_path'] = 'uploads/patient/';
					$config['allowed_types'] = 'jpg|jpeg|png|gif';
					$config['file_name'] = $_FILES['image']['name'];
					
					//Load upload library and initialize configuration
					$this->load->library('upload',$config);
					$this->upload->initialize($config);
					
					if($this->upload->do_upload('image')){
						$uploadData = $this->upload->data();
						$image = $uploadData['file_name'];
					}
					else
					{
						$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Image not uploaded.Please Try Again...</div>');
						redirect(base_url().'admin/patient/editPatient/'.$id, 'refresh');
					}
				}
				else
				{
					$image = $this->input->post('patient_image');
				} 
				
					$update_data = array(
						'name'=>$this->input->post('user_name'),
						'clinic_id'=>1,
						'doctor_id'=>$doc_id,
						'clinic_uid'=>$clinic_id,
						// 'email'=>$this->input->post('user_email'),
						// 'phone'=>$this->input->post('phone'),
						// 'password'=>hash('sha256',$salt.$this->input->post('password')),
						'address1'=>$this->input->post('address1'),
						'address2'=>$this->input->post('address2'),
						'state_id'=>$this->input->post('state_id'),
						'city_id'=>$this->input->post('city_id'),
						'pincode'=>$this->input->post('pincode'),
						'designation'=>$this->input->post('designation'),
						'created_by'=>$this->adminUser['id'],
						// 'created_at'=>date('Y-m-d H:i:s'),
						'updated_at'=>date('Y-m-d H:i:s'),
						'picture'=>$image,
						//'status'=>$this->input->post('status'),
						// 'salt'=>$salt,
					);  
					 
			
				
			  
					// print_r($registration_data);die;
				
				$data_update = $this->patient_model->updatePatient($update_data,$id);
				
				  //$data_category = $this->user->update_category($data_cat,$id);
				  if($data_update > 0)
				  {
					 $this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Patient updated successfully.</div>');
					 redirect(base_url().'admin/patient/', 'refresh');
				  }
				  else
				  {
					$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Please Try Again...</div>');
				   redirect(base_url().'admin/patient/editPatient/'.$id, 'refresh');
				  }
			}
		}
		else
		{
		   
		   redirect(base_url().'admin/patient');
		}
	}
	
	
	public function deletePatient($id)  
	{
		$this->patient_model->delete($id);
	
		$this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Patient deleted successfully!</div>');
	
		redirect(base_url().'admin/patient');
	}
	
	public function updateStatus($id)  
	{
		$status = $this->input->post('status');
		$status_array = array('status'=>$status);
		$query = $this->patient_model->update_status($status_array,$id);
		if($query){
			echo 1;
		}else{
			echo 0;
		}
	}
	
	
	
	
	public function getPatientDetail($id){
		$alias = "usr";
		$fields = array($alias.".name", $alias.".email", $alias.'.phone',"dt.name as doctor_name","dt.clinic_name as clinic_name");
		$conditions = array("where"=>array($alias.".id"=>$id));
		$joins = array(array('states as st', 'st.id = '.$alias.'.state_id'),array('cities as ct', 'ct.id = '.$alias.'.city_id'),array('clinic_address as cd', 'cd.id = '.$alias.'.clinic_id'),array('doctor as dt', 'dt.id = '.$alias.'.doctor_id'));
		$userdata = $this->patient_model->getPatientData($fields,$conditions,$joins,$alias);
		if($userdata[0]!==null){
			/* if($userdata[0]->pincode==0){
				$userdata[0]->pincode = "";
		} */
		$singleuserdata = array();
			foreach($userdata[0] as $ukey=>$uvalue){
				//if($singleuserdata->$ukey=='status' && $uvalue==1){ $singleuserdata->$uvalue="Enabled"; }else{ $singleuserdata->$uvalue="Disabled"; }
				$singleuserdata[ucfirst(str_replace('_',' ',$ukey))] = ($ukey=="email")?$uvalue:ucfirst($uvalue);
				//print_r($ukey);
				//print_r($uvalue);
			}
			echo json_encode($singleuserdata);
		}else{
			echo 0;
		}
	}
	
	
	/*********************************reset password*******************************************************/
	public function resetpassword($id){
		$session = $this->adminUser;
		if($id){
			//echo "<pre>"; print_r($this->session->userdata); echo "</pre>";
			$this->form_validation->set_rules('password','Password','trim|required');
			$this->form_validation->set_rules('confirm_password','confirm_password','trim|required|matches[password]');
			$user = $this->patient_model->getSinglePatient($id);
			if($this->input->post('submit')){
				//echo "<pre>"; print_r($this->input->post()); echo "</pre>";
				if($this->form_validation->run() == false){
					$data = $this->input->post();	
					$data['id'] = $id;
					$data['file']  = 'admin/patient/reset_password';
					$this->load->view('admin/template',$data);
				}else{
					//echo "<pre>"; print_r($this->input->post()); echo "</pre>";
					//echo "<pre>"; print_r($user); echo "</pre>";
					// $salt = $user->salt;
					$password = password_hash($this->input->post('password'), PASSWORD_DEFAULT);
					$user_data = array("password"=>$password,"p1"=>$this->input->post('password'));
					if($user->password==$password){
						$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Please insert a new password...</div>');
						redirect(base_url().'admin/patient/resetpassword/'.$id, 'refresh');
					}
					$data_update = $this->patient_model->updatePatient($user_data,$id);
					if($data_update > 0)
					{	
						/*********************mail**body****************************/
						/* $subject = "New Password";
						$mailbody = 'Dear '.ucfirst($user->name).'<p>Your password has been changed</p>
							<p>Your new password is <b>'.$this->input->post('password').'</b>.</p>';
						$mail = $this->send_mail->sendMail(array($user->email => ucfirst($user->name)),$mailbody,$subject); */
						/*********************************************************/
						$this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Patient password updated successfully.</div>');
						redirect(base_url().'admin/patient/', 'refresh');
					}
					else
					{
						$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Please Try Again...</div>');
						redirect(base_url().'admin/patient/editPatient/'.$id, 'refresh');
					}
				}
				 
			}else{
				$data = array();
				$data['id'] = $user->id; 
				$data['email'] = $user->email; 
				$data['file']  = 'admin/patient/reset_password';
				$this->load->view('admin/template',$data);
			}	
			
			
		}else{
			redirect(base_url().'admin/dashboard', 'refresh');
		}
	}
	
	
	public function is_confirm_password_strong($password)
	{
	   if (preg_match('#[0-9]#', $password) && preg_match('#[a-zA-Z]#', $password)) {
		 return TRUE;
	   }
	   return FALSE;
	}
	
	/**************************************end*************************************************************/
}
?>