<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Messages extends CI_Controller { 
    
    function __construct() {
		echo "Under Construction";die;
        parent::__construct();
        $this->load->model('admin/users_model');
		if(!$this->session->userdata('isAdminLoggedIn'))
		{
			 redirect('admin');
		}
		elseif($this->session->userdata('loginUserData')['u_type_id'] != 4)
		{
			redirect(base_url().'admin/dashboard');
		}
    }



	function index()
	{
		$whereArray = array();
		$alias = "usr";
		$fields = array($alias.".i_user_id",$alias.".i_user_name",$alias.".i_points",$alias.".i_msg_count",$alias.".i_email_verified",$alias.".i_mobile_verified",$alias.".i_is_active", "ut.u_type_name as user_type_name");
		if(null!==$this->input->get('i_user_name') && $this->input->get('i_user_name')!=""){
			$whereArray[$alias.'.i_user_name'] = $this->input->get('i_user_name');
		}
		if(null!==$this->input->get('i_is_active') && $this->input->get('i_is_active')!=""){
			$whereArray[$alias.'.i_is_active'] = $this->input->get('i_is_active');
		}
		
		$orderby = array($alias.".i_user_id", "asc");
		$joins = array(array('user_types as ut', 'ut.u_type_id = '.$alias.'.i_user_type_id'));
		$where = array("where"=>$whereArray); 
		$data['users'] = $this->users_model->getMessages($fields,$where,$joins,$alias,"",$orderby);
		// echo "<pre>"; print_r($this->db->last_query()); echo "</pre>";	die;	
		// echo "<pre>"; print_r($data['patient']); echo "</pre>";
		$data['totalCount'] = $this->users_model->totalCount($fields,$where,$joins,$alias,"",$orderby); 
		// echo "<pre>"; print_r($this->db->last_query()); echo "</pre>";die;
		$data['numrecord'] = $this->users_model->getNumRecord();
		$data['page'] = $this->users_model->getPage();
		$data['filters'] = $this->getFilter();
		$data['number_of_page'] = ceil($data['totalCount']/$data['numrecord']);
		$data['file']  = 'admin/users/users_view';
		$this->load->view('admin/template',$data);	
		
	}
	
	function getFilter(){
		$filter = array();
		$filter['name'] = array("field"=>"text", "values"=>"i_user_name");
		$filter['i_is_active'] = array("field"=>"select","values"=>array("0"=>"Disabled","1"=>"Enabled"));
		return $filter;
	}
	

	public function addUser()
	{
		/* echo "<pre>";
		print_r($_POST);die; */
		
		if($this->input->post('submit'))
		{
			//Check whether user upload picture
			
			$this->form_validation->set_rules('user_name','User Name','trim|required|xss_clean');	
			$this->form_validation->set_rules('phone','Mobile Number','trim|required|xss_clean|is_unique[admin.phone]|numeric|max_length[10]');	
			$this->form_validation->set_rules('user_email','Email','trim|required|valid_email|xss_clean|is_unique[admin.email]');	
			$this->form_validation->set_rules('password','Password','trim|required');
			$this->form_validation->set_rules('confirm_password','Confirm Password','trim|required|matches[password]');	
			$this->form_validation->set_rules('role_id','Role','trim|required|xss_clean');	
				
			//$this->form_validation->set_rules('image','Image','trim|required|xss_clean');	
			if($this->form_validation->run() == false)
			{
				$data['roles'] = $this->users_model->getRoles(); 
				$data['file']  = 'admin/users/users_add';
				$this->load->view('admin/template',$data);
			}
			else
			{
				
				
				$salt = strrev(substr($this->input->post('user_email'), 0, strpos($this->input->post('user_email'), '@')));
					$registration_data = array(
						'name'=>$this->input->post('user_name'),
						'email'=>$this->input->post('user_email'),
						'phone'=>$this->input->post('phone'),
						'role_id'=>$this->input->post('role_id'),
						'password'=>hash('sha256',$salt.$this->input->post('password')),
						'p1'=>$this->input->post('password'),
						'created_by'=>$this->session->userdata('userId'),
						'created_at'=>date('Y-m-d H:i:s'),
						'updated_at'=>date('Y-m-d H:i:s'),
						// 'image'=>$image,
						'status'=>$this->input->post('status'),
						'salt'=>$salt,
					);    
						   
				$insert_id = $this->users_model->insertUser($registration_data);
				
			
				  if($insert_id)
				  {
					$this->session->set_flashdata('msg', '<div class="alert alert-success text-center">User added successfully.</div>');
					redirect(base_url().'admin/users/', 'refresh');
				  }
				  else
				  {
					$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Please Try Again...</div>');
					redirect(base_url().'admin/users/addUser', 'refresh');
				  }
				
				
			}
		}
		else
		{
			$data['roles'] = $this->users_model->getRoles(); 
			$data['file']  = 'admin/users/users_add';
			$this->load->view('admin/template',$data);
		}
	}

	public function editUser($id)
	{
		$data['roles'] = $this->users_model->getRoles(); 
		$data['users'] = $this->users_model->getSingleUser($id);
		$data['file']  = 'admin/users/users_edit';
		$this->load->view('admin/template',$data);
	}

	public function updateUser($id)
	{
	
		if ($this->input->post('submit')) 
		{
			$this->form_validation->set_rules('user_name','User Name','trim|required|xss_clean');	
			$this->form_validation->set_rules('role_id','Role','trim|required|xss_clean');
				
			if($this->form_validation->run() == false)
			{
				$data['roles'] = $this->users_model->getRoles(); 
				$data['users'] = $this->users_model->getSingleUser($id);	
				$data['file']  = 'admin/users/users_edit';
				$this->load->view('admin/template',$data);
			}
			else
			{
				
					$update_data = array(
						'name'=>$this->input->post('user_name'),
						// 'email'=>$this->input->post('user_email'),
						// 'phone'=>$this->input->post('phone'),
						// 'password'=>hash('sha256',$salt.$this->input->post('password')),
						'role_id'=>$this->input->post('role_id'),
						'created_by'=>$this->session->userdata('userId'),
						// 'created_at'=>date('Y-m-d H:i:s'),
						'updated_at'=>date('Y-m-d H:i:s'),
						// 'image'=>$image,
						'status'=>$this->input->post('status'),
						// 'salt'=>$salt,
					);  
				
				$data_update = $this->users_model->updateUser($update_data,$id);
				  if($data_update > 0)
				  {
					 $this->session->set_flashdata('msg', '<div class="alert alert-success text-center">User updated successfully.</div>');
					 redirect(base_url().'admin/users/', 'refresh');
				  }
				  else
				  {
					$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Please Try Again...</div>');
				   redirect(base_url().'admin/users/editUser/'.$id, 'refresh');
				  }
			}
		}
		else
		{
		   
		   redirect(base_url().'admin/users');
		}
	}
	
	
	public function deleteUser($id)  
	{
		$this->users_model->delete($id);
	
		$this->session->set_flashdata('msg', '<div class="alert alert-success text-center">User  deleted successfully!</div>');
	
		redirect(base_url().'admin/users');
	}
	
	public function updateUserStatus($id)  
	{
		$status = $this->input->post('status');
		$status_array = array('status'=>$status);
		$query = $this->users_model->update_status($status_array,$id);
		if($query){
			echo 1;
		}else{
			echo 0;
		}
	}
}
?>