<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Menu extends CI_Controller { 
    var $role_id;
	
    function __construct() {
        parent::__construct();
		$this->load->model('admin/menu_model');
		if(!$this->session->userdata('isAdminLoggedIn'))
		{
			 redirect('admin');
		}
		if($this->session->userdata('loginUserData')['role_id'] != 1)
		{
			$this->role_id = $this->session->userdata('loginUserData')['role_id'];
		}
		else
		{
			$this->role_id = 0;
		}
    }



	function index()
	{
		
		$data['menu'] = $this->menu_model->getParentCategory($this->role_id); 
		$data['totalCount'] = $this->menu_model->totalCount($this->role_id); 
		$data['numrecord'] = $this->menu_model->getNumRecord();
		$data['page'] = $this->menu_model->getPage();
		$data['number_of_page'] = ceil($data['totalCount']/$data['numrecord']);
		$data['file']  = 'admin/menu/menu_view';
		$this->load->view('admin/template',$data);
	}
	
	
	function addSubmenu($role_id = null)
	{
		if($role_id)
		{
			if($this->role_id)
			{
				if($this->role_id == $role_id)
				{
					$data['sub_menu'] = $this->menu_model->getSubCategory($role_id);
					// echo "<pre>";print_r($data['sub_menu']);die;
					$data['file']  = 'admin/menu/submenu_view';
					$this->load->view('admin/template',$data);
				}
				else
				{
					redirect(base_url().'admin/menu');
				}
			}
			else
			{
				$data['sub_menu'] = $this->menu_model->getSubCategory($role_id);
				// echo "<pre>";print_r($data['sub_menu']);die;
				$data['file']  = 'admin/menu/submenu_view';
				$this->load->view('admin/template',$data);	
			}
			
			
		}
		else
		{
			redirect(base_url().'admin/menu');
		}
		
	}
	

	
	
	public function updateMenuStatus()  
	{
		$id = $this->input->post('id');
		$is_type = $this->input->post('type');
		if($is_type == 'add')
		{
			$status_array = array('is_menu'=>1);
		}
		else{
			$status_array = array('is_menu'=>0);
		}
		
		$query = $this->menu_model->isMenuStatus($status_array,$id);
		if($query == 2){
			echo 2;
		}elseif($query){
			echo 1;
		}else{
			echo 0;
		}
	}
	
	function updateSorting()
	{
		$idWithSort = $this->input->post('ids');
		
		foreach($idWithSort as $k=>$v)
		{
			$idWithSort = explode('-',$v);
			/* echo "<pre>";
			print_r($idWithSort);die; */
			$status_array = array('is_menu_sort_order'=>$idWithSort[1]);
			$id = $idWithSort[0];
			$query = $this->menu_model->isSortingStatus($status_array,$id); 
		}
		
		echo 1;
	}
	
	function addUrl()
	{
		$parent_id = $this->input->post('parent_id');
		$category_name = $this->input->post('category_name');
		$url = '';
		$res = $this->menu_model->url_recursive($parent_id,$url);
		echo $res.'/'.$category_name;
	}
}
?>