<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Cms extends CI_Controller { 
    
    function __construct() {
        parent::__construct();
       $this->load->model('admin/cms_model');
		if(!$this->session->userdata('isAdminLoggedIn'))
		{
			 redirect('admin');
		}
    }



	function index()
	{
		$data['cms'] = $this->cms_model->getCMS(); 
		$data['totalCount'] = $this->cms_model->totalCount(); 
		$data['numrecord'] = $this->cms_model->getNumRecord();
		$data['page'] = $this->cms_model->getPage();
		$data['number_of_page'] = ceil($data['totalCount']/$data['numrecord']);
		$data['file']  = 'admin/cms/cms_view';
		$this->load->view('admin/template',$data);
	}
	

	public function addCMS()
	{
		/* echo "<pre>";
		print_r($_POST);die; */
		
		if($this->input->post('submit'))
		{
			//Check whether user upload picture
			
			$this->form_validation->set_rules('cms_name','CMS Name','trim|required|xss_clean|is_unique[cms_pages.name]');	
			$this->form_validation->set_rules('short_description','Short Description','trim|required|xss_clean');	
			$this->form_validation->set_rules('long_description','Long Description','trim|required|xss_clean');	
			$this->form_validation->set_rules('meta_title','Meta Title','trim|required|xss_clean');	
			$this->form_validation->set_rules('meta_keywords','Meta Keywords','trim|required|xss_clean');	
			$this->form_validation->set_rules('meta_description','Meta Description','trim|required|xss_clean');	
				
				
			//$this->form_validation->set_rules('image','Image','trim|required|xss_clean');	
			if($this->form_validation->run() == false)
			{
				$data['categori'] = $this->cms_model->getAllCMS(); 
				$data['file']  = 'admin/cms/cms_add';
				$this->load->view('admin/template',$data);
			}
			else
			{
				
				if(!empty($_FILES['image']['name']))
				{
					$config['upload_path'] = 'uploads/cms/';
					$config['allowed_types'] = 'jpg|jpeg|png|gif';
					$config['file_name'] = $_FILES['image']['name'];
					
					//Load upload library and initialize configuration
					$this->load->library('upload',$config);
					$this->upload->initialize($config);
					
					if($this->upload->do_upload('image')){
						$uploadData = $this->upload->data();
						$image = $uploadData['file_name'];
					}
					else
					{
						$image = '';
					}
				}
				else
				{
					$image = '';
				}
				
					$cms_data = array(
						'name'=>$this->input->post('cms_name'),
						'slug'=>str_replace(' ','-',strtolower($this->input->post('cms_name'))),
						'short_description'=>$this->input->post('short_description'),
						'long_description'=>$this->input->post('long_description'),
						'meta_title'=>$this->input->post('meta_title'),
						'meta_keywords'=>$this->input->post('meta_keywords'),
						'meta_description'=>$this->input->post('meta_description'),
						'created_by'=>$this->session->userdata('userId'),
						'created_at'=>date('Y-m-d H:i:s'),
						'updated_at'=>date('Y-m-d H:i:s'),
						'image'=>$image,
						'status'=>$this->input->post('status')
					);    
						   
				$insert_id = $this->cms_model->insertCMS($cms_data);
				
			
				  if($insert_id)
				  {
					$this->session->set_flashdata('msg', '<div class="alert alert-success text-center">CMS added successfully.</div>');
					redirect(base_url().'admin/cms/', 'refresh');
				  }
				  else
				  {
					$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Please Try Again...</div>');
					redirect(base_url().'admin/cms/addCMS', 'refresh');
				  }
				
				
			}
		}
		else
		{
			$data['categori'] = $this->cms_model->getAllCMS(); 
			$data['file']  = 'admin/cms/cms_add';
			$this->load->view('admin/template',$data);
		}
	}

	public function editCMS($id)
	{
		$data['categori'] = $this->cms_model->getAllCMS(); 
		$data['cms'] = $this->cms_model->getSingleCMS($id);
		$data['file']  = 'admin/cms/cms_edit';
		$this->load->view('admin/template',$data);
	}

	public function updateCMS($id)
	{
	
		if ($this->input->post('submit')) 
		{
			$res_cms= $this->cms_model->getSingleCMS($id);
			if($this->input->post('cms_name') != $res_cms->name) {
			   $is_unique =  '|is_unique[cms_pages.name]';
			} else {
			   $is_unique =  '';
			}
			$this->form_validation->set_rules('cms_name','CMS Name','trim|required|xss_clean'.$is_unique);
			$this->form_validation->set_rules('short_description','Short Description','trim|required|xss_clean');	
			$this->form_validation->set_rules('long_description','Long Description','trim|required|xss_clean');	
			$this->form_validation->set_rules('meta_title','Meta Title','trim|required|xss_clean');	
			$this->form_validation->set_rules('meta_keywords','Meta Keywords','trim|required|xss_clean');	
			$this->form_validation->set_rules('meta_description','Meta Description','trim|required|xss_clean');				
				
			if($this->form_validation->run() == false)
			{
				$data['categori'] = $this->cms_model->getAllCMS(); 
				$data['cms'] = $this->cms_model->getSingleCMS($id);	
				$data['file']  = 'admin/cms/cms_edit';
				$this->load->view('admin/template',$data);
			}
			else
			{
				if(!empty($_FILES['image']['name']))
				{
					$config['upload_path'] = 'uploads/cms/';
					$config['allowed_types'] = 'jpg|jpeg|png|gif';
					$config['file_name'] = $_FILES['image']['name'];
					
					//Load upload library and initialize configuration
					$this->load->library('upload',$config);
					$this->upload->initialize($config);
					
					if($this->upload->do_upload('image')){
						$uploadData = $this->upload->data();
						$image = $uploadData['file_name'];
					}
					else
					{
						$image = '';
					}
				}
				else
				{
					$image = $this->input->post('pic');
				}
				
				$update_data = array(
						'name'=>$this->input->post('cms_name'),
						'slug'=>str_replace(' ','-',strtolower($this->input->post('cms_name'))),
						'short_description'=>$this->input->post('short_description'),
						'long_description'=>$this->input->post('long_description'),
						'meta_title'=>$this->input->post('meta_title'),
						'meta_keywords'=>$this->input->post('meta_keywords'),
						'meta_description'=>$this->input->post('meta_description'),
						'created_by'=>$this->session->userdata('userId'),
						'created_at'=>date('Y-m-d H:i:s'),
						'updated_at'=>date('Y-m-d H:i:s'),
						'image'=>$image,
						'status'=>$this->input->post('status')
					);    
				
				$data_update = $this->cms_model->updateCMS($update_data,$id);
				  if($data_update > 0)
				  {
					 $this->session->set_flashdata('msg', '<div class="alert alert-success text-center">CMS updated successfully.</div>');
					 redirect(base_url().'admin/cms/', 'refresh');
				  }
				  else
				  {
					$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Please Try Again...</div>');
				   redirect(base_url().'admin/cms/editCMS/'.$id, 'refresh');
				  }
			}
		}
		else
		{
		   
		   redirect(base_url().'admin/cms');
		}
	}
	
	
	public function deleteCMS($id)  
	{
		$this->cms_model->delete($id);
	
		$this->session->set_flashdata('msg', '<div class="alert alert-success text-center">CMS  deleted successfully!</div>');
	
		redirect(base_url().'admin/cms');
	}
	
	public function updateCMSStatus($id)  
	{
		$status = $this->input->post('status');
		$status_array = array('status'=>$status);
		$query = $this->cms_model->update_status($status_array,$id);
		if($query){
			echo 1;
		}else{
			echo 0;
		}
	}
	
	function addUrl()
	{
		$parent_id = $this->input->post('parent_id');
		$cms_name = $this->input->post('cms_name');
		$url = '';
		$res = $this->cms_model->url_recursive($parent_id,$url);
		echo $res.'/'.$cms_name;
	}
}
?>