<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Category extends CI_Controller { 
    var $role_id;
	
    function __construct() {
        parent::__construct();
		$this->load->model('admin/category_model');
		if(!$this->session->userdata('isAdminLoggedIn'))
		{
			 redirect('admin');
		}
		if($this->session->userdata('loginUserData')['role_id'] != 1)
		{
			$this->role_id = $this->session->userdata('loginUserData')['role_id'];
		}
		else
		{
			$this->role_id = 0;
		}
    }



	function index()
	{
		$data['category'] = $this->category_model->getCategory($this->role_id); 
		$data['totalCount'] = $this->category_model->totalCount($this->role_id); 
		$data['numrecord'] = $this->category_model->getNumRecord();
		$data['page'] = $this->category_model->getPage();
		$data['number_of_page'] = ceil($data['totalCount']/$data['numrecord']);
		$data['file']  = 'admin/category/category_view';
		$this->load->view('admin/template',$data);
	}
	

	public function addCategory()
	{
		/* echo "<pre>";
		print_r($_POST);die; */
		
		
		if($this->input->post('submit'))
		{
			//Check whether user upload picture
			
			$this->form_validation->set_rules('category_name','Category Name','trim|required|xss_clean');	
			$this->form_validation->set_rules('parent_id','Parent Category','trim|required|xss_clean');	
			$this->form_validation->set_rules('short_description','Short Description','trim|required|xss_clean');	
			$this->form_validation->set_rules('long_description','Long Description','trim|required|xss_clean');	
			$this->form_validation->set_rules('meta_title','Meta Title','trim|required|xss_clean');	
			$this->form_validation->set_rules('meta_keywords','Meta Keywords','trim|required|xss_clean');	
			$this->form_validation->set_rules('meta_description','Meta Description','trim|required|xss_clean');	
				
				
			//$this->form_validation->set_rules('image','Image','trim|required|xss_clean');	
			if($this->form_validation->run() == false)
			{
				$data['categori'] = $this->category_model->getAllCategory($this->role_id); 
				$data['file']  = 'admin/category/category_add';
				$this->load->view('admin/template',$data);
			}
			else
			{
				
				if(!empty($_FILES['image']['name']))
				{
					$config['upload_path'] = 'uploads/category/';
					$config['allowed_types'] = 'jpg|jpeg|png|gif';
					$config['file_name'] = $_FILES['image']['name'];
					
					//Load upload library and initialize configuration
					$this->load->library('upload',$config);
					$this->upload->initialize($config);
					
					if($this->upload->do_upload('image')){
						$uploadData = $this->upload->data();
						$image = $uploadData['file_name'];
					}
					else
					{
						$image = '';
					}
				}
				else
				{
					$image = '';
				}
					
					if($this->role_id == 0)
					{
						$url = explode('/',$this->input->post('url'));
						$parent_slug = $url[1];
						$res = $this->category_model->getParentidBySlug($parent_slug);
						if($res)
						{
							$this->role_id = $res;
						}
					}
				
					$category_data = array(
						'name'=>$this->input->post('category_name'),
						'parent_id'=>$this->input->post('parent_id'),
						'role_id'=>$this->role_id,
						'url'=>$this->input->post('url'),
						'short_description'=>$this->input->post('short_description'),
						'long_description'=>$this->input->post('long_description'),
						'meta_title'=>$this->input->post('meta_title'),
						'meta_keywords'=>$this->input->post('meta_keywords'),
						'meta_description'=>$this->input->post('meta_description'),
						'created_by'=>$this->session->userdata('userId'),
						'created_at'=>date('Y-m-d H:i:s'),
						'updated_at'=>date('Y-m-d H:i:s'),
						'image'=>$image,
						'status'=>$this->input->post('status')
					);    
						   
				$insert_id = $this->category_model->insertCategory($category_data);
				
			
				  if($insert_id)
				  {
					$this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Category added successfully.</div>');
					redirect(base_url().'admin/category/', 'refresh');
				  }
				  else
				  {
					$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Please Try Again...</div>');
					redirect(base_url().'admin/category/addCategory', 'refresh');
				  }
				
				
			}
		}
		else
		{
			$data['categori'] = $this->category_model->getAllCategory($this->role_id); 
			$data['file']  = 'admin/category/category_add';
			$this->load->view('admin/template',$data);
		}
	}

	public function editCategory($id)
	{
		$data['categori'] = $this->category_model->getAllCategory($this->role_id); 
		$data['category'] = $this->category_model->getSingleCategory($id,$this->role_id);
		$data['file']  = 'admin/category/category_edit';
		$this->load->view('admin/template',$data);
	}

	public function updateCategory($id)
	{
	
		if ($this->input->post('submit')) 
		{
			$this->form_validation->set_rules('category_name','Category Name','trim|required|xss_clean');
			$this->form_validation->set_rules('parent_id','Parent Category','trim|required|xss_clean');	
			$this->form_validation->set_rules('short_description','Short Description','trim|required|xss_clean');	
			$this->form_validation->set_rules('long_description','Long Description','trim|required|xss_clean');	
			$this->form_validation->set_rules('meta_title','Meta Title','trim|required|xss_clean');	
			$this->form_validation->set_rules('meta_keywords','Meta Keywords','trim|required|xss_clean');	
			$this->form_validation->set_rules('meta_description','Meta Description','trim|required|xss_clean');				
				
			if($this->form_validation->run() == false)
			{
				$data['categori'] = $this->category_model->getAllCategory($this->role_id); 
				$data['category'] = $this->category_model->getSingleCategory($id,$this->role_id);	
				$data['file']  = 'admin/category/category_edit';
				$this->load->view('admin/template',$data);
			}
			else
			{
				if(!empty($_FILES['image']['name']))
				{
					$config['upload_path'] = 'uploads/category/';
					$config['allowed_types'] = 'jpg|jpeg|png|gif';
					$config['file_name'] = $_FILES['image']['name'];
					
					//Load upload library and initialize configuration
					$this->load->library('upload',$config);
					$this->upload->initialize($config);
					
					if($this->upload->do_upload('image')){
						$uploadData = $this->upload->data();
						$image = $uploadData['file_name'];
					}
					else
					{
						$image = '';
					}
				}
				else
				{
					$image = $this->input->post('pic');
				}
				
				if($this->role_id == 0)
				{
					$url = explode('/',$this->input->post('url'));
					$parent_slug = $url[1];
					$res = $this->category_model->getParentidBySlug($parent_slug);
					if($res)
					{
						$this->role_id = $res;
					}
				}
				
				$update_data = array(
						'name'=>$this->input->post('category_name'),
						'parent_id'=>$this->input->post('parent_id'),
						'role_id'=>$this->role_id,
						'url'=>$this->input->post('url'),
						'short_description'=>$this->input->post('short_description'),
						'long_description'=>$this->input->post('long_description'),
						'meta_title'=>$this->input->post('meta_title'),
						'meta_keywords'=>$this->input->post('meta_keywords'),
						'meta_description'=>$this->input->post('meta_description'),
						'created_by'=>$this->session->userdata('userId'),
						'created_at'=>date('Y-m-d H:i:s'),
						'updated_at'=>date('Y-m-d H:i:s'),
						'image'=>$image,
						'status'=>$this->input->post('status')
					);    
				
				$data_update = $this->category_model->updateCategory($update_data,$id,$this->role_id);
				  if($data_update > 0)
				  {
					 $this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Category updated successfully.</div>');
					 redirect(base_url().'admin/category/', 'refresh');
				  }
				  else
				  {
					$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Please Try Again...</div>');
				   redirect(base_url().'admin/category/editCategory/'.$id, 'refresh');
				  }
			}
		}
		else
		{
		   
		   redirect(base_url().'admin/category');
		}
	}
	
	
	public function deleteCategory($id)  
	{
		$res = $this->category_model->delete($id,$this->role_id);
		
		if($res)
		{
			$this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Category  deleted successfully!</div>');
		}
		else
		{	
			$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Please Try Again...</div>');
		}
		
	
		redirect(base_url().'admin/category');
	}
	
	public function updateCategoryStatus($id)  
	{
		$status = $this->input->post('status');
		$status_array = array('status'=>$status);
		$query = $this->category_model->update_status($status_array,$id);
		if($query){
			echo 1;
		}else{
			echo 0;
		}
	}
	
	function addUrl()
	{
		$parent_id = $this->input->post('parent_id');
		$category_name = $this->input->post('category_name');
		$url = '';
		$res = $this->category_model->url_recursive($parent_id,$url);
		echo $res.'/'.$category_name;
	}
}
?>