<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Banner extends CI_Controller { 
    
    function __construct() {
        parent::__construct();
       $this->load->model('admin/banner_model');
		if(!$this->session->userdata('isAdminLoggedIn'))
		{
			 redirect('admin');
		}
    }



	function index()
	{
		$data['banner'] = $this->banner_model->getBanner(); 
		$data['totalCount'] = $this->banner_model->totalCount(); 
		$data['numrecord'] = $this->banner_model->getNumRecord();
		$data['page'] = $this->banner_model->getPage();
		$data['number_of_page'] = ceil($data['totalCount']/$data['numrecord']);
		$data['file']  = 'admin/banner/banner_view';
		$this->load->view('admin/template',$data);
	}
	

	public function addBanner()
	{
		/* echo "<pre>";
		print_r($_POST);die; */
		
		if($this->input->post('submit'))
		{
		
			//Check whether user upload picture
			
			$this->form_validation->set_rules('page_name','Page Name','trim|required|xss_clean|is_unique[banners.name]');	
				
			if($this->form_validation->run() == false)
			{
				$data['file']  = 'admin/banner/banner_add';
				$this->load->view('admin/template',$data);
			}
			else
			{
				
				$filesCount = count($_FILES['image']['name']);
				for($i = 0; $i < $filesCount; $i++)
				{
					if($_FILES['image']['name'][$i])
					{
						$_FILES['images']['name'] = $_FILES['image']['name'][$i];
						$_FILES['images']['type'] = $_FILES['image']['type'][$i];
						$_FILES['images']['tmp_name'] = $_FILES['image']['tmp_name'][$i];
						$_FILES['images']['error'] = $_FILES['image']['error'][$i];
						$_FILES['images']['size'] = $_FILES['image']['size'][$i];
						
							$uploadPath = 'uploads/banner/';
							$config['upload_path'] = $uploadPath;
							$config['allowed_types'] = 'gif|jpg|png|jpeg';
							$config['max_size']	= '52428800';
							/* $config['max_width']  = '1600';
							$config['max_height']  = '1200';  */
							/* $config['max_width']  = '1024';
							$config['max_height']  = '768'; */
							$config['file_name'] = time().''.$_FILES['images']['name']; 
							
							$this->load->library('upload', $config);
							$this->upload->initialize($config);
							if($this->upload->do_upload('images'))
							{
								$fileData = $this->upload->data();
								$bannerUploadData[$i]['name'] = $this->input->post('page_name');
								$bannerUploadData[$i]['title'] = $this->input->post('title')[$i];
								$bannerUploadData[$i]['description'] = $this->input->post('description')[$i];
								$bannerUploadData[$i]['slug'] = str_replace(' ','-',strtolower($this->input->post('page_name')));
								$bannerUploadData[$i]['image'] = $fileData['file_name'];
								$bannerUploadData[$i]['sort_order'] = $this->input->post('banner_sort_number')[$i];
								$bannerUploadData[$i]['status'] = $this->input->post('status');
								$bannerUploadData[$i]['created_by'] = $this->session->userdata('userId');
								$bannerUploadData[$i]['created_at'] = date('Y-m-d H:i:s');
								$bannerUploadData[$i]['updated_at'] = date('Y-m-d H:i:s');
								$bannerUploadData[$i]['status'] = $this->input->post('status');
								
							}
							else
							{
								//$error = array('error' => $this->upload->display_errors());
								$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Banner Image not uploaded.</div>');
								redirect(base_url().'admin/pava/editPava/'.$id, 'refresh');
							}
					}
					else
					{
						$bannerUploadData[$i]['name'] = $this->input->post('page_name');
						$bannerUploadData[$i]['title'] = '';
						$bannerUploadData[$i]['description'] = '';
						$bannerUploadData[$i]['slug'] = '';
						$bannerUploadData[$i]['image'] = '';
						$bannerUploadData[$i]['sort_order'] = '';
						$bannerUploadData[$i]['status'] = '';
						$bannerUploadData[$i]['created_by'] = '';
						$bannerUploadData[$i]['created_at'] = '';
						$bannerUploadData[$i]['status'] = '';
					}
					
				}
				
				/* echo "<pre>";
				print_r($bannerUploadData);die; */
		
				/* if(!empty($_FILES['image']['name']))
				{
					$config['upload_path'] = 'uploads/banner/';
					$config['allowed_types'] = 'jpg|jpeg|png|gif';
					$config['file_name'] = $_FILES['image']['name'];
					
					//Load upload library and initialize configuration
					$this->load->library('upload',$config);
					$this->upload->initialize($config);
					
					if($this->upload->do_upload('image')){
						$uploadData = $this->upload->data();
						$image = $uploadData['file_name'];
					}
					else
					{
						$image = '';
					}
				}
				else
				{
					$image = '';
				} */
				  
						   
				$insert_id = $this->banner_model->insertBanner($bannerUploadData);
				
			
				  if($insert_id)
				  {
					$this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Banner added successfully.</div>');
					redirect(base_url().'admin/banner/', 'refresh');
				  }
				  else
				  {
					$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Please Try Again...</div>');
					redirect(base_url().'admin/banner/addBanner', 'refresh');
				  }
				
				
			}
		}
		else
		{
			$data['file']  = 'admin/banner/banner_add';
			$this->load->view('admin/template',$data);
		}
	}

	public function editBanner($slug)
	{
		$data['banner'] = $this->banner_model->getSingleBanner($slug);
		$data['file']  = 'admin/banner/banner_edit';
		$this->load->view('admin/template',$data);
	}

	public function updateBanner($slug)
	{
	
		if ($this->input->post('submit')) 
		{
			$res_banner = $this->banner_model->getSingleBanner($slug);
			if($this->input->post('page_name') != $res_banner[0]['name']) {
			   $is_unique =  '|is_unique[banners.name]';
			} else {
			   $is_unique =  '';
			}

			$this->form_validation->set_rules('page_name','Page Name','trim|required|xss_clean'.$is_unique);	
				
			if($this->form_validation->run() == false)
			{
				$data['banner'] = $this->banner_model->getSingleBanner($slug);	
				$data['file']  = 'admin/banner/banner_edit';
				$this->load->view('admin/template',$data);
			}
			else
			{
				
				$filesCount = count($_FILES['image']['name']);
				for($i = 0; $i < $filesCount; $i++)
				{
					if($_FILES['image']['name'][$i])
					{
						$_FILES['images']['name'] = $_FILES['image']['name'][$i];
						$_FILES['images']['type'] = $_FILES['image']['type'][$i];
						$_FILES['images']['tmp_name'] = $_FILES['image']['tmp_name'][$i];
						$_FILES['images']['error'] = $_FILES['image']['error'][$i];
						$_FILES['images']['size'] = $_FILES['image']['size'][$i];
						
							$uploadPath = 'uploads/banner/';
							$config['upload_path'] = $uploadPath;
							$config['allowed_types'] = 'gif|jpg|png|jpeg';
							$config['max_size']	= '52428800';
							/* $config['max_width']  = '1600';
							$config['max_height']  = '1200';  */
							/* $config['max_width']  = '1024';
							$config['max_height']  = '768'; */
							$config['file_name'] = time().''.$_FILES['images']['name']; 
							
							$this->load->library('upload', $config);
							$this->upload->initialize($config);
							if($this->upload->do_upload('images'))
							{
								$fileData = $this->upload->data();
								$bannerUploadData[$i]['name'] = $this->input->post('page_name');
								$bannerUploadData[$i]['title'] = $this->input->post('title')[$i];
								$bannerUploadData[$i]['description'] = $this->input->post('description')[$i];
								$bannerUploadData[$i]['slug'] = str_replace(' ','-',strtolower($this->input->post('page_name')));
								$bannerUploadData[$i]['image'] = $fileData['file_name'];
								$bannerUploadData[$i]['sort_order'] = $this->input->post('banner_sort_number')[$i];
								$bannerUploadData[$i]['status'] = $this->input->post('status');
								$bannerUploadData[$i]['created_by'] = $this->session->userdata('userId');
								$bannerUploadData[$i]['created_at'] = date('Y-m-d H:i:s');
								$bannerUploadData[$i]['updated_at'] = date('Y-m-d H:i:s');
								$bannerUploadData[$i]['status'] = $this->input->post('status');
								
							}
							else
							{
								//$error = array('error' => $this->upload->display_errors());
								$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Banner Image not uploaded.</div>');
								redirect(base_url().'admin/pava/editPava/'.$id, 'refresh');
							}
					}
					else
					{
						$bannerUploadData[$i]['name'] = $this->input->post('page_name');
						$bannerUploadData[$i]['title'] = $this->input->post('title')[$i];
						$bannerUploadData[$i]['description'] = $this->input->post('description')[$i];
						$bannerUploadData[$i]['slug'] = str_replace(' ','-',strtolower($this->input->post('page_name')));
						$bannerUploadData[$i]['image'] = $this->input->post('banner_pic')[$i];
						$bannerUploadData[$i]['sort_order'] = $this->input->post('banner_sort_number')[$i];
						$bannerUploadData[$i]['status'] = $this->input->post('status');
						$bannerUploadData[$i]['created_by'] = $this->session->userdata('userId');
						$bannerUploadData[$i]['created_at'] = date('Y-m-d H:i:s');
						$bannerUploadData[$i]['updated_at'] = date('Y-m-d H:i:s');
						$bannerUploadData[$i]['status'] = $this->input->post('status');
					}
					
				}
				
				/* echo "<pre>";
				print_r($bannerUploadData);die; */
				/* if(!empty($_FILES['image']['name']))
				{
					$config['upload_path'] = 'uploads/banner/';
					$config['allowed_types'] = 'jpg|jpeg|png|gif';
					$config['file_name'] = $_FILES['image']['name'];
					
					//Load upload library and initialize configuration
					$this->load->library('upload',$config);
					$this->upload->initialize($config);
					
					if($this->upload->do_upload('image')){
						$uploadData = $this->upload->data();
						$image = $uploadData['file_name'];
					}
					else
					{
						$image = '';
					}
				}
				else
				{
					$image = $this->input->post('pic');
				}
				
				$update_data = array(
						'name'=>$this->input->post('page_name'),
						'title'=>$this->input->post('title'),
						'description'=>$this->input->post('description'),
						'slug'=>str_replace(' ','-',strtolower($this->input->post('page_name'))),
						'created_by'=>$this->session->userdata('userId'),
						'created_at'=>date('Y-m-d H:i:s'),
						'updated_at'=>date('Y-m-d H:i:s'),
						'image'=>$image,
						'status'=>$this->input->post('status')
					);    */
				
				$data_update = $this->banner_model->updateBanner($bannerUploadData,$slug);
				  if($data_update > 0)
				  {
					 $this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Banner updated successfully.</div>');
					 redirect(base_url().'admin/banner/', 'refresh');
				  }
				  else
				  {
					$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Please Try Again...</div>');
				   redirect(base_url().'admin/banner/editBanner/'.$id, 'refresh');
				  }
			}
		}
		else
		{
		   
		   redirect(base_url().'admin/banner');
		}
	}
	
	
	public function deleteBanner($id)  
	{
		$this->banner_model->delete($id);
	
		$this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Banner  deleted successfully!</div>');
	
		redirect(base_url().'admin/banner');
	}
	
	public function updateBannerStatus($id)  
	{
		$status = $this->input->post('status');
		$status_array = array('status'=>$status);
		$query = $this->banner_model->update_status($status_array,$id);
		if($query){
			echo 1;
		}else{
			echo 0;
		}
	}
}
?>