<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Home extends CI_Controller {
    
    function __construct() {
        parent::__construct();
       // $this->load->library('form_validation');
	   //$this->load->library('session');
       $this->load->model('admin/Adminleads');
    }
    
    
    
	function index()
	{
		
		$this->session->set_userdata('loginUserData');
		if($this->session->userdata('isAdminLoggedIn'))
		{
			redirect('admin/dashboard');
		}
		
        $data = array();
        if($this->session->userdata('success_msg')){
            $data['success_msg'] = $this->session->userdata('success_msg');
            $this->session->unset_userdata('success_msg');
        }
        if($this->session->userdata('error_msg')){
            $data['error_msg'] = $this->session->userdata('error_msg');
            $this->session->unset_userdata('error_msg');
        }
        if($this->input->post('loginSubmit')){
			
            $this->form_validation->set_rules('email', 'Email/Mobile', 'required');
            $this->form_validation->set_rules('password', 'password', 'required');
            if ($this->form_validation->run() == true) {
                $con['returnType'] = 'single';
				$email = $this->input->post('email');
				$password = $this->input->post('password');
				
				$salt = strrev(substr($email, 0, strpos($email, '@')));
				
				$con['conditions'] = array(
						'email'=>$email,
						'password' => md5($this->input->post('password')),
						'status' => '1'
					);
				
				
                $checkLogin = $this->Adminleads->getRows($con);
				// echo "<pre>";print_r($checkLogin);die;
                if($checkLogin){
					
					if($this->google_recaptcha_validation())
					{
						$this->session->set_userdata('isAdminLoggedIn',TRUE);
						$this->session->set_userdata('userId',$checkLogin['id']);
						$this->session->set_userdata('loginUserData',$checkLogin);
					}
					else
					{
						$data['error_msg'] = 'Captcha Error.Try Again';
					}

                    redirect(base_url().'admin/dashboard');
                }else{
                    $data['error_msg'] = 'Wrong email/username or password, please try again.';
                }
				
            }
        }
        //load the view
        $this->load->view('admin/login', $data);
    }
	
	function contact_leads()
	{
		$this->session->unset_userdata('date_range');
		if(!$this->session->userdata('isAdminLoggedIn'))
		{
			redirect(base_url());
		}
		
		if(isset($_GET['search']) || isset($_GET['contact_date']) || isset($_GET['sort']) || isset($_GET['entry']))
		{
			$data['contact_leads_excel'] = $this->Adminleads->getAllFilterContactLeads(); 
			$this->session->set_userdata('contactRecords',$data['contact_leads_excel']);
		}
		else{
			$data['contact_leads_excel'] = $this->Adminleads->getAllContactLeads(); 
			$this->session->set_userdata('contactRecords',$data['contact_leads_excel']);
		}
		$data['contact_leads'] = $this->Adminleads->getContactLeads(); 
		$data['totalCount'] = $this->Adminleads->totalCount(); 
		$data['numrecord'] = $this->Adminleads->getNumRecord();
		$data['page'] = $this->Adminleads->getPage();
		$data['number_of_page'] = ceil($data['totalCount']/$data['numrecord']);
		$data['file']  = 'admin/contact_leads_view';
		$this->load->view('admin/template',$data);
	}   
   
    
    /*
     * User logout
     */
    function logout(){
        $this->session->unset_userdata('isAdminLoggedIn');
        $this->session->unset_userdata('userId');
		$this->session->unset_userdata('date_range');
        $this->session->sess_destroy();
        redirect(base_url());
    }
    
    
	function dashboard()
	{ 
		if($this->session->userdata('isAdminLoggedIn'))
		{
			$data['file'] = 'admin/index';
			$this->load->view('admin/template',$data);  
		}
		else
		{
			redirect(base_url());
		}
		
	}
	
	function contact_lead_reset()
	{
		if(!$this->session->userdata('isAdminLoggedIn'))
		{
			redirect(base_url());
		}
		$this->session->unset_userdata('contactRecords');
		$this->session->unset_userdata('date_range');
		redirect('home/contact-leads');
	}
	
	
	public function google_recaptcha_validation()
	{
		if(empty($this->input->post('g-recaptcha-response')))
		{
			$this->session->set_flashdata( 'error', 'Captcha Error' );
			return 0;
		}
		 // post request to server
		$url = 'https://www.google.com/recaptcha/api/siteverify';
		$data = array('secret' => SECRET_KEY, 'response' => $this->input->post('g-recaptcha-response'));
		
		$options = array(
			'http' => array(
			  'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
			  'method'  => 'POST',
			  'content' => http_build_query($data)
			)
		);
		$context  = stream_context_create($options);
		$result = file_get_contents($url, false, $context);
		$responseJson = json_decode($result,true);
		/* echo "<pre>";
		print_r($responseJson);die; */
		if(empty($responseJson['success']) || $responseJson['success'] != 1)
		{
			$this->session->set_flashdata( 'error', 'Captcha Error' );
			return 0;
			  
		}else
		{
			return 1;
		}
	}
	
	
	public function contact_lead_excel()
	{
		if(!$this->session->userdata('isAdminLoggedIn'))
		{
			redirect(base_url());
		}
		require_once APPPATH . '/third_party/Phpexcel/Bootstrap.php';
		
		$contact_list = $this->session->userdata('contactRecords');
	
			// Create new Spreadsheet object
			$spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
			
			// Set document properties
			$spreadsheet->getProperties()->setCreator('Maxlife');
			if($this->session->userdata('date_range'))
			{
				$fileName = 'MLI-INNOVATIONLABS_DATA_'.$this->session->userdata('date_range').".xls";
			}
			else{
				$fileName = 'MLI-INNOVATIONLABS_DATA_'.date('d-m-Y').".xls";
			}
			
			// add style to the header
			$styleArray = array(
				'font' => array(
					'bold' => true,
				),
				'alignment' => array(
					'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
					'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
				),
				'borders' => array(
					'top' => array(
						'style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
					),
				),
				'fill' => array(
					'type' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_GRADIENT_LINEAR,
					'rotation' => 90,
					'startcolor' => array(
						'argb' => 'FFA0A0A0',
					),
					'endcolor' => array(
						'argb' => 'FFFFFFFF',
					),
				),
			);
			$spreadsheet->getActiveSheet()->getStyle('A1:K1')->applyFromArray($styleArray);
			

			// auto fit column to content

			foreach (range('A', 'K') as $columnID) {
				$spreadsheet->getActiveSheet()->getColumnDimension($columnID)
						->setAutoSize(true);
			}
			
			// set the names of header cells
			$spreadsheet->setActiveSheetIndex(0)
					->setCellValue("A1", 'Name OF Organization')
					->setCellValue("B1", "SPOC's Name")
					->setCellValue("C1", "SPOC's Email")
					->setCellValue("D1", "SPOC's Mobile Number")
					->setCellValue("E1", 'State')
					->setCellValue("F1", 'City')
					->setCellValue("G1", 'Category')
					->setCellValue("H1", 'Website Link')
					->setCellValue("I1", 'Description')
					->setCellValue("J1", 'Upload PDF Path')
					->setCellValue("K1", 'Created Date');
					
			// Add some data
			$x = 2;
			foreach ($contact_list as $key=>$row) {
				if($row->category === 0)
				{
					$category = '';
				}
				else{
					$category = $row->category;
				}
				$spreadsheet->setActiveSheetIndex(0)
						->setCellValue("A$x", $row->name)
						->setCellValue("B$x", $this->decrypted_data($row->id,$row->spoc_name))
						->setCellValue("C$x", $this->decrypted_data($row->id,$row->email))
						->setCellValue("D$x", $this->decrypted_data($row->id,$row->mobile_no))
						->setCellValue("E$x", $row->state_name)
						->setCellValue("F$x", $row->city_name)
						->setCellValue("G$x", $category)
						->setCellValue("H$x", $row->website_link)
						->setCellValue("I$x", $row->description)
						->setCellValue("J$x", $row->upload_name)
						->setCellValue("K$x", date('d-m-Y H:i:s',strtotime($row->created_at)));
						
				$x++;
		}
		
		// Rename worksheet
		$spreadsheet->getActiveSheet()->setTitle('Maxlife');
		
		$spreadsheet->setActiveSheetIndex(0);
		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		header('Content-Disposition: attachment;filename= "'.$fileName.'"');
		header('Cache-Control: max-age=0');
		// If you're serving to IE 9, then the following may be needed
		header('Cache-Control: max-age=1');

		// If you're serving to IE over SSL, then the following may be needed
		header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
		header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
		header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
		header('Pragma: public'); // HTTP/1.0
		$writer = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, 'Excel2007');
		//ob_end_clean();
		$writer->save('php://output');
		exit;
	}
	
	function decrypted_data($id,$decryptedformfield)
	{
		$data = $decryptedformfield;
		
		if ($id <= 112)
		{
			return $decryptedformfield;
		}
		if(!empty($data))
		{
			$password = '3sc3RLrpd17';

			// CBC has an IV and thus needs randomness every time a message is encrypted
			$method = 'aes-256-cbc';

			// Must be exact 32 chars (256 bit)
			// You must store this secret random key in a safe place of your system.
			$key = substr(hash('sha256', $password, true), 0, 32);

			// Most secure key
			//$key = openssl_random_pseudo_bytes(openssl_cipher_iv_length($method));

			// IV must be exact 16 chars (128 bit)
			$iv = chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0) . chr(0x0);
			
			
			$decrypted = openssl_decrypt(base64_decode($data), $method, $key, OPENSSL_RAW_DATA, $iv);
			
			return $decrypted;
		}
		else{
			return '';
		}
		
	}
	
	
	
}