<?php 
/** * Template Name: Service */
get_header(); 
?>

<!-- Demo Content -->
    <main class="main-content ">
        <section class="projectService contanerPadding ">
            <div class="service-page-container-2">
                <!-- Main Content Area -->
                <div class="service-page-main-area" data-aos="fade-right">
                    <!-- Hero Section -->
                    <div class="service-page-hero-section">
                        <?php 
                        $banner_image = get_field('banner_image'); // ACF image field
                        if ($banner_image): ?>
                            <img 
                                src="<?php echo esc_url($banner_image['url']); ?>" 
                                alt="<?php echo esc_attr($banner_image['alt'] ?: 'Banner Image'); ?>" 
                                class="service-page-hero-image"
                            >
                        <?php endif; ?>

                        <div class="service-page-hero-overlay serviceOverLayBanner">
                            <?php
                                $banner_tittle = get_field("banner_tittle");
                                echo $banner_tittle ? $banner_tittle : 'Not Available';
                            ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- text area  -->

        <section class="content-section contanerPadding" >
            <div class="content-sec-wrapper">
                <div class="leftContentSec">
                        <?php
                            $service_post_heading = get_field("service_post_heading");
                            echo $service_post_heading ? $service_post_heading : 'Not Available';
                        ?>
                    <div class="button-group">
                            <?php
                                $brochure_btn = get_field("brochure_btn");
                                echo $brochure_btn ? $brochure_btn : 'Not Available';
                                $case_study_btn = get_field("case_study_btn");
                                echo $case_study_btn ? $case_study_btn : 'Not Available';
                            ?>
                        </div>
                </div>
                <div class="rightContentSection">
                     <div class="service-page-main-content">
                        
                        <?php
                            $service_blog_paragraph = get_field("service_blog_paragraph");
                            echo $service_blog_paragraph ? $service_blog_paragraph : 'Not Available';
                        ?>
                    </div>
                </div>
            </div>
        </section>

        <!-- Video Wrapper -->

        <section class="videoWrapperSection contanerPadding">
            <div class="video-wrapper">
                <?php
                    $youtube_iframe = get_field("youtube_iframe");
                    echo $youtube_iframe ? $youtube_iframe : 'Not Available';
                ?>
            </div>
        </section>

        <!-- Related Post -->
        <section class="contanerPadding">
            <div class="related-projects-container">
                
                    <?php
                        $bridge_project_title = get_field("bridge_project_title");
                        echo $bridge_project_title ? $bridge_project_title : 'Not Available';
                    ?>
                
                <!-- <h4 class="service-page-hero-title headingRelatedPost">Bridges Projects</h4> -->

                <div class="related-projects-slider" data-aos="fade-up">

                    <?php if (have_rows('bridge_project_card')): ?>
                        <?php while (have_rows('bridge_project_card')): the_row();
                            $image = get_sub_field('card_image');
                            $badge = get_sub_field('card_badges');
                            $title = get_sub_field('card_title');
                            $address = get_sub_field('card_address');
                            $country = get_sub_field('card_country');
                            $url = get_sub_field('url');
                        ?>
                        <div class="related-projects-card" data-project="<?php echo sanitize_title($title); ?>">
                            <div class="related-projects-image-container">
                                <?php if ($image): ?>
                                    <img 
                                        src="<?php echo esc_url($image['sizes']['medium_large']); ?>" 
                                        alt="<?php echo esc_attr($image['alt'] ?: $title); ?>" 
                                        class="related-projects-image">
                                <?php endif; ?>
                                <?php if ($badge): ?>
                                    <div class="related-projects-category-tag related-projects-roads-tag">
                                        <?php echo esc_html($badge); ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="related-projects-content">
                                <?php if ($title): ?>
                                    <h3 class="news-log-slide-title"><?php echo esc_html($title); ?></h3>
                                <?php endif; ?>
                                <?php if ($address): ?>
                                    <p class="service-page-expertise-name"><?php echo esc_html($address); ?></p>
                                <?php endif; ?>
                                <?php if ($country): ?>
                                    <p class="related-projects-location-secondary"><?php echo esc_html($country); ?></p>
                                <?php endif; ?>
                                 <?php if ($url): ?>
        <a href="<?php echo esc_url($url); ?>" class="readmore-modern j-f-readmore" target="_blank" rel="noopener noreferrer">Read More →</a>
    <?php endif; ?>
                            </div>
                        </div>
                        <?php endwhile; ?>
                    <?php endif; ?>


                </div>
            </div>
        </section>

        <section class="hero-bottom-section marginforHero">
            <div class="hero-bottom-background  hero-bottom-background-service"></div>
            <div class="hero-bottom-container servicePage-heroContainer">
                <div class="hero-bottom-content servicePage-hero">
                    
                        <?php
                        $curiosity_title = get_field("curiosity_title");
                        echo $curiosity_title ? $curiosity_title : 'Not Available';
                        ?>
                        
                    
                    
                        <?php
                            $curiosity_heading = get_field("curiosity_heading");
                            echo $curiosity_heading ? $curiosity_heading : 'Not Available';
                        ?>
                   
                    <div class="button-group serivePageButtonGroup">
                        <?php
                            $getin_touch_btn = get_field("getin_touch_btn");
                            echo $getin_touch_btn ? $getin_touch_btn : 'Not Available';
                            $corporate_brocher_btn = get_field("corporate_brocher_btn");
                            echo $corporate_brocher_btn ? $corporate_brocher_btn : 'Not Available';
                        ?>
                    </div>
                </div>
            </div>
        </section>
    </main>
   
<?php get_footer(); ?>

<script>
jQuery(document).ready(function($){
    $('.related-projects-slider').slick({
        slidesToShow: 4,
        slidesToScroll: 1,
        infinite: true,
        arrows: true,
        dots: false,
        speed: 500,
        autoplay: true,
        autoplaySpeed: 4000,
        prevArrow: '<button type="button" class="j-f-arrows j-f-prev"><span class="relative-j-f-arrow">‹</span></button>',
        nextArrow: '<button type="button" class="j-f-arrows j-f-next"><span class="relative-j-f-arrow">›</span></button>',
        responsive: [
            {
                breakpoint: 1500,
                settings: {
                    slidesToShow: 3
                }
            },
            {
                breakpoint: 1024,
                settings: {
                    slidesToShow: 2
                }
            },
            {
                breakpoint: 768,
                settings: {
                    slidesToShow: 1
                }
            }
        ]
    });
});
</script>

<style>
    /* Card spacing */
.related-projects-slider .related-projects-card {
    margin: 0 10px;
}

.related-projects-slider {
    margin: 0 -10px; /* Adjust for equal spacing on both sides */
}

/* Arrow base class */
.j-f-arrows {
    background: #fff;
    border: none;
    color: #000;
    font-size: 30px;
    width: 40px;
    height: 40px;
    position: absolute;
    top: 50%;
    transform: translateY(-50%);
    z-index: 10;
    cursor: pointer;
    border-radius: 50%;
    box-shadow: 0 0 8px rgba(0, 0, 0, 0.2);
}

/* Left arrow */
.j-f-prev {
    left: -50px;
}

/* Right arrow */
.j-f-next {
    right: -50px;
}
.j-f-readmore {
    /* display: inline-block; */
    margin-top: -38px;
    padding: 6px 14px;
    font-size: 14px;
    font-weight: 500;
    color: #fff;
    background-color: #000;
    border-radius:5px;
    text-decoration: none; 
    transition: all 0.3s ease;
    /* float: right; */
    margin-right: 15px;
        position: absolute;
        right:0px;
        border-radius:1px solid #000;

}

.j-f-readmore:hover {
    background-color: #222;
    transform: translateX(2px);
    box-shadow: 2px 2px 8px rgba(0,0,0,0.15);
}
@media (max-width:1024px) {
    .j-f-prev {
    left: -20px;
}

/* Right arrow */
.j-f-next {
    right: -20px;
}
}
.relative-j-f-arrow{
    position: relative;
        top: -2px;

}

</style>

