<?php 
/** * Template Name: Sector Page */
get_header(); 
?>

<!-- Demo Content -->
    <main class="main-content">

        <section class="topSectionSector contanerPadding">
            <div class="facade-services-container">
                <div class="facade-services-content">
                    <div class="facade-services-text">
                    
                            <?php
                                $witness_precision_heading = get_field("witness_precision_heading");
                                echo $witness_precision_heading ? $witness_precision_heading : 'Not Available';
                            ?>
                        
                        <?php
                                $witness_precision_paragraph = get_field("witness_precision_paragraph");
                                echo $witness_precision_paragraph ? $witness_precision_paragraph : 'Not Available';
                            ?>

                        <div class="button-group">
                            <?php
                                $request_case_study_btn = get_field("request_case_study_btn");
                                echo $request_case_study_btn ? $request_case_study_btn : 'Not Available';
                                $getin_touch_btn = get_field("getin_touch_btn");
                                echo $getin_touch_btn ? $getin_touch_btn : 'Not Available';
                            ?>
                            
                        </div>
                    </div>
                    <div class="facade-services-image">
                        <?php 
                            $image = get_field('witness_precision_image');
                            if ($image): ?>
                                <img 
                                    src="<?php echo esc_url($image['url']); ?>" 
                                    alt="<?php echo esc_attr($image['alt'] ?: 'Witness Precision Image'); ?>" 
                                    class="facade-services-img"
                                >
                        <?php endif; ?>


                        <div class="facade-services-badge">
                            <?php
                                $witness_precision_badges = get_field("witness_precision_badges");
                                echo $witness_precision_badges ? $witness_precision_badges : 'Not Available';
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section class="sector-sectionTwo  contanerPadding">
            <div class="sector-page-container">
                <div class="sector-page-content">
                    <!-- Feature 1 - Left -->
                    <?php if (have_rows('experienced_international')): ?>
                        <?php while (have_rows('experienced_international')): the_row(); 
                            $img1 = get_sub_field('experienced_international_image');
                            $img2 = get_sub_field('experienced_international_image_second');
                            $img3 = get_sub_field('experienced_international_image_third');
                            $text = get_sub_field('experienced_international_text');
                        ?>
                        <div class="sector-page-feature sector-page-feature-left">
                            <div class="sector-page-avatars">
                                <?php if ($img1): ?>
                                    <div class="sector-page-avatar sector-page-avatar-1">
                                        <img src="<?php echo esc_url($img1['url']); ?>" alt="<?php echo esc_attr($img1['alt']); ?>">
                                    </div>
                                <?php endif; ?>
                                <?php if ($img2): ?>
                                    <div class="sector-page-avatar sector-page-avatar-2">
                                        <img src="<?php echo esc_url($img2['url']); ?>" alt="<?php echo esc_attr($img2['alt']); ?>">
                                    </div>
                                <?php endif; ?>
                                <?php if ($img3): ?>
                                    <div class="sector-page-avatar sector-page-avatar-more">
                                        <img src="<?php echo esc_url($img3['url']); ?>" alt="<?php echo esc_attr($img3['alt']); ?>">
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="sector-page-text">
                                <?php    
                                    echo $text ? $text : 'Not Available';
                                ?>
                            </div>
                        </div>
                        <?php endwhile; ?>
                    <?php endif; ?>
                </div>
            </div>
        </section>

        <section class="keyServices contanerPadding">
            <div class="contanienrSecFour">
                
                                    <?php
                                $why_choose_heading = get_field("why_choose_heading");
                                echo $why_choose_heading ? $why_choose_heading : 'Not Available';
                            ?>
              
                <div class="sector-page-accordion-container">
                    <div class="sector-page-content-wrapper">
                        <!-- Left Side - Accordion -->
                        <div class="sector-page-accordion">
                            <div class="why-chose-container">

                                    <?php if (have_rows('why_choose_brief')): ?>
                                        <?php while (have_rows('why_choose_brief')): the_row(); 
                                            $title = get_sub_field('why_choose_title');
                                            $paragraph = get_sub_field('why_choose_paragraph');
                                        ?>
                                        <div class="why-chose-section">
                                            <?php if ($title): ?>
                                                <h3 class="sector-page-accordion-title"><?php echo $title; ?></h3>
                                            <?php endif; ?>
                                            
                                            <?php if ($paragraph): ?>
                                                <?php echo $paragraph; ?>
                                            <?php endif; ?>
                                        </div>
                                        <?php endwhile; ?>
                                    <?php endif; ?>


                            </div>
                        </div>

                        <!-- Right Side - Image Placeholder -->
                        <div class="sector-page-technical-drawing">
                            <!-- Space reserved for your technical drawings/images -->
                            <!-- You can replace this with your actual image -->
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section class="modelingContainer contanerPadding">
            <div class="container-modeling">
                
                    <?php
                        $our_facade_heading = get_field("our_facade_heading");
                        echo $our_facade_heading ? $our_facade_heading : 'Not Available';
                    ?>
               
                <?php
                    $our_facade_sub_head = get_field("our_facade_sub_head");
                    echo $our_facade_sub_head ? $our_facade_sub_head : 'Not Available';
                ?>
                <div class="services-grid">

                    <?php if (have_rows('our_facade_cards')): ?>
                        <?php while (have_rows('our_facade_cards')): the_row(); 
                            $image = get_sub_field('our_facade_card_image');
                            $heading = get_sub_field('our_facade_card_heading');
                            $paragraph = get_sub_field('our_facade_card_paragraph');
                        ?>
                        <div class="service-card">
                            <div class="service-image-sector">
                                <div class="image-modelling">
                                    <?php if ($image): ?>
                                        <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr($image['alt']); ?>">
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="service-content-modeling">
                                <?php if ($heading): ?>
                                    <h3 class="sector-page-accordion-title"><?php echo $heading; ?></h3>
                                <?php endif; ?>
                                
                                <?php if ($paragraph): ?>
                                    <?php echo $paragraph; ?>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php endwhile; ?>
                    <?php endif; ?>

                </div>
            </div>
        </section>

        <section class="sectionTestimoneal contanerPadding">
            <div class="sector-page-testimonial ">
                <div class="sector-page-rating-section">
                    <?php
                        $customers_recommend = get_field("customers_recommend");
                        echo $customers_recommend ? $customers_recommend : 'Not Available';
                    ?>
                </div>

                <div class="sector-page-slider-container">
                    <div class="sector-page-slider-track">
                        <!-- Duplicate slides for seamless looping -->
                                    
                        <?php if (have_rows('customers_recommend_logo')): ?>
                            <?php while (have_rows('customers_recommend_logo')): the_row(); 
                                $logo = get_sub_field('customers_recommend_img');
                            ?>
                            <?php if ($logo): ?>
                                <div class="sector-page-slider-item">
                                    <img src="<?php echo esc_url($logo['url']); ?>" 
                                        alt="<?php echo esc_attr($logo['alt'] ?: 'Client Logo'); ?>" 
                                        class="sector-page-slider-img" />
                                </div>
                            <?php endif; ?>
                            <?php endwhile; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </section>

        <section class="keyServices contanerPadding">
            <div class="contanienrSecFour">
                
                    <?php
                        $key_services_heading = get_field("key_services_heading");
                        echo $key_services_heading ? $key_services_heading : 'Not Available';
                    ?>

               
                <?php
                        $key_services_sub_head = get_field("key_services_sub_head");
                        echo $key_services_sub_head ? $key_services_sub_head : 'Not Available';
                    ?>
                <div class="sector-page-accordion-container">
                    <div class="sector-page-content-wrapper">
                        <!-- Left Side - Accordion -->
                        <div class="sector-page-accordion">
                            
                            <!-- Curtain Walls - Active/Expanded -->
                            <?php if (have_rows('key_services_accordion')): ?>
                                <?php $is_first = true; ?>
                                <?php while (have_rows('key_services_accordion')): the_row(); 
                                    $heading = get_sub_field('accordions_heading');
                                    $paragraph = get_sub_field('accordions_paragraph');

                                    // Add "active" class only to the first item
                                    $class = $is_first ? 'sector-page-accordion-item active' : 'sector-page-accordion-item';
                                ?>
                                <div class="<?php echo $class; ?>">
                                    <?php
                                        echo $heading ? $heading : 'Not Available';
                                        echo $paragraph ? $paragraph : 'Not Available';
                                    ?>
                                </div>
                                <?php $is_first = false; ?>
                                <?php endwhile; ?>
                            <?php endif; ?>

                        </div>

                        <!-- Right Side - Image Placeholder -->
                        <div class="sector-page-technical-drawing">
                            <!-- Space reserved for your technical drawings/images -->
                            <!-- You can replace this with your actual image -->
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section class="benifitsContainer contanerPadding">
            <div class="container-benifits">
                <?php
                        $bennifits_heading = get_field("bennifits_heading");
                        echo $bennifits_heading ? $bennifits_heading : 'Not Available';
                    ?>
                    
                    <?php
                        $bennifits_sub_head = get_field("bennifits_sub_head");
                        echo $bennifits_sub_head ? $bennifits_sub_head : 'Not Available';
                    ?>
                
                <div class="features-list">


                    <?php if (have_rows('bennifits_cards')): ?>
                        <?php while (have_rows('bennifits_cards')): the_row(); 
                            $heading = get_sub_field('bennifits_card_heading');
                            $paragraph = get_sub_field('bennifits_card_paragraph');
                        ?>
                        <div class="feature-card">
                            <div class="feature-icon"></div> <!-- You can enhance this with an SVG or icon logic if needed -->
                            <div class="feature-content">
                                <?php if ($heading): ?>
                                    <h3 class="sector-page-accordion-title"><?php echo $heading; ?></h3>
                                <?php endif; ?>
                                
                                <?php if ($paragraph): ?>
                                    <?php echo $paragraph; ?>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php endwhile; ?>
                    <?php endif; ?>


                </div>
            </div>
        </section>

        <section class="benifitBanner contanerPadding">
            <div class="benefits-banner-container">
                <div class="benefits-banner-content">
                    <div class="benefits-banner-text">
                        <?php
                        $find_the_right_heading = get_field("find_the_right_heading");
                        echo $find_the_right_heading ? $find_the_right_heading : 'Not Available';
                    ?>

                        <?php
                            $find_the_right_paragraph = get_field("find_the_right_paragraph");
                            echo $find_the_right_paragraph ? $find_the_right_paragraph : 'Not Available';
                            $find_the_right_touch_btn = get_field("find_the_right_touch_btn");
                            echo $find_the_right_touch_btn ? $find_the_right_touch_btn : 'Not Available';
                        ?>
                        
                    </div>

                    <div class="benefits-banner-image">
                        <?php 
                            $image = get_field('find_the_right_image'); 
                            if ($image): 
                            ?>
                                <img src="<?php echo esc_url($image['url']); ?>" 
                                    alt="<?php echo esc_attr($image['alt'] ?: 'Building Image'); ?>" 
                                    class="benefits-banner-building">
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </section>

        <!-- <section class="international-container contanerPadding">
            <div class="container-international">
                
                    
                     <?php
                            $international_profile_heading = get_field("international_profile_heading");
                            echo $international_profile_heading ? $international_profile_heading : 'Not Available';
                          
                        ?>

                
                <?php
                    $international_profile_sub_head = get_field("international_profile_sub_head");
                    echo $international_profile_sub_head ? $international_profile_sub_head : 'Not Available';
                ?>
                
                <div class="grid-international">
                    <?php if (have_rows('international_profile_card')): ?>
                        <?php while (have_rows('international_profile_card')): the_row(); 
                            $heading = get_sub_field('international_profile_card_head');
                            $paragraph = get_sub_field('international_profile_paragraph');
                        ?>
                        <div class="card-international">
                            <?php
                                echo $heading ? $heading : '';
                                echo $paragraph ? $paragraph : 'Not Available';
                            ?>
                        </div>
                        <?php endwhile; ?>
                    <?php endif; ?>                    
                </div>

                
            </div>
        </section> -->

        <section class="frequentyAsked contanerPadding">
            <div class="frequently-asked-wrapper">
               
                <?php
                    $frequently_asked_heading = get_field("frequently_asked_heading");
                    echo $frequently_asked_heading ? $frequently_asked_heading : 'Not Available';
                ?>
                

                <?php
                    $frequently_asked_sub_head = get_field("frequently_asked_sub_head");
                    echo $frequently_asked_sub_head ? $frequently_asked_sub_head : 'Not Available';
                ?>
                <div class="sector-page-accordion-container">
                    <div class="sector-page-content-wrapper-frequently ">
                        <!-- Left Side - Accordion -->
                        <div class="sector-page-accordion">
                            <!-- What are Facade Detailing Services? - Active/Expanded -->
                            

                            <?php if (have_rows('frequently_asked_accordions')): ?>
                                <?php $isfirst = true; ?>
                                <?php while (have_rows('frequently_asked_accordions')): the_row(); 
                                    $heading = get_sub_field('frequently_accordions_heading');
                                    $paragraph = get_sub_field('frequently_accordions_paragraph');
                                    $activeclass = $isfirst ? 'sector-page-accordion-item active' : 'sector-page-accordion-item';
                                ?>
                                <div class="<?php echo $activeclass; ?>">
                                    <?php
                                        echo $heading ? $heading : 'Not Available';
                                        echo $paragraph ? $paragraph : 'Not Available';
                                    ?>
                                    
                                </div>
                                <?php endwhile; ?>
                            <?php endif; ?>
                        </div>

                    </div>
                </div>
            </div>

        </section>

        <!-- hero bottom section sector-->
        <section class="hero-bottom-section marginforHero">
            <div class="hero-bottom-background"></div>

            <div class="hero-bottom-shape hero-bottom-shape-1"></div>
            <div class="hero-bottom-shape hero-bottom-shape-2"></div>
            <div class="hero-bottom-shape hero-bottom-shape-3"></div>

            <div class="hero-bottom-container">
                <div class="hero-bottom-content">
                    <div class="hero-bottom-subtitle">
                                <?php
                        $engineering_title = get_field("engineering_title");
                        echo $engineering_title ? $engineering_title : 'Not Available';
                    ?>
                    </div>
                   
                                 <?php
                        $engineering_heading = get_field("engineering_heading");
                        echo $engineering_heading ? $engineering_heading : 'Not Available';
                    ?>
                                
                    
                    <div class="hero-bottom-cta">
                    <?php
                        $engineering_project_btn = get_field("engineering_project_btn");
                        echo $engineering_project_btn ? $engineering_project_btn : 'Not Available';
                    ?>
                    </div>
                </div>
            </div>
        </section>

    <section><?php the_content(); ?></section>                       

    </main>


<?php get_footer(); ?>

<script>  jQuery(document).ready(function () {
      jQuery('.sector-page-slider-track').slick({
        slidesToShow: 5,
        slidesToScroll: 1,
        autoplay: true,
        autoplaySpeed: 0,
        speed: 3000,
        cssEase: 'linear',
        infinite: true,
        arrows: false,
        dots: false,
        pauseOnHover: true,
        responsive: [
          {
            breakpoint: 1200,
            settings: { slidesToShow: 4 }
          },
          {
            breakpoint: 992,
            settings: { slidesToShow: 3 }
          },
          {
            breakpoint: 768,
            settings: { slidesToShow: 2 }
          },
          {
            breakpoint: 480,
            settings: { slidesToShow: 1 }
          }
        ]
      });
      
      // Fix for seamless looping
      jQuery('.sector-page-slider-track').on('afterChange', function(event, slick, currentSlide){
        if(currentSlide >= slick.slideCount/2){
          slick.slickGoTo(currentSlide - (slick.slideCount/2), false);
        }
      });
    });</script>
