<?php 
/** * Template Name: Product */
get_header(); ?>

   
<main class="main-content ">
    <section class="projectService contanerPadding ">

        <div class="service-page-container">
            <!-- Main Content Area -->
            <div class="service-page-main-area" data-aos="fade-right">
                <!-- Hero Section -->
                <div class="service-page-hero-section">
                    
                    <?php 
                        $hero_image = get_field('hero_image');
                        if ($hero_image): 
                        ?>
                            <img src="<?php echo esc_url($hero_image['url']); ?>" 
                                alt="<?php echo esc_attr($hero_image['alt'] ?: 'Hero image'); ?>" 
                                class="service-page-hero-image">
                    <?php endif; ?>

                    <div class="service-page-hero-overlay">
                        
                            
                            <?php
                                $hero_title = get_field("hero_title");
                                echo $hero_title ? $hero_title : 'Not Available';
                            ?>
                      
                        <div class="service-page-hero-tags">
                            <?php if (have_rows('hero_tag')): ?>
                                <?php while (have_rows('hero_tag')): the_row(); 
                                    $tag = get_sub_field('hero_badges');
                                    
                                ?>
                                    <span class="service-page-hero-tag"><?php echo $tag ? $tag : 'Not Available'; ?></span>
                                <?php 
                                   
                                endwhile; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Main Content -->
                <div class="service-page-main-content">
                    <?php
                        $hero_paragraph = get_field("hero_paragraph");
                        echo $hero_paragraph ? $hero_paragraph : 'Not Available';
                    ?>
                </div>
            </div>

            <!-- Sidebar -->
            <div class="service-page-sidebar">
                <!-- Location Card -->
                <div class="service-page-sidebar-card service-page-location-card">
                    <div class="service-page-location-header">
                        <div class="service-page-location-icon">
                             <?php
                                $location_icon = get_field("location_icon");
                                echo $location_icon ? $location_icon : 'Not Available';
                            ?>    
                        </div>
                       
                            <?php
                                $location_title = get_field("location_title");
                                echo $location_title ? $location_title : 'Not Available';
                            ?>
                        
                    </div>
                    <div class="service-page-location-content">
                        <div class="service-page-location-title">
                            <?php
                                $location_address = get_field("location_address");
                                echo $location_address ? $location_address : 'Not Available';
                            ?>
                        </div>
                        <div class="service-page-location-subtitle">
                            
                            <?php
                                $country = get_field("country");
                                echo $country ? $country : 'Not Available';
                            ?>
                        </div>
                    </div>
                    <div class="service-page-sidebar-card">
                        <div class="service-page-client-header">
                            <div class="service-page-client-icon"></div>
                            <span class="service-page-client-header-text"> 
                                <?php
                                    $client_title = get_field("client_title");
                                    echo $client_title ? $client_title : 'Not Available';
                                ?>
                            </span>
                        </div>
                        <div class="service-page-client-content">
                            <div class="service-page-client-name">
                                <?php
                                    $client_name = get_field("client_name");
                                    echo $client_name ? $client_name : 'Not Available';
                                ?>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Client Card -->


                <!-- Key Outcomes Card -->
                <div class="service-page-sidebar-card service-page-outcomes-card">
                    <div class="service-page-outcomes-header">
                        <div class="service-page-outcomes-icon">
                            <?php
                                $keyoutcomes_icon = get_field("keyoutcomes_icon");
                                echo $keyoutcomes_icon ? $keyoutcomes_icon : 'Not Available';
                            ?>
                        </div>
                        <span class="service-page-outcomes-header-text">
                            
                            <?php
                                $key_outcomes_head = get_field("key_outcomes_head");
                                echo $key_outcomes_head ? $key_outcomes_head : 'Not Available';
                            ?>
                        </span>
                    </div>
                    <div class="service-page-outcomes-content">
                       
                            <?php if (have_rows('key_outcomes_title')): ?>
                                <ul class="service-page-outcomes-list">
                                    <?php while (have_rows('key_outcomes_title')): the_row(); 
                                        $outcome_text = get_sub_field('keyoutcomes_text');
                                        if ($outcome_text):
                                    ?>
                                        <li><?php echo $outcome_text; ?></li>
                                    <?php endif; endwhile; ?>
                                </ul>
                            <?php endif; ?>
                   
                    </div>
                </div>

                <!-- Expertise Provided Card -->
                <div class="service-page-sidebar-card service-page-expertise-card">
                    <div class="service-page-expertise-header">
                        <div class="service-page-expertise-icon">
                            
                            <?php
                                $expertice_image = get_field("expertice_image");
                                echo $expertice_image ? $expertice_image : 'Not Available';
                            ?>
                        </div>
                        
                            <?php
                                $expertise_title = get_field("expertise_title");
                                echo $expertise_title ? $expertise_title : 'Not Available';
                            ?>
                       
                    </div>
                    <div class="service-page-expertise-content">

                        <?php if (have_rows('expertise_listing')): ?>
                            <?php while (have_rows('expertise_listing')): the_row(); 
                                $title = get_sub_field('expertise_title');
                                $icon = get_sub_field('expertise_title_icon');
                                if ($title):
                            ?>
                            <div class="service-page-expertise-item">
                                <span class="service-page-expertise-name"><?php echo $title ? $title : 'Not Available'; ?></span>
                                <?php echo $icon ? $icon : 'Not Available'; ?>
                            </div>
                            <?php endif; endwhile; ?>
                        <?php endif; ?>

                        
                    </div>
                </div>

                <!-- Contact Button -->
                 
                <?php
                    $let_build_together_btn = get_field("let_build_together_btn");
                    echo $let_build_together_btn ? $let_build_together_btn : 'Not Available';
                ?>
            </div>
        </div>

    </section>
    <!-- Related Post -->
    <section class="contanerPadding">
        <div class="related-projects-container">
            
                <?php
                    $related_post_title = get_field("related_post_title");
                    echo $related_post_title ? $related_post_title : 'Not Available';
                ?>
                
            
            <!-- <h4 class="service-page-hero-title headingRelatedPost"></h4> -->

            <div class="related-projects-grid" data-aos="fade-up">
                <!-- Male-Thilaafushi Link Card -->
                
                <?php if (have_rows('related_posts')): ?>
                    <?php while (have_rows('related_posts')): the_row(); 
                        $image = get_sub_field('related_post_image');
                        $badge = get_sub_field('related_post_bages');
                        $title = get_sub_field('related_post_title');
                        $address = get_sub_field('related_post_address');
                        $country = get_sub_field('related_post_country');
                    ?>
                    <div class="related-projects-card" data-project="<?php echo sanitize_title($title); ?>">
                        <div class="related-projects-image-container">
                            <?php if (!empty($image)): ?>
                                <img src="<?php echo esc_url($image['url']); ?>" 
                                    alt="<?php echo esc_attr($image['alt'] ?: $title); ?>" 
                                    class="related-projects-image">
                            <?php endif; ?>
                            <?php if ($badge): ?>
                                <div class="related-projects-category-tag related-projects-bridges-tag">
                                    <?php echo $badge; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="related-projects-content">
                            <?php if ($title): ?>
                                <h3 class="news-log-slide-title"><?php echo $title; ?></h3>
                            <?php endif; ?>
                            <?php if ($address): ?>
                                <p class="service-page-expertise-name"><?php echo $address; ?></p>
                            <?php endif; ?>
                            <?php if ($country): ?>
                                <p class="related-projects-location-secondary"><?php echo $country; ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php endwhile; ?>
                <?php endif; ?>



            </div>
        </div>
    </section>
    <section class="hero-bottom-section marginforHero">
        <div class="hero-bottom-background  hero-bottom-background-service"></div>
        <div class="hero-bottom-container servicePage-heroContainer">
            <div class="hero-bottom-content servicePage-hero">
                
                <?php
                    $word_class_engineer_title = get_field("word_class_engineer_title");
                    echo $word_class_engineer_title ? $word_class_engineer_title : 'Not Available';
                ?>    
               
                
                <?php
                    $word_class_engineer_heading = get_field("word_class_engineer_heading");
                    echo $word_class_engineer_heading ? $word_class_engineer_heading : 'Not Available';
                ?>  
           
                <div class="button-group serivePageButtonGroup">
                        <?php
                            $get_in_touch_btn = get_field("get_in_touch_btn");
                            echo $get_in_touch_btn ? $get_in_touch_btn : 'Not Available';
                            $corporate_broucher_btn = get_field("corporate_broucher_btn");
                            echo $corporate_broucher_btn ? $corporate_broucher_btn : 'Not Available';
                        ?>
                    </div>
            </div>
        </div>
    </section>
    <section><?php the_content(); ?></section>
</main>


<?php get_footer(); ?>