<?php 
/** * Template Name: Contact */
get_header(); 
?>
<style>
.wpcf7-form p {
  position: relative;
  margin-top: 40px;
}

/* Floating label inside input */
.wpcf7-form p > label {
  position: absolute;
  left: 14px;
  top: 25px;
  transform: translateY(-50%);
  font-size: 16px;
  color: #aaa;
  background: #fff;
  padding: 0 4px;
  pointer-events: none;
  transition: all 0.2s ease;
  z-index: 1;
}

/* Float label to top */
.wpcf7-form p.float > label {
  top: -10px;
  left: 10px;
  font-size: 12px;
  color: #333;
}

/* Input and textarea styling */
.wpcf7-form p input[type="text"],
.wpcf7-form p input[type="email"],
.wpcf7-form p input[type="tel"],
.wpcf7-form p textarea {
  padding: 16px 12px 10px 12px;
  font-size: 16px;
  box-sizing: border-box;
  border: 1px solid #ccc;
  background: transparent;
  outline: none;
  width: 100%;
}

.wpcf7-form p input:focus,
.wpcf7-form p textarea:focus {
  border-color: #333;
}

.checkbox-consent > p > span > .wpcf7-not-valid-tip {
    position: absolute;
    width: 200px;
    top: 47px;
}

.wpcf7-list-item-label {
  display: none;
}
</style>
<!-- Demo Content -->
    <main class="main-content">
        <div class="scroll-indicator">
            <div class="scroll-text">SCROLL</div>
            <div class="scroll-line">
                <div class="scroll-progress"></div>
            </div>
        </div>
        <!-- hero bottom section -->
        <section class="hero-bottom-section marginforHero">
            <div class="hero-bottom-background"></div>
            <div class="hero-bottom-container">
                <div class="hero-bottom-content">
                    <div class="hero-bottom-subtitle">
                      <?php
                            $get_in_touch_title = get_field("get_in_touch_title");
                            echo $get_in_touch_title ? $get_in_touch_title : 'Not Available';
                        ?>
                    </div>
                    
                        <?php
                            $contact_us_heading = get_field("contact_us_heading");
                            echo $contact_us_heading ? $contact_us_heading : 'Not Available';
                        ?>
            
                </div>
            </div>
        </section>
        <section class=" marginforHero">
            <section class="wrapper">
              <section class="left-panel">
                <?php
                    $contact_heading = get_field("contact_heading");
                    echo $contact_heading ? $contact_heading : 'Not Available';
                    $contact_us_paragraph = get_field("contact_us_paragraph");
                    echo $contact_us_paragraph ? $contact_us_paragraph : 'Not Available';
                ?>
                <div class="locations">
                  <?php
                    $contact_us_location = get_field("contact_us_location");
                    echo $contact_us_location ? $contact_us_location : 'Not Available';
                  ?>
                </div>
                  <?php
                    $contact_us_email = get_field("contact_us_email");
                    echo $contact_us_email ? $contact_us_email : 'Not Available';
                  ?>
              </section>

              <section class="form-panel">
                <?php
                  $form_shortcode = '[contact-form-7 id="db73c9b" title="contact us"]';
                  if (function_exists('do_shortcode')) {
                      echo do_shortcode($form_shortcode);
                  } else {
                      echo '<p>Error: Contact form could not be loaded.</p>';
                  }
                ?>
              </section>
            </section>
        </section>
        <section class="map-section">
          <div id="map-container">
            <?php
                $contact_map = get_field("contact_map");
                echo $contact_map ? $contact_map : 'Not Available';
            ?>
          </div>
        </section>
        <section><?php the_content(); ?></section>
    </main> 
<?php get_footer(); ?>

<script>
document.addEventListener("DOMContentLoaded", function () {
  const form = document.querySelector(".wpcf7-form");
  if (!form) return;

  const fields = form.querySelectorAll("p");

  fields.forEach((field) => {
    const input = field.querySelector("input, textarea");
    const label = field.querySelector("label");

    if (!input || !label) return;

    const toggleFloat = () => {
      if (input.value.trim() !== "") {
        field.classList.add("float");
      } else {
        field.classList.remove("float");
      }
    };

    // Check on load
    toggleFloat();

    input.addEventListener("focus", () => field.classList.add("float"));
    input.addEventListener("blur", toggleFloat);
  });
});
</script>
