<?php

/**
 * The main template file
 *
 * Template Name: Project Masonary Template
 *
 * @link https:   //developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package vernex
 * @since 1.0.0
 * 
 */
get_header();

if (!is_front_page()) {
    $posts_per_page_option = Egns\Helper\Egns_Helper::egns_get_theme_option('posts_per_page_option_portfolio');
    // Include breadcrumb template
    Egns\Helper\Egns_Helper::egns_template_part('breadcrumb', 'templates/breadcrumb-archive');
}

?>


<div class="project-masonary-page sec-mar">
    <div class="container">
        <div class="row gy-5 align-items-center justify-content-between" id="project-archive-masonary">
            <?php
            $args = array(
                'post_type'      => 'project',
                'post_status'    => 'publish',
                'posts_per_page' => 5,
                'paged'          => (get_query_var('paged')) ? get_query_var('paged') : 1
            );

            $wp_query = new WP_Query($args);

            if ($wp_query->have_posts()) {
                $index = 0; // Initialize index counter
                $classes = array('col-lg-6 ', 'col-lg-5', 'col-lg-5', 'col-lg-6', 'col-lg-12'); // Column classes
                $class_count = count($classes);

                while ($wp_query->have_posts()) :
                    $wp_query->the_post();
                    // Determine the class for the current iteration
                    $class = $classes[$index % $class_count];
                    $index++; // Increment the index counter
            ?>
                    <div class="<?php echo esc_attr($class); ?> wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                        <?php echo apply_filters('egns_filter_blog_single_template', Egns\Helper\Egns_Helper::egns_get_template_part('project', 'parts/archive-masonary')); ?>
                    </div>
            <?php
                endwhile;
                wp_reset_postdata();
            } else {
                // Include global posts not found template
                Egns\Helper\Egns_Helper::egns_template_part('content', 'templates/posts-not-found');
            }
            ?>
        </div>
        <div class="row">
            <div class="col-lg-12 d-flex justify-content-center">
                <div id="archive-load-more-project-masonary" class="load-more-for-project-btn">
                    <button class="primary-btn2 bounce_up mt-70">
                        <span>
                            <?php echo esc_html__('Load More', 'vernex'); ?>
                            <svg viewBox="0 0 13 20">
                                <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                            </svg>
                            <img src="<?php echo esc_sql(get_template_directory_uri() . '/assets/img/loading.gif') ?>" class="loading-gif" style="display: none; height:14px; width:14px" alt="<?php echo esc_attr__('image', 'vernex') ?>" />
                        </span>
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>


<?php

get_footer();

?>