<div class="project-details-page pt-120 mb-120">
    <div class="container">
        <div class="row g-lg-4 gy-5 mb-120">
            <div class="col-lg-8">
                <div class="project-details-thumb mb-50">
                    <?php if (has_post_thumbnail()) : ?>
                        <?php the_post_thumbnail(); ?>
                    <?php endif; ?>
                </div>
                <?php the_content(); ?>
            </div>
            <div class="col-lg-4">
                <div class="project-details-sidebar">
                    <?php $project_info = Egns\Helper\Egns_Helper::egns_project_value('project_info_list');
                    if (!empty($project_info)) :  ?>
                        <div class="project-info-wrap mb-35">
                            <ul class="project-info">
                                <?php
                                if (!empty(Egns\Helper\Egns_Helper::egns_project_value('project_info_list'))) :
                                    foreach ($project_info as $step_data) :
                                ?>
                                        <li>
                                            <div class="icon">
                                                <svg width="33" height="31" viewBox="0 0 33 31" xmlns="http://www.w3.org/2000/svg">
                                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                                        d="M16.0579 21.2802H4.74407V9.95283L16.0579 2.90563V21.2802ZM24.3018 31V20.9025H28.8373V31H29.9073V20.3253C29.9073 20.1726 29.851 20.0256 29.7505 19.9173C29.6501 19.8089 29.5139 19.7481 29.3723 19.7481H23.7668C23.6252 19.7481 23.489 19.8089 23.3886 19.9173C23.2889 20.0256 23.2326 20.1726 23.2326 20.3253V31H24.3018ZM4.72961 31V26.1754H8.87098V31H9.94094V25.5982C9.94094 25.4447 9.88463 25.2985 9.78418 25.1901C9.68372 25.0818 9.5475 25.021 9.40596 25.021H4.19539C4.05309 25.021 3.91687 25.0818 3.81718 25.1901C3.71672 25.2985 3.66041 25.4447 3.66041 25.5982V31H4.72961ZM4.72961 31V26.1754H8.87098V31H9.94094V25.5982C9.94094 25.4447 9.88463 25.2985 9.78418 25.1901C9.68372 25.0818 9.5475 25.021 9.40596 25.021H4.19539C4.05309 25.021 3.91687 25.0818 3.81718 25.1901C3.71672 25.2985 3.66041 25.4447 3.66041 25.5982V31H4.72961ZM4.72961 31V26.1754H8.87098V31H9.94094V25.5982C9.94094 25.4447 9.88463 25.2985 9.78418 25.1901C9.68372 25.0818 9.5475 25.021 9.40596 25.021H4.19539C4.05309 25.021 3.91687 25.0818 3.81718 25.1901C3.71672 25.2985 3.66041 25.4447 3.66041 25.5982V31H4.72961ZM4.72961 31V26.1754H8.87098V31H9.94094V25.5982C9.94094 25.4447 9.88463 25.2985 9.78418 25.1901C9.68372 25.0818 9.5475 25.021 9.40596 25.021H4.19539C4.05309 25.021 3.91687 25.0818 3.81718 25.1901C3.71672 25.2985 3.66041 25.4447 3.66041 25.5982V31H4.72961ZM4.72961 31V26.1754H8.87098V31H9.94094V25.5982C9.94094 25.4447 9.88463 25.2985 9.78418 25.1901C9.68372 25.0818 9.5475 25.021 9.40596 25.021H4.19539C4.05309 25.021 3.91687 25.0818 3.81718 25.1901C3.71672 25.2985 3.66041 25.4447 3.66041 25.5982V31H4.72961ZM1.0692 31V22.4338H20.7997V31H21.8696V21.8574C21.8696 21.7039 21.8133 21.5578 21.7129 21.4494C21.6124 21.341 21.4762 21.2802 21.3346 21.2802H17.1271V10.2468L31.9308 14.0187V31H33V13.5622C33 13.4325 32.9597 13.3061 32.8851 13.2042C32.8097 13.1024 32.7055 13.031 32.5883 13.0006L17.1271 9.06115V2.23974L18.9938 1.07712C19.1171 0.999935 19.2061 0.874313 19.2434 0.726521C19.2799 0.578729 19.2609 0.421085 19.1901 0.288893C19.1186 0.155881 19.0022 0.0598162 18.8652 0.019584C18.7282 -0.0198271 18.5821 0.000699533 18.4588 0.0770586L1.41926 10.6918C1.29674 10.7681 1.20695 10.8946 1.17042 11.0424C1.13389 11.1902 1.15291 11.3478 1.22369 11.48C1.29446 11.6122 1.41165 11.7091 1.54863 11.7485C1.68561 11.7887 1.83097 11.7674 1.95425 11.691L3.67487 10.6195V21.2802H0.534222C0.392676 21.2802 0.256457 21.341 0.156766 21.4494C0.056314 21.5578 0 21.7039 0 21.8574V31H1.0692Z" />
                                                </svg>
                                            </div>
                                            <div class="content">
                                                <?php if (!empty($step_data['project_label_text'])) : ?>
                                                    <span><?php echo esc_html($step_data['project_label_text']); ?></span>
                                                <?php endif; ?>
                                                <?php if (!empty($step_data['project_content_text'])) : ?>
                                                    <h5><?php echo esc_html($step_data['project_content_text']); ?></h5>
                                                <?php endif; ?>
                                            </div>
                                        </li>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                    <?php if (Egns\Helper\Egns_Helper::egns_project_value('project_sidebar_banner_enable')) : ?>
                        <div class="sidebar-banner">
                            <?php if (!empty(Egns\Helper\Egns_Helper::egns_project_value('project_sidebar_banner_image', 'url'))) : ?>
                                <img src="<?php echo esc_url(Egns\Helper\Egns_Helper::egns_project_value('project_sidebar_banner_image', 'url')); ?>" alt="<?php echo esc_attr__('banner-image', 'vernex'); ?>">
                            <?php endif; ?>
                            <div class="banner-content-wrap">
                                <div class="banner-content">
                                    <?php if (!empty(Egns\Helper\Egns_Helper::egns_project_value('project_sidebar_banner_title_text'))) : ?>
                                        <h2><?php echo wp_kses(Egns\Helper\Egns_Helper::egns_project_value('project_sidebar_banner_title_text'), array()); ?> </h2>
                                    <?php endif; ?>
                                    <?php if (!empty(Egns\Helper\Egns_Helper::egns_project_value('project_sidebar_banner_button_text'))) : ?>
                                        <a href="<?php echo esc_url(Egns\Helper\Egns_Helper::egns_project_value('project_sidebar_banner_button_link', 'url')); ?>" class="primary-btn2 white-bg">
                                            <span>
                                                <?php echo esc_html(Egns\Helper\Egns_Helper::egns_project_value('project_sidebar_banner_button_text')); ?> <svg viewBox="0 0 13 20">
                                                    <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                                </svg>
                                            </span>
                                        </a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <?php
        $prev = get_adjacent_post(false, '', true);
        $next = get_adjacent_post(false, '', false);
        ?>
        <?php if (!empty($prev || $next)) : ?>
            <div class="row">
                <div class="col-lg-12">
                    <div class="details-navigation">
                        <?php if (!empty($prev)) : ?>
                            <div class="single-navigation">
                                <a href="<?php echo get_permalink($prev->ID); ?>" class="nav-btn">
                                    <svg width="11" height="10" viewBox="0 0 11 10" xmlns="http://www.w3.org/2000/svg">
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M1.67118 2.22814C3.3038 3.17073 5.66169 2.52309 6.61781 0.867041L7.00966 0.188334L8.34898 0.961587L7.95712 1.64029C7.26198 2.84432 6.08894 3.6729 4.79245 4.03021L10.0419 7.06097L9.25818 8.41838L4.00874 5.38762C4.34755 6.68907 4.2165 8.11924 3.52136 9.32327L3.12951 10.002L1.79019 9.22872L2.18204 8.55001C3.13777 6.89464 2.5201 4.52815 0.887474 3.58555L0.217818 3.19893L1.00152 1.84151L1.67118 2.22814Z" />
                                    </svg>
                                    <?php echo esc_html__('PRV PROJECT', 'vernex'); ?>
                                </a>
                                <div class="content">
                                    <h6><a href="<?php the_permalink(); ?>"><?php echo esc_html__('The complete gu unlocking your team’s power of our unique work.', 'vernex'); ?></a></h6>
                                </div>
                            </div>
                        <?php endif; ?>
                        <?php if (!empty($next)) : ?>
                            <div class="single-navigation two">
                                <div class="content">
                                    <h6><a href="<?php the_permalink(); ?>"><?php echo esc_html__('Challenges creating structure multiple brand system.', 'vernex'); ?></a></h6>
                                </div>
                                <a href="<?php echo get_permalink($next->ID); ?>" class="nav-btn">
                                    <?php echo esc_html__('NXT PROJECT', 'vernex'); ?>
                                    <svg width="11" height="10" viewBox="0 0 11 10" xmlns="http://www.w3.org/2000/svg">
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M8.97921 2.22814C7.34659 3.17073 4.9887 2.52309 4.03258 0.867041L3.64073 0.188334L2.30142 0.961587L2.69327 1.64029C3.38841 2.84432 4.56145 3.6729 5.85794 4.03021L0.608508 7.06097L1.39221 8.41838L6.64165 5.38762C6.30284 6.68907 6.43389 8.11924 7.12903 9.32327L7.52088 10.002L8.8602 9.22872L8.46835 8.55001C7.51262 6.89464 8.13029 4.52815 9.76292 3.58555L10.4326 3.19893L9.64887 1.84151L8.97921 2.22814Z" />
                                    </svg>
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>