<?php

use Egns\Inc\Blog_Helper; ?>


<div class="blog-details-top-area">
    <ul class="blog-meta">
        <li>
            <svg width="16" height="16" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg">
                <path
                    d="M8 0C3.60594 0 0 3.60594 0 8C0 12.3941 3.60594 16 8 16C12.3941 16 16 12.3941 16 8C16 3.60594 12.3941 0 8 0ZM11.646 3.69106C11.8291 3.508 12.1259 3.508 12.3089 3.69106C12.492 3.87413 12.492 4.17091 12.3089 4.35397C12.1259 4.53703 11.8291 4.53703 11.646 4.35397C11.463 4.17091 11.463 3.87413 11.646 3.69106ZM7.53125 2.375C7.53125 2.11591 7.74091 1.90625 8 1.90625C8.25909 1.90625 8.46875 2.11591 8.46875 2.375V3.3125C8.46875 3.57159 8.25909 3.78125 8 3.78125C7.74091 3.78125 7.53125 3.57159 7.53125 3.3125V2.375ZM2.375 8.46875C2.11591 8.46875 1.90625 8.25909 1.90625 8C1.90625 7.74091 2.11591 7.53125 2.375 7.53125H3.3125C3.57159 7.53125 3.78125 7.74091 3.78125 8C3.78125 8.25909 3.57159 8.46875 3.3125 8.46875H2.375ZM4.35397 12.3089C4.17091 12.492 3.87413 12.492 3.69106 12.3089C3.508 12.1259 3.508 11.8291 3.69106 11.646C3.87413 11.4629 4.17091 11.4629 4.35397 11.646C4.53703 11.8291 4.53703 12.1259 4.35397 12.3089ZM4.35397 4.35397C4.17091 4.53703 3.87413 4.53703 3.69106 4.35397C3.508 4.17091 3.508 3.87413 3.69106 3.69106C3.87413 3.508 4.17091 3.508 4.35397 3.69106C4.53703 3.87413 4.53703 4.17091 4.35397 4.35397ZM8.46875 13.625C8.46875 13.8841 8.25909 14.0938 8 14.0938C7.74091 14.0938 7.53125 13.8841 7.53125 13.625V12.6875C7.53125 12.4284 7.74091 12.2188 8 12.2188C8.25909 12.2188 8.46875 12.4284 8.46875 12.6875V13.625ZM11.1439 11.1439C10.9608 11.327 10.6642 11.327 10.4811 11.1439L7.66856 8.33141C7.58069 8.24353 7.53125 8.1245 7.53125 8V5.1875C7.53125 4.92841 7.74091 4.71875 8 4.71875C8.25909 4.71875 8.46875 4.92841 8.46875 5.1875V7.80591L11.1439 10.4811C11.327 10.6642 11.327 10.9608 11.1439 11.1439ZM12.3089 12.3089C12.1259 12.492 11.8291 12.492 11.646 12.3089C11.463 12.1259 11.463 11.8291 11.646 11.646C11.8291 11.4629 12.1259 11.4629 12.3089 11.646C12.492 11.8291 12.492 12.1259 12.3089 12.3089ZM14.0938 8C14.0938 8.25909 13.8841 8.46875 13.625 8.46875H12.6875C12.4284 8.46875 12.2188 8.25909 12.2188 8C12.2188 7.74091 12.4284 7.53125 12.6875 7.53125H13.625C13.8841 7.53125 14.0938 7.74091 14.0938 8Z" />
            </svg>
            <?php echo get_the_date('F d, Y'); ?>
        </li>

        <?php
        if (is_single()) {
            Blog_Helper::customSetPostViews(get_the_ID());
        }
        $count = get_post_meta(get_the_ID(), 'post_views_count', true);
        $count_formatted = Blog_Helper::format_post_views_count($count);
        ?>
        <li>
            <svg width="12" height="16" viewBox="0 0 12 16" xmlns="http://www.w3.org/2000/svg">
                <path
                    d="M7.80968 15.0679C9.5273 12.1176 8.80817 8.40483 6.09966 6.24033C6.09808 6.23911 6.0965 6.23758 6.09523 6.23666L6.10694 6.26482L6.10504 6.28594C6.63276 7.63466 6.55873 9.11531 5.91047 10.3857L5.45362 11.2813L5.31347 10.2917C5.21824 9.62039 4.95659 8.98001 4.55353 8.43177H4.48994L4.4564 8.33993C4.46115 9.3657 4.23778 10.3762 3.7996 11.3294C3.22474 12.5768 3.30922 14.0152 4.02581 15.1778L4.52031 15.9804L3.63066 15.6168C2.16361 15.0171 0.990804 13.8618 0.412783 12.4473C-0.234842 10.8678 -0.114934 9.03633 0.733906 7.54925C1.17652 6.77572 1.48657 5.95443 1.65583 5.10773L1.82129 4.27787L2.24334 5.01804C2.44487 5.37098 2.59326 5.75301 2.68532 6.15432L2.69481 6.16381L2.70462 6.22809L2.71379 6.22533C3.97804 4.6002 4.73545 2.57805 4.84586 0.530486L4.87434 0L5.33435 0.290191C7.21173 1.47391 8.51552 3.37301 8.91827 5.5069L8.92744 5.55067L8.93219 5.5574L8.95275 5.52924C9.3207 5.05906 9.51496 4.4998 9.51496 3.91115V2.99956L10.0835 3.72626C11.4053 5.41537 12.083 7.51068 11.9919 9.62651C11.8799 12.117 10.4761 14.3029 8.23648 15.4873L7.26678 16L7.80968 15.0679Z" />
            </svg>
            <?php echo sprintf('%s', $count_formatted) . esc_html__(' Views', 'vernex'); ?>
        </li>
        <li>
            <a href="#comment-area">
                <svg width="16" height="16" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg">
                    <g>
                        <path
                            d="M14.5672 14.9619C14.5917 15.0728 14.5913 15.1878 14.5658 15.2986C14.5403 15.4093 14.4905 15.513 14.42 15.6021C14.3494 15.6912 14.2599 15.7635 14.158 15.8136C14.056 15.8638 13.9441 15.8906 13.8305 15.8922C13.7133 15.8916 13.5977 15.8643 13.4925 15.8124L12.1483 15.1555C10.8921 15.6143 9.51644 15.6277 8.2515 15.1936C6.98655 14.7595 5.90904 13.9042 5.19922 12.7708C6.15026 12.8941 7.11661 12.8159 8.03545 12.5413C8.95429 12.2667 9.80505 11.8018 10.5324 11.1768C11.2598 10.5518 11.8476 9.78079 12.2575 8.91379C12.6674 8.0468 12.8902 7.10326 12.9116 6.14449C12.9119 5.70944 12.8674 5.27551 12.7787 4.84961C13.6879 5.29062 14.4611 5.96909 15.0165 6.81329C15.572 7.65749 15.8891 8.63608 15.9342 9.64561C15.9643 10.4111 15.8346 11.1744 15.5535 11.887C15.2724 12.5996 14.846 13.2459 14.3014 13.7847L14.5672 14.9619Z" />
                        <path
                            d="M6.0757 0.216683C4.48484 0.198937 2.95187 0.812778 1.81293 1.92361C0.673981 3.03443 0.0220199 4.55159 1.29169e-06 6.14239C-0.000538167 6.95003 0.167902 7.74885 0.494497 8.48752C0.821091 9.22618 1.29861 9.88834 1.89638 10.4315L1.65183 11.737C1.63148 11.8466 1.63545 11.9593 1.66346 12.0673C1.69147 12.1752 1.74285 12.2756 1.81395 12.3615C1.88505 12.4474 1.97414 12.5166 2.07493 12.5642C2.17572 12.6119 2.28575 12.6368 2.39724 12.6373C2.52333 12.6371 2.64739 12.6056 2.75837 12.5458L4.19679 11.773C4.8041 11.9679 5.43791 12.0675 6.0757 12.0685C7.66662 12.0862 9.19965 11.4723 10.3386 10.3614C11.4776 9.25051 12.1295 7.73326 12.1514 6.14239C12.1294 4.55159 11.4774 3.03443 10.3385 1.92361C9.19953 0.812778 7.66656 0.198937 6.0757 0.216683ZM3.79731 7.05184C3.64711 7.05184 3.50027 7.0073 3.37538 6.92385C3.25049 6.8404 3.15314 6.72179 3.09566 6.58302C3.03818 6.44424 3.02314 6.29154 3.05244 6.14422C3.08175 5.9969 3.15408 5.86157 3.26029 5.75536C3.36651 5.64915 3.50183 5.57682 3.64915 5.54751C3.79647 5.51821 3.94917 5.53325 4.08795 5.59073C4.22672 5.64821 4.34533 5.74555 4.42878 5.87045C4.51223 5.99534 4.55678 6.14217 4.55678 6.29238C4.55678 6.4938 4.47676 6.68698 4.33433 6.8294C4.19191 6.97183 3.99874 7.05184 3.79731 7.05184ZM6.0757 7.05184C5.92549 7.05184 5.77866 7.0073 5.65377 6.92385C5.52887 6.8404 5.43153 6.72179 5.37405 6.58302C5.31657 6.44424 5.30153 6.29154 5.33083 6.14422C5.36013 5.9969 5.43247 5.86157 5.53868 5.75536C5.64489 5.64915 5.78022 5.57682 5.92754 5.54751C6.07486 5.51821 6.22756 5.53325 6.36633 5.59073C6.50511 5.64821 6.62372 5.74555 6.70717 5.87045C6.79062 5.99534 6.83516 6.14217 6.83516 6.29238C6.83516 6.4938 6.75515 6.68698 6.61272 6.8294C6.47029 6.97183 6.27712 7.05184 6.0757 7.05184ZM8.35409 7.05184C8.20388 7.05184 8.05704 7.0073 7.93215 6.92385C7.80726 6.8404 7.70992 6.72179 7.65244 6.58302C7.59495 6.44424 7.57991 6.29154 7.60922 6.14422C7.63852 5.9969 7.71085 5.86157 7.81707 5.75536C7.92328 5.64915 8.0586 5.57682 8.20592 5.54751C8.35324 5.51821 8.50595 5.53325 8.64472 5.59073C8.78349 5.64821 8.90211 5.74555 8.98556 5.87045C9.06901 5.99534 9.11355 6.14217 9.11355 6.29238C9.11355 6.4938 9.03354 6.68698 8.89111 6.8294C8.74868 6.97183 8.55551 7.05184 8.35409 7.05184Z" />
                    </g>
                </svg>
                <?php comments_number(esc_html__('0 Comment', 'vernex'), esc_html__('1 Comment', 'vernex'), esc_html__('% Comments', 'vernex')); ?>
            </a>
        </li>
    </ul>

    <div class="author-area">
        <div class="author-img">
            <?php echo get_avatar(get_the_author_meta('ID')); ?>
        </div>
        <div class="author-content">
            <h6><?php echo esc_html__('By', 'vernex') ?>, <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID')))  ?>"><?php echo get_the_author_meta('display_name') ?></a></h6>
        </div>
    </div>
</div>