<?php
/*-------------------------
**** WooCommerce Hooks ****
--------------------------*/

global $product;

/**
 * remove default woocommerce sidebar
 */
remove_action('woocommerce_sidebar', 'woocommerce_get_sidebar', 10);

/**
 * remove default breadcrumb product
 */
remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);


/**
 * remove default related_products
 */
remove_action('woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20);


/**
 * woocommerce product single review position change
 */
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10);
add_action('woocommerce_single_product_summary', 'woocommerce_template_single_rating', 9);


// Remove rating text and show only stars on archive and single product pages
add_filter('woocommerce_product_get_rating_html', 'custom_woocommerce_rating_stars_only', 10, 3);

function custom_woocommerce_rating_stars_only($rating_html, $rating, $count)
{
    // Generate star rating HTML without the text
    if ($rating > 0) {
        $rating_html  = '<div class="star-rating" title="' . esc_attr(sprintf(__('Rated %s out of 5', 'vernex'), $rating)) . '">';
        $rating_html .= wc_get_star_rating_html($rating, $count, false);
        $rating_html .= '</div>';
    }
    return $rating_html;
}

/**
 * woocommerce product single excerpt position change
 */
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 20);
add_action('woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 9);



/**
 * Add ICON to Add to Cart Button
 */
add_filter('woocommerce_loop_add_to_cart_link', 'custom_add_to_cart_button_icon', 10, 2);

function custom_add_to_cart_button_icon($button, $product)
{
    // Add the icon before the Add to Cart button text
    $button = sprintf(
        '<a href="%s" data-quantity="%s" class="%s" %s>%s</a>',
        esc_url($product->add_to_cart_url()),
        esc_attr(isset($quantity) ? $quantity : 1),
        esc_attr(isset($class) ? $class : 'add-cart-btn'),
        wc_implode_html_attributes(apply_filters('woocommerce_loop_add_to_cart_args', [], $product)),
        '<i class="bi bi-bag-check"></i> ' . esc_html($product->add_to_cart_text())
    );

    return $button;
}

/**
 * 
 * Change number of products per page (rows) 
 * 
 * */
if (class_exists('CSF')) {
    function custom_products_per_page($products)
    {
        return \Egns\Helper\Egns_Helper::egns_get_theme_option('product_per_page');  // Change this to the desired number of products per page
    }
    add_filter('loop_shop_per_page', 'custom_products_per_page', 20);
} else {

    function custom_products_per_page($products)
    {
        return 12;  // Change this to the desired number of products per page
    }
    add_filter('loop_shop_per_page', 'custom_products_per_page', 20);
}

/**
 * Add Text Above the Add to Cart Button
 */
function add_to_cart_button_woocommerce()
{ ?>
    <div class="quantity-area">
        <h6><?php echo esc_html__('Quantity', 'vernex'); ?></h6>
    </div>
<?php
}
add_action('woocommerce_single_product_summary', 'add_to_cart_button_woocommerce', 20);


function add_content_woocommerce()
{ ?>
    <?php if ((Egns\Helper\Egns_Helper::egns_get_theme_option('enable_contents') == 1) && class_exists('CSF')): ?>

        <?php
        // Get the gallery field value using the Egns_Helper class
        $image_gallery = Egns\Helper\Egns_Helper::egns_get_theme_option('vernex-payment-img');
        $gallery_ids   = explode(',', $image_gallery);

        // Check if the field has any images
        if (!empty($image_gallery)) {
            echo '<div class="payment-method">';
            echo '<h6>' . wp_kses(Egns\Helper\Egns_Helper::egns_get_theme_option('vernex_payment_title'), wp_kses_allowed_html('post')) . '</h6>';
            echo '<ul class="payment-card-list">';

            foreach ($gallery_ids as $image) {
        ?>
                <li><?php echo wp_get_attachment_image($image); ?></li>
    <?php }

            echo '</ul>';
            echo '</div>';
        }
    endif;
    ?>

    <?php
}
add_action('woocommerce_single_product_summary', 'add_content_woocommerce', 70);


/**
 * Add buy now button before Add to Cart Button
 */
function add_custom_addtocart_and_checkout()
{
    global $product;

    // conditional tags
    $condition = $product->is_type('simple') || $product->is_type('variable');

    $addtocart_url = wc_get_checkout_url() . '?add-to-cart=' . $product->get_id();
    $button_class  = 'single_add_to_cart_button button alt custom-checkout-btn secondary-btn4 two';

    // Change the text of the buy now button from here
    $button_text = __("Buy now", "vernex");

    if ($product->is_type('simple')):
    ?>
        <script>
            jQuery(function($) {
                var url = '<?php echo esc_url($addtocart_url); ?>',
                    qty = 'input.qty',
                    button = 'a.custom-checkout-btn';

                // On input/change quantity event
                $(qty).on('input change', function() {
                    $(button).attr('href', url + '&quantity=' + $(this).val());
                });
            });
        </script>
    <?php
    elseif ($product->is_type('variable')):
        $addtocart_url = wc_get_checkout_url() . '?add-to-cart=';
    ?>
        <script>
            jQuery(function($) {
                var url = '<?php echo esc_url($addtocart_url); ?>',
                    vid = 'input[name="variation_id"]',
                    pid = 'input[name="product_id"]',
                    qty = 'input.qty',
                    button = 'a.custom-checkout-btn';
                setTimeout(function() {
                    if ($(vid).val() != '') {
                        $(button).attr('href', url + $(vid).val() + '&quantity=' + $(qty).val());
                    }
                }, 300);
                $(qty).on('input change', function() {
                    if ($(vid).val() != '') {
                        $(button).attr('href', url + $(vid).val() + '&quantity=' + $(this).val());
                    }
                });
                $('.variations_form').on('change blur', 'table.variations select', function() {
                    if ($(vid).val() != '') {
                        $(button).attr('href', url + $(vid).val() + '&quantity=' + $(qty).val());
                    }
                });
            });
        </script>
    <?php
    endif;
    if ($condition) {
        echo '<a href="' . $addtocart_url . '" class="' . $button_class . '">' . $button_text . '</a>';
    }
}
add_action('woocommerce_after_add_to_cart_button', 'add_custom_addtocart_and_checkout');


/**
 * Shop page product column
 */
// function wc_loop_shop_columns($number_columns)
// {
//     if (class_exists('CSF')) {
//         // Return value from theme option if CSF exists
//         return \Egns\Helper\Egns_Helper::egns_get_theme_option('shop_column');
//     } else {
//         // Return default value if CSF does not exist
//         return 4;
//     }
// }
// add_filter('loop_shop_columns', 'wc_loop_shop_columns', 1, 10);


/**
 * WooCommerce breadcrumb defaults
 */
function nexaq_woocommerce_breadcrumbs()
{
    return array(
        'delimiter'   => ' &#10170; ',
        'wrap_before' => '<nav class="woocommerce-breadcrumb" itemprop="breadcrumb">',
        'wrap_after'  => '</nav>',
        'before'      => '',
        'after'       => '',
        'home'        => _x('Home', 'breadcrumb', 'vernex'),
    );
}
add_filter('woocommerce_breadcrumb_defaults', 'nexaq_woocommerce_breadcrumbs');


/**
 * WooCommerce product archive page title link add
 */
function nexaqChangeProductsTitle()
{
    ?>
    <h2 class="woocommerce-loop-product__title"><a href="<?php echo esc_url(get_the_permalink()) ?>"><?php echo get_the_title(); ?></a></h2>
<?php
}
remove_action('woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10);
add_action('woocommerce_shop_loop_item_title', 'nexaqChangeProductsTitle', 10);

/**
 * WooCommerce archive rating position change
 */
remove_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5);
add_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 11);


// change woocommerce thumbnail image size
function override_woocommerce_image_size_gallery_thumbnail($size)
{
    // Gallery thumbnails: proportional
    return array(
        'width'  => '300',
        'height' => '300',
        'crop'   => 0,
    );
}
add_filter('woocommerce_get_image_size_gallery_thumbnail', 'override_woocommerce_image_size_gallery_thumbnail');






// 1. Show plus minus buttons
function nexaq_display_quantity_plus()
{
    echo '<button type="button" class="plus"><i class="bi bi-plus-lg"></i></button>';
}
add_action('woocommerce_after_quantity_input_field', 'nexaq_display_quantity_plus');

function nexaq_display_quantity_minus()
{
    echo '<button type="button" class="minus"><i class="bi bi-dash-lg"></i></button>';
}
add_action('woocommerce_before_quantity_input_field', 'nexaq_display_quantity_minus');

function nexaq_set_default_quantity($args, $product)
{
    $args['input_value'] = 1;  // Default quantity
    return $args;
}
add_filter('woocommerce_quantity_input_args', 'nexaq_set_default_quantity', 10, 2);
if (class_exists('WooCommerce', false)) {
    // 2. Trigger update quantity script
    function nexaq_add_cart_quantity_plus_minus()
    {

        if (!is_product() && !is_cart()) return;
        wc_enqueue_js("
            $(document).on( 'click', 'button.plus, button.minus', function() {
                var qty  = $( this ).parent( '.quantity' ).find( '.qty' );
                var val  = parseFloat(qty.val()) || 1;
                var max  = parseFloat(qty.attr( 'max' ));
                var min  = parseFloat(qty.attr( 'min' ));
                var step = parseFloat(qty.attr( 'step' ));

                if ( $( this ).is( '.plus' ) ) {
                if ( max && ( max <= val ) ) {
                qty.val( max ).change();
                } else {
                qty.val( val + step ).change();
                }
                } else {
                if ( min && ( min >= val ) ) {
                qty.val( min ).change();
                } else if ( val > 1 ) {
                qty.val( val - step ).change();
                }
                }
                });

        ");
    }

    add_action('wp_footer', 'nexaq_add_cart_quantity_plus_minus');
}

/**Product archive page edit -mna */

add_action('template_redirect', 'egns_nexaq_remove_woocommerce_hooks');
function egns_nexaq_remove_woocommerce_hooks()
{
    // Check if WooCommerce is installed and activated
    if (class_exists('WooCommerce')) {
        if (is_shop() || is_product_category() || is_product_tag()) {
            // Remove product title and price
            remove_action('woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10);
            remove_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10);

            // Remove add to cart button
            remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10);
        }
    }
}
add_action('wp', 'egns_nexaq_remove_woocommerce_hooks');  // Ensures the hook runs after WordPress determines the query



add_action('egns_nexaq_shop_page_product_card', 'egns_nexaq_shop_product_card');
function egns_nexaq_shop_product_card()
{
    global $product;

?>
    <div class="product-card">
        <div class="product-card-img">
            <a href="<?php echo esc_url(get_permalink($product->get_id())); ?>">
                <?php echo woocommerce_get_product_thumbnail('full'); ?>
                <?php if ($product->is_on_sale()): ?>
                    <div class="batch">
                        <span class="sale"><?php echo esc_html__('SALE', 'vernex') ?>!</span>
                    </div>
                <?php endif; ?>

            </a>
            <div class="cart-btn-area">
                <?php
                // Determine the product type
                $product_type = $product->get_type();

                $button_text = __('Add to Cart', 'vernex');
                if ($product_type === 'grouped') {
                    $button_text = __('Select Options', 'vernex');
                } elseif ($product_type === 'variable') {
                    $button_text = __('View Options', 'vernex');
                } elseif ($product_type === 'external') {
                    $button_text = __('Buy Product', 'vernex');
                }
                ?>
                <a href="<?php echo esc_url($product->add_to_cart_url()); ?>"
                    class="add-cart-btn button <?php echo esc_attr($product_type); ?> add_to_cart_button"
                    data-product_id="<?php echo esc_attr($product->get_id()); ?>"
                    data-product_sku="<?php echo esc_attr($product->get_sku()); ?>"
                    aria-label="<?php echo esc_attr($product->add_to_cart_description()); ?>"
                    rel="nofollow"><i class="bi bi-bag-check"></i>
                    <?php echo esc_html($button_text); ?>
                </a>
            </div>
            <div class="view-and-favorite-area">
                <ul>
                    <li>
                        <?php
                        if (function_exists('YITH_WCWL')) {
                            echo do_shortcode('[yith_wcwl_add_to_wishlist]');
                        }
                        ?>
                    </li>
                    <li>
                        <?php
                        if (function_exists('YITH_WCQV')) {
                            echo do_shortcode('[yith_quick_view]');
                        }
                        ?>
                    </li>
                </ul>
            </div>
        </div>
        <div class="product-card-content">
            <h6>
                <a href="<?php echo esc_url(get_permalink($product->get_id())); ?>">
                    <?php echo esc_html($product->get_name()); ?>
                </a>
            </h6>
            <?php if ($product->get_rating_count() > 0): ?>
                <div class="rating">
                    <?php echo wc_get_rating_html($product->get_average_rating(), $product->get_rating_count()); ?>
                    <span>(<?php echo esc_html($product->get_rating_count()); ?>)</span>
                </div>
            <?php endif; ?>
            <span><?php echo sprintf('%s', $product->get_price_html()); ?></span>
        </div>
    </div>
<?php
}



add_action('egns_nexaq_shop_page_no_products', 'egns_nexaq_shop_no_products');
function egns_nexaq_shop_no_products()
{
?>
    <p><?php esc_html_e('No products found.', 'vernex'); ?></p>
<?php
}


//Woocommerce "Add to cart" button modify for external product template
add_action('woocommerce_after_add_to_cart_button', 'replace_single_add_to_cart_button_external');

function replace_single_add_to_cart_button_external()
{
    global $product;

    // Check if the product is of type "external"
    if ($product->is_type('external')) {
        $add_to_cart_url         = $product->add_to_cart_url();
        $product_id              = $product->get_id();
        $product_sku             = $product->get_sku();
        $add_to_cart_description = $product->add_to_cart_description();

        // Custom button for single external product
        echo sprintf(
            '<a href="%1$s" class="primary-btn2 transparent" data-product_id="%2$d" data-product_sku="%3$s" aria-label="%4$s">
                <span>
                    Add to Cart
                    <svg      viewBox = "0 0 13 20">
                    <polyline points  = "0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                    </svg>
                </span>
            </a>',
            esc_url($add_to_cart_url),
            esc_attr($product_id),
            esc_attr($product_sku),
            esc_attr($add_to_cart_description)
        );
    }
}
