<?php

//load more project
function load_more_project()
{

    $posts_per_page_option = Egns\Helper\Egns_Helper::egns_get_theme_option('posts_per_page_option_project');
    $paged                 = sanitize_text_field($_POST['page']);

    // Check if the posts_per_page_option is 6, then set it to 7
    if ($posts_per_page_option == 6) {
        $posts_per_page_option = 6;
    }
    $args = array(
        'post_type'      => 'project',
        'posts_per_page' => $posts_per_page_option,
        'paged'          => $paged,
    );
    $wp_query = new WP_Query($args);

    $num = 0;

    if ($wp_query->have_posts()) {
        while ($wp_query->have_posts()) :
            $num++;
            $wp_query->the_post();
?>
            <?php
            echo apply_filters('egns_filter_blog_single_template', Egns\Helper\Egns_Helper::egns_get_template_part('project', '/parts/archive-content')); ?>

        <?php
        endwhile;
    } else {
        echo esc_html('No data');
    }
    wp_reset_postdata();

    wp_die();
}
add_action('wp_ajax_load_more_project', 'load_more_project');
add_action('wp_ajax_nopriv_load_more_project', 'load_more_project');

//load more project masonary
function load_more_project_masonary()
{

    $paged = sanitize_text_field($_POST['page']);

    $args = array(
        'post_type'      => 'project',
        'posts_per_page' => 5,
        'paged'          => $paged,
    );
    $wp_query = new WP_Query($args);

    $num = 0;

    if ($wp_query->have_posts()) {
        $index           = 0;                                                                                                                                                    // Initialize an index counter
        $classes = array('col-lg-6 ', 'col-lg-5', 'col-lg-5', 'col-lg-6', 'col-lg-12'); // Column classes
        $class_count     = count($classes);
        $classes_two     = array('', 'masonry-img', 'masonry-img', '', '');
        $class_count_two = count($classes_two);
        while ($wp_query->have_posts()) :
            $num++;
            $wp_query->the_post();
            $class     = $classes[$index % $class_count];
            $class_two = $classes_two[$index % $class_count_two];
            $index++;  // Increment the index counter after each loop
        ?>

            <div class="<?php echo esc_attr($class); ?> wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
                <?php
                echo apply_filters('egns_filter_blog_single_template', Egns\Helper\Egns_Helper::egns_get_template_part('project', '/parts/archive-masonary')); ?>

            </div>

        <?php
        endwhile;
    } else {
        echo esc_html('No data');
    }
    wp_reset_postdata();

    wp_die();
}

add_action('wp_ajax_load_more_project_masonary', 'load_more_project_masonary');
add_action('wp_ajax_nopriv_load_more_project_masonary', 'load_more_project_masonary');



//load more project masonary
function load_more_project_info_flow()
{

    $paged = sanitize_text_field($_POST['page']);

    $args = array(
        'post_type'      => 'project',
        'posts_per_page' => 8,
        'paged'          => $paged,
    );
    $wp_query = new WP_Query($args);

    $num = 0;

    if ($wp_query->have_posts()) {
        while ($wp_query->have_posts()) :
            $num++;
            $wp_query->the_post();
        ?>
            <?php
            echo apply_filters('egns_filter_blog_single_template', Egns\Helper\Egns_Helper::egns_get_template_part('project', '/parts/archive-info-flow')); ?>

        <?php
        endwhile;
    } else {
        echo esc_html('No data');
    }
    wp_reset_postdata();

    wp_die();
}
add_action('wp_ajax_load_more_project_info_flow', 'load_more_project_info_flow');
add_action('wp_ajax_nopriv_load_more_project_info_flow', 'load_more_project_info_flow');


//load more properties
function load_more_properties()
{
    global $wp_query;

    $posts_per_page_option = Egns\Helper\Egns_Helper::egns_get_theme_option('posts_per_page_option_property');
    $paged                 = sanitize_text_field($_POST['page']);

    // Check if the posts_per_page_option is 6, then set it to 7
    if ($posts_per_page_option == 6) {
        $posts_per_page_option = 6;
    }

    $args = array(
        'post_type'      => 'properties',
        'post_status'    => 'publish',
        'posts_per_page' => $posts_per_page_option,
        'paged'          => $paged,
    );

    // Merge existing query vars with custom args, giving priority to custom args
    $args = array_merge($wp_query->query_vars, $args);

    $wp_query = new WP_Query($args);

    if ($wp_query->have_posts()) {
        while ($wp_query->have_posts()) {
            $wp_query->the_post();
        ?>
            <?php
            echo apply_filters('egns_filter_blog_single_template', Egns\Helper\Egns_Helper::egns_get_template_part('properties', '/content/archive-properties-content'));
            ?>

<?php
        };
        wp_reset_postdata();
    }


    wp_die();
}
add_action('wp_ajax_load_more_properties', 'load_more_properties');
add_action('wp_ajax_nopriv_load_more_properties', 'load_more_properties');









// Function to add a search query to recent searches
function add_recent_search($query)
{
    // Trim the search query to remove leading and trailing spaces
    $query = trim($query);

    // Check if the query is not empty
    if (!empty($query)) {
        $recent_searches = get_option('recent_searches', array());

        // Remove any existing occurrences of the query
        $recent_searches = array_diff($recent_searches, array($query));

        // Add the query to the beginning of the array
        array_unshift($recent_searches, $query);

        // Limit the number of recent searches, adjust as needed
        $max_recent_searches = 5;

        // Trim the array to the maximum allowed size
        $recent_searches = array_slice($recent_searches, 0, $max_recent_searches);

        // Update the option
        update_option('recent_searches', $recent_searches);
    }
}

// Function to get recent searches
function get_recent_searches()
{
    return get_option('recent_searches', array());
}

// Call add_recent_search whenever a search is performed
if (isset($_GET['s'])) {
    $search_query = sanitize_text_field($_GET['s']);
    add_recent_search($search_query);
}

// AJAX handler to clear search history
function clear_search_history()
{
    delete_option('recent_searches');
    wp_send_json_success();
}
add_action('wp_ajax_clear_search_history', 'clear_search_history');
