<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="robots" content="noindex, nofollow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
    <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no" />
    <title><?php wp_title(); ?></title>
    <?php wp_head(); ?>
    
</head>


<body>
    <?php
        $menu_items = wp_get_menu_array('Header');
        // echo "<pre>";
        // print_r($mainMenu);die;
    ?>
    <!-- Navigation Header -->
    <header class="navbar123">
        <div class="nav-container123">
            <!-- Logo -->
            <div class="nav-logo">
                <a href="<?php echo home_url(); ?>" class="logo-link">
                <span class="logo-text">J&F</span>
                </a>
            </div>

            <!-- Desktop Navigation -->
            <nav class="nav-menu">
                <?php foreach ($menu_items as $item): ?>
                <?php $has_children = !empty($item['children']); ?>
                    <div class="nav-item<?php echo $has_children ? ' mega-menu-item' : ''; ?>">
                        <a href="<?php echo esc_url($item['url']); ?>" class="nav-link" data-page="<?php echo sanitize_title($item['title']); ?>">
                            <?php echo esc_html($item['title']); ?>
                            <span class="nav-underline"></span>
                        </a>

                        <?php if ($has_children): ?>
                            <div class="mega-menu">
                                <div class="mega-menu-content">
                                    <?php foreach ($item['children'] as $child): ?>
                                        <div class="mega-menu-column">
                                            <h4><?php echo esc_html($child['title']); ?></h4>

                                            <?php if (!empty($child['children'])): ?>
                                                <ul>
                                                    <?php foreach ($child['children'] as $subchild): ?>
                                                        <li>
                                                            <a href="<?php echo esc_url($subchild['url']); ?>">
                                                                <?php echo esc_html($subchild['title']); ?>
                                                            </a>
                                                        </li>
                                                    <?php endforeach; ?>
                                                </ul>
                                            <?php endif; ?>
                                        </div>
                                    <?php endforeach; ?>
                                     <?php 
                                            if($item['title'] == "Our Services") {
                                        ?>
                                            <div class="mega-menu-footer">
                                                <a href="#" class="view-all-link">View All Services →</a>
                                            </div>
                                        <?php } ?>

                                        <?php 
                                            if(($item['title'] == "Our Projects")) {
                                        ?>
                                            <div class="mega-menu-footer">
                                                <a href="#" class="view-all-link">View All Projects →</a>
                                            </div>
                                        <?php } ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            </nav>

            <!-- Right Side Buttons -->
            <div class="nav-actions">
                <?php
                    $get_in_touch_btn = get_field("get_in_touch_btn", "option");
                    echo $get_in_touch_btn ? $get_in_touch_btn : 'Not Available';
                    $start_project_btn = get_field("start_project_btn", "option");
                    echo $start_project_btn ? $start_project_btn : 'Not Available';
                ?>
            </div>

            <!-- Mobile Menu Toggle -->
            <div class="mobile-menu-toggle">
                <span class="hamburger-line"></span>
                <span class="hamburger-line"></span>
                <span class="hamburger-line"></span>
            </div>
        </div>

        <!-- Mobile Navigation Overlay -->
        <div class="mobile-nav-overlay"></div>

        <!-- Mobile Navigation -->
        <div class="mobile-nav">
            <div class="mobile-nav-header">
                <div class="mobile-logo">
                    <a href="<?php echo home_url(); ?>" class="logo-link">
                        <span class="logo-text">J&F</span>
                    </a>
                </div>
                <button class="mobile-close-btn">
                    <i class="fas fa-times"></i>
                </button>
            </div>

            <div class="mobile-nav-content">

                <?php if (isset($menu_items) && is_array($menu_items)): ?>
                    <?php foreach ($menu_items as $parent): ?>
                        <?php 
                            $has_children = !empty($parent['children']); 
                            $title = isset($parent['title']) ? esc_html($parent['title']) : 'Untitled'; 
                        ?>
                        <div class="mobile-nav-item">
                            <div class="mobile-nav-header-item">
                               <?php if ($has_children): ?>
    <span><?php echo $title; ?></span>
    <i class="fas fa-chevron-right mobile-chevron"></i>
<?php else: ?>
    <a href="<?php echo esc_url($parent['url']); ?>"><?php echo $title; ?></a>
<?php endif; ?>
                            </div>

                            <?php if ($has_children): ?>
                                <div class="mobile-submenu">
                                    <div class="mobile-submenu-header">
                                        <button class="mobile-back-btn">
                                            <i class="fas fa-chevron-left"></i>
                                            Back
                                        </button>
                                        <h3><?php echo $title; ?></h3>
                                    </div>

                                    <div class="mobile-submenu-content">
                                        <?php foreach ($parent['children'] as $child): ?>
                                            <div class="mobile-submenu-section">
                                                <h5><?php echo esc_html($child['title']); ?></h5>

                                                <?php if (!empty($child['children'])): ?>
                                                    <ul>
                                                        <?php foreach ($child['children'] as $subchild): ?>
                                                            <li>
                                                                <a href="<?php echo esc_html($subchild['url'] ?? '#'); ?>">
                                                                    <?php echo esc_html($subchild['title']); ?>
                                                                </a>
                                                            </li>
                                                        <?php endforeach; ?>
                                                    </ul>
                                                <?php else: ?>
                                                    <p class="btx-no-items">No items available.</p>
                                                <?php endif; ?>
                                            </div>
                                        <?php endforeach; ?>

                                        <?php 
                                            if(($title == "Our Services")) {
                                        ?>
                                            <div class="mobile-view-all">
                                                <a href="#" class="view-all-link">View All Services →</a>
                                            </div>
                                        <?php } ?>
                                        <?php 
                                            if(($title == "Our Projects")) {
                                        ?>
                                            <div class="mobile-view-all">
                                                <a href="#" class="view-all-link">View All Projects →</a>
                                            </div>
                                        <?php } ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <p>Error: Invalid or missing menu data.</p>
                <?php endif; ?>

                <!-- Mobile Action Buttons -->
                <div class="mobile-actions">
                    <?php
                        $get_in_touch_btn = get_field("get_in_touch_btn", "option");
                        echo $get_in_touch_btn ? $get_in_touch_btn : 'Not Available';
                        $start_project_btn = get_field("start_project_btn", "option");
                        echo $start_project_btn ? $start_project_btn : 'Not Available';
                    ?>
                </div>
            </div>
        </div>
    </header>
    <style>.sec-mar{     margin: 0px 0;!important;}</style>
    <?php if (is_page('get-a-free-quote')) : ?>
    <style>
        .breadcrumb-section {
            display: none !important;
        }
    </style>
    <script>
  document.getElementById("scheduleConsultation").addEventListener("click", function(event) { alert();
    event.preventDefault(); // prevent <a> from navigating
    document.getElementById("consultationForm").submit(); // submit the form via JS
  });
</script>
<?php endif; ?>
