<?php

if (!class_exists('Egns_Handler')) {

	/**
	 * Main theme class with configuration
	 */

	class Egns_Handler
	{

		/**
		 * Initializes a singleton instance
		 *
		 * @return \Egns_Handler
		 */
		private static $instance;


		public static function get_instance()
		{
			if (is_null(self::$instance)) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		/**
		 * Main Class Constructor
		 */
		public function __construct()
		{

			// Include all require files
			require_once get_template_directory() . '/helpers/constants.php';
			require_once get_template_directory() . '/helpers/search_query.php';
			require_once EGNS_HELPERS_ROOT_DIR . '/theme_setup.php';
			require_once EGNS_HELPERS_ROOT_DIR . '/assets.php';
			require_once EGNS_HELPERS_ROOT_DIR . '/helper.php';
			require_once EGNS_HELPERS_ROOT_DIR . '/breadcrumb.php';
			require_once EGNS_HELPERS_ROOT_DIR . '/comments.php';
			require_once EGNS_HELPERS_ROOT_DIR . '/woo-hooks-mutated.php';
			require_once EGNS_HELPERS_ROOT_DIR . '/custom-with-ajax.php';
			require_once EGNS_INC_ROOT_DIR . '/plugins/tgma/activation.php';

			// Instantiation helper classes
			new Egns\Helper\Egns_Assets();
			new Egns\Helper\Egns_Theme_Setup();
			new Egns\Helper\Egns_Helper();
		}
	}

	Egns_Handler::get_instance();
}


/**
 * Remove p tag from contact form 7
 */
add_filter('wpcf7_autop_or_not', '__return_false');


/**
 * Change the number of related products output
 */
function vernex_move_comment_field($fields)
{
	$comment_field = $fields['comment'];
	unset($fields['comment']);
	$fields['comment'] = $comment_field;
	return $fields;
}
add_filter('comment_form_fields', 'vernex_move_comment_field', 10, 3);



/**
 *Codestar Fontawesome 5 
 */
if (!function_exists('your_prefix_enqueue_fa5')) {
	function your_prefix_enqueue_fa5()
	{
		wp_enqueue_style('fa5', 'https://use.fontawesome.com/releases/v5.13.0/css/all.css', array(), '5.13.0', 'all');
		wp_enqueue_style('fa5-v4-shims', 'https://use.fontawesome.com/releases/v5.13.0/css/v4-shims.css', array(), '5.13.0', 'all');
	}
	add_action('wp_enqueue_scripts', 'your_prefix_enqueue_fa5');
}


// Automatically use the custom template for posts in 'footer_blocks' post type
function set_footer_blocks_template($template)
{
	if (is_singular('footer_blocks')) {
		// Specify the path to your custom template file
		$custom_template = locate_template('template-footer-blocks.php');

		// If the custom template exists, use it
		if ($custom_template) {
			return $custom_template;
		}
	}
	return $template;
}
add_filter('template_include', 'set_footer_blocks_template');

define('Version', time());

//require_once get_template_directory() . '/helpers.php';

function enqueueChildStyle()
{
    // Custom CSS files with unique handles
    
    wp_enqueue_style('nave-css', get_template_directory_uri() . '/assets/css/nav.css', array(), Version, 'all');
    
    wp_enqueue_style('home-css', get_template_directory_uri() . '/assets/css/homepage.css', array(), Version, 'all');
    wp_enqueue_style('contact-css', get_template_directory_uri() . '/assets/css/contact.css', array(), Version, 'all');
    // Font Awesome
    wp_enqueue_style('font-awesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css', array(), null, 'all');
     // Google Fonts
    wp_enqueue_style('google-fonts', 'https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap', array(), null);

    // Font Awesome
    wp_enqueue_style('fontawesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css', array(), '6.0.0');

    // Slick Carousel
    wp_enqueue_style('slick-css', 'https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css', array(), '1.8.1');
    wp_enqueue_style('slick-theme-css', 'https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick-theme.css', array('slick-css'), '1.8.1');

    // AOS Animation Library
    wp_enqueue_style('aos-css', 'https://cdn.jsdelivr.net/npm/aos@2.3.4/dist/aos.css', array(), '2.3.4');
}
add_action('wp_enqueue_scripts', 'enqueueChildStyle');


function enqueue_custom_scripts() {
    // Optionally deregister WordPress's default jQuery if you need a specific version
    wp_deregister_script('jquery');

    // Enqueue jQuery from CDN
    wp_enqueue_script('jquery-cdn', 'https://code.jquery.com/jquery-3.6.0.min.js', array(), '3.6.0', true);

    // Bootstrap (if needed, remove if not using)
    wp_enqueue_script('bootstrap-bundle', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js', array('jquery-cdn'), '5.3.3', true);

    // Slick Carousel
    wp_enqueue_script('slick-carousel', 'https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.min.js', array('jquery-cdn'), '1.8.1', true);

    // AOS Animation Library
    wp_enqueue_script('aos', 'https://cdn.jsdelivr.net/npm/aos@2.3.4/dist/aos.js', array(), '2.3.4', true);

    // Local custom JS
    wp_enqueue_script('main-js', get_template_directory_uri() . '/assets/js/main.js', array('jquery-cdn'), '1.0', true);

    // AOS Init Inline Script
    wp_add_inline_script('aos', 'AOS.init({ duration: 1300 });');
}
add_action('wp_enqueue_scripts', 'enqueue_custom_scripts');

add_action('wp_enqueue_scripts', 'enqueue_custom_scripts');

function allow_svg_upload($mimes) {
    $mimes['svg'] = 'image/svg+xml';
    return $mimes;
}
add_filter('upload_mimes', 'allow_svg_upload');

add_theme_support( 'menus' );
add_action('acf/init', 'my_acf_op_init');

// add_filter('wpcf7_autop_or_not', '__return_false');



function my_acf_op_init()
{

  // Check function exists.
  if (function_exists('acf_add_options_page')) {

    // Register options page.
    $option_page = acf_add_options_page(array(
      'page_title'    => __('Theme Settings'),
      'menu_title'    => __('Theme Settings'),
      'menu_slug'     => 'theme-general-settings',
      'capability'    => 'edit_posts',
      'redirect'      => false
    ));
  }
}





// add_action('wpcf7_mail_sent', 'custom_save_submission_to_db');

// function custom_save_submission_to_db($contact_form) {
//     $submission = WPCF7_Submission::get_instance();

//     if ($submission) {
//         $data = $submission->get_posted_data();

//         global $wpdb;
//         $table = $wpdb->prefix . 'your_custom_table'; // Create this table first

//         $wpdb->insert($table, [
//             'first_name'   => sanitize_text_field($data['first-name']),
//             'last_name'    => sanitize_text_field($data['last-name']),
//             'email'        => sanitize_email($data['your-email']),
//             'phone'        => sanitize_text_field($data['phone-number']),
//             'job_title'    => sanitize_text_field($data['job-title']),
//             'company_name' => sanitize_text_field($data['company-name']),
//             'country'      => sanitize_text_field($data['country']),
//             'message'      => sanitize_textarea_field($data['your-message']),
//             'submitted_at' => current_time('mysql')
//         ]);
//     }
// }


function register_footer_menu() {
    register_nav_menu('footer', __('Footer Menu'));
}
add_action('init', 'register_footer_menu');
// Prevent premature ACF text domain loading error
remove_action( 'plugins_loaded', '_load_textdomain_just_in_time' );

// Load ACF translations at the correct time
add_action( 'init', function() {
    // Ensure ACF translation domain loads properly
    load_textdomain( 'acf', WP_PLUGIN_DIR . '/advanced-custom-fields/languages/acf-' . get_locale() . '.mo' );
});
function wp_get_menu_array($current_menu) {
    $menu_array = array();
    $menu_items = wp_get_nav_menu_items($current_menu);
    
    if (!$menu_items) return $menu_array;

    $menu_items_by_id = [];

    foreach ($menu_items as $item) {
        $menu_items_by_id[$item->ID] = [
            'id'       => $item->ID,
            'title'    => $item->title,
            'url'      => $item->url,
            'parent'   => $item->menu_item_parent,
            'children' => [],
        ];
    }

    // Assign children to their parent
    foreach ($menu_items_by_id as $item_id => $item) {
        if ($item['parent'] != 0 && isset($menu_items_by_id[$item['parent']])) {
            $menu_items_by_id[$item['parent']]['children'][] = &$menu_items_by_id[$item_id];
        } else if ($item['parent'] == 0) {
            $menu_array[] = &$menu_items_by_id[$item_id];
        }
    }

    return $menu_array;
}
function vernex_dequeue_bootstrap_css() {
    wp_dequeue_style('bootstrap'); // replace with actual handle if different
    wp_deregister_style('bootstrap');
}
add_action('wp_enqueue_scripts', 'vernex_dequeue_bootstrap_css', 100);
// function remove_vernex_css() {
//     wp_dequeue_style('vernex-style'); // replace with correct handle if different
//     wp_deregister_style('vernex-style');
// }
// add_action('wp_enqueue_scripts', 'remove_vernex_css', 100);

