<?php

/**
 * The template for displaying category archive pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package vernex
 */

get_header();

if (!is_front_page()) {
    // Include breadcrumb template
    Egns\Helper\Egns_Helper::egns_template_part('breadcrumb', 'templates/breadcrumb-archive');
}

?>
<div class="blog-grid-section sec-mar" id="page-wrapper">
    <div class="container">
        <div class="row g-4 mb-60">
            <?php
            if (have_posts()) {

                while (have_posts()) :
                    the_post();

                    echo apply_filters('egns_filter_blog_single_template', Egns\Helper\Egns_Helper::egns_get_template_part('blog', 'templates/grid/post/post', get_post_format() ? get_post_format() : 'default'));

                endwhile;
            } else {
                // Include global posts not found
                Egns\Helper\Egns_Helper::egns_template_part('content', 'templates/posts-not-found');
            }
            ?>
        </div>
        <?php if (!empty(Egns\Inc\Blog_Helper::egns_pagination())) : ?>
            <div class="row">
                <div class="col-lg-12 d-flex justify-content-center wow animate fadeInUp" data-wow-delay="400ms" data-wow-duration="1500ms">
                    <div class="inner-pagination-area">
                        <?php
                        // Pagination
                        echo Egns\Inc\Blog_Helper::egns_pagination();
                        ?>
                    </div>
                </div>
            </div>
        <?php endif ?>
    </div>
</div>
<?php
get_footer();
?>