  $(document).ready(function () {
        // Initialize Slider
        $('.news-log-slider').slick({
            dots: false,
            arrows: false,
            infinite: false,
            speed: 600,
            slidesToShow: 2,
            slidesToScroll: 1,
            autoplay: false,
            cssEase: 'cubic-bezier(0.645, 0.045, 0.355, 1)',
            responsive: [
                {
                    breakpoint: 992,
                    settings: {
                        slidesToShow: 2,
                        slidesToScroll: 1,
                        centerMode: false,
                        variableWidth: false
                    }
                },
                {
                    breakpoint: 768,
                    settings: {
                        slidesToShow: 1,
                        slidesToScroll: 1,
                        centerMode: false,
                        centerPadding: '0px',
                        variableWidth: false
                    }
                }
            ]
        });

        // Set initial positions for desktop and check button states
        function setInitialPositions() {
            if ($(window).width() > 992) {
                $('.news-log-slider .slick-slide.slick-active:nth-child(odd) .news-log-slide-card')
                    .css('transform', 'translateY(60px)');
                
                $('.news-log-slider .slick-slide.slick-active:nth-child(even) .news-log-slide-card')
                    .css('transform', 'translateY(-60px)');
            }
            checkButtonStates();
        }
        
        // Check and update button states
        function checkButtonStates() {
            var currentSlide = $('.news-log-slider').slick('slickCurrentSlide');
            var slideCount = $('.news-log-slider').slick('getSlick').slideCount;
            var slidesToShow = $('.news-log-slider').slick('getSlick').options.slidesToShow;
            
            // Disable prev button if at first slide
            if (currentSlide === 0) {
                $('.news-prev').addClass('disabled').prop('disabled', true);
            } else {
                $('.news-prev').removeClass('disabled').prop('disabled', false);
            }
            
            // Disable next button if at last slide
            if (currentSlide >= slideCount - slidesToShow) {
                $('.news-next').addClass('disabled').prop('disabled', true);
            } else {
                $('.news-next').removeClass('disabled').prop('disabled', false);
            }
        }
        
        // Call initially
        setInitialPositions();

        // Handle window resize
        $(window).on('resize', function() {
            setInitialPositions();
        });

        // Handle slide change for desktop - DURING transition
        $('.news-log-slider').on('beforeChange', function(event, slick, currentSlide, nextSlide) {
            if ($(window).width() > 992) {
                // Reset all slides
                $('.news-log-slide-card').css('transform', 'translateY(0)');
                
                // Calculate which slides will be active after the change
                var nextActiveSlides = [];
                nextActiveSlides.push(nextSlide);
                
                // Determine the second active slide (depends on direction)
                var direction = (nextSlide > currentSlide || (currentSlide === slick.slideCount-1 && nextSlide === 0)) ? 1 : -1;
                var secondSlide = (nextSlide + direction) % slick.slideCount;
                if (secondSlide < 0) secondSlide = slick.slideCount - 1;
                
                nextActiveSlides.push(secondSlide);
                
                // Apply staggered effect to the upcoming active slides
                nextActiveSlides.forEach(function(slideIndex, i) {
                    var $slide = $('.news-log-slider .slick-slide[data-slick-index="' + slideIndex + '"]');
                    if (i % 2 === 0) { // Even index (first slide)
                        $slide.find('.news-log-slide-card').css('transform', 'translateY(60px)');
                    } else { // Odd index (second slide)
                        $slide.find('.news-log-slide-card').css('transform', 'translateY(-60px)');
                    }
                });
            }
        });

        // Update button states after slide change
        $('.news-log-slider').on('afterChange', function(event, slick, currentSlide) {
            checkButtonStates();
        });

        // Custom navigation with disabled state handling
        $('.news-prev').click(function () {
            if (!$(this).hasClass('disabled')) {
                $('.news-log-slider').slick('slickPrev');
            }
        });

        $('.news-next').click(function () {
            if (!$(this).hasClass('disabled')) {
                $('.news-log-slider').slick('slickNext');
            }
        });
    });