  $(document).ready(function () {
    const $slider = $(".logo-slider");
    const $container = $(".logo-slider-container");

    // Clone logos for infinite loop
    $slider.append($slider.html());

    let sliderWidth = $slider[0].scrollWidth / 2; // original width before duplication
    let currentScroll = 0;
    const speed = 0.5; // adjust scroll speed

    function scrollLogos() {
      currentScroll += speed;
      if (currentScroll >= sliderWidth) {
        currentScroll = 0;
      }
      $slider.css("transform", `translateX(-${currentScroll}px)`);
      requestAnimationFrame(scrollLogos);
    }

    scrollLogos();

    // Pause on hover
    let paused = false;
    $container.on("mouseenter", () => (paused = true));
    $container.on("mouseleave", () => (paused = false));

    function checkPause() {
      if (!paused) scrollLogos();
      else requestAnimationFrame(checkPause);
    }

    checkPause();
  });