<?php

/**
 * The template for displaying archive pages
 *
 * @link https:   //developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package vernex
 */

get_header();

if (!is_front_page()) {

    $posts_per_page_option = Egns\Helper\Egns_Helper::egns_get_theme_option('posts_per_page_option_property');
    // Include breadcrumb template
    Egns\Helper\Egns_Helper::egns_template_part('breadcrumb', 'templates/breadcrumb-archive');
}


// Fetch terms from the 'properties-location' taxonomy
$terms = get_terms(array(
    'taxonomy'   => 'properties-location',
    'hide_empty' => false,
));

// Fetch terms from the 'properties-type' taxonomy
$terms_type = get_terms(array(
    'taxonomy'   => 'properties-type',
    'hide_empty' => false,
));

global $wp_query;

// Custom query arguments
$args = array(
    'post_type'      => 'properties',
    'post_status'    => 'publish',
    'posts_per_page' => $posts_per_page_option,
    'paged'          => (get_query_var('paged')) ? get_query_var('paged') : 1,
);

// Merge existing query vars with custom args, giving priority to custom args
$args = array_merge($wp_query->query_vars, $args);

$wp_query = new WP_Query($args);


?>
<div class="property-form-section">
    <div class="container">
        <div class="property-form-wrap">
            <form id="search-prp" method="get" action="<?php echo get_post_type_archive_link('properties'); ?>">
                <div class="row g-xxl-4 g-xl-3 g-lg-2 gx-md-2 gy-4">
                    <div class="col-lg-3 col-md-3">
                        <div class="single-dropdown">
                            <select name="properties_status">
                                <option value=""><?php echo esc_html__('Status', 'vernex') ?></option>
                                <option value="<?php echo esc_attr('rent') ?>"><?php echo esc_html__('For Rent', 'vernex') ?></option>
                                <option value="<?php echo esc_attr('sell') ?>"><?php echo esc_html__('For Sale', 'vernex') ?></option>
                                <option value="<?php echo esc_attr('others') ?>"><?php echo esc_html__("Other's", 'vernex') ?></option>
                            </select>
                        </div>
                    </div>

                    <?php
                    // Check if there are terms available
                    if (!empty($terms_type) && !is_wp_error($terms_type)):
                    ?>
                        <div class="col-lg-3 col-md-4">
                            <div class="single-dropdown">
                                <select name="properties_type">
                                    <option value=""><?php echo esc_html__('Type', 'vernex') ?></option>
                                    <?php
                                    foreach ($terms_type as $term) {
                                        echo '<option value="' . esc_attr($term->slug) . '">' . esc_html($term->name) . '</option>';
                                    }
                                    ?>
                                </select>
                            </div>
                        </div>
                    <?php endif; ?>

                    <?php
                    // Check if there are terms available
                    if (!empty($terms) && !is_wp_error($terms)):
                    ?>
                        <div class="col-lg-4 col-md-5">
                            <div class="single-dropdown">
                                <select name="properties_location">
                                    <option value=""><?php echo esc_html__('Location', 'vernex') ?></option>
                                    <?php
                                    foreach ($terms as $term) {
                                        echo '<option value="' . esc_attr($term->slug) . '">' . esc_html($term->name) . '</option>';
                                    }
                                    ?>
                                </select>
                            </div>
                        </div>
                    <?php endif; ?>

                    <div class=" col-lg-2 d-flex justify-content-center">
                        <button type="submit">
                            <?php echo esc_html__('Search Property', 'vernex') ?>
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="properties-page sec-mar">
    <div class="container">
        <div class="row gy-5" id="properties-archive">
            <?php if ($wp_query->have_posts()) {
                while ($wp_query->have_posts()):
                    $wp_query->the_post();
                    Egns\Helper\Egns_Helper::egns_template_part('properties', 'content/archive-properties-content');
                endwhile;
            } else {
                // Include global posts not found
                Egns\Helper\Egns_Helper::egns_template_part('content', 'templates/posts-not-found');
            }
            ?>
        </div>
        <?php if ($wp_query->max_num_pages > 1) : ?>
            <div class="row">
                <div class="col-lg-12 d-flex justify-content-center">
                    <div id="load-more-properties-btn" class="load-more-for-properties-btn">
                        <button class="primary-btn2 bounce_up mt-70">
                            <span>
                                <?php echo esc_html__('Load More', 'vernex'); ?>
                                <svg viewBox="0 0 13 20">
                                    <polyline points="0.5 19.5 3 19.5 12.5 10 3 0.5"></polyline>
                                </svg>
                            </span>
                        </button>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php get_footer(); ?>