<?php 
/** * Template Name: Home */
get_header(); ?>


<!-- Demo Content -->
    <main class="main-content">
        <div class="scroll-indicator">
            <div class="scroll-text">SCROLL</div>
            <div class="scroll-line">
                <div class="scroll-progress"></div>
            </div>
        </div>
        <section class="heroSectionHome contanerPadding">
            <div class="heroSctionGrid">
                <div class="content-wrapper" data-aos="fade-right">
                    <div class="contentSection">
                        <?php
                            $hero_heading = get_field("hero_heading");
                            echo $hero_heading ? $hero_heading : 'Not Available';
                            $hero_paragraph = get_field("hero_paragraph");
                            echo $hero_paragraph ? $hero_paragraph : 'Not Available';
                        ?>
                        <!-- <br> -->
                        
                        <!-- <br> -->
                        <div class="button-group">
                            <?php
                                $hero_build_together_btn = get_field("hero_build_together_btn");
                                echo $hero_build_together_btn ? $hero_build_together_btn : 'Not Available';
                                $hero_learn_more_btn = get_field("hero_learn_more_btn");
                                echo $hero_learn_more_btn ? $hero_learn_more_btn : 'Not Available';
                            ?>
                            
                        </div>
                    </div>
                </div>
                <div class="hero-section " data-aos="fade-left">
                    <div class="heading-right-wrapper heading-video-max-height">
                        <?php 
                            $hero_video = get_field('hero_video');
                            $hero_image = get_field('hero_image');
                            if ($hero_image && is_array($hero_image)) {
                                $hero_image_url = $hero_image['url'];
                                $hero_image_alt = $hero_image['alt'];
                            } else {
                                $hero_image_url = $hero_image; // plain URL fallback
                                $hero_image_alt = ''; // or provide a default
                            }
                            $hero_video_url = is_array($hero_video) ? $hero_video['url'] : $hero_video;
                        ?>

                            <?php if ($hero_video_url): ?>
                                <video class="header-video" autoplay loop muted>
                                    <source src="<?php echo esc_url($hero_video_url); ?>" type="video/mp4">
                                </video>
                            <?php endif; ?>

                            <?php if ($hero_image_url): ?>
                            <img 
                                src="<?php echo esc_url($hero_image_url); ?>" 
                                alt="<?php echo esc_attr($hero_image_alt); ?>" 
                                class="header-mask lazyloaded" 
                                decoding="async"
                            >
                        <?php endif; ?>
                    </div>


                </div>
            </div>
        </section>

        <!-- Discover More Section -->
        <section class="discoverMore contanerPadding">
            <div class="wrap-content" data-aos="fade-up">
                <div class="textWrap">
                    
                        <?php
                            $discover_heading = get_field("discover_heading");
                            echo $discover_heading ? $discover_heading : 'Not Available';                            
                        ?>
                    
                    
                    <?php
                        $discover_paragraph = get_field("discover_paragraph");
                        echo $discover_paragraph ? $discover_paragraph : 'Not Available';
                    ?>
                </div>
                <div class="btnWrap">
                    <?php
                        $discover_btn = get_field("discover_btn");
                        echo $discover_btn ? $discover_btn : 'Not Available';
                    ?>
                    
                </div>
            </div>

        </section>

        <!-- Circle Section -->
        <section class="jandk-section contanerPadding">
            <div class="jandk-circles-wrapper" id="jandk-stats">
                <?php if( have_rows('counter') ): ?>
                    <?php while( have_rows('counter') ): the_row(); 
                        $number = get_sub_field('counter_number');
                        $label  = get_sub_field('counter_text');
                    ?>
                    <div class="jandk-circle-card" data-aos="fade-right">
                        <h2 class="jandk-circle-number" data-target="<?php echo esc_attr($number); ?>" data-suffix="+">0</h2>
                        <p class="jandk-circle-label"><?php echo esc_html($label); ?></p>
                    </div>
                    <?php endwhile; ?>
                <?php endif; ?>
            </div>
        </section>
        
        <!-- Pending Section -->
        <section class="categoryContainer contanerPadding">
            <div class="services-container">
                <div class="services-left" data-aos="fade-up-right">
                    <?php
                        if (have_rows('service_name')) {
                            while (have_rows('service_name')) {
                                the_row();
                                $servicetext = get_sub_field('service_link');

                                // Output plain text only
                                echo $servicetext ? $servicetext : 'Not Available';
                            }
                        } else {
                            echo "No services found.\n";
                        }
                    ?>

                    <div class="view-all">
                        <?php
                            $view_all_service_btn = get_field("view_all_service_btn");
                            echo $view_all_service_btn ? $view_all_service_btn : 'Not Available';
                        ?>
                    </div>
                </div>

                <div class="services-right" data-aos="fade-up-left">
                    <?php
                        if (have_rows('service_desc')) {
                            while (have_rows('service_desc')) {
                                the_row();
                                $serviceparagraph = get_sub_field('service_paragraph');
                                // Output plain text only
                                echo $serviceparagraph ? $serviceparagraph : 'Not Available';
                            }
                        } else {
                            echo "No services found.\n";
                        }
                    ?>
                </div>
            </div>
        </section>

        <!-- Logo Slider Section -->
        <section class="logo-section contanerPadding">
            <div class="LogosContainer">
                <div class="content-wrapper-logo">
                    <div class="text-content">
                        <?php
                        $logo_container_text = get_field("logo_container_text");
                        echo $logo_container_text ? $logo_container_text : 'Not Available';
                        ?>
                    </div>
                    <div class="logo-slider-container">
                        <div class="logo-slider">
                            <?php if( have_rows('logo_image') ): ?>
                            <?php while( have_rows('logo_image') ): the_row(); 
                                $logo = get_sub_field('logs_img');
                                if( $logo ):
                                    $logo_url = is_array($logo) ? $logo['url'] : $logo; // handle if returns string or array
                                    $logo_alt = is_array($logo) && !empty($logo['alt']) ? $logo['alt'] : 'Logo';
                                ?>
                                <div class="logo-slide">
                                    <img src="<?php echo esc_url($logo_url); ?>" alt="<?php echo esc_attr($logo_alt); ?>" class="logo">
                                </div>
                            <?php endif; endwhile; ?>
                        <?php endif; ?>

                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Modern Section -->
        <section class="modern-section contanerPadding modernsec-slider">
            <div class="modern-container">
                <!-- Left Content Section -->
                <div class="modern-content-section" data-aos="fade-right">
                    <?php
                        $modern_content_heading = get_field("modern_content_heading");
                        echo $modern_content_heading ? $modern_content_heading : 'Not Available';
                        $modern_content_paragraph = get_field("modern_content_paragraph");
                        echo $modern_content_paragraph ? $modern_content_paragraph : 'Not Available';
                    ?>
                    <div class="modern-slider-nav">
                        <div class="modern-slider-arrow modern-slider-prev">←</div>
                        <div class="modern-slider-arrow modern-slider-next">→</div>
                    </div>
                </div>

                <!-- Right Images Section -->
                <div class="modern-images-section" data-aos="zoom-in">
                    <div class="modern-slider-container">
                        <div class="modern-images-slider">
                            <?php if( have_rows('modern_images') ): ?>
                                <?php while( have_rows('modern_images') ): the_row(); 
                                    $image = get_sub_field('modern_image');
                                    $text  = get_sub_field('modern_image_text_overlay');

                                    // Handle both array and URL returns
                                    $image_url = is_array($image) ? $image['url'] : $image;
                                    $image_alt = is_array($image) && !empty($image['alt']) ? $image['alt'] : $text;
                                ?>
                                    <div class="modern-image-card">
                                        <?php if ($image_url): ?>
                                            <img src="<?php echo esc_url($image_url); ?>" alt="<?php echo esc_attr($image_alt); ?>">
                                        <?php endif; ?>
                                        <?php if ($text): ?>
                                            <div class="modern-image-overlay">
                                                <h3 class="modern-image-title"><?php echo esc_html($text); ?></h3>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                <?php endwhile; ?>
                            <?php endif; ?>

                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- News and Blog -->
        <section class="modern-section contanerPadding ">
            <div class="news-log-container">
                <!-- Left Content Section (35%) -->
                <div class="news-log-content-section">
                    <div class="hero-bottom-subtitle gird-right-subhed">
                        <?php
                            $news_blog_sub_heading = get_field("news_blog_sub_heading");
                            echo $news_blog_sub_heading ? $news_blog_sub_heading : 'Not Available';
                        ?>
                    </div>
                    
                        <?php
                            $news_blog_heading = get_field("news_blog_heading");
                            echo $news_blog_heading ? $news_blog_heading : 'Not Available';
                        ?>
               
                    <?php
                        $news_blog_paragraph = get_field("news_blog_paragraph");
                        echo $news_blog_paragraph ? $news_blog_paragraph : 'Not Available';
                    ?>

                    <div class="news-log-content-nav">
                        <div class="modern-slider-arrow news-prev">←</div>
                        <div class="modern-slider-arrow news-next">→</div>
                    </div>
                </div>

                <!-- Right Slider Section (65%) -->
                <div class="news-log-slider-section">
                    <div class="news-log-slider-container">
                        <div class="news-log-slider">
                            <?php if (have_rows('news_blog_images')): ?>
                                <?php while (have_rows('news_blog_images')): the_row(); 
                                    $date = get_sub_field('news_blog_date_time');
                                    $type = get_sub_field('news_blog_type');
                                    $title = get_sub_field('news_blog_text');
                                    $image = get_sub_field('blog_img'); // ACF image field
                                    $image_url = $image['sizes']['large']; // or 'url' for full
                                    $image_alt = $image['alt'];
                                ?>
                                <div class="news-log-slide">
                                    <div class="news-log-slide-card">
                                        <div class="news-log-slide-image-container">
                                            <img src="<?php echo esc_url($image_url); ?>" 
                                                alt="<?php echo esc_attr($image_alt); ?>" 
                                                class="news-log-slide-image">
                                        </div>
                                        <div class="news-log-slide-content">
                                            <div class="news-log-slide-meta">
                                                <span class="news-log-slide-date"><?php echo esc_html($date); ?></span>
                                                <span class="news-log-slide-category"><?php echo esc_html($type); ?></span>
                                            </div>
                                            <h3 class="news-log-slide-title"><?php echo esc_html($title); ?></h3>
                                        </div>
                                    </div>
                                </div>
                                <?php endwhile; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>



        <!-- Testimoneal -->

        <section class="contanerPadding testimonealSection">
            <div class="testimonial-container">
                <!-- Left Content Section (35%) -->
                <div class="testimonial-content-section">
                    <div class="hero-bottom-subtitle" style="color: gray;">
                        <?php
                            $testimonial_title = get_field("testimonial_title");
                            echo $testimonial_title ? $testimonial_title : 'Not Available';
                        ?>
                    </div>
                    <!-- <h2 class="modern-news-heading"> -->
                        <?php
                            $testimonial_heading = get_field("testimonial_heading");
                            echo $testimonial_heading ? $testimonial_heading : 'Not Available';
                        ?>
                    <!-- </h2> -->
                    <div class="testimonial-content-nav">
                        <div class="modern-slider-arrow testimonial-prev">←</div>
                        <div class="modern-slider-arrow testimonial-next">→</div>
                    </div>
                </div>

                <!-- Right Testimonial Display Section (65%) -->
                <div class="testimonial-display-section">
                    <div class="testimonial-slider">
                        <?php if (have_rows('testimonial_paragraph')): ?>
                            <?php while (have_rows('testimonial_paragraph')): the_row(); 
                                $paragraph = get_sub_field('testimonial_paragraph');
                                $writer = get_sub_field('writer_name');
                                $svgicon = get_sub_field("double_quotes_svg");
                                $designation = get_sub_field('designation');
                                $button_text = get_sub_field('testimonial_btn');
                            ?>
                            <div class="testimonial-item">
                                <div class="testimonial-content">
                                    <?php
                                        echo $paragraph ? $paragraph : 'Not Available';
                                    ?>
                                    <div class="userWrapper">
                                        <!-- SVG Icon (can be static or from ACF if needed) -->
                                        <?php
                                            echo $svgicon ? $svgicon : 'Not Available';
                                        ?>
                                        <div class="testimonial-author">
                                            <div class="testimonial-name">
                                                <?php
                                                    echo $writer ? $writer : 'Not Available';
                                                ?>
                                            </div>
                                            <div class="testimonial-title">
                                                <?php
                                                    echo $designation ? $designation : 'Not Available';
                                                ?>
                                            </div>
                                            <?php
                                                 echo $button_text ? $button_text : 'Not Available';
                                            ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endwhile; ?>
                        <?php endif; ?>


                    </div>
                </div>
            </div>
        </section>



        <!-- hero bottom section -->
        <section class="hero-bottom-section marginforHero">
            <div class="hero-bottom-background"></div>

            <div class="hero-bottom-container">
                <div class="hero-bottom-content">
                    <div class="hero-bottom-subtitle">
                        <?php
                            $engineering_title = get_field("engineering_title");
                            echo $engineering_title ? $engineering_title : 'Not Available';
                        ?>
                    </div>
                   
                        <?php
                            $engineering_heading = get_field("engineering_heading");
                            echo $engineering_heading ? $engineering_heading : 'Not Available';
                        ?>
              
                    <div class="hero-bottom-cta">
                        <?php
                            $engineering_heading_btn = get_field("engineering_heading_btn");
                            echo $engineering_heading_btn ? $engineering_heading_btn : 'Not Available';
                        ?>
                    </div>
                </div>
            </div>
        </section>

      <section><?php the_content(); ?></section>
    </main>

<?php get_footer(); ?>